<?php
// app/Http/Controllers/AdminDashboardController.php
namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Warehouse;

class AdminDashboardController extends Controller
{
    public function index()
    {
        // ตรวจสอบสิทธิ์ admin
        if (!auth()->user()->isAdmin()) {
            abort(403, 'คุณไม่มีสิทธิ์เข้าถึงหน้านี้');
        }

        $users = User::with('warehouse')->get();
        $stats = [
            'total' => $users->count(),
            'active' => $users->where('is_active', true)->count(),
            'inactive' => $users->where('is_active', false)->count(),
            'admin' => $users->where('role', 'admin')->count(),
            '2wheel' => $users->where('role', '2wheel')->count(),
            '4wheel' => $users->where('role', '4wheel')->count(),
        ];
        
        return view('admin.dashboard', compact('users', 'stats'));
    }

    public function toggleUserStatus(User $user)
    {
        // ป้องกันไม่ให้ปิดการใช้งานตัวเอง
        if ($user->id === auth()->id()) {
            return back()->with('error', 'คุณไม่สามารถปิดการใช้งานตัวเองได้');
        }

        $user->update(['is_active' => !$user->is_active]);
        
        $status = $user->is_active ? 'เปิดใช้งาน' : 'ปิดใช้งาน';
        return back()->with('success', "เปลี่ยนสถานะผู้ใช้เป็น {$status} เรียบร้อยแล้ว");
    }

    public function changeUserRole(Request $request, User $user)
    {
        $request->validate([
            'role' => 'required|in:admin,2wheel,4wheel'
        ]);

        // ป้องกันไม่ให้เปลี่ยน role ตัวเอง
        if ($user->id === auth()->id()) {
            return back()->with('error', 'คุณไม่สามารถเปลี่ยน Role ตัวเองได้');
        }

        $user->update(['role' => $request->role]);
        return back()->with('success', 'เปลี่ยน Role ผู้ใช้เรียบร้อยแล้ว');
    }
}