<?php
// database/migrations/xxxx_create_commission_rates_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('commission_rates', function (Blueprint $table) {
            $table->id();
            $table->string('warehouse_code');
            $table->enum('vehicle_type', ['2wheel', '4wheel']);
            $table->integer('tier');
            $table->integer('min_packages');
            $table->integer('max_packages')->nullable();
            $table->decimal('rate_per_package', 8, 2);
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->index(['warehouse_code', 'vehicle_type', 'tier']);
            $table->unique(['warehouse_code', 'vehicle_type', 'tier']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('commission_rates');
    }
};