<?php
// database/seeders/AdminUserSeeder.php
namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    public function run()
    {
        User::create([
            'warehouse_code' => 'WH001',
            'first_name' => 'Admin',
            'last_name' => 'System',
            'email' => 'admin@example.com',
            'password' => Hash::make('password'),
            'role' => 'admin',
            'is_active' => true,
        ]);

        // สร้างผู้ใช้ทดสอบ 2wheel
        User::create([
            'warehouse_code' => 'WH002',
            'first_name' => 'John',
            'last_name' => 'Doe',
            'email' => 'user2wheel@example.com',
            'password' => Hash::make('password'),
            'role' => '2wheel',
            'is_active' => true,
        ]);

        // สร้างผู้ใช้ทดสอบ 4wheel
        User::create([
            'warehouse_code' => 'WH003',
            'first_name' => 'Jane',
            'last_name' => 'Smith',
            'email' => 'user4wheel@example.com',
            'password' => Hash::make('password'),
            'role' => '4wheel',
            'is_active' => true,
        ]);
    }
}