@extends('layouts.app')

@section('title', 'Admin Dashboard - ระบบจัดการค่าคอมมิชชั่น')

@section('content')
<div class="content-container">

    {{-- HERO --}}
    <div class="mb-8">
        <div class="dashboard-hero">
            <div class="dashboard-hero-blur"></div>
            <div class="dashboard-hero-white1"></div>
            <div class="dashboard-hero-white2"></div>
            <div class="dashboard-hero-main">
                <div class="dashboard-hero-row">
                    <div>
                        <div class="dashboard-hero-flex">
                            <div class="dashboard-hero-crown">
                                <i class="fas fa-crown"></i>
                            </div>
                            <div>
                                <h1 class="dashboard-hero-title">
                                    สวัสดี, {{ auth()->user()->name }} 👋
                                </h1>
                                <p class="dashboard-hero-desc">
                                    ยินดีต้อนรับสู่ระบบจัดการค่าคอมมิชชั่น
                                </p>
                            </div>
                        </div>
                        <div class="dashboard-hero-date">
                            <i class="fas fa-calendar"></i>
                            <span>{{ now()->locale('th')->translatedFormat('l ที่ j F Y') }}</span>
                        </div>
                    </div>
                    <div class="dashboard-hero-time">
                        <div class="dashboard-hero-time-box">
                            <div class="dashboard-hero-time-label">เวลาปัจจุบัน</div>
                            <div class="dashboard-hero-time-value" id="current-time">{{ now()->format('H:i:s') }}</div>
                            <div class="dashboard-hero-time-desc">อัปเดตแบบเรียลไทม์</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><br>

    {{-- Stat Cards --}}
    <div class="dashboard-grid" >
        <div class="dashboard-card dashboard-card-orange">
            <div class="dashboard-card-hover"></div>
            <div class="dashboard-card-main">
                <div class="dashboard-card-row">
                    <div class="dashboard-card-icon dashboard-card-icon-orange">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="dashboard-card-info">
                        <div class="dashboard-card-num">{{ number_format($stats['total'] ?? 0) }}</div>
                        <div class="dashboard-card-label">ผู้ใช้ทั้งหมด</div>
                    </div>
                </div>
                <div class="dashboard-card-row2">
                    <div class="dashboard-card-status dashboard-card-status-green">
                        <i class="fas fa-arrow-up"></i>
                        <span>+{{ $stats['new_users_this_month'] ?? 0 }}</span>
                        <span>เดือนนี้</span>
                    </div>
                    <a href="{{ route('admin.users.index') }}" class="dashboard-card-link">ดูทั้งหมด <i class="fas fa-arrow-right"></i></a>
                </div>
            </div>
        </div>
        <div class="dashboard-card dashboard-card-green">
            <div class="dashboard-card-hover"></div>
            <div class="dashboard-card-main">
                <div class="dashboard-card-row">
                    <div class="dashboard-card-icon dashboard-card-icon-green">
                        <i class="fas fa-user-check"></i>
                    </div>
                    <div class="dashboard-card-info">
                        <div class="dashboard-card-num">{{ number_format($stats['active'] ?? 0) }}</div>
                        <div class="dashboard-card-label">ใช้งานอยู่</div>
                    </div>
                </div>
                <div class="dashboard-card-row2">
                    <div class="dashboard-card-status">
                        <span>{{ $stats['online_users'] ?? 0 }} ออนไลน์</span>
                    </div>
                    <div class="dashboard-card-status-green">{{ number_format((($stats['active'] ?? 0) / max($stats['total'] ?? 1, 1)) * 100, 1) }}%</div>
                </div>
            </div>
        </div>
        <div class="dashboard-card dashboard-card-blue">
            <div class="dashboard-card-hover"></div>
            <div class="dashboard-card-main">
                <div class="dashboard-card-row">
                    <div class="dashboard-card-icon dashboard-card-icon-blue">
                        <i class="fas fa-warehouse"></i>
                    </div>
                    <div class="dashboard-card-info">
                        <div class="dashboard-card-num">{{ number_format($stats['total_warehouses'] ?? 0) }}</div>
                        <div class="dashboard-card-label">คลังสินค้า</div>
                    </div>
                </div>
                <div class="dashboard-card-row2">
                    <div class="dashboard-card-status dashboard-card-status-blue">
                        <span>{{ number_format($stats['active_warehouses'] ?? 0) }} ใช้งานอยู่</span>
                    </div>
                    <a href="{{ route('admin.warehouses.index') }}" class="dashboard-card-link">จัดการ <i class="fas fa-arrow-right"></i></a>
                </div>
            </div>
        </div>
        <div class="dashboard-card dashboard-card-purple">
            <div class="dashboard-card-hover"></div>
            <div class="dashboard-card-main">
                <div class="dashboard-card-row">
                    <div class="dashboard-card-icon dashboard-card-icon-purple">
                        <i class="fas fa-percentage"></i>
                    </div>
                    <div class="dashboard-card-info">
                        <div class="dashboard-card-num">{{ number_format($stats['total_commission_rates'] ?? 0) }}</div>
                        <div class="dashboard-card-label">อัตราค่าคอมมิชชั่น</div>
                    </div>
                </div>
                <div class="dashboard-card-row2">
                    <div class="dashboard-card-status dashboard-card-status-purple">
                        <span>{{ number_format($stats['active_commission_rates'] ?? 0) }} ใช้งานอยู่</span>
                    </div>
                    <a href="{{ route('admin.commission-rates.index') }}" class="dashboard-card-link">ตั้งค่า <i class="fas fa-arrow-right"></i></a>
                </div>
            </div>
        </div>
    </div>

    {{-- Section: Quick Actions & Chart --}}
    <div class="dashboard-section-grid">
        <div class="dashboard-quick-actions modern-card">
            <div class="modern-card-header">
                <div class="flex items-center">
                    <div class="quick-action-icon"><i class="fas fa-bolt"></i></div>
                    <h3>การดำเนินการด่วน</h3>
                </div>
            </div>
            <div class="quick-action-list">
                <a href="{{ route('admin.users.create') }}" class="quick-action-item orange"><i class="fas fa-user-plus"></i> เพิ่มผู้ใช้ใหม่</a>
                <a href="{{ route('admin.warehouses.create') }}" class="quick-action-item blue"><i class="fas fa-warehouse"></i> เพิ่มคลังใหม่</a>
                <a href="{{ route('admin.commission-rates.create') }}" class="quick-action-item purple"><i class="fas fa-percentage"></i> กำหนดอัตราค่าคอมมิชชั่น</a>
            </div>
        </div>
        <div class="modern-card">
            <div class="modern-card-header">
                <div class="flex items-center">
                    <div class="chart-header-icon"><i class="fas fa-chart-pie"></i></div>
                    <h3>การกระจายผู้ใช้งาน</h3>
                </div>
            </div>
            <div style="padding: 2rem;">
                <div class="chart-canvas-wrapper">
                    <canvas id="userDistributionChart"></canvas>
                </div>
                <div class="chart-legend">
                    <div><span class="legend-color purple"></span> ผู้ดูแลระบบ ({{ $stats['admin'] ?? 0 }})</div>
                    <div><span class="legend-color blue"></span> รถ 2 ล้อ ({{ $stats['2wheel'] ?? 0 }})</div>
                    <div><span class="legend-color green"></span> รถ 4 ล้อ ({{ $stats['4wheel'] ?? 0 }})</div>
                </div>
            </div>
        </div>
    </div>

    {{-- Section: Recent Users & System Status --}}
    <div class="dashboard-section-grid2">
        <div class="modern-card">
            <div class="modern-card-header">
                <div class="flex items-center">
                    <div class="recent-header-icon"><i class="fas fa-user-clock"></i></div>
                    <h3>ผู้ใช้ล่าสุด</h3>
                </div>
            </div>
            <div class="recent-users-list">
                @forelse($recent_users ?? [] as $user)
                <div class="recent-user-item">
                    <div class="recent-avatar">{{ strtoupper(mb_substr($user->name,0,2)) }}</div>
                    <div class="recent-user-info">
                        <div class="recent-name">{{ $user->name }}</div>
                        <div class="recent-email">{{ $user->email }}</div>
                        <div class="recent-date">{{ $user->created_at? $user->created_at->diffForHumans() : '' }}</div>
                    </div>
                    <span class="recent-badge {{ $user->role=='admin'?'purple':($user->role=='2wheel'?'blue':'green') }}">
                        {{ $user->role_display_name ?? $user->role }}
                    </span>
                </div>
                @empty
                <div class="recent-empty">ยังไม่มีผู้ใช้ใหม่</div>
                @endforelse
            </div>
        </div>
        <div class="modern-card">
            <div class="modern-card-header">
                <div class="flex items-center">
                    <div class="status-header-icon"><i class="fas fa-server"></i></div>
                    <h3>สถานะระบบ</h3>
                </div>
            </div>
            <div class="system-status-list">
                <div class="system-status-item green"><span class="system-status-dot green"></span> ฐานข้อมูล <span class="system-status-right">ปกติ</span></div>
                <div class="system-status-item blue"><span class="system-status-dot blue"></span> พื้นที่จัดเก็บ <span class="system-status-right">{{ $system_status['storage_usage'] ?? '75%' }}</span></div>
                <div class="system-status-item yellow"><span class="system-status-dot yellow"></span> แคชระบบ <span class="system-status-right">ปกติ</span></div>
                <div class="system-performance">
                    <div>ประสิทธิภาพระบบ</div>
                    <div class="system-bar">
                        <div class="system-bar-fill" style="width:{{ $system_status['performance'] ?? 92 }}%"></div>
                    </div>
                    <div class="system-status-right">{{ $system_status['performance'] ?? 92 }}%</div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
function updateTime() {
    const now = new Date();
    const timeString = now.toLocaleTimeString('th-TH');
    const timeElement = document.getElementById('current-time');
    if (timeElement.textContent !== timeString) {
        timeElement.style.opacity = '0.7';
        setTimeout(() => {
            timeElement.textContent = timeString;
            timeElement.style.opacity = '1';
        }, 100);
    }
}
setInterval(updateTime, 1000);

// Chart: Responsive + ไม่ล้นจอ
const ctx = document.getElementById('userDistributionChart').getContext('2d');
new Chart(ctx, {
    type: 'doughnut',
    data: {
        labels: ['ผู้ดูแลระบบ', 'รถ 2 ล้อ', 'รถ 4 ล้อ'],
        datasets: [{
            data: [{{ $stats['admin'] ?? 0 }}, {{ $stats['2wheel'] ?? 0 }}, {{ $stats['4wheel'] ?? 0 }}],
            backgroundColor: [
                'rgba(139, 92, 246, 0.85)', // purple
                'rgba(37, 99, 235, 0.85)', // blue
                'rgba(16, 185, 129, 0.85)' // green
            ],
            borderWidth: 0
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        cutout: '70%',
        plugins: { legend: { display: false } }
    }
});
</script>
@endpush
@push('styles')
@endpush
