@extends('layouts.admin')

@section('title', 'รายงานค่าคอมมิชชั่น')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">รายงานค่าคอมมิชชั่น</h1>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">หน้าหลัก</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.reports.index') }}">รายงาน</a></li>
                    <li class="breadcrumb-item active">รายงานค่าคอมมิชชั่น</li>
                </ol>
            </nav>
        </div>
        <div>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exportModal">
                <i class="fas fa-download"></i> ส่งออกรายงาน
            </button>
            <button type="button" class="btn btn-secondary" onclick="window.print()">
                <i class="fas fa-print"></i> พิมพ์
            </button>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form id="filterForm" method="GET" action="{{ route('admin.reports.commission') }}">
                <div class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label">เดือน</label>
                        <select class="form-select" name="month">
                            @for($i = 1; $i <= 12; $i++)
                                <option value="{{ $i }}" {{ request('month', now()->month) == $i ? 'selected' : '' }}>
                                    {{ DateTime::createFromFormat('!m', $i)->format('F') }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">ปี</label>
                        <select class="form-select" name="year">
                            @for($year = now()->year; $year >= now()->year - 2; $year--)
                                <option value="{{ $year }}" {{ request('year', now()->year) == $year ? 'selected' : '' }}>
                                    {{ $year + 543 }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">คลังสินค้า</label>
                        <select class="form-select" name="warehouse_id">
                            <option value="">ทั้งหมด</option>
                            @foreach($warehouses as $warehouse)
                                <option value="{{ $warehouse->id }}" {{ request('warehouse_id') == $warehouse->id ? 'selected' : '' }}>
                                    {{ $warehouse->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">ระดับพนักงาน</label>
                        <select class="form-select" name="tier">
                            <option value="">ทั้งหมด</option>
                            <option value="1" {{ request('tier') == '1' ? 'selected' : '' }}>Tier 1</option>
                            <option value="2" {{ request('tier') == '2' ? 'selected' : '' }}>Tier 2</option>
                            <option value="3" {{ request('tier') == '3' ? 'selected' : '' }}>Tier 3</option>
                        </select>
                    </div>
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-filter"></i> กรองข้อมูล
                        </button>
                        <a href="{{ route('admin.reports.commission') }}" class="btn btn-secondary">
                            <i class="fas fa-redo"></i> รีเซ็ต
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                ค่าคอมมิชชั่นรวม
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                ฿{{ number_format($summary['total_commission'], 2) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                ค่าคอมมิชชั่นเฉลี่ย
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                ฿{{ number_format($summary['average_commission'], 2) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                จำนวนพนักงาน
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ number_format($summary['total_employees']) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                การเติบโตจากเดือนก่อน
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                @if($summary['growth_rate'] > 0)
                                    <i class="fas fa-arrow-up text-success"></i>
                                @elseif($summary['growth_rate'] < 0)
                                    <i class="fas fa-arrow-down text-danger"></i>
                                @else
                                    <i class="fas fa-minus text-secondary"></i>
                                @endif
                                {{ abs($summary['growth_rate']) }}%
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-percentage fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row mb-4">
        <!-- Monthly Trend Chart -->
        <div class="col-xl-8 col-lg-7">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">แนวโน้มค่าคอมมิชชั่นรายเดือน (6 เดือนล่าสุด)</h6>
                </div>
                <div class="card-body">
                    <div class="chart-area">
                        <canvas id="monthlyTrendChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Commission by Tier -->
        <div class="col-xl-4 col-lg-5">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">ค่าคอมมิชชั่นตามระดับพนักงาน</h6>
                </div>
                <div class="card-body">
                    <div class="chart-pie pt-4 pb-2">
                        <canvas id="tierChart"></canvas>
                    </div>
                    <div class="mt-4 text-center small">
                        <span class="mr-2">
                            <i class="fas fa-circle text-primary"></i> Tier 1
                        </span>
                        <span class="mr-2">
                            <i class="fas fa-circle text-success"></i> Tier 2
                        </span>
                        <span class="mr-2">
                            <i class="fas fa-circle text-info"></i> Tier 3
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Earners and Warehouse Comparison -->
    <div class="row mb-4">
        <!-- Top Earners -->
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">พนักงานที่มีรายได้สูงสุด</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>อันดับ</th>
                                    <th>ชื่อพนักงาน</th>
                                    <th>คลังสินค้า</th>
                                    <th>Tier</th>
                                    <th>ค่าคอมมิชชั่น</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($topEarners as $index => $earner)
                                    <tr>
                                        <td>
                                            @if($index == 0)
                                                <i class="fas fa-trophy text-warning"></i>
                                            @elseif($index == 1)
                                                <i class="fas fa-medal text-secondary"></i>
                                            @elseif($index == 2)
                                                <i class="fas fa-medal" style="color: #CD7F32;"></i>
                                            @else
                                                {{ $index + 1 }}
                                            @endif
                                        </td>
                                        <td>{{ $earner->name }}</td>
                                        <td>{{ $earner->warehouse->name }}</td>
                                        <td>
                                            <span class="badge bg-primary">Tier {{ $earner->tier }}</span>
                                        </td>
                                        <td class="text-success font-weight-bold">
                                            ฿{{ number_format($earner->total_commission, 2) }}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Warehouse Comparison -->
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">เปรียบเทียบค่าคอมมิชชั่นตามคลังสินค้า</h6>
                </div>
                <div class="card-body">
                    <canvas id="warehouseComparisonChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Commission Analysis -->
    <div class="row mb-4">
        <div class="col-lg-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">การวิเคราะห์ค่าคอมมิชชั่น</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <h6 class="font-weight-bold">สถิติตามระดับพนักงาน</h6>
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Tier</th>
                                        <th>จำนวน</th>
                                        <th>ค่าเฉลี่ย</th>
                                        <th>รวม</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($tierAnalysis as $tier)
                                        <tr>
                                            <td>Tier {{ $tier->tier }}</td>
                                            <td>{{ $tier->count }}</td>
                                            <td>฿{{ number_format($tier->average, 2) }}</td>
                                            <td>฿{{ number_format($tier->total, 2) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="col-md-8">
                            <h6 class="font-weight-bold">การกระจายค่าคอมมิชชั่น</h6>
                            <canvas id="distributionChart" height="100"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Detailed Records -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">รายละเอียดค่าคอมมิชชั่น</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable">
                    <thead>
                        <tr>
                            <th>รหัสพนักงาน</th>
                            <th>ชื่อ-นามสกุล</th>
                            <th>คลังสินค้า</th>
                            <th>Tier</th>
                            <th>จำนวนการจัดส่ง</th>
                            <th>อัตราต่อชิ้น</th>
                            <th>โบนัส</th>
                            <th>รวมค่าคอมมิชชั่น</th>
                            <th>สถานะ</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($commissions as $commission)
                            <tr>
                                <td>{{ $commission->employee->code }}</td>
                                <td>{{ $commission->employee->name }}</td>
                                <td>{{ $commission->warehouse->name }}</td>
                                <td>
                                    <span class="badge bg-primary">Tier {{ $commission->tier }}</span>
                                </td>
                                <td>{{ number_format($commission->delivery_count) }}</td>
                                <td>฿{{ number_format($commission->rate_per_piece, 2) }}</td>
                                <td>฿{{ number_format($commission->bonus, 2) }}</td>
                                <td class="text-success font-weight-bold">
                                    ฿{{ number_format($commission->total_commission, 2) }}
                                </td>
                                <td>
                                    @if($commission->status == 'paid')
                                        <span class="badge bg-success">จ่ายแล้ว</span>
                                    @elseif($commission->status == 'pending')
                                        <span class="badge bg-warning">รอการจ่าย</span>
                                    @else
                                        <span class="badge bg-danger">ยกเลิก</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            <div class="d-flex justify-content-center">
                {{ $commissions->links() }}
            </div>
        </div>
    </div>
</div>

<!-- Export Modal -->
<div class="modal fade" id="exportModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">ส่งออกรายงานค่าคอมมิชชั่น</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.reports.commission.export') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">รูปแบบไฟล์</label>
                        <select class="form-select" name="format" required>
                            <option value="excel">Excel (.xlsx)</option>
                            <option value="pdf">PDF</option>
                            <option value="csv">CSV</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">ช่วงเวลา</label>
                        <select class="form-select" name="period" required>
                            <option value="current">ตามตัวกรองปัจจุบัน</option>
                            <option value="month">เดือนนี้</option>
                            <option value="quarter">ไตรมาสนี้</option>
                            <option value="year">ปีนี้</option>
                            <option value="custom">กำหนดเอง</option>
                        </select>
                    </div>
                    <div id="customDateRange" style="display: none;">
                        <div class="mb-3">
                            <label class="form-label">เดือนเริ่มต้น</label>
                            <input type="month" class="form-control" name="custom_start_month">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">เดือนสิ้นสุด</label>
                            <input type="month" class="form-control" name="custom_end_month">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">เลือกข้อมูลที่ต้องการ</label>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="include[]" value="summary" checked>
                            <label class="form-check-label">สรุปภาพรวม</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="include[]" value="monthly_trend" checked>
                            <label class="form-check-label">แนวโน้มรายเดือน</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="include[]" value="tier_analysis" checked>
                            <label class="form-check-label">การวิเคราะห์ตาม Tier</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="include[]" value="top_earners" checked>
                            <label class="form-check-label">พนักงานที่มีรายได้สูง</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="include[]" value="detailed_records" checked>
                            <label class="form-check-label">รายละเอียดค่าคอมมิชชั่น</label>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">ยกเลิก</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-download"></i> ส่งออก
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    @media print {
        .btn, .breadcrumb, .card {
            break-inside: avoid;
        }
        
        .no-print {
            display: none !important;
        }
    }
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Monthly Trend Chart
    const monthlyTrendCtx = document.getElementById('monthlyTrendChart').getContext('2d');
    new Chart(monthlyTrendCtx, {
        type: 'line',
        data: {
            labels: @json($monthlyTrend->pluck('month_name')),
            datasets: [{
                label: 'ค่าคอมมิชชั่นรวม',
                data: @json($monthlyTrend->pluck('total')),
                backgroundColor: 'rgba(78, 115, 223, 0.1)',
                borderColor: 'rgba(78, 115, 223, 1)',
                borderWidth: 2,
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return '฿' + value.toLocaleString();
                        }
                    }
                }
            },
            plugins: {
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return context.dataset.label + ': ฿' + context.parsed.y.toLocaleString();
                        }
                    }
                }
            }
        }
    });

    // Tier Chart
    const tierCtx = document.getElementById('tierChart').getContext('2d');
    new Chart(tierCtx, {
        type: 'doughnut',
        data: {
            labels: ['Tier 1', 'Tier 2', 'Tier 3'],
            datasets: [{
                data: @json($tierData->pluck('total')),
                backgroundColor: ['#4e73df', '#1cc88a', '#36b9cc']
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return context.label + ': ฿' + context.parsed.toLocaleString();
                        }
                    }
                }
            }
        }
    });

    // Warehouse Comparison Chart
    const warehouseCtx = document.getElementById('warehouseComparisonChart').getContext('2d');
    new Chart(warehouseCtx, {
        type: 'bar',
        data: {
            labels: @json($warehouseComparison->pluck('name')),
            datasets: [{
                label: 'ค่าคอมมิชชั่นรวม',
                data: @json($warehouseComparison->pluck('total')),
                backgroundColor: 'rgba(54, 162, 235, 0.5)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return '฿' + value.toLocaleString();
                        }
                    }
                }
            },
            plugins: {
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return context.dataset.label + ': ฿' + context.parsed.y.toLocaleString();
                        }
                    }
                }
            }
        }
    });

    // Distribution Chart
    const distributionCtx = document.getElementById('distributionChart').getContext('2d');
    new Chart(distributionCtx, {
        type: 'bar',
        data: {
            labels: @json($distributionData->pluck('range')),
            datasets: [{
                label: 'จำนวนพนักงาน',
                data: @json($distributionData->pluck('count')),
                backgroundColor: 'rgba(255, 159, 64, 0.5)',
                borderColor: 'rgba(255, 159, 64, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Custom date range toggle
    document.querySelector('select[name="period"]').addEventListener('change', function() {
        const customDateRange = document.getElementById('customDateRange');
        customDateRange.style.display = this.value === 'custom' ? 'block' : 'none';
    });
});
</script>
@endpush