<!-- resources/views/auth/login.blade.php -->
<x-guest-layout>
    <!-- Include CSS -->
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;500;600;700&display=swap');
        @import url('{{ asset('css/app.css') }}');
        
        .auth-container {
            min-height: 100vh;
            background: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
            position: relative;
            overflow: hidden;
        }
        
        .auth-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><polygon fill="%23ffffff10" points="0,1000 1000,0 1000,1000"/></svg>');
            background-size: cover;
        }
        
        .auth-card {
            background: var(--white);
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-xl);
            padding: 3rem 2.5rem;
            width: 100%;
            max-width: 420px;
            position: relative;
            z-index: 1;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .auth-header {
            text-align: center;
            margin-bottom: 2.5rem;
        }
        
        .auth-logo {
            width: 60px;
            height: 60px;
            background: var(--primary-gradient);
            border-radius: var(--radius-lg);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem auto;
            box-shadow: var(--shadow-md);
        }
        
        .auth-title {
            font-size: 1.75rem;
            font-weight: 600;
            color: var(--dark-gray);
            margin-bottom: 0.5rem;
        }
        
        .auth-subtitle {
            color: var(--gray);
            font-size: 1rem;
        }
        
        .alert {
            padding: 1rem 1.25rem;
            border-radius: var(--radius-md);
            margin-bottom: 1.5rem;
            font-size: 0.9rem;
            border: 1px solid;
        }
        
        .alert-success {
            background: rgba(34, 197, 94, 0.1);
            border-color: rgba(34, 197, 94, 0.3);
            color: #16a34a;
        }
        
        .alert-error {
            background: rgba(239, 68, 68, 0.1);
            border-color: rgba(239, 68, 68, 0.3);
            color: #dc2626;
        }
        
        .password-wrapper {
            position: relative;
        }
        
        .password-toggle {
            position: absolute;
            right: 0.75rem;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--gray);
            cursor: pointer;
            padding: 0.5rem;
            border-radius: var(--radius-sm);
            transition: var(--transition-fast);
        }
        
        .password-toggle:hover {
            color: var(--primary-orange);
            background: rgba(255, 107, 53, 0.05);
        }
        
        .remember-me {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin: 1.5rem 0;
        }
        
        .remember-me input[type="checkbox"] {
            width: auto;
            height: auto;
        }
        
        .auth-submit {
            width: 100%;
            background: var(--primary-gradient);
            color: var(--white);
            border: none;
            padding: 0.875rem 1.5rem;
            border-radius: var(--radius-md);
            font-family: inherit;
            font-weight: 500;
            font-size: 1rem;
            cursor: pointer;
            transition: var(--transition-fast);
            box-shadow: var(--shadow-sm);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }
        
        .auth-submit:hover {
            transform: translateY(-1px);
            box-shadow: var(--shadow-md);
        }
        
        .auth-submit:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .auth-footer {
            text-align: center;
            margin-top: 2rem;
            padding-top: 1.5rem;
            border-top: 1px solid var(--medium-gray);
        }
        
        .auth-links {
            display: flex;
            flex-direction: column;
            gap: 1rem;
            align-items: center;
        }
        
        .auth-link {
            color: var(--primary-orange);
            text-decoration: none;
            font-weight: 500;
            transition: var(--transition-fast);
            font-size: 0.9rem;
        }
        
        .auth-link:hover {
            color: var(--primary-dark);
            text-decoration: underline;
        }
        
        @media (max-width: 640px) {
            .auth-card {
                padding: 2rem 1.5rem;
                margin: 1rem;
            }
        }
    </style>

    <div class="auth-container">
        <div class="auth-card">
            <!-- Header -->
            <div class="auth-header">
                <div class="auth-logo">
                    <svg width="32" height="32" fill="white" viewBox="0 0 24 24">
                        <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
                    </svg>
                </div>
                <h1 class="auth-title">เข้าสู่ระบบ</h1>
                <p class="auth-subtitle">ยินดีต้อนรับกลับ</p>
            </div>

            <!-- Session Status -->
            @if (session('status'))
                <div class="alert alert-success">
                    {{ session('status') }}
                </div>
            @endif

            <!-- Error Messages -->
            @if(session('error'))
                <div class="alert alert-error">
                    {{ session('error') }}
                </div>
            @endif

            <!-- Form -->
            <form method="POST" action="{{ route('login') }}" id="loginForm">
                @csrf

                <!-- Email Address -->
                <div class="form-group">
                    <label for="email" class="form-label">อีเมล</label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           style="width: 100%;"
                           class="form-control @error('email') border-red-300 @enderror"
                           value="{{ old('email') }}" 
                           required 
                           autofocus 
                           autocomplete="username"
                           placeholder="example@email.com">
                    @error('email')
                        <div style="color: var(--danger); font-size: 0.875rem; margin-top: 0.25rem;">{{ $message }}</div>
                    @enderror
                </div>

                <!-- Password -->
                <div class="form-group">
                    <label for="password" class="form-label">รหัสผ่าน</label>
                    <div class="password-wrapper">
                        <input type="password" 
                               id="password" 
                               name="password" 
                               style="width: 100%;"
                               class="form-control @error('password') border-red-300 @enderror"
                               required 
                               autocomplete="current-password"
                               placeholder="กรอกรหัสผ่าน"
                               style="padding-right: 3rem;">
                        <button type="button" class="password-toggle" onclick="togglePassword('password')">
                            <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24" id="password-eye">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                            </svg>
                        </button>
                    </div>
                    @error('password')
                        <div style="color: var(--danger); font-size: 0.875rem; margin-top: 0.25rem;">{{ $message }}</div>
                    @enderror
                </div>

                <!-- Remember Me -->
                <div class="remember-me">
                    <input type="checkbox" 
                           id="remember_me" 
                           name="remember"
                           class="form-control">
                    <label for="remember_me" style="color: var(--gray); font-size: 0.9rem;">จดจำการเข้าสู่ระบบ</label>
                </div>

                <!-- Submit Button -->
                <button type="submit" class="auth-submit" id="submitBtn">
                    <span id="submitText">เข้าสู่ระบบ</span>
                    <svg class="animate-spin hidden" id="loadingIcon" width="20" height="20" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </button>

                <!-- Footer Links -->
                <div class="auth-footer">
                    <div class="auth-links">
                        @if (Route::has('password.request'))
                            <a href="{{ route('password.request') }}" class="auth-link">
                                ลืมรหัสผ่าน?
                            </a>
                        @endif
                        
                        <div style="color: var(--gray); font-size: 0.9rem;">
                            ยังไม่มีบัญชี? 
                            <a href="{{ route('register') }}" class="auth-link">สมัครสมาชิก</a>
                        </div>
                    </div>
                </div>
            </form>

        </div>
    </div>

    <script>
        // Password visibility toggle
        function togglePassword(fieldId) {
            const field = document.getElementById(fieldId);
            const eye = document.getElementById(fieldId + '-eye');
            
            if (field.type === 'password') {
                field.type = 'text';
                eye.innerHTML = `
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L3 3m6.878 6.878L21 21" />
                `;
            } else {
                field.type = 'password';
                eye.innerHTML = `
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                `;
            }
        }

        // Form submission handling
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            const submitBtn = document.getElementById('submitBtn');
            const submitText = document.getElementById('submitText');
            const loadingIcon = document.getElementById('loadingIcon');
            
            submitBtn.disabled = true;
            submitText.textContent = 'กำลังเข้าสู่ระบบ...';
            loadingIcon.classList.remove('hidden');
        });

        // Quick login demo accounts
        function quickLogin(email, password) {
            document.getElementById('email').value = email;
            document.getElementById('password').value = password;
        }

        // Add click handlers for demo accounts
        document.addEventListener('DOMContentLoaded', function() {
            // Optional: Add quick fill functionality for demo accounts
            const demoAccounts = document.querySelectorAll('[data-demo-account]');
            demoAccounts.forEach(account => {
                account.addEventListener('click', function() {
                    const email = this.dataset.email;
                    const password = this.dataset.password;
                    if (email && password) {
                        quickLogin(email, password);
                    }
                });
            });
        });
    </script>
</x-guest-layout>