<!-- resources/views/auth/register.blade.php -->
<x-guest-layout>
    <!-- Include CSS -->
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;500;600;700&display=swap');
        @import url('{{ asset('css/app.css') }}');
        
        .auth-container {
            min-height: 100vh;
            background: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
            position: relative;
            overflow: hidden;
        }
        
        .auth-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><polygon fill="%23ffffff10" points="0,1000 1000,0 1000,1000"/></svg>');
            background-size: cover;
        }
        
        .auth-card {
            background: var(--white);
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-xl);
            padding: 3rem 2.5rem;
            width: 100%;
            max-width: 480px;
            position: relative;
            z-index: 1;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .auth-header {
            text-align: center;
            margin-bottom: 2.5rem;
        }
        
        .auth-logo {
            width: 60px;
            height: 60px;
            background: var(--primary-gradient);
            border-radius: var(--radius-lg);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem auto;
            box-shadow: var(--shadow-md);
        }
        
        .auth-title {
            font-size: 1.75rem;
            font-weight: 600;
            color: var(--dark-gray);
            margin-bottom: 0.5rem;
        }
        
        .auth-subtitle {
            color: var(--gray);
            font-size: 1rem;
        }
        
        .form-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
        }
        
        .form-grid-full {
            grid-column: 1 / -1;
        }
        
        .vehicle-selection {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
            margin-top: 0.5rem;
        }
        
        .vehicle-card {
            position: relative;
            cursor: pointer;
        }
        
        .vehicle-input {
            position: absolute;
            opacity: 0;
            width: 0;
            height: 0;
        }
        
        .vehicle-label {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 1.5rem 1rem;
            border: 2px solid var(--medium-gray);
            border-radius: var(--radius-md);
            transition: var(--transition-fast);
            background: var(--white);
            text-align: center;
            min-height: 120px;
            justify-content: center;
        }
        
        .vehicle-label:hover {
            border-color: var(--primary-orange);
            background: rgba(255, 107, 53, 0.02);
        }
        
        .vehicle-input:checked + .vehicle-label {
            border-color: var(--primary-orange);
            background: rgba(255, 107, 53, 0.05);
            box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
        }
        
        .vehicle-icon {
            width: 40px;
            height: 40px;
            margin-bottom: 0.75rem;
            color: var(--primary-orange);
        }
        
        .vehicle-title {
            font-weight: 500;
            color: var(--dark-gray);
            margin-bottom: 0.25rem;
        }
        
        .vehicle-desc {
            font-size: 0.85rem;
            color: var(--gray);
        }
        
        .password-wrapper {
            position: relative;
        }
        
        .password-toggle {
            position: absolute;
            right: 0.75rem;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--gray);
            cursor: pointer;
            padding: 0.5rem;
            border-radius: var(--radius-sm);
            transition: var(--transition-fast);
        }
        
        .password-toggle:hover {
            color: var(--primary-orange);
            background: rgba(255, 107, 53, 0.05);
        }
        
        .strength-indicator {
            margin-top: 0.5rem;
        }
        
        .strength-bars {
            display: flex;
            gap: 0.25rem;
            margin-bottom: 0.5rem;
        }
        
        .strength-bar {
            height: 4px;
            flex: 1;
            background: var(--medium-gray);
            border-radius: 2px;
            transition: var(--transition-fast);
        }
        
        .strength-text {
            font-size: 0.8rem;
            font-weight: 500;
        }
        
        .terms-checkbox {
            display: flex;
            align-items: flex-start;
            gap: 0.75rem;
            margin: 1.5rem 0;
        }
        
        .terms-checkbox input[type="checkbox"] {
            margin-top: 0.125rem;
        }
        
        .auth-submit {
            width: 100%;
            background: var(--primary-gradient);
            color: var(--white);
            border: none;
            padding: 0.875rem 1.5rem;
            border-radius: var(--radius-md);
            font-family: inherit;
            font-weight: 500;
            font-size: 1rem;
            cursor: pointer;
            transition: var(--transition-fast);
            box-shadow: var(--shadow-sm);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }
        
        .auth-submit:hover {
            transform: translateY(-1px);
            box-shadow: var(--shadow-md);
        }
        
        .auth-submit:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .auth-footer {
            text-align: center;
            margin-top: 2rem;
            padding-top: 1.5rem;
            border-top: 1px solid var(--medium-gray);
        }
        
        .auth-link {
            color: var(--primary-orange);
            text-decoration: none;
            font-weight: 500;
            transition: var(--transition-fast);
        }
        
        .auth-link:hover {
            color: var(--primary-dark);
            text-decoration: underline;
        }
        
        @media (max-width: 640px) {
            .auth-card {
                padding: 2rem 1.5rem;
                margin: 1rem;
            }
            
            .form-grid {
                grid-template-columns: 1fr;
            }
            
            .vehicle-selection {
                grid-template-columns: 1fr;
            }
        }
    </style>

    <div class="auth-container">
        <div class="auth-card">
            <!-- Header -->
            <div class="auth-header">
                <div class="auth-logo">
                    <svg width="32" height="32" fill="white" viewBox="0 0 24 24">
                        <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
                    </svg>
                </div>
                <h1 class="auth-title">สมัครสมาชิก</h1>
                <p class="auth-subtitle">กรอกข้อมูลเพื่อสร้างบัญชีใหม่</p>
            </div>

            <!-- Form -->
            <form method="POST" action="{{ route('register') }}" id="registerForm">
                @csrf

                <!-- Warehouse Selection -->
                <div class="form-group form-grid-full">
                    <label for="warehouse_code" class="form-label">เลือกคลัง <span style="color: var(--danger);">*</span></label>
                    <select id="warehouse_code" name="warehouse_code" class="form-control @error('warehouse_code') border-red-300 @enderror" required>
                        <option value="">-- เลือกคลัง --</option>
                        @if(isset($warehouses))
                            @foreach($warehouses as $warehouse)
                                <option value="{{ $warehouse->code }}" 
                                        {{ old('warehouse_code') == $warehouse->code ? 'selected' : '' }}
                                        data-location="{{ $warehouse->location }}">
                                    {{ $warehouse->code }} - {{ $warehouse->name }}
                                    @if($warehouse->location)
                                        ({{ $warehouse->location }})
                                    @endif
                                </option>
                            @endforeach
                        @endif
                    </select>
                    @error('warehouse_code')
                        <div style="color: var(--danger); font-size: 0.875rem; margin-top: 0.25rem;">{{ $message }}</div>
                    @enderror
                </div>

                <!-- Name Fields -->
                <div class="form-grid">
                    <div class="form-group">
                        <label for="first_name" class="form-label">ชื่อ <span style="color: var(--danger);">*</span></label>
                        <input type="text" 
                               id="first_name" 
                               name="first_name" 
                               style="width: 100%;"
                               class="form-control @error('first_name') border-red-300 @enderror"
                               value="{{ old('first_name') }}" 
                               required 
                               autocomplete="given-name"
                               placeholder="กรอกชื่อ">
                        @error('first_name')
                            <div style="color: var(--danger); font-size: 0.875rem; margin-top: 0.25rem;">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="last_name" class="form-label">นามสกุล <span style="color: var(--danger);">*</span></label>
                        <input type="text" 
                               id="last_name" 
                               name="last_name" 
                               style="width: 100%;"
                               class="form-control @error('last_name') border-red-300 @enderror"
                               value="{{ old('last_name') }}" 
                               required 
                               autocomplete="family-name"
                               placeholder="กรอกนามสกุล">
                        @error('last_name')
                            <div style="color: var(--danger); font-size: 0.875rem; margin-top: 0.25rem;">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <!-- Vehicle Type Selection -->
                <div class="form-group form-grid-full">
                    <label class="form-label">ประเภทรถ <span style="color: var(--danger);">*</span></label>
                    <div class="vehicle-selection">
                        <div class="vehicle-card">
                            <input type="radio" 
                                   id="2wheel" 
                                   name="role" 
                                   value="2wheel" 
                                   class="vehicle-input"
                                   {{ old('role') == '2wheel' ? 'checked' : '' }}
                                   required>
                            <label for="2wheel" class="vehicle-label">
                                <svg class="vehicle-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                                </svg>
                                <div class="vehicle-title">รถ 2 ล้อ</div>
                                <div class="vehicle-desc">มอเตอร์ไซค์</div>
                            </label>
                        </div>

                        <div class="vehicle-card">
                            <input type="radio" 
                                   id="4wheel" 
                                   name="role" 
                                   value="4wheel" 
                                   class="vehicle-input"
                                   {{ old('role') == '4wheel' ? 'checked' : '' }}
                                   required>
                            <label for="4wheel" class="vehicle-label">
                                <svg class="vehicle-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l4-4 4 4m0 6l-4 4-4-4"></path>
                                </svg>
                                <div class="vehicle-title">รถ 4 ล้อ</div>
                                <div class="vehicle-desc">รถยนต์/รถกระบะ</div>
                            </label>
                        </div>
                    </div>
                    @error('role')
                        <div style="color: var(--danger); font-size: 0.875rem; margin-top: 0.25rem;">{{ $message }}</div>
                    @enderror
                </div>

                <!-- Email -->
                <div class="form-group form-grid-full">
                    <label for="email" class="form-label">อีเมล <span style="color: var(--danger);">*</span></label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           class="form-control @error('email') border-red-300 @enderror"
                           value="{{ old('email') }}" 
                           required 
                           autocomplete="username"
                           placeholder="example@email.com">
                    @error('email')
                        <div style="color: var(--danger); font-size: 0.875rem; margin-top: 0.25rem;">{{ $message }}</div>
                    @enderror
                </div>

                <!-- Password -->
                <div class="form-group form-grid-full">
                    <label for="password" class="form-label">รหัสผ่าน <span style="color: var(--danger);">*</span></label>
                    <div class="password-wrapper">
                        <input type="password" 
                               id="password" 
                               name="password" 
                               style="width: 100%;"
                               class="form-control @error('password') border-red-300 @enderror"
                               required 
                               autocomplete="new-password"
                               placeholder="อย่างน้อย 8 ตัวอักษร"
                               style="padding-right: 3rem;">
                        <button type="button" class="password-toggle" onclick="togglePassword('password')">
                            <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24" id="password-eye">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                            </svg>
                        </button>
                    </div>
                    @error('password')
                        <div style="color: var(--danger); font-size: 0.875rem; margin-top: 0.25rem;">{{ $message }}</div>
                    @enderror
                    
                    <!-- Password Strength Indicator -->
                    <div class="strength-indicator">
                        <div class="strength-bars">
                            <div class="strength-bar" id="strength-1"></div>
                            <div class="strength-bar" id="strength-2"></div>
                            <div class="strength-bar" id="strength-3"></div>
                            <div class="strength-bar" id="strength-4"></div>
                        </div>
                        <div class="strength-text" id="strength-text" style="color: var(--gray);">กรอกรหัสผ่าน</div>
                    </div>
                </div>

                <!-- Confirm Password -->
                <div class="form-group form-grid-full">
                    <label for="password_confirmation" class="form-label">ยืนยันรหัสผ่าน <span style="color: var(--danger);">*</span></label>
                    <div class="password-wrapper">
                        <input type="password" 
                               id="password_confirmation" 
                               name="password_confirmation" 
                               style="width: 100%;"
                               class="form-control @error('password_confirmation') border-red-300 @enderror"
                               required 
                               autocomplete="new-password"
                               placeholder="กรอกรหัสผ่านอีกครั้ง"
                               style="padding-right: 3rem;">
                        <button type="button" class="password-toggle" onclick="togglePassword('password_confirmation')">
                            <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24" id="password_confirmation-eye">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                            </svg>
                        </button>
                    </div>
                    @error('password_confirmation')
                        <div style="color: var(--danger); font-size: 0.875rem; margin-top: 0.25rem;">{{ $message }}</div>
                    @enderror
                    <div style="font-size: 0.8rem; margin-top: 0.25rem;" id="password-match"></div>
                </div>

                <!-- Terms and Conditions -->
                <div class="terms-checkbox">
                    <input type="checkbox" 
                           name="terms" 
                           id="terms"
                           class="form-control" 
                           style="width: auto; height: auto;"
                           required>
                    <label for="terms" style="font-size: 0.9rem; color: var(--gray);">
                        ฉันยอมรับ
                        <a href="#" class="auth-link">ข้อกำหนดและเงื่อนไข</a>
                        และ
                        <a href="#" class="auth-link">นโยบายความเป็นส่วนตัว</a>
                    </label>
                </div>
                @error('terms')
                    <div style="color: var(--danger); font-size: 0.875rem; margin-top: -0.5rem;">{{ $message }}</div>
                @enderror

                <!-- Submit Button -->
                <button type="submit" class="auth-submit" id="submitBtn">
                    <span id="submitText">สร้างบัญชี</span>
                    <svg class="animate-spin hidden" id="loadingIcon" width="20" height="20" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </button>

                <!-- Footer -->
                <div class="auth-footer">
                    <p style="color: var(--gray); font-size: 0.9rem;">
                        มีบัญชีอยู่แล้ว? 
                        <a href="{{ route('login') }}" class="auth-link">เข้าสู่ระบบ</a>
                    </p>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Password visibility toggle
        function togglePassword(fieldId) {
            const field = document.getElementById(fieldId);
            const eye = document.getElementById(fieldId + '-eye');
            
            if (field.type === 'password') {
                field.type = 'text';
                eye.innerHTML = `
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L3 3m6.878 6.878L21 21" />
                `;
            } else {
                field.type = 'password';
                eye.innerHTML = `
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                `;
            }
        }

        // Password strength checker
        function checkPasswordStrength(password) {
            let strength = 0;
            if (password.length >= 8) strength++;
            if (/[a-z]/.test(password) && /[A-Z]/.test(password)) strength++;
            if (/\d/.test(password)) strength++;
            if (/[^A-Za-z0-9]/.test(password)) strength++;
            return strength;
        }

        // Update password strength indicator
        document.getElementById('password').addEventListener('input', function() {
            const password = this.value;
            const strength = checkPasswordStrength(password);
            const colors = ['#EF4444', '#F59E0B', '#FFD93D', '#22C55E'];
            const labels = ['อ่อนแอ', 'พอใช้', 'ดี', 'แข็งแกร่ง'];
            
            // Reset all bars
            for (let i = 1; i <= 4; i++) {
                document.getElementById(`strength-${i}`).style.background = '#E9ECEF';
            }

            // Update active bars
            for (let i = 1; i <= strength; i++) {
                document.getElementById(`strength-${i}`).style.background = colors[strength - 1] || '#EF4444';
            }

            const strengthText = document.getElementById('strength-text');
            if (password.length === 0) {
                strengthText.textContent = 'กรอกรหัสผ่าน';
                strengthText.style.color = '#6C757D';
            } else {
                strengthText.textContent = labels[strength - 1] || 'อ่อนแอ';
                strengthText.style.color = colors[strength - 1] || '#EF4444';
            }
        });

        // Password confirmation checker
        document.getElementById('password_confirmation').addEventListener('input', function() {
            const password = document.getElementById('password').value;
            const confirmation = this.value;
            const matchDiv = document.getElementById('password-match');

            if (confirmation.length === 0) {
                matchDiv.textContent = '';
            } else if (password === confirmation) {
                matchDiv.textContent = '✓ รหัสผ่านตรงกัน';
                matchDiv.style.color = '#22C55E';
            } else {
                matchDiv.textContent = '✗ รหัสผ่านไม่ตรงกัน';
                matchDiv.style.color = '#EF4444';
            }
        });

        // Form submission handling
        document.getElementById('registerForm').addEventListener('submit', function(e) {
            const submitBtn = document.getElementById('submitBtn');
            const submitText = document.getElementById('submitText');
            const loadingIcon = document.getElementById('loadingIcon');
            
            submitBtn.disabled = true;
            submitText.textContent = 'กำลังสร้างบัญชี...';
            loadingIcon.classList.remove('hidden');
        });
    </script>
</x-guest-layout>