@extends('layouts.app')

@section('content')
<div class="monthly-report-container">
    <!-- Header -->
    <div class="report-header">
        <div class="header-content">
            <h1 class="report-title">
                <i class="fas fa-calendar-alt"></i>
                รายงานรายเดือน
            </h1>
            <p class="report-subtitle">
                {{ Carbon\Carbon::parse($month)->locale('th')->monthName }} 
                {{ Carbon\Carbon::parse($month)->year + 543 }}
            </p>
        </div>
        <div class="header-actions">
            <form method="GET" action="{{ route('finance.reports.monthly') }}" class="month-selector">
                <input type="month" name="month" value="{{ $month }}" class="form-control" onchange="this.form.submit()">
            </form>
            <div class="export-buttons">
                <form method="POST" action="{{ route('finance.reports.export') }}" class="d-inline">
                    @csrf
                    <input type="hidden" name="type" value="monthly">
                    <input type="hidden" name="period" value="{{ $month }}">
                    <input type="hidden" name="format" value="csv">
                    <button type="submit" class="btn btn-export">
                        <i class="fas fa-file-csv"></i> CSV
                    </button>
                </form>
                <form method="POST" action="{{ route('finance.reports.export') }}" class="d-inline">
                    @csrf
                    <input type="hidden" name="type" value="monthly">
                    <input type="hidden" name="period" value="{{ $month }}">
                    <input type="hidden" name="format" value="pdf">
                    <button type="submit" class="btn btn-export">
                        <i class="fas fa-file-pdf"></i> PDF
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="summary-section">
        <div class="summary-card income">
            <div class="card-icon">
                <i class="fas fa-arrow-circle-up"></i>
            </div>
            <div class="card-content">
                <h3>รายรับรวม</h3>
                <p class="amount">฿{{ number_format($monthlyStats['total_income'], 2) }}</p>
                <div class="sources">
                    @foreach($monthlyStats['income_sources'] as $source => $amount)
                        <div class="source-item">
                            <span>{{ $source === 'delivery' ? 'จากการจัดส่ง' : 'บันทึกเอง' }}</span>
                            <span>฿{{ number_format($amount, 2) }}</span>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <div class="summary-card expense">
            <div class="card-icon">
                <i class="fas fa-arrow-circle-down"></i>
            </div>
            <div class="card-content">
                <h3>รายจ่ายรวม</h3>
                <p class="amount">฿{{ number_format($monthlyStats['total_expense'], 2) }}</p>
                <div class="top-categories">
                    @foreach($monthlyStats['expense_by_category']->take(3) as $cat)
                        @php
                            $category = \App\Models\FinanceCategory::where('slug', $cat['category'])->first();
                        @endphp
                        <div class="category-item">
                            <span>
                                <i class="fas {{ $category->icon ?? 'fa-circle' }}" style="color: {{ $category->color ?? '#6B7280' }}"></i>
                                {{ $category->name ?? $cat['category'] }}
                            </span>
                            <span>{{ $cat['percentage'] }}%</span>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <div class="summary-card {{ $monthlyStats['is_positive'] ? 'positive' : 'negative' }}">
            <div class="card-icon">
                <i class="fas {{ $monthlyStats['is_positive'] ? 'fa-check-circle' : 'fa-exclamation-circle' }}"></i>
            </div>
            <div class="card-content">
                <h3>สถานะ</h3>
                <p class="amount">฿{{ number_format($monthlyStats['net_amount'], 2) }}</p>
                <span class="status-label">
                    {{ $monthlyStats['is_positive'] ? 'เงินเหลือ' : 'ติดลบ' }}
                </span>
            </div>
        </div>
    </div>

    <!-- Daily Chart -->
    <div class="chart-section">
        <h2 class="section-title">
            <i class="fas fa-chart-line"></i>
            กราฟรายวัน
        </h2>
        <div class="chart-container">
            <canvas id="dailyChart"></canvas>
        </div>
    </div>

    <!-- Category Breakdown -->
    <div class="category-section">
        <h2 class="section-title">
            <i class="fas fa-chart-pie"></i>
            สัดส่วนค่าใช้จ่าย
        </h2>
        <div class="category-grid">
            <div class="pie-chart">
                <canvas id="categoryChart"></canvas>
            </div>
            <div class="category-list">
                @foreach($monthlyStats['expense_by_category'] as $expense)
                    @php
                        $category = \App\Models\FinanceCategory::where('slug', $expense['category'])->first();
                    @endphp
                    <div class="category-row">
                        <div class="category-info">
                            <span class="category-color" style="background: {{ $category->color ?? '#6B7280' }}"></span>
                            <i class="fas {{ $category->icon ?? 'fa-circle' }}"></i>
                            <span class="category-name">{{ $category->name ?? $expense['category'] }}</span>
                        </div>
                        <div class="category-data">
                            <span class="amount">฿{{ number_format($expense['amount'], 2) }}</span>
                            <span class="percentage">{{ $expense['percentage'] }}%</span>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Budget vs Actual -->
    @if($budgets->count() > 0)
    <div class="budget-comparison">
        <h2 class="section-title">
            <i class="fas fa-balance-scale"></i>
            เปรียบเทียบกับงบประมาณ
        </h2>
        <div class="budget-table">
            <table>
                <thead>
                    <tr>
                        <th>หมวดหมู่</th>
                        <th>งบประมาณ</th>
                        <th>ใช้จริง</th>
                        <th>คงเหลือ</th>
                        <th>สถานะ</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($budgets as $budget)
                        <tr class="{{ $budget->status }}">
                            <td>
                                <i class="fas {{ $budget->categoryInfo->icon ?? 'fa-circle' }}" 
                                   style="color: {{ $budget->categoryInfo->color ?? '#6B7280' }}"></i>
                                {{ $budget->categoryInfo->name ?? $budget->category }}
                            </td>
                            <td>฿{{ number_format($budget->budget_amount, 2) }}</td>
                            <td>฿{{ number_format($budget->spent_amount, 2) }}</td>
                            <td>฿{{ number_format($budget->remaining_amount, 2) }}</td>
                            <td>
                                <div class="progress-bar-mini">
                                    <div class="progress-fill {{ $budget->status }}" 
                                         style="width: {{ min($budget->usage_percentage, 100) }}%"></div>
                                </div>
                                <span class="percentage-text">{{ $budget->usage_percentage }}%</span>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th>รวม</th>
                        <th>฿{{ number_format($budgets->sum('budget_amount'), 2) }}</th>
                        <th>฿{{ number_format($budgets->sum('spent_amount'), 2) }}</th>
                        <th>฿{{ number_format($budgets->sum('remaining_amount'), 2) }}</th>
                        <th>
                            @php
                                $totalBudget = $budgets->sum('budget_amount');
                                $totalSpent = $budgets->sum('spent_amount');
                                $totalPercentage = $totalBudget > 0 ? round(($totalSpent / $totalBudget) * 100, 1) : 0;
                            @endphp
                            {{ $totalPercentage }}%
                        </th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
    @endif

    <!-- Daily Details -->
    <div class="daily-details">
        <h2 class="section-title">
            <i class="fas fa-calendar-day"></i>
            รายละเอียดรายวัน
        </h2>
        <div class="daily-table">
            <table>
                <thead>
                    <tr>
                        <th>วันที่</th>
                        <th>รายรับ</th>
                        <th>รายจ่าย</th>
                        <th>คงเหลือ</th>
                        <th>สะสม</th>
                    </tr>
                </thead>
                <tbody>
                    @php $cumulative = 0; @endphp
                    @foreach($dailyData as $day)
                        @php $cumulative += $day['net']; @endphp
                        <tr class="{{ $day['net'] >= 0 ? 'positive' : 'negative' }}">
                            <td>
                                <strong>{{ $day['day'] }}</strong>
                                <span class="day-name">{{ Carbon\Carbon::parse($day['date'])->locale('th')->dayName }}</span>
                            </td>
                            <td class="income">฿{{ number_format($day['income'], 2) }}</td>
                            <td class="expense">฿{{ number_format($day['expense'], 2) }}</td>
                            <td class="{{ $day['net'] >= 0 ? 'positive' : 'negative' }}">
                                ฿{{ number_format($day['net'], 2) }}
                            </td>
                            <td class="{{ $cumulative >= 0 ? 'positive' : 'negative' }}">
                                ฿{{ number_format($cumulative, 2) }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@push('styles')
<style>
.monthly-report-container {
    max-width: 1200px;
    margin: 2rem auto;
    padding: 0 1rem;
}

/* Header */
.report-header {
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    border-radius: 20px;
    padding: 2rem;
    color: white;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(59, 130, 246, 0.3);
}

.header-content {
    margin-bottom: 1.5rem;
}

.report-title {
    font-size: 1.8rem;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin-bottom: 0.5rem;
}

.report-subtitle {
    font-size: 1.2rem;
    opacity: 0.9;
}

.header-actions {
    display: flex;
    gap: 1rem;
    align-items: center;
    flex-wrap: wrap;
}

.month-selector .form-control {
    background: rgba(255, 255, 255, 0.2);
    border: 1px solid rgba(255, 255, 255, 0.3);
    color: white;
    padding: 0.5rem 1rem;
    border-radius: 10px;
}

.export-buttons {
    display: flex;
    gap: 0.5rem;
}

.btn-export {
    background: rgba(255, 255, 255, 0.2);
    border: 1px solid rgba(255, 255, 255, 0.3);
    color: white;
    padding: 0.5rem 1rem;
    border-radius: 8px;
    font-size: 0.9rem;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-export:hover {
    background: rgba(255, 255, 255, 0.3);
}

/* Summary Cards */
.summary-section {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.summary-card {
    background: white;
    border-radius: 16px;
    padding: 1.5rem;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    display: flex;
    gap: 1.5rem;
    align-items: flex-start;
}

.summary-card .card-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.8rem;
    flex-shrink: 0;
}

.summary-card.income .card-icon {
    background: #d1fae5;
    color: #10b981;
}

.summary-card.expense .card-icon {
    background: #fee2e2;
    color: #ef4444;
}

.summary-card.positive .card-icon {
    background: #dbeafe;
    color: #3b82f6;
}

.summary-card.negative .card-icon {
    background: #fef3c7;
    color: #f59e0b;
}

.card-content {
    flex: 1;
}

.card-content h3 {
    font-size: 0.9rem;
    color: #6b7280;
    margin-bottom: 0.5rem;
}

.card-content .amount {
    font-size: 1.8rem;
    font-weight: 700;
    color: #1f2937;
    margin-bottom: 0.75rem;
}

.sources,
.top-categories {
    font-size: 0.85rem;
}

.source-item,
.category-item {
    display: flex;
    justify-content: space-between;
    padding: 0.25rem 0;
    color: #6b7280;
}

.status-label {
    display: inline-block;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.875rem;
    font-weight: 600;
}

.summary-card.positive .status-label {
    background: #d1fae5;
    color: #065f46;
}

.summary-card.negative .status-label {
    background: #fee2e2;
    color: #991b1b;
}

/* Chart Section */
.chart-section,
.category-section,
.budget-comparison,
.daily-details {
    background: white;
    border-radius: 16px;
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
}

.section-title {
    font-size: 1.2rem;
    font-weight: 600;
    color: #1f2937;
    margin-bottom: 1.5rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.chart-container {
    height: 300px;
    position: relative;
}

/* Category Grid */
.category-grid {
    display: grid;
    grid-template-columns: 300px 1fr;
    gap: 2rem;
    align-items: center;
}

.pie-chart {
    height: 300px;
    position: relative;
}

.category-list {
    max-height: 300px;
    overflow-y: auto;
}

.category-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem 0;
    border-bottom: 1px solid #f3f4f6;
}

.category-row:last-child {
    border-bottom: none;
}

.category-info {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.category-color {
    width: 12px;
    height: 12px;
    border-radius: 3px;
}

.category-name {
    font-weight: 500;
    color: #374151;
}

.category-data {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.category-data .amount {
    font-weight: 600;
    color: #1f2937;
}

.category-data .percentage {
    background: #f3f4f6;
    padding: 0.25rem 0.5rem;
    border-radius: 6px;
    font-size: 0.875rem;
    color: #6b7280;
}

/* Budget Table */
.budget-table table,
.daily-table table {
    width: 100%;
    border-collapse: collapse;
}

.budget-table th,
.budget-table td,
.daily-table th,
.daily-table td {
    padding: 0.75rem;
    text-align: left;
    border-bottom: 1px solid #f3f4f6;
}

.budget-table th,
.daily-table th {
    background: #f9fafb;
    font-weight: 600;
    color: #374151;
    font-size: 0.875rem;
}

.budget-table tr.over {
    background: #fef2f2;
}

.budget-table tr.warning {
    background: #fffbeb;
}

.progress-bar-mini {
    width: 100px;
    height: 8px;
    background: #e5e7eb;
    border-radius: 4px;
    overflow: hidden;
    display: inline-block;
    margin-right: 0.5rem;
}

.progress-fill {
    height: 100%;
    transition: width 0.3s;
}

.progress-fill.good {
    background: #10b981;
}

.progress-fill.warning {
    background: #f59e0b;
}

.progress-fill.over {
    background: #ef4444;
}

.percentage-text {
    font-size: 0.875rem;
    font-weight: 600;
}

/* Daily Table */
.daily-table td.income {
    color: #10b981;
}

.daily-table td.expense {
    color: #ef4444;
}

.daily-table td.positive {
    color: #10b981;
    font-weight: 600;
}

.daily-table td.negative {
    color: #ef4444;
    font-weight: 600;
}

.day-name {
    font-size: 0.875rem;
    color: #6b7280;
    margin-left: 0.5rem;
}

/* Responsive */
@media (max-width: 768px) {
    .category-grid {
        grid-template-columns: 1fr;
    }
    
    .header-actions {
        flex-direction: column;
        width: 100%;
    }
    
    .month-selector {
        width: 100%;
    }
    
    .summary-section {
        grid-template-columns: 1fr;
    }
    
    .budget-table,
    .daily-table {
        overflow-x: auto;
    }
}

/* Scrollbar */
.category-list::-webkit-scrollbar {
    width: 6px;
}

.category-list::-webkit-scrollbar-track {
    background: #f3f4f6;
    border-radius: 3px;
}

.category-list::-webkit-scrollbar-thumb {
    background: #d1d5db;
    border-radius: 3px;
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Daily Chart
const dailyCtx = document.getElementById('dailyChart').getContext('2d');
const dailyData = @json($dailyData);

new Chart(dailyCtx, {
    type: 'line',
    data: {
        labels: dailyData.map(d => d.day),
        datasets: [{
            label: 'รายรับ',
            data: dailyData.map(d => d.income),
            borderColor: '#10b981',
            backgroundColor: '#10b98120',
            tension: 0.4
        }, {
            label: 'รายจ่าย',
            data: dailyData.map(d => d.expense),
            borderColor: '#ef4444',
            backgroundColor: '#ef444420',
            tension: 0.4
        }, {
            label: 'คงเหลือ',
            data: dailyData.map(d => d.net),
            borderColor: '#3b82f6',
            backgroundColor: '#3b82f620',
            tension: 0.4
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom'
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return '฿' + value.toLocaleString();
                    }
                }
            }
        }
    }
});

// Category Pie Chart
const categoryCtx = document.getElementById('categoryChart').getContext('2d');
const categoryData = @json($monthlyStats['expense_by_category']);
const categories = @json(\App\Models\FinanceCategory::expense()->get());

new Chart(categoryCtx, {
    type: 'doughnut',
    data: {
        labels: categoryData.map(d => {
            const cat = categories.find(c => c.slug === d.category);
            return cat ? cat.name : d.category;
        }),
        datasets: [{
            data: categoryData.map(d => d.amount),
            backgroundColor: categoryData.map(d => {
                const cat = categories.find(c => c.slug === d.category);
                return cat ? cat.color : '#6B7280';
            })
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom'
            }
        }
    }
});
</script>
@endpush
@endsection