

<?php $__env->startSection('content'); ?>
<div class="goal-form-container">
    <div class="form-header">
        <h1 class="form-title">
            <i class="fas fa-piggy-bank"></i>
            สร้างเป้าหมายการออม
        </h1>
        <a href="<?php echo e(route('finance.goals.index')); ?>" class="btn-back">
            <i class="fas fa-arrow-left"></i> กลับ
        </a>
    </div>

    <form method="POST" action="<?php echo e(route('finance.goals.store')); ?>" class="goal-form">
        <?php echo csrf_field(); ?>
        
        <div class="form-section">
            <h2 class="section-title">ข้อมูลเป้าหมาย</h2>
            
            <div class="form-group">
                <label class="form-label">
                    <i class="fas fa-bullseye"></i> ชื่อเป้าหมาย
                </label>
                <input type="text" 
                       name="goal_name" 
                       class="form-control <?php $__errorArgs = ['goal_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                       placeholder="เช่น ซื้อรถใหม่, เที่ยวญี่ปุ่น, เงินฉุกเฉิน"
                       value="<?php echo e(old('goal_name')); ?>"
                       required>
                <?php $__errorArgs = ['goal_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">
                        <i class="fas fa-coins"></i> จำนวนเงินเป้าหมาย
                    </label>
                    <div class="input-group">
                        <span class="input-addon">฿</span>
                        <input type="number" 
                               name="target_amount" 
                               class="form-control amount-input <?php $__errorArgs = ['target_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               placeholder="0.00"
                               value="<?php echo e(old('target_amount')); ?>"
                               step="100"
                               min="1"
                               required>
                    </div>
                    <?php $__errorArgs = ['target_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-group">
                    <label class="form-label">
                        <i class="fas fa-calendar-alt"></i> วันที่เป้าหมาย (ถ้ามี)
                    </label>
                    <input type="date" 
                           name="target_date" 
                           class="form-control <?php $__errorArgs = ['target_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                           value="<?php echo e(old('target_date')); ?>"
                           min="<?php echo e(date('Y-m-d', strtotime('+1 day'))); ?>">
                    <?php $__errorArgs = ['target_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="form-group">
                <label class="form-label">
                    <i class="fas fa-wallet"></i> จำนวนเงินเริ่มต้น (ถ้ามี)
                </label>
                <div class="input-group">
                    <span class="input-addon">฿</span>
                    <input type="number" 
                           name="initial_amount" 
                           class="form-control amount-input <?php $__errorArgs = ['initial_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                           placeholder="0.00"
                           value="<?php echo e(old('initial_amount', 0)); ?>"
                           step="100"
                           min="0">
                </div>
                <?php $__errorArgs = ['initial_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
        </div>

        <!-- Goal Calculator -->
        <div class="calculator-section">
            <h2 class="section-title">
                <i class="fas fa-calculator"></i> คำนวณการออม
            </h2>
            <div class="calculator-result" id="calculatorResult" style="display: none;">
                <div class="result-item">
                    <span class="label">ต้องออมทั้งหมด:</span>
                    <span class="value" id="totalToSave">฿0</span>
                </div>
                <div class="result-item">
                    <span class="label">ระยะเวลา:</span>
                    <span class="value" id="duration">- วัน</span>
                </div>
                <div class="result-item highlight">
                    <span class="label">ควรออมต่อเดือน:</span>
                    <span class="value" id="monthlySaving">฿0</span>
                </div>
                <div class="result-item">
                    <span class="label">ควรออมต่อวัน:</span>
                    <span class="value" id="dailySaving">฿0</span>
                </div>
            </div>
            <p class="calculator-hint">กรอกจำนวนเงินเป้าหมายและวันที่เพื่อคำนวณแผนการออม</p>
        </div>

        <!-- Goal Ideas -->
        <div class="ideas-section">
            <h3>💡 ไอเดียเป้าหมายการออม</h3>
            <div class="idea-tags">
                <button type="button" class="idea-tag" onclick="setGoalIdea('เงินฉุกเฉิน 6 เดือน', 180000)">
                    🏥 เงินฉุกเฉิน 6 เดือน
                </button>
                <button type="button" class="idea-tag" onclick="setGoalIdea('ดาวน์บ้าน', 300000)">
                    🏠 ดาวน์บ้าน
                </button>
                <button type="button" class="idea-tag" onclick="setGoalIdea('ซื้อรถใหม่', 200000)">
                    🚗 ซื้อรถใหม่
                </button>
                <button type="button" class="idea-tag" onclick="setGoalIdea('เที่ยวต่างประเทศ', 50000)">
                    ✈️ เที่ยวต่างประเทศ
                </button>
                <button type="button" class="idea-tag" onclick="setGoalIdea('แต่งงาน', 500000)">
                    💒 แต่งงาน
                </button>
                <button type="button" class="idea-tag" onclick="setGoalIdea('เรียนต่อ', 100000)">
                    🎓 เรียนต่อ
                </button>
            </div>
        </div>

        <div class="form-actions">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i>
                สร้างเป้าหมาย
            </button>
            <a href="<?php echo e(route('finance.goals.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-times"></i> ยกเลิก
            </a>
        </div>
    </form>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.goal-form-container {
    max-width: 700px;
    margin: 2rem auto;
    padding: 0 1rem;
}

.form-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 2rem;
}

.form-title {
    font-size: 1.8rem;
    font-weight: 700;
    color: #1f2937;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-back {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: #6b7280;
    text-decoration: none;
    font-weight: 500;
    transition: color 0.3s;
}

.btn-back:hover {
    color: #3b82f6;
}

.goal-form {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
}

/* Form Sections */
.form-section,
.calculator-section,
.ideas-section {
    margin-bottom: 2rem;
}

.section-title {
    font-size: 1.2rem;
    font-weight: 600;
    color: #1f2937;
    margin-bottom: 1.5rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1.5rem;
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-label {
    font-weight: 600;
    color: #374151;
    margin-bottom: 0.5rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.form-control {
    width: 100%;
    padding: 0.75rem 1rem;
    border: 2px solid #e5e7eb;
    border-radius: 12px;
    font-size: 1rem;
    transition: all 0.3s;
    background: #f9fafb;
}

.form-control:focus {
    outline: none;
    border-color: #3b82f6;
    background: white;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.form-control.is-invalid {
    border-color: #ef4444;
}

.invalid-feedback {
    color: #ef4444;
    font-size: 0.875rem;
    margin-top: 0.25rem;
    display: block;
}

/* Input Group */
.input-group {
    display: flex;
    align-items: stretch;
}

.input-addon {
    display: flex;
    align-items: center;
    padding: 0 1rem;
    background: #f3f4f6;
    border: 2px solid #e5e7eb;
    border-right: none;
    border-radius: 12px 0 0 12px;
    color: #6b7280;
    font-weight: 600;
}

.input-group .form-control {
    border-radius: 0 12px 12px 0;
}

.amount-input {
    text-align: right;
    font-size: 1.2rem;
    font-weight: 600;
}

/* Calculator Section */
.calculator-section {
    background: #f9fafb;
    border-radius: 16px;
    padding: 1.5rem;
}

.calculator-result {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1rem;
    margin-bottom: 1rem;
}

.result-item {
    background: white;
    border-radius: 12px;
    padding: 1rem;
    text-align: center;
    border: 1px solid #e5e7eb;
}

.result-item.highlight {
    grid-column: 1 / -1;
    background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%);
    border-color: #3b82f6;
}

.result-item .label {
    display: block;
    font-size: 0.875rem;
    color: #6b7280;
    margin-bottom: 0.25rem;
}

.result-item .value {
    display: block;
    font-size: 1.25rem;
    font-weight: 700;
    color: #1f2937;
}

.result-item.highlight .value {
    color: #3b82f6;
    font-size: 1.5rem;
}

.calculator-hint {
    text-align: center;
    color: #6b7280;
    font-size: 0.875rem;
}

/* Ideas Section */
.ideas-section {
    background: #fef3c7;
    border-radius: 16px;
    padding: 1.5rem;
}

.ideas-section h3 {
    font-size: 1.1rem;
    font-weight: 600;
    color: #92400e;
    margin-bottom: 1rem;
}

.idea-tags {
    display: flex;
    flex-wrap: wrap;
    gap: 0.75rem;
}

.idea-tag {
    background: white;
    border: 2px solid #fbbf24;
    border-radius: 20px;
    padding: 0.5rem 1rem;
    font-size: 0.9rem;
    color: #78350f;
    cursor: pointer;
    transition: all 0.3s;
}

.idea-tag:hover {
    background: #fbbf24;
    color: white;
    transform: translateY(-2px);
}

/* Form Actions */
.form-actions {
    display: flex;
    gap: 1rem;
    margin-top: 2rem;
    padding-top: 2rem;
    border-top: 1px solid #e5e7eb;
}

.btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    border: none;
    border-radius: 12px;
    font-size: 1rem;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    text-decoration: none;
}

.btn-primary {
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: white;
    box-shadow: 0 4px 15px rgba(59, 130, 246, 0.3);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(59, 130, 246, 0.4);
}

.btn-secondary {
    background: #f3f4f6;
    color: #6b7280;
}

.btn-secondary:hover {
    background: #e5e7eb;
}

/* Responsive */
@media (max-width: 768px) {
    .goal-form {
        padding: 1.5rem;
    }
    
    .form-row {
        grid-template-columns: 1fr;
    }
    
    .calculator-result {
        grid-template-columns: 1fr;
    }
    
    .form-actions {
        flex-direction: column;
    }
    
    .btn {
        width: 100%;
        justify-content: center;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Calculate savings plan
function calculateSavings() {
    const targetAmount = parseFloat(document.querySelector('[name="target_amount"]').value) || 0;
    const initialAmount = parseFloat(document.querySelector('[name="initial_amount"]').value) || 0;
    const targetDate = document.querySelector('[name="target_date"]').value;
    
    if (targetAmount > 0 && targetDate) {
        const totalToSave = targetAmount - initialAmount;
        const today = new Date();
        const target = new Date(targetDate);
        const days = Math.ceil((target - today) / (1000 * 60 * 60 * 24));
        const months = Math.ceil(days / 30);
        
        if (days > 0 && totalToSave > 0) {
            const monthlySaving = totalToSave / months;
            const dailySaving = totalToSave / days;
            
            document.getElementById('totalToSave').textContent = '฿' + totalToSave.toLocaleString('th-TH', {minimumFractionDigits: 0});
            document.getElementById('duration').textContent = days + ' วัน (' + months + ' เดือน)';
            document.getElementById('monthlySaving').textContent = '฿' + monthlySaving.toLocaleString('th-TH', {minimumFractionDigits: 0});
            document.getElementById('dailySaving').textContent = '฿' + dailySaving.toLocaleString('th-TH', {minimumFractionDigits: 0});
            
            document.getElementById('calculatorResult').style.display = 'grid';
        } else {
            document.getElementById('calculatorResult').style.display = 'none';
        }
    } else {
        document.getElementById('calculatorResult').style.display = 'none';
    }
}

// Set goal idea
function setGoalIdea(name, amount) {
    document.querySelector('[name="goal_name"]').value = name;
    document.querySelector('[name="target_amount"]').value = amount;
    calculateSavings();
}

// Event listeners
document.querySelector('[name="target_amount"]').addEventListener('input', calculateSavings);
document.querySelector('[name="initial_amount"]').addEventListener('input', calculateSavings);
document.querySelector('[name="target_date"]').addEventListener('change', calculateSavings);

// Initial calculation
calculateSavings();
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\my-laravel-app\resources\views/finance/goals/create.blade.php ENDPATH**/ ?>