

<?php $__env->startSection('content'); ?>
<div class="reports-container">
    <div class="reports-header">
        <h1 class="reports-title">
            <i class="fas fa-file-chart-line"></i>
            รายงานการเงิน
        </h1>
        <p class="reports-subtitle">เลือกประเภทรายงานที่ต้องการดู</p>
    </div>

    <div class="report-cards">
        <!-- Monthly Report -->
        <div class="report-card">
            <div class="card-icon monthly">
                <i class="fas fa-calendar-alt"></i>
            </div>
            <div class="card-content">
                <h3>รายงานรายเดือน</h3>
                <p>ดูสรุปรายรับ-รายจ่าย และการใช้จ่ายในแต่ละวันของเดือน</p>
                <form action="<?php echo e(route('finance.reports.monthly')); ?>" method="GET" class="report-form">
                    <div class="form-group">
                        <label>เลือกเดือน</label>
                        <input type="month" name="month" class="form-control" 
                               value="<?php echo e(now()->format('Y-m')); ?>" required>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-chart-line"></i> ดูรายงาน
                    </button>
                </form>
            </div>
        </div>

        <!-- Yearly Report -->
        <div class="report-card">
            <div class="card-icon yearly">
                <i class="fas fa-chart-bar"></i>
            </div>
            <div class="card-content">
                <h3>รายงานรายปี</h3>
                <p>ดูภาพรวมการเงินทั้งปี แนวโน้มรายเดือน และการเปรียบเทียบ</p>
                <form action="<?php echo e(route('finance.reports.yearly')); ?>" method="GET" class="report-form">
                    <div class="form-group">
                        <label>เลือกปี</label>
                        <select name="year" class="form-control" required>
                            <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($year); ?>" <?php echo e($year == now()->year ? 'selected' : ''); ?>>
                                    <?php echo e($year + 543); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-chart-bar"></i> ดูรายงาน
                    </button>
                </form>
            </div>
        </div>

        <!-- Category Report -->
        <div class="report-card">
            <div class="card-icon category">
                <i class="fas fa-chart-pie"></i>
            </div>
            <div class="card-content">
                <h3>รายงานตามหมวดหมู่</h3>
                <p>วิเคราะห์รายรับ-รายจ่ายแยกตามหมวดหมู่ พร้อมเปอร์เซ็นต์</p>
                <form action="<?php echo e(route('finance.reports.category')); ?>" method="GET" class="report-form">
                    <div class="form-group">
                        <label>ช่วงเวลา</label>
                        <select name="period" class="form-control" id="categoryPeriod" required>
                            <option value="month">รายเดือน</option>
                            <option value="year">รายปี</option>
                        </select>
                    </div>
                    <div class="form-group" id="categoryMonthInput">
                        <label>เลือกเดือน</label>
                        <input type="month" name="date" class="form-control" 
                               value="<?php echo e(now()->format('Y-m')); ?>">
                    </div>
                    <div class="form-group" id="categoryYearInput" style="display: none;">
                        <label>เลือกปี</label>
                        <select name="year" class="form-control">
                            <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($year); ?>"><?php echo e($year + 543); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-chart-pie"></i> ดูรายงาน
                    </button>
                </form>
            </div>
        </div>

        <!-- Export Data -->
        <div class="report-card">
            <div class="card-icon export">
                <i class="fas fa-file-export"></i>
            </div>
            <div class="card-content">
                <h3>ส่งออกข้อมูล</h3>
                <p>ดาวน์โหลดรายงานเป็นไฟล์ CSV หรือ PDF</p>
                <form action="<?php echo e(route('finance.reports.export')); ?>" method="POST" class="report-form">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <label>ประเภทรายงาน</label>
                        <select name="type" class="form-control" required>
                            <option value="monthly">รายเดือน</option>
                            <option value="yearly">รายปี</option>
                            <option value="category">ตามหมวดหมู่</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>ช่วงเวลา</label>
                        <input type="month" name="period" class="form-control" 
                               value="<?php echo e(now()->format('Y-m')); ?>" required>
                    </div>
                    <div class="form-group">
                        <label>รูปแบบไฟล์</label>
                        <select name="format" class="form-control" required>
                            <option value="csv">CSV (Excel)</option>
                            <option value="pdf">PDF</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-export">
                        <i class="fas fa-download"></i> ดาวน์โหลด
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="quick-stats">
        <h2>สถิติด่วน</h2>
        <div class="stats-grid">
            <div class="stat-item">
                <i class="fas fa-calendar-check"></i>
                <div class="stat-info">
                    <h4>เดือนนี้</h4>
                    <p><?php echo e(now()->locale('th')->monthName); ?> <?php echo e(now()->year + 543); ?></p>
                </div>
            </div>
            <div class="stat-item">
                <i class="fas fa-coins"></i>
                <div class="stat-info">
                    <h4>รายรับเดือนนี้</h4>
                    <p>฿<?php echo e(number_format(\App\Models\FinanceRecord::forUser(auth()->id())->income()->forMonth(now()->format('Y-m'))->sum('amount'), 2)); ?></p>
                </div>
            </div>
            <div class="stat-item">
                <i class="fas fa-shopping-cart"></i>
                <div class="stat-info">
                    <h4>รายจ่ายเดือนนี้</h4>
                    <p>฿<?php echo e(number_format(\App\Models\FinanceRecord::forUser(auth()->id())->expense()->forMonth(now()->format('Y-m'))->sum('amount'), 2)); ?></p>
                </div>
            </div>
            <div class="stat-item">
                <i class="fas fa-piggy-bank"></i>
                <div class="stat-info">
                    <h4>คงเหลือเดือนนี้</h4>
                    <?php
                        $monthlyIncome = \App\Models\FinanceRecord::forUser(auth()->id())->income()->forMonth(now()->format('Y-m'))->sum('amount');
                        $monthlyExpense = \App\Models\FinanceRecord::forUser(auth()->id())->expense()->forMonth(now()->format('Y-m'))->sum('amount');
                        $monthlyNet = $monthlyIncome - $monthlyExpense;
                    ?>
                    <p class="<?php echo e($monthlyNet >= 0 ? 'text-success' : 'text-danger'); ?>">
                        ฿<?php echo e(number_format($monthlyNet, 2)); ?>

                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.reports-container {
    max-width: 1200px;
    margin: 2rem auto;
    padding: 0 1rem;
}

.reports-header {
    text-align: center;
    margin-bottom: 3rem;
}

.reports-title {
    font-size: 2rem;
    font-weight: 700;
    color: #1f2937;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    margin-bottom: 0.5rem;
}

.reports-subtitle {
    color: #6b7280;
    font-size: 1.1rem;
}

/* Report Cards */
.report-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 2rem;
    margin-bottom: 3rem;
}

.report-card {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    transition: all 0.3s;
}

.report-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.12);
}

.card-icon {
    width: 80px;
    height: 80px;
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2.5rem;
    margin-bottom: 1.5rem;
}

.card-icon.monthly {
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: white;
}

.card-icon.yearly {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
}

.card-icon.category {
    background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
    color: white;
}

.card-icon.export {
    background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);
    color: white;
}

.card-content h3 {
    font-size: 1.3rem;
    font-weight: 600;
    color: #1f2937;
    margin-bottom: 0.5rem;
}

.card-content p {
    color: #6b7280;
    margin-bottom: 1.5rem;
    line-height: 1.5;
}

/* Report Form */
.report-form {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.form-group label {
    font-weight: 600;
    color: #374151;
    font-size: 0.9rem;
}

.form-control {
    padding: 0.75rem 1rem;
    border: 2px solid #e5e7eb;
    border-radius: 10px;
    font-size: 1rem;
    transition: all 0.3s;
}

.form-control:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.btn {
    padding: 0.75rem 1.5rem;
    border: none;
    border-radius: 10px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
}

.btn-primary {
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(59, 130, 246, 0.3);
}

.btn-export {
    background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);
    color: white;
}

.btn-export:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(139, 92, 246, 0.3);
}

/* Quick Stats */
.quick-stats {
    background: #f9fafb;
    border-radius: 20px;
    padding: 2rem;
}

.quick-stats h2 {
    font-size: 1.3rem;
    font-weight: 600;
    color: #1f2937;
    margin-bottom: 1.5rem;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1.5rem;
}

.stat-item {
    background: white;
    border-radius: 12px;
    padding: 1.5rem;
    display: flex;
    align-items: center;
    gap: 1rem;
    border: 1px solid #e5e7eb;
}

.stat-item i {
    font-size: 2rem;
    color: #3b82f6;
}

.stat-info h4 {
    font-size: 0.875rem;
    color: #6b7280;
    margin-bottom: 0.25rem;
}

.stat-info p {
    font-size: 1.1rem;
    font-weight: 600;
    color: #1f2937;
    margin: 0;
}

.text-success {
    color: #10b981;
}

.text-danger {
    color: #ef4444;
}

/* Responsive */
@media (max-width: 768px) {
    .report-cards {
        grid-template-columns: 1fr;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .reports-title {
        font-size: 1.5rem;
    }
}

/* Form Select Styling */
select.form-control {
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%236b7280' d='M10.293 3.293L6 7.586 1.707 3.293A1 1 0 00.293 4.707l5 5a1 1 0 001.414 0l5-5a1 1 0 10-1.414-1.414z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 1rem center;
    padding-right: 2.5rem;
}

/* Animation */
@keyframes fadeIn {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.report-card {
    animation: fadeIn 0.5s ease-out;
}

.report-card:nth-child(1) {
    animation-delay: 0.1s;
}

.report-card:nth-child(2) {
    animation-delay: 0.2s;
}

.report-card:nth-child(3) {
    animation-delay: 0.3s;
}

.report-card:nth-child(4) {
    animation-delay: 0.4s;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Toggle period inputs for category report
document.getElementById('categoryPeriod').addEventListener('change', function() {
    const monthInput = document.getElementById('categoryMonthInput');
    const yearInput = document.getElementById('categoryYearInput');
    
    if (this.value === 'month') {
        monthInput.style.display = 'block';
        yearInput.style.display = 'none';
        monthInput.querySelector('input').required = true;
        yearInput.querySelector('select').required = false;
    } else {
        monthInput.style.display = 'none';
        yearInput.style.display = 'block';
        monthInput.querySelector('input').required = false;
        yearInput.querySelector('select').required = true;
    }
});

// Animate numbers on page load
document.addEventListener('DOMContentLoaded', function() {
    const statValues = document.querySelectorAll('.stat-info p');
    statValues.forEach(stat => {
        const value = stat.textContent;
        if (value.includes('฿')) {
            const numericValue = parseFloat(value.replace(/[^\d.-]/g, ''));
            let current = 0;
            const increment = numericValue / 50;
            const timer = setInterval(() => {
                current += increment;
                if (current >= numericValue) {
                    current = numericValue;
                    clearInterval(timer);
                }
                stat.textContent = '฿' + current.toLocaleString('th-TH', {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                });
            }, 20);
        }
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.finance', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/finance/reports/index.blade.php ENDPATH**/ ?>