
<?php $__env->startSection('title', 'ประวัติการจัดส่ง'); ?>

<?php $__env->startSection('content'); ?>
<main class="main-content" style="width:100%;max-width:100vw;min-width:0;margin:0;padding:0;overflow-x:hidden;">
    <div class="content-container" style="width:100%;max-width:100vw;min-width:0;padding:2rem;overflow-x:hidden;">
        
        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-title">
                <i class="fas fa-history"></i>
                ประวัติการจัดส่งพัสดุ <?php echo e(\Carbon\Carbon::parse($selectedMonth.'-01')->isoFormat('MMMM YYYY')); ?>

            </h1>
            <p class="page-subtitle">ดูสถิติการจัดส่ง แยกตามเดือน พร้อมรายงานแบบละเอียดและกราฟ</p>
        </div>

        <!-- Back Button -->
        <div class="mb-3">
            <a href="<?php echo e(route('vehicle.dashboard')); ?>" class="btn" style="background: var(--gray); color: white;">
                <i class="fas fa-arrow-left"></i> กลับหน้าแดชบอร์ด
            </a>
            <a href="<?php echo e(route('vehicle.deliveries.create')); ?>" class="btn btn-primary" style="margin-left: 0.5rem;">
                <i class="fas fa-plus"></i> บันทึกการจัดส่งใหม่
            </a>
        </div><br>

        <!-- Filter Section -->
        <form method="GET" class="filter-section mb-4">
            <div class="filter-form">
                <div class="form-group">
                    <label class="form-label">
                        <i class="fas fa-calendar-month"></i> เลือกเดือน
                    </label>
                    <input type="month" name="month" class="form-control"
                        value="<?php echo e($selectedMonth); ?>"
                        max="<?php echo e(now()->format('Y-m')); ?>">
                </div>
                <div class="form-group">
                    <label class="form-label">
                        <i class="fas fa-search"></i> ค้นหา (จำนวน/คอมมิชชั่น)
                    </label>
                    <input type="text" name="search" class="form-control"
                        value="<?php echo e(request('search')); ?>"
                        placeholder="ค้นหา... เช่น 250 หรือ 1000">
                </div>
                <div style="align-self:end;">
                    <button type="submit" class="btn btn-primary" style="min-width:120px;">
                        <i class="fas fa-search"></i> ค้นหา
                    </button>
                    <a href="<?php echo e(route('vehicle.deliveries.index')); ?>" class="btn" style="background: var(--gray); color: white; margin-left:0.6rem;">
                        <i class="fas fa-undo"></i> รีเซ็ต
                    </a>
                </div>
            </div>
        </form>

        <!-- Summary Stats -->
        <div class="stats-grid mb-4">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #FF6B35, #F7931E);">
                    <i class="fas fa-calendar-day"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value"><?php echo e(number_format($summary['total_days'])); ?></div>
                    <div class="stat-label">วันที่ทำงาน</div>
                    <div class="stat-extra">ในเดือนนี้</div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #4ECDC4, #44A08D);">
                    <i class="fas fa-box"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value"><?php echo e(number_format($summary['total_parcels'])); ?></div>
                    <div class="stat-label">พัสดุรวม</div>
                    <div class="stat-extra"><?php echo e($summary['total_days'] > 0 ? number_format($summary['total_parcels'] / $summary['total_days'], 1) : 0); ?> ชิ้น/วัน</div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #A8E6CF, #56C596);">
                    <i class="fas fa-money-bill-wave"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value"><?php echo e(number_format($summary['total_commission'], 2)); ?></div>
                    <div class="stat-label">รายได้รวม</div>
                    <div class="stat-extra">บาท</div>
                </div>
            </div>
        </div>

        <!-- Chart Section -->
        <?php if(!$records->isEmpty()): ?>
        <div class="table-container mb-4" style="background:#F6FBFF;">
            <div class="table-header" style="border-radius:18px 18px 0 0;background:linear-gradient(135deg,#d8ecff 0%,#ffe8db 100%);">
                <h4 class="table-title mb-0">
                    <i class="fas fa-chart-line"></i> กราฟจำนวนพัสดุรายวัน
                </h4>
            </div>
            <div style="padding:1.5rem;">
                <canvas id="deliveryChart" style="width:100%;max-width:800px;height:300px;margin:auto;display:block;"></canvas>
            </div>
        </div>
        <?php endif; ?>

        <!-- Main Data Table -->
        <div class="table-container mb-4">
            <div class="table-header" style="background:linear-gradient(135deg,rgba(255,107,53,0.02),rgba(255,140,97,0.02));">
                <h4 class="table-title mb-0" style="font-size:1.13rem;font-weight:500;">
                    <i class="fas fa-table"></i> รายละเอียดการจัดส่ง
                    <small style="font-weight: 400; color: var(--gray); font-size: 0.9rem;">
                        (<?php echo e(number_format($records->total())); ?> รายการ)
                    </small>
                </h4>
            </div>
            
            <?php if($records->isEmpty()): ?>
                <div class="p-4 empty-state" style="padding: 4rem 2rem; text-align: center;">
                    <div style="color: var(--gray); margin-bottom: 2rem;">
                        <i class="fas fa-calendar-times" style="font-size: 4rem; margin-bottom: 1rem; display: block;"></i>
                    </div>
                    <h3 style="color: var(--dark-gray); margin-bottom: 1rem; font-weight: 500;">ไม่มีข้อมูลในเดือนที่เลือก</h3>
                    <p style="color: var(--gray); margin-bottom: 2rem;">
                        ลองเปลี่ยนเดือน หรือตรวจสอบการกรอกข้อมูลค้นหา
                        <br><small>หรือเริ่มบันทึกการจัดส่งแรกของเดือนนี้</small>
                    </p>
                    <a href="<?php echo e(route('vehicle.deliveries.create')); ?>" class="btn btn-primary">
                        <i class="fas fa-plus"></i> บันทึกการจัดส่งใหม่
                    </a>
                </div><br>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th>วันที่</th>
                                <th>วัน</th>
                                <th>จำนวนพัสดุ</th>
                                <th>อัตรา/ชิ้น</th>
                                <th>ค่าคอมมิชชั่น</th>
                                <th>บันทึกเมื่อ</th>
                                <th>จัดการ</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <span class="badge badge-info" style="font-size:0.95rem;">
                                        <?php echo e(\Carbon\Carbon::parse($record->delivery_date)->format('d/m/Y')); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php
                                        $days = ['อาทิตย์','จันทร์','อังคาร','พุธ','พฤหัสบดี','ศุกร์','เสาร์'];
                                        $dayColor = \Carbon\Carbon::parse($record->delivery_date)->dayOfWeek == 0 ? 'color: #e74c3c;' : '';
                                    ?>
                                    <span style="<?php echo e($dayColor); ?>">
                                        <?php echo e($days[\Carbon\Carbon::parse($record->delivery_date)->dayOfWeek]); ?>

                                    </span>
                                </td>
                                <td>
                                    <span style="color:#FF6B35;font-weight:600; font-size: 1.1rem;">
                                        <?php echo e(number_format($record->parcel_count)); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php
                                        $rate = $record->parcel_count > 0 ? $record->commission_amount / $record->parcel_count : 0;
                                    ?>
                                    <span style="color: var(--gray); font-size: 0.9rem;">
                                        <?php echo e(number_format($rate, 2)); ?>

                                    </span>
                                </td>
                                <td>
                                    <span style="color:#22C55E;font-weight:600; font-size: 1.1rem;">
                                        <?php echo e(number_format($record->commission_amount, 2)); ?>

                                    </span>
                                </td>
                                <td>
                                    <span style="color: var(--gray); font-size: 0.85rem;">
                                        <?php echo e(\Carbon\Carbon::parse($record->created_at)->format('d/m/Y H:i')); ?>

                                    </span>
                                </td>
                                <td>
                                    <div style="display: flex; gap: 0.5rem;">
                                        <a href="<?php echo e(route('vehicle.deliveries.edit', $record)); ?>" 
                                           class="btn btn-sm" style="background: var(--warning); color: white;" 
                                           title="แก้ไข">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-danger" 
                                                onclick="deleteRecord(<?php echo e($record->id); ?>)" title="ลบ">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="mt-3 mb-2 d-flex flex-wrap flex-md-nowrap justify-content-between align-items-center pagination-info" style="padding: 1.5rem 2rem; border-top: 1px solid var(--medium-gray);">
                    <span style="color: var(--gray); font-size: 0.9rem;">
                        แสดง <?php echo e($records->firstItem()); ?> - <?php echo e($records->lastItem()); ?> จาก <?php echo e(number_format($records->total())); ?> รายการ
                    </span>
                    <div>
                        <?php echo e($records->links()); ?>

                    </div>
                </div>
            <?php endif; ?>
        </div><br>

        <!-- Weekly Summary -->
        <?php if(!empty($weeklyData)): ?>
        <div class="table-container mt-4 mb-4">
            <div class="table-header">
                <h4 class="table-title mb-0">
                    <i class="fas fa-calendar-week"></i> สรุปรายสัปดาห์
                </h4>
            </div>
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>สัปดาห์ที่</th>
                            <th>วันทำงาน</th>
                            <th>พัสดุรวม</th>
                            <th>รายได้รวม</th>
                            <th>เฉลี่ย/วัน</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $weeklyData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $week => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <span class="badge" style="background: var(--info); color: white;">
                                    สัปดาห์ <?php echo e($week); ?>

                                </span>
                            </td>
                            <td><?php echo e($data['days']); ?> วัน</td>
                            <td>
                                <span style="color: var(--primary-orange); font-weight: 600;">
                                    <?php echo e(number_format($data['parcels'])); ?>

                                </span>
                            </td>
                            <td>
                                <span style="color: var(--success); font-weight: 600;">
                                    <?php echo e(number_format($data['commission'], 2)); ?>

                                </span>
                            </td>
                            <td>
                                <span style="color: var(--gray);">
                                    <?php echo e($data['days'] > 0 ? number_format($data['parcels'] / $data['days'], 1) : 0); ?> ชิ้น
                                </span>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div><br>
        <?php endif; ?>

        <!-- Performance Insights -->
        <div class="table-container mt-4">
            <div class="table-header">
                <h4 class="table-title mb-0">
                    <i class="fas fa-chart-bar"></i> ข้อมูลเชิงลึก
                </h4>
            </div>
            <div style="padding: 1.5rem;">
                <?php if($summary['total_days'] > 0): ?>
                    <?php
                        $avgParcels = $summary['total_parcels'] / $summary['total_days'];
                        $avgCommission = $summary['total_commission'] / $summary['total_days'];
                        $avgRate = $summary['total_parcels'] > 0 ? $summary['total_commission'] / $summary['total_parcels'] : 0;
                    ?>
                    
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem;">
                        <div style="background: #f8f9fa; padding: 1.5rem; border-radius: 12px; text-align: center;">
                            <div style="font-size: 2rem; font-weight: 700; color: var(--primary-orange); margin-bottom: 0.5rem;">
                                <?php echo e(number_format($avgParcels, 1)); ?>

                            </div>
                            <div style="color: var(--gray); font-weight: 500;">เฉลี่ยพัสดุ/วัน</div>
                        </div>
                        
                        <div style="background: #f8f9fa; padding: 1.5rem; border-radius: 12px; text-align: center;">
                            <div style="font-size: 2rem; font-weight: 700; color: var(--success); margin-bottom: 0.5rem;">
                                <?php echo e(number_format($avgCommission, 2)); ?>

                            </div>
                            <div style="color: var(--gray); font-weight: 500;">เฉลี่ยรายได้/วัน</div>
                        </div>
                        
                        <div style="background: #f8f9fa; padding: 1.5rem; border-radius: 12px; text-align: center;">
                            <div style="font-size: 2rem; font-weight: 700; color: var(--info); margin-bottom: 0.5rem;">
                                <?php echo e(number_format($avgRate, 2)); ?>

                            </div>
                            <div style="color: var(--gray); font-weight: 500;">เฉลี่ยอัตรา/ชิ้น</div>
                        </div>
                    </div><br>

                    <!-- Performance Tips -->
                    <div class="mt-4" style="background: #e7f3ff; padding: 1.5rem; border-radius: 12px; border-left: 4px solid var(--info);">
                        <h6 style="color: var(--info); margin-bottom: 1rem;">
                            <i class="fas fa-lightbulb"></i> คำแนะนำการทำงาน
                        </h6>
                        <div style="color: var(--dark-gray); line-height: 1.6;">
                            <?php if($avgParcels < 50): ?>
                                📈 <strong>เป้าหมาย:</strong> ลองเพิ่มประสิทธิภาพให้ได้มากกว่า 50 ชิ้น/วัน
                            <?php elseif($avgParcels < 100): ?>
                                🎯 <strong>ผลงานดี!</strong> เป้าหมายต่อไปคือ 100 ชิ้น/วัน
                            <?php else: ?>
                                🏆 <strong>ยอดเยี่ยม!</strong> คุณอยู่ในระดับ Top Performer
                            <?php endif; ?>
                            <br>
                            💡 <strong>เคล็ดลับ:</strong> ใช้เครื่องมือคำนวณค่าคอมมิชชั่นเพื่อวางแผนรายได้
                        </div>
                    </div>
                <?php else: ?>
                    <div style="text-align: center; color: var(--gray); padding: 2rem;">
                        <i class="fas fa-chart-line" style="font-size: 3rem; margin-bottom: 1rem; display: block; opacity: 0.5;"></i>
                        <p>เริ่มบันทึกการจัดส่งเพื่อดูข้อมูลเชิงลึก</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</main>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<?php if(!$records->isEmpty()): ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // กราฟพัสดุรายวัน
    const ctx = document.getElementById('deliveryChart').getContext('2d');
    const chartData = {
        labels: <?php echo json_encode($records->pluck('delivery_date')->map(fn($d) => \Carbon\Carbon::parse($d)->format('d/m'))); ?>,
        datasets: [{
            label: 'จำนวนพัสดุ',
            data: <?php echo json_encode($records->pluck('parcel_count')); ?>,
            backgroundColor: 'rgba(255,107,53,0.14)',
            borderColor: '#FF6B35',
            borderWidth: 3,
            fill: true,
            tension: 0.3,
            pointRadius: 6,
            pointBackgroundColor: '#FF6B35',
            pointBorderColor: '#fff',
            pointBorderWidth: 2,
        }]
    };
    
    new Chart(ctx, {
        type: 'line',
        data: chartData,
        options: {
            responsive: true,
            plugins: {
                legend: { display: false },
                title: { display: false }
            },
            scales: {
                y: { 
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(0,0,0,0.1)'
                    }
                },
                x: {
                    grid: {
                        color: 'rgba(0,0,0,0.1)'
                    }
                }
            },
            interaction: {
                intersect: false,
                mode: 'index'
            }
        }
    });
});

// Delete record function
function deleteRecord(id) {
    Swal.fire({
        title: 'ยืนยันการลบ',
        text: 'คุณต้องการลบบันทึกการจัดส่งนี้หรือไม่?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'ลบ',
        cancelButtonText: 'ยกเลิก',
        confirmButtonColor: '#d33'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `/vehicle/deliveries/${id}`;
            
            const csrfToken = document.createElement('input');
            csrfToken.type = 'hidden';
            csrfToken.name = '_token';
            csrfToken.value = '<?php echo e(csrf_token()); ?>';
            
            const methodField = document.createElement('input');
            methodField.type = 'hidden';
            methodField.name = '_method';
            methodField.value = 'DELETE';
            
            form.appendChild(csrfToken);
            form.appendChild(methodField);
            document.body.appendChild(form);
            form.submit();
        }
    });
}
</script>
<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Show success message
<?php if(session('success')): ?>
    Swal.fire({
        icon: 'success',
        title: 'สำเร็จ',
        text: '<?php echo e(session('success')); ?>',
        timer: 2000,
        showConfirmButton: false
    });
<?php endif; ?>

<?php if(session('error')): ?>
    Swal.fire({
        icon: 'error',
        title: 'เกิดข้อผิดพลาด',
        text: '<?php echo e(session('error')); ?>'
    });
<?php endif; ?>
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.stat-card {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.stat-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
}

.stat-content {
    flex: 1;
}

.stat-extra {
    font-size: 0.85rem;
    color: var(--gray);
    margin-top: 0.25rem;
}

.badge {
    padding: 0.35rem 0.65rem;
    border-radius: 0.375rem;
    font-size: 0.75rem;
    font-weight: 600;
}

.badge-info {
    background: var(--info);
    color: white;
}

.d-flex {
    display: flex;
}

.flex-wrap {
    flex-wrap: wrap;
}

.justify-content-between {
    justify-content: space-between;
}

.align-items-center {
    align-items: center;
}

@media (max-width: 768px) {
    .filter-form {
        grid-template-columns: 1fr !important;
    }
    
    .data-table th:nth-child(4),
    .data-table td:nth-child(4),
    .data-table th:nth-child(6),
    .data-table td:nth-child(6) {
        display: none;
    }
    
    .stat-card {
        flex-direction: column;
        text-align: center;
        gap: 0.5rem;
    }
    
    .stat-icon {
        width: 50px;
        height: 50px;
        font-size: 1.2rem;
    }
    
    .pagination-info {
        flex-direction: column !important;
        gap: 1rem;
        text-align: center;
    }
}

@media (max-width: 480px) {
    .data-table th:nth-child(7),
    .data-table td:nth-child(7) {
        width: 60px;
    }
    
    .data-table th:nth-child(7) button,
    .data-table td:nth-child(7) button {
        padding: 0.25rem;
        font-size: 0.75rem;
    }
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\my-laravel-app\resources\views/vehicle/deliveries/index.blade.php ENDPATH**/ ?>