
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'ระบบจัดการค่าคอมมิชชั่น'); ?></title>
    
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    
    <!-- Styles -->
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
    
    <!-- Meta Tags for SEO and Social -->
    <meta name="description" content="ระบบจัดการค่าคอมมิชชั่นสำหรับรถส่งของ">
    <meta property="og:title" content="<?php echo $__env->yieldContent('title', 'ระบบจัดการค่าคอมมิชชั่น'); ?>">
    <meta property="og:description" content="ระบบจัดการค่าคอมมิชชั่นสำหรับรถส่งของ">
    <meta property="og:type" content="website">
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <!-- Additional Styles -->
    <style>
        /* Enhanced App Layout Styles */
        :root {
            --primary-orange: #FF6B35;
            --primary-dark: #E85D2F;
            --primary-light: #FF8C61;
            --primary-gradient: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
            --secondary-orange: #FFA94D;
            --accent-orange: #FFD93D;
            --white: #fff;
            --off-white: #FEFEFE;
            --light-gray: #F8F9FA;
            --medium-gray: #E9ECEF;
            --gray: #6C757D;
            --dark-gray: #343A40;
            --black: #212529;
            --success: #22C55E;
            --danger: #EF4444;
            --warning: #F59E0B;
            --info: #3B82F6;
            --shadow-sm: 0 1px 3px rgba(0, 0, 0, 0.1);
            --shadow-md: 0 4px 6px rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 10px 15px rgba(0, 0, 0, 0.1);
            --shadow-xl: 0 20px 25px rgba(0, 0, 0, 0.1);
            --transition-fast: all 0.15s ease-out;
            --transition-normal: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            --transition-slow: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
            --radius-sm: 6px;
            --radius-md: 12px;
            --radius-lg: 16px;
            --radius-xl: 24px;
            --radius-full: 9999px;
            --sidebar-width: 280px;
            --sidebar-collapsed: 80px;
            --header-height: 70px;
        }

        /* Global Styles */
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Kanit', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            font-weight: 300;
            color: var(--dark-gray);
            background: var(--off-white);
            line-height: 1.6;
            overflow-x: hidden;
            font-size: 16px;
        }

        /* App Layout */
        .app-layout {
            position: relative;
            min-height: 100vh;
            display: flex;
        }

        /* Mobile Menu Button */
        .mobile-menu-btn {
            display: none;
            position: fixed;
            top: 1rem;
            left: 1rem;
            z-index: 1100;
            background: var(--primary-gradient);
            color: var(--white);
            border: none;
            border-radius: var(--radius-full);
            width: 50px;
            height: 50px;
            box-shadow: var(--shadow-lg);
            cursor: pointer;
            transition: var(--transition-fast);
            align-items: center;
            justify-content: center;
        }

        .mobile-menu-btn:hover {
            transform: scale(1.05);
            box-shadow: var(--shadow-xl);
        }

        .mobile-menu-btn:active {
            transform: scale(0.95);
        }

        /* Sidebar */
        .sidebar {
            width: var(--sidebar-width);
            background: var(--white);
            border-right: 1px solid var(--medium-gray);
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            transition: var(--transition-normal);
            box-shadow: var(--shadow-lg);
            overflow-y: auto;
            overflow-x: hidden;
            display: flex;
            flex-direction: column;
        }

        .sidebar.collapsed {
            width: var(--sidebar-collapsed);
        }

        /* Sidebar Header */
        .sidebar-header {
            background: var(--primary-gradient);
            color: var(--white);
            padding: 1.5rem 1.25rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            min-height: var(--header-height);
            position: relative;
            overflow: hidden;
        }

        .sidebar-header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
            animation: shimmer 4s ease-in-out infinite;
        }

        @keyframes shimmer {
            0%, 100% { transform: translateX(-100%) translateY(-100%) rotate(0deg); }
            50% { transform: translateX(-50%) translateY(-50%) rotate(180deg); }
        }

        .sidebar-logo {
            display: flex;
            align-items: center;
            gap: 0.875rem;
            font-weight: 600;
            font-size: 1.125rem;
            white-space: nowrap;
            overflow: hidden;
            position: relative;
            z-index: 10;
            transition: var(--transition-normal);
        }

        .sidebar-logo i {
            font-size: 1.5rem;
            flex-shrink: 0;
            background: rgba(255, 255, 255, 0.2);
            padding: 0.5rem;
            border-radius: var(--radius-sm);
        }

        .sidebar.collapsed .sidebar-logo span {
            opacity: 0;
            width: 0;
        }

        /* Sidebar Toggle */
        .sidebar-toggle {
            background: none;
            border: none;
            color: var(--white);
            font-size: 1.25rem;
            cursor: pointer;
            padding: 0.5rem;
            border-radius: var(--radius-sm);
            transition: var(--transition-fast);
            flex-shrink: 0;
            position: relative;
            z-index: 10;
        }

        .sidebar-toggle:hover {
            background: rgba(255, 255, 255, 0.15);
            transform: scale(1.1);
        }

        .sidebar-close {
            display: none;
        }

        /* Navigation Menu */
        .sidebar-nav {
            flex: 1;
            padding: 1.5rem 0;
            overflow-y: auto;
            overflow-x: hidden;
        }

        .nav-menu {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .nav-section-title {
            padding: 0 1.5rem;
            font-size: 0.75rem;
            font-weight: 600;
            color: #9CA3AF;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            margin: 1.5rem 0 0.75rem;
            transition: opacity 0.3s ease;
        }

        .sidebar.collapsed .nav-section-title {
            opacity: 0;
        }

        .nav-item {
            margin: 0.25rem 0.875rem;
            animation: slideInLeft 0.3s ease-out forwards;
        }

        @keyframes slideInLeft {
            from { opacity: 0; transform: translateX(-20px); }
            to { opacity: 1; transform: translateX(0); }
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 0.875rem 1.25rem;
            color: var(--gray);
            text-decoration: none;
            border-radius: var(--radius-md);
            transition: var(--transition-fast);
            font-weight: 400;
            font-size: 0.95rem;
            position: relative;
            overflow: hidden;
            white-space: nowrap;
        }

        .nav-link::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            width: 0;
            height: 100%;
            background: var(--primary-gradient);
            transition: width 0.3s ease;
            z-index: -1;
        }

        .nav-link:hover {
            color: var(--primary-orange);
            background: rgba(255, 107, 53, 0.08);
            transform: translateX(4px);
        }

        .nav-link:hover::before {
            width: 4px;
        }

        .nav-link.active {
            background: var(--primary-gradient);
            color: var(--white);
            font-weight: 500;
            box-shadow: var(--shadow-sm);
        }

        .nav-link.active::before {
            width: 100%;
        }

        .nav-link i {
            font-size: 1.125rem;
            width: 1.25rem;
            text-align: center;
            flex-shrink: 0;
        }

        .sidebar.collapsed .nav-link {
            justify-content: center;
            padding: 0.875rem 0.75rem;
        }

        .sidebar.collapsed .nav-link span {
            opacity: 0;
            width: 0;
            overflow: hidden;
        }

        /* Profile Section */
        .sidebar-profile {
            padding: 1.25rem;
            border-top: 1px solid var(--medium-gray);
            background: linear-gradient(135deg, rgba(255, 107, 53, 0.03) 0%, rgba(255, 140, 97, 0.03) 100%);
            flex-shrink: 0;
        }

        .profile-info {
            display: flex;
            align-items: center;
            gap: 0.875rem;
            padding: 0.875rem;
            border-radius: var(--radius-md);
            transition: var(--transition-fast);
            cursor: pointer;
        }

        .profile-info:hover {
            background: rgba(255, 107, 53, 0.08);
        }

        .profile-avatar {
            width: 42px;
            height: 42px;
            border-radius: var(--radius-full);
            background: var(--primary-gradient);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--white);
            font-size: 1.125rem;
            font-weight: 600;
            flex-shrink: 0;
            box-shadow: var(--shadow-sm);
        }

        .profile-details {
            flex: 1;
            min-width: 0;
        }

        .profile-name {
            font-weight: 500;
            font-size: 0.9rem;
            color: var(--dark-gray);
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .profile-role {
            font-size: 0.8rem;
            color: var(--gray);
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .sidebar.collapsed .profile-details {
            opacity: 0;
            width: 0;
            overflow: hidden;
        }

        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            min-height: 100vh;
            background: var(--off-white);
            transition: var(--transition-normal);
            position: relative;
            width: calc(100% - var(--sidebar-width));
            flex: 1;
        }

        .sidebar.collapsed + .main-content {
            margin-left: var(--sidebar-collapsed);
            width: calc(100% - var(--sidebar-collapsed));
        }

        .content-container {
            padding: 2rem;
            max-width: none;
            margin: 0;
            min-height: 100vh;
        }

        /* Sidebar Overlay for Mobile */
        .sidebar-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.6);
            z-index: 999;
            opacity: 0;
            visibility: hidden;
            transition: var(--transition-normal);
            backdrop-filter: blur(2px);
        }

        .sidebar-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .content-container {
                padding: 1.5rem;
            }
        }

        @media (max-width: 768px) {
            .mobile-menu-btn {
                display: flex;
            }

            .sidebar {
                transform: translateX(-100%);
                width: var(--sidebar-width);
                z-index: 1001;
            }

            .sidebar.active {
                transform: translateX(0);
            }

            .sidebar-close {
                display: block;
            }

            .sidebar-toggle {
                display: none;
            }

            .main-content {
                margin-left: 0;
                width: 100%;
            }

            .content-container {
                padding: 1rem;
                padding-top: 5rem;
            }

            .nav-section-title {
                margin: 1rem 0 0.5rem;
            }

            .sidebar-header {
                padding: 1rem 1.25rem;
            }
        }

        @media (max-width: 480px) {
            .content-container {
                padding: 0.75rem;
                padding-top: 4.5rem;
            }

            .sidebar-header {
                padding: 0.875rem 1rem;
            }

            .sidebar-logo {
                font-size: 1rem;
            }

            .nav-link {
                padding: 0.75rem 1rem;
                font-size: 0.9rem;
            }
        }

        /* Desktop specific styles */
        @media (min-width: 769px) {
            .sidebar {
                position: fixed !important;
                transform: none !important;
                left: 0 !important;
            }

            .main-content {
                margin-left: var(--sidebar-width);
                width: calc(100% - var(--sidebar-width));
                position: relative;
            }

            .sidebar.collapsed + .main-content {
                margin-left: var(--sidebar-collapsed);
                width: calc(100% - var(--sidebar-collapsed));
            }

            .sidebar-close,
            .sidebar-overlay,
            .mobile-menu-btn {
                display: none !important;
            }
        }

        /* Scrollbar Styling */
        .sidebar-nav::-webkit-scrollbar {
            width: 4px;
        }

        .sidebar-nav::-webkit-scrollbar-track {
            background: transparent;
        }

        .sidebar-nav::-webkit-scrollbar-thumb {
            background: rgba(255, 107, 53, 0.3);
            border-radius: 2px;
        }

        .sidebar-nav::-webkit-scrollbar-thumb:hover {
            background: rgba(255, 107, 53, 0.5);
        }

        /* Loading Spinner */
        .page-loading {
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: rgba(255, 255, 255, 0.95);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 99999;
            transition: opacity 0.3s ease;
        }

        .spinner {
            border: 4px solid rgba(255, 107, 53, 0.2);
            border-top: 4px solid var(--primary-orange);
            border-radius: 50%;
            width: 60px;
            height: 60px;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Notification Toast */
        .toast {
            position: fixed;
            top: 2rem;
            right: 2rem;
            background: var(--white);
            border-radius: var(--radius-lg);
            box-shadow: var(--shadow-xl);
            border-left: 4px solid var(--primary-orange);
            padding: 1rem 1.5rem;
            max-width: 400px;
            z-index: 9999;
            transform: translateX(100%);
            transition: transform 0.3s ease;
        }

        .toast.show {
            transform: translateX(0);
        }

        .toast-success {
            border-left-color: var(--success);
        }

        .toast-error {
            border-left-color: var(--danger);
        }

        .toast-warning {
            border-left-color: var(--warning);
        }

        .toast-info {
            border-left-color: var(--info);
        }

        /* Print Styles */
        @media print {
            .sidebar,
            .mobile-menu-btn,
            .sidebar-overlay {
                display: none !important;
            }

            .main-content {
                margin-left: 0 !important;
                width: 100% !important;
            }

            .content-container {
                padding: 0 !important;
            }
        }

        /* High Contrast Mode */
        @media (prefers-contrast: high) {
            :root {
                --primary-orange: #E85D2F;
                --medium-gray: #CCCCCC;
                --gray: #555555;
            }
        }

        /* Reduced Motion */
        @media (prefers-reduced-motion: reduce) {
            *,
            *::before,
            *::after {
                animation-duration: 0.01ms !important;
                animation-iteration-count: 1 !important;
                transition-duration: 0.01ms !important;
            }
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <!-- Loading Screen -->
    <div class="page-loading" id="pageLoading">
        <div class="spinner"></div>
    </div>

    <!-- App Layout -->
    <div class="app-layout">
        <!-- Mobile Menu Button -->
        <button class="mobile-menu-btn" id="mobileMenuBtn" onclick="toggleSidebar()">
            <i class="fas fa-bars"></i>
        </button>

        <!-- Sidebar Overlay -->
        <div class="sidebar-overlay" id="sidebarOverlay" onclick="closeSidebar()"></div>

        <!-- Sidebar -->
        <nav class="sidebar" id="sidebar">
            <!-- Sidebar Header -->
            <div class="sidebar-header">
                <div class="sidebar-logo">
                    <i class="fas fa-truck-fast"></i>
                    <span>Commission System</span>
                </div>
                <button class="sidebar-toggle" id="sidebarToggle" onclick="toggleSidebarCollapse()">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button class="sidebar-close" onclick="closeSidebar()">
                    <i class="fas fa-times"></i>
                </button>
            </div>

            <!-- Navigation Menu -->
            <div class="sidebar-nav">
                <ul class="nav-menu">
                    <?php if(auth()->guard()->check()): ?>
                        <?php if(auth()->user()->isAdmin()): ?>
                            <!-- Admin Navigation -->
                            <li class="nav-section-title">การจัดการ</li>
                            
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.dashboard')); ?>" 
                                   class="nav-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>">
                                    <i class="fas fa-tachometer-alt"></i>
                                    <span>แดชบอร์ด</span>
                                </a>
                            </li>
                            
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.users.index')); ?>" 
                                   class="nav-link <?php echo e(request()->routeIs('admin.users.*') ? 'active' : ''); ?>">
                                    <i class="fas fa-users"></i>
                                    <span>จัดการผู้ใช้</span>
                                </a>
                            </li>
                            
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.warehouses.index')); ?>" 
                                   class="nav-link <?php echo e(request()->routeIs('admin.warehouses.*') ? 'active' : ''); ?>">
                                    <i class="fas fa-warehouse"></i>
                                    <span>จัดการคลัง</span>
                                </a>
                            </li>
                            
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.commission-rates.index')); ?>" 
                                   class="nav-link <?php echo e(request()->routeIs('admin.commission-rates.*') ? 'active' : ''); ?>">
                                    <i class="fas fa-percentage"></i>
                                    <span>อัตราค่าคอมมิชชั่น</span>
                                </a>
                            </li>

                            <li class="nav-section-title">รายงาน</li>
                            
                            <li class="nav-item">
                                <a href="#" 
                                   class="nav-link <?php echo e(request()->routeIs('admin.reports.*') ? 'active' : ''); ?>">
                                    <i class="fas fa-chart-line"></i>
                                    <span>รายงานการจัดส่ง</span>
                                </a>
                            </li>

                        <?php elseif(auth()->user()->isVehicleUser()): ?>
                            <!-- Vehicle User Navigation -->
                            <li class="nav-section-title">รายงานการจัดส่ง</li>

                            <li class="nav-item">
                                <a href="<?php echo e(route('vehicle.dashboard')); ?>" 
                                   class="nav-link <?php echo e(request()->routeIs('vehicle.dashboard') ? 'active' : ''); ?>">
                                    <i class="fas fa-tachometer-alt"></i>
                                    <span>แดชบอร์ด</span>
                                </a>
                            </li>
                            
                            <li class="nav-item">
                                <a href="<?php echo e(route('vehicle.deliveries.create')); ?>" 
                                   class="nav-link <?php echo e(request()->routeIs('vehicle.deliveries.create') ? 'active' : ''); ?>">
                                    <i class="fas fa-clipboard-list"></i>
                                    <span>บันทึกการจัดส่ง</span>
                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="<?php echo e(route('vehicle.deliveries.index')); ?>" 
                                   class="nav-link <?php echo e(request()->routeIs('vehicle.deliveries.index') ? 'active' : ''); ?>">
                                    <i class="fas fa-history"></i>
                                    <span>ดูประวัติการจัดส่ง</span>
                                </a>
                            </li>

                            <li class="nav-section-title">เครื่องมือ</li>
                            
                            <li class="nav-item">
                                <a href="<?php echo e(route('vehicle.calculator')); ?>" 
                                   class="nav-link <?php echo e(request()->routeIs('vehicle.calculator') ? 'active' : ''); ?>">
                                    <i class="fas fa-calculator"></i>
                                    <span>คำนวณค่าคอมมิชชั่น</span>
                                </a>
                            </li>

                        <li class="nav-section-title">บัญชีการเงิน</li>

                            <li class="nav-item">
                                <a href="<?php echo e(route('finance.dashboard')); ?>"
                                    class="nav-link <?php echo e(request()->routeIs('finance.dashboard') ? 'active' : ''); ?>">
                                    <i class="fas fa-chart-line"></i>
                                    <span>ภาพรวมการเงิน</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('finance.records.index')); ?>"
                                    class="nav-link <?php echo e(request()->routeIs('finance.records.*') ? 'active' : ''); ?>">
                                    <i class="fas fa-list"></i>
                                    <span>รายรับ-รายจ่าย</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('finance.budgets.index')); ?>"
                                    class="nav-link <?php echo e(request()->routeIs('finance.budgets.*') ? 'active' : ''); ?>">
                                    <i class="fas fa-calculator"></i>
                                    <span>งบประมาณ</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('finance.goals.index')); ?>"
                                    class="nav-link <?php echo e(request()->routeIs('finance.goals.*') ? 'active' : ''); ?>">
                                    <i class="fas fa-piggy-bank"></i>
                                    <span>เป้าหมายการออม</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('finance.reports.index')); ?>"
                                    class="nav-link <?php echo e(request()->routeIs('finance.reports.*') ? 'active' : ''); ?>">
                                    <i class="fas fa-file-chart-line"></i>
                                    <span>รายงาน</span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <li class="nav-section-title">บัญชี</li>
                        
                        <li class="nav-item">
                            <a href="<?php echo e(route('profile.edit')); ?>" 
                               class="nav-link <?php echo e(request()->routeIs('profile.*') ? 'active' : ''); ?>">
                                <i class="fas fa-user-cog"></i>
                                <span>ตั้งค่าโปรไฟล์</span>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <form method="POST" action="<?php echo e(route('logout')); ?>" id="logoutForm">
                                <?php echo csrf_field(); ?>
                                <a href="#" class="nav-link" onclick="confirmLogout(event)">
                                    <i class="fas fa-sign-out-alt"></i>
                                    <span>ออกจากระบบ</span>
                                </a>
                            </form>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>

            <!-- Profile Section -->
            <?php if(auth()->guard()->check()): ?>
            <div class="sidebar-profile">
                <div class="profile-info" onclick="toggleProfileMenu()">
                    <div class="profile-avatar">
                        <?php echo e(strtoupper(substr(auth()->user()->name ?? 'U', 0, 2))); ?>

                    </div>
                    <div class="profile-details">
                        <div class="profile-name"><?php echo e(auth()->user()->name ?? 'ผู้ใช้'); ?></div>
                        <div class="profile-role"><?php echo e(auth()->user()->role_display_name ?? 'ผู้ใช้งาน'); ?></div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </nav>

        <!-- Main Content -->
        <main class="main-content">
            <div class="content-container">
                <!-- Flash Messages -->
                <?php if(session('success')): ?>
                    <div class="toast toast-success show" id="successToast">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-3"></i>
                            <div>
                                <div class="font-medium">สำเร็จ!</div>
                                <div class="text-sm text-gray-600"><?php echo e(session('success')); ?></div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="toast toast-error show" id="errorToast">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-circle text-red-500 mr-3"></i>
                            <div>
                                <div class="font-medium">เกิดข้อผิดพลาด!</div>
                                <div class="text-sm text-gray-600"><?php echo e(session('error')); ?></div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if(session('warning')): ?>
                    <div class="toast toast-warning show" id="warningToast">
                        <div class="flex items-center">
                            <i class="fas fa-exclamation-triangle text-yellow-500 mr-3"></i>
                            <div>
                                <div class="font-medium">คำเตือน!</div>
                                <div class="text-sm text-gray-600"><?php echo e(session('warning')); ?></div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Page Content -->
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main>
    </div>

    <!-- Scripts -->
    <script>
        // Global App Functions
        window.CommissionApp = {
            // Sidebar Functions
            toggleSidebar: function() {
                const sidebar = document.getElementById('sidebar');
                const overlay = document.getElementById('sidebarOverlay');
                
                sidebar.classList.toggle('active');
                overlay.classList.toggle('active');
                
                // Prevent body scroll when sidebar is open on mobile
                if (sidebar.classList.contains('active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            },

            closeSidebar: function() {
                const sidebar = document.getElementById('sidebar');
                const overlay = document.getElementById('sidebarOverlay');
                
                sidebar.classList.remove('active');
                overlay.classList.remove('active');
                document.body.style.overflow = '';
            },

            toggleSidebarCollapse: function() {
                const sidebar = document.getElementById('sidebar');
                const toggleIcon = document.querySelector('#sidebarToggle i');
                
                sidebar.classList.toggle('collapsed');
                
                if (sidebar.classList.contains('collapsed')) {
                    toggleIcon.classList.remove('fa-chevron-left');
                    toggleIcon.classList.add('fa-chevron-right');
                } else {
                    toggleIcon.classList.remove('fa-chevron-right');
                    toggleIcon.classList.add('fa-chevron-left');
                }
                
                // Store preference
                localStorage.setItem('sidebarCollapsed', sidebar.classList.contains('collapsed'));
            },

            // Toast Functions
            showToast: function(message, type = 'info', duration = 5000) {
                const toast = document.createElement('div');
                toast.className = `toast toast-${type} show`;
                
                const iconMap = {
                    success: 'fa-check-circle text-green-500',
                    error: 'fa-exclamation-circle text-red-500',
                    warning: 'fa-exclamation-triangle text-yellow-500',
                    info: 'fa-info-circle text-blue-500'
                };
                
                toast.innerHTML = `
                    <div class="flex items-center">
                        <i class="fas ${iconMap[type]} mr-3"></i>
                        <div class="text-sm">${message}</div>
                        <button onclick="this.parentElement.parentElement.remove()" class="ml-4 text-gray-400 hover:text-gray-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                `;
                
                document.body.appendChild(toast);
                
                // Auto remove
                setTimeout(() => {
                    if (toast.parentElement) {
                        toast.classList.remove('show');
                        setTimeout(() => toast.remove(), 300);
                    }
                }, duration);
            },

            // Loading Functions
            showLoading: function() {
                document.getElementById('pageLoading').style.display = 'flex';
            },

            hideLoading: function() {
                document.getElementById('pageLoading').style.display = 'none';
            },

            // AJAX Helper
            request: function(url, options = {}) {
                const defaultOptions = {
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    }
                };

                return fetch(url, { ...defaultOptions, ...options })
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(`HTTP error! status: ${response.status}`);
                        }
                        return response.json();
                    });
            }
        };

        // Make functions globally available
        window.toggleSidebar = CommissionApp.toggleSidebar;
        window.closeSidebar = CommissionApp.closeSidebar;
        window.toggleSidebarCollapse = CommissionApp.toggleSidebarCollapse;

        // Logout confirmation
        function confirmLogout(event) {
            event.preventDefault();
            
            if (window.Swal) {
                Swal.fire({
                    title: 'ยืนยันการออกจากระบบ',
                    text: 'คุณต้องการออกจากระบบหรือไม่?',
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonColor: '#FF6B35',
                    cancelButtonColor: '#6B7280',
                    confirmButtonText: 'ออกจากระบบ',
                    cancelButtonText: 'ยกเลิก'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById('logoutForm').submit();
                    }
                });
            } else {
                if (confirm('คุณต้องการออกจากระบบหรือไม่?')) {
                    document.getElementById('logoutForm').submit();
                }
            }
        }

        // Profile menu toggle
        function toggleProfileMenu() {
            // Add profile menu functionality here if needed
            console.log('Profile menu clicked');
        }

        // Initialize app
        document.addEventListener('DOMContentLoaded', function() {
            // Hide loading screen
            setTimeout(() => {
                CommissionApp.hideLoading();
            }, 500);

            // Restore sidebar collapse state
            const sidebarCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
            if (sidebarCollapsed) {
                document.getElementById('sidebar').classList.add('collapsed');
                const toggleIcon = document.querySelector('#sidebarToggle i');
                toggleIcon.classList.remove('fa-chevron-left');
                toggleIcon.classList.add('fa-chevron-right');
            }

            // Auto-hide toasts
            document.querySelectorAll('.toast.show').forEach(toast => {
                setTimeout(() => {
                    toast.classList.remove('show');
                    setTimeout(() => toast.remove(), 300);
                }, 5000);
            });

            // Handle window resize
            let resizeTimer;
            window.addEventListener('resize', function() {
                clearTimeout(resizeTimer);
                resizeTimer = setTimeout(function() {
                    // Close mobile sidebar on resize to desktop
                    if (window.innerWidth > 768) {
                        CommissionApp.closeSidebar();
                    }
                }, 250);
            });

            // Handle escape key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    CommissionApp.closeSidebar();
                }
            });

            // Add navigation animation delays
            document.querySelectorAll('.nav-item').forEach((item, index) => {
                item.style.animationDelay = `${index * 50}ms`;
            });
        });

        // Service Worker Registration (for PWA)
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                navigator.serviceWorker.register('/sw.js')
                    .then(function(registration) {
                        console.log('SW registered: ', registration);
                    })
                    .catch(function(registrationError) {
                        console.log('SW registration failed: ', registrationError);
                    });
            });
        }
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\xampp\htdocs\my-laravel-app\resources\views/layouts/app.blade.php ENDPATH**/ ?>