<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;

class SetLocale
{
    public function handle(Request $request, Closure $next)
    {
        // Get locale from session or default
        $locale = Session::get('locale', config('app.locale', 'en'));
        
        // Validate locale
        $availableLocales = config('app.available_locales', ['en', 'th']);
        if (in_array($locale, $availableLocales)) {
            App::setLocale($locale);
        } else {
            // Fallback to default
            App::setLocale(config('app.locale', 'en'));
        }
        
        return $next($request);
    }
}