<?php

namespace App\Models;

use App\Services\VehicleNotificationService;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Vehicle extends Model
{
    protected $fillable = [
        'user_id',
        'vehicle_type',
        'license_plate',
        'status',
        'last_login_at',
        'password_changed_at',
        'profile_updated_at'
    ];

    protected $casts = [
        'last_login_at' => 'datetime',
        'password_changed_at' => 'datetime',
        'profile_updated_at' => 'datetime'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function deliveryRecords()
    {
        return $this->hasMany(DeliveryRecord::class, 'user_id', 'user_id');
    }

    public function recordLogin($ipAddress = null)
    {
        $this->update(['last_login_at' => now()]);
        app(VehicleNotificationService::class)->sendLoginNotification($this, $ipAddress);
    }

    public function recordPasswordChange()
    {
        $this->update(['password_changed_at' => now()]);
        app(VehicleNotificationService::class)->sendPasswordChangedNotification($this);
    }

    public function recordProfileUpdate(array $updatedFields)
    {
        $this->update(['profile_updated_at' => now()]);
        app(VehicleNotificationService::class)->sendProfileUpdatedNotification($this, $updatedFields);
    }

    public function sendReport(string $reportType, array $reportData, string $period)
    {
        app(VehicleNotificationService::class)->sendReportNotification($this, $reportType, $reportData, $period);
    }
}