<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class VehicleLoginNotification extends Notification
{
    use Queueable;

    public function __construct(
        public $vehicle,
        public $loginTime,
        public $ipAddress = null
    ) {}

    public function via($notifiable): array
    {
        return ['mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('แจ้งเตือน: การเข้าสู่ระบบ - ' . $this->vehicle->license_plate)
            ->view('emails.vehicle.login', [
                'vehicle' => $this->vehicle,
                'user' => $notifiable,
                'loginTime' => $this->loginTime,
                'ipAddress' => $this->ipAddress
            ]);
    }
}