<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class VehiclePasswordChangedNotification extends Notification
{
    use Queueable;

    public function __construct(
        public $vehicle,
        public $changedAt
    ) {}

    public function via($notifiable): array
    {
        return ['mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('แจ้งเตือน: เปลี่ยนรหัสผ่าน - ' . $this->vehicle->license_plate)
            ->view('emails.vehicle.password-changed', [
                'vehicle' => $this->vehicle,
                'user' => $notifiable,
                'changedAt' => $this->changedAt
            ]);
    }
}