<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Security Headers
    |--------------------------------------------------------------------------
    */
    'headers' => [
        'x-frame-options' => 'DENY',
        'x-content-type-options' => 'nosniff',
        'x-xss-protection' => '1; mode=block',
        'referrer-policy' => 'strict-origin-when-cross-origin',
        'content-security-policy' => "default-src 'self'; script-src 'self' 'unsafe-inline' 'unsafe-eval' https://cdn.jsdelivr.net https://unpkg.com https://cdn.tailwindcss.com; style-src 'self' 'unsafe-inline' https://fonts.googleapis.com https://cdnjs.cloudflare.com; img-src 'self' data: https://cdn.niendsitekungz.com; font-src 'self' https://fonts.googleapis.com https://fonts.gstatic.com https://cdnjs.cloudflare.com data:; connect-src 'self'; frame-ancestors 'none';",
    ],

    /*
    |--------------------------------------------------------------------------
    | Input Validation
    |--------------------------------------------------------------------------
    */
    'validation' => [
        'max_file_size' => 2048, // KB
        'allowed_file_types' => ['csv', 'txt', 'pdf', 'jpg', 'png'],
        'max_string_length' => 1000,
    ],

    /*
    |--------------------------------------------------------------------------
    | Rate Limiting
    |--------------------------------------------------------------------------
    */
    'rate_limiting' => [
        'api' => '60,1', // 60 requests per minute
        'login' => '5,1', // 5 login attempts per minute
        'password_reset' => '3,1', // 3 password reset attempts per minute
    ],

    /*
    |--------------------------------------------------------------------------
    | SQL Injection Protection
    |--------------------------------------------------------------------------
    */
    'sql_protection' => [
        'blocked_patterns' => [
            'union\s+select',
            'drop\s+table',
            'delete\s+from',
            'insert\s+into',
            'update\s+set',
            '--',
            '/\*',
            '\*/',
            'xp_',
            'sp_',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | XSS Protection
    |--------------------------------------------------------------------------
    */
    'xss_protection' => [
        'auto_escape' => true,
        'allowed_tags' => '<b><i><u><strong><em>',
        'blocked_attributes' => ['onclick', 'onload', 'onerror', 'onmouseover'],
    ],
];