<?php
// database/seeders/CommissionRateSeeder.php
namespace Database\Seeders;

use App\Models\CommissionRate;
use Illuminate\Database\Seeder;

class CommissionRateSeeder extends Seeder
{
    public function run()
    {
        $warehouses = ['WH001', 'WH002', 'WH003'];
        $vehicleTypes = ['2wheel', '4wheel'];

        foreach ($warehouses as $warehouse) {
            foreach ($vehicleTypes as $vehicleType) {
                if ($vehicleType === '2wheel') {
                    $rates = [
                        ['tier' => 1, 'min' => 1, 'max' => 69, 'rate' => 0.00],
                        ['tier' => 2, 'min' => 70, 'max' => 149, 'rate' => 5.00],
                        ['tier' => 3, 'min' => 150, 'max' => 209, 'rate' => 6.00],
                        ['tier' => 4, 'min' => 210, 'max' => null, 'rate' => 7.00],
                    ];
                } else {
                    $rates = [
                        ['tier' => 1, 'min' => 1, 'max' => 49, 'rate' => 0.00],
                        ['tier' => 2, 'min' => 50, 'max' => 99, 'rate' => 8.00],
                        ['tier' => 3, 'min' => 100, 'max' => 149, 'rate' => 10.00],
                        ['tier' => 4, 'min' => 150, 'max' => null, 'rate' => 12.00],
                    ];
                }

                foreach ($rates as $rate) {
                    CommissionRate::create([
                        'warehouse_code' => $warehouse,
                        'vehicle_type' => $vehicleType,
                        'tier' => $rate['tier'],
                        'min_packages' => $rate['min'],
                        'max_packages' => $rate['max'],
                        'rate_per_package' => $rate['rate'],
                        'is_active' => true,
                    ]);
                }
            }
        }
    }
}