<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Vehicle;
use Illuminate\Database\Seeder;

class VehicleSeeder extends Seeder
{
    public function run(): void
    {
        $vehicleUsers = User::whereIn('role', ['2wheel', '4wheel'])->get();
        
        foreach ($vehicleUsers as $user) {
            Vehicle::create([
                'user_id' => $user->id,
                'vehicle_type' => $user->role,
                'license_plate' => $this->generateLicensePlate(),
                'status' => 'active'
            ]);
        }
    }
    
    private function generateLicensePlate(): string
    {
        $letters = ['ก', 'ข', 'ค', 'ง', 'จ', 'ฉ', 'ช', 'ซ', 'ญ', 'ด', 'ต', 'ถ', 'ท', 'ธ', 'น', 'บ', 'ป', 'ผ', 'ฝ', 'พ', 'ฟ', 'ภ', 'ม', 'ย', 'ร', 'ล', 'ว', 'ศ', 'ษ', 'ส', 'ห', 'ฬ', 'อ', 'ฮ'];
        
        do {
            $plate = $letters[array_rand($letters)] . $letters[array_rand($letters)] . ' ' . rand(1000, 9999);
        } while (Vehicle::where('license_plate', $plate)->exists());
        
        return $plate;
    }
}