@extends('layouts.app')

@section('title', 'จัดการผู้ใช้งาน - EazyCom Plus')
@section('page-title', 'จัดการผู้ใช้งาน')
@section('mobile-title', 'ผู้ใช้งาน')

@section('content')
<div class="users-management">
    <!-- Header Section -->
    <div class="page-header">
        <div class="header-content">
            <div class="header-info">
                <div class="header-title">
                    <div class="title-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="title-text">
                        <h1>จัดการผู้ใช้งาน</h1>
                        <p>จัดการข้อมูลผู้ใช้งานทั้งหมดในระบบ</p>
                    </div>
                </div>
                <div class="header-actions">
                    <button onclick="exportUsers()" class="action-btn export-btn">
                        <i class="fas fa-download"></i>
                        <span>Export</span>
                    </button>
                    <a href="{{ route('admin.users.create') }}" class="action-btn primary-btn">
                        <i class="fas fa-plus"></i>
                        <span>เพิ่มผู้ใช้</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="stats-grid">
        <div class="stat-card total">
            <div class="stat-icon">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-content">
                <div class="stat-number">{{ number_format($stats['total'] ?? 0) }}</div>
                <div class="stat-label">ผู้ใช้ทั้งหมด</div>
                <div class="stat-trend">
                    <i class="fas fa-chart-line"></i>
                    <span>ทั้งระบบ</span>
                </div>
            </div>
            <div class="stat-action">
                <button onclick="clearFilters()" class="stat-link">ดูทั้งหมด</button>
            </div>
        </div>

        <div class="stat-card active">
            <div class="stat-icon">
                <i class="fas fa-user-check"></i>
            </div>
            <div class="stat-content">
                <div class="stat-number">{{ number_format($stats['active'] ?? 0) }}</div>
                <div class="stat-label">ใช้งานอยู่</div>
                <div class="stat-trend">
                    <i class="fas fa-check-circle"></i>
                    <span>Active</span>
                </div>
            </div>
            <div class="stat-action">
                <button onclick="filterByStatus('active')" class="stat-link">กรองดู</button>
            </div>
        </div>

        <div class="stat-card vehicle-2w">
            <div class="stat-icon">
                <i class="fas fa-motorcycle"></i>
            </div>
            <div class="stat-content">
                <div class="stat-number">{{ number_format($stats['2wheel'] ?? 0) }}</div>
                <div class="stat-label">รถ 2 ล้อ</div>
                <div class="stat-trend">
                    <i class="fas fa-motorcycle"></i>
                    <span>2-Wheeler</span>
                </div>
            </div>
            <div class="stat-action">
                <button onclick="filterByRole('2wheel')" class="stat-link">กรองดู</button>
            </div>
        </div>

        <div class="stat-card vehicle-4w">
            <div class="stat-icon">
                <i class="fas fa-truck"></i>
            </div>
            <div class="stat-content">
                <div class="stat-number">{{ number_format($stats['4wheel'] ?? 0) }}</div>
                <div class="stat-label">รถ 4 ล้อ</div>
                <div class="stat-trend">
                    <i class="fas fa-truck"></i>
                    <span>4-Wheeler</span>
                </div>
            </div>
            <div class="stat-action">
                <button onclick="filterByRole('4wheel')" class="stat-link">กรองดู</button>
            </div>
        </div>
    </div>

    <!-- Search & Filter Section -->
    <div class="filter-section">
        <div class="filter-header">
            <div class="filter-title">
                <i class="fas fa-filter"></i>
                <span>ค้นหาและกรอง</span>
            </div>
            <button class="filter-toggle" onclick="toggleFilters()">
                <i class="fas fa-chevron-down"></i>
            </button>
        </div>
        <div class="filter-content" id="filterContent">
            <form method="GET" action="{{ route('admin.users.index') }}" class="filter-form">
                <div class="filter-row">
                    <div class="filter-group">
                        <label class="filter-label">ค้นหา</label>
                        <div class="input-group">
                            <div class="input-icon">
                                <i class="fas fa-search"></i>
                            </div>
                            <input type="text" name="search" value="{{ request('search') }}" 
                                   class="filter-input" placeholder="ชื่อ, อีเมล หรือรหัสคลัง">
                        </div>
                    </div>
                    
                    <div class="filter-group">
                        <label class="filter-label">บทบาท</label>
                        <div class="input-group">
                            <div class="input-icon">
                                <i class="fas fa-user-tag"></i>
                            </div>
                            <select name="role" class="filter-select">
                                <option value="">ทั้งหมด</option>
                                <option value="admin" {{ request('role') === 'admin' ? 'selected' : '' }}>👑 ผู้ดูแลระบบ</option>
                                <option value="2wheel" {{ request('role') === '2wheel' ? 'selected' : '' }}>🏍️ รถ 2 ล้อ</option>
                                <option value="4wheel" {{ request('role') === '4wheel' ? 'selected' : '' }}>🚚 รถ 4 ล้อ</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="filter-group">
                        <label class="filter-label">สถานะ</label>
                        <div class="input-group">
                            <div class="input-icon">
                                <i class="fas fa-toggle-on"></i>
                            </div>
                            <select name="status" class="filter-select">
                                <option value="">ทั้งหมด</option>
                                <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>✅ ใช้งานอยู่</option>
                                <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>❌ ปิดใช้งาน</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="filter-actions">
                        <button type="submit" class="filter-btn search-btn">
                            <i class="fas fa-search"></i>
                            <span>ค้นหา</span>
                        </button>
                        <a href="{{ route('admin.users.index') }}" class="filter-btn clear-btn">
                            <i class="fas fa-times"></i>
                            <span>ล้าง</span>
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Bulk Actions Bar -->
    <div class="bulk-actions" id="bulkActions" style="display: none;">
        <div class="bulk-info">
            <div class="bulk-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="bulk-text">
                เลือกแล้ว <span id="selectedCount">0</span> รายการ
            </div>
        </div>
        <div class="bulk-buttons">
            <button onclick="bulkAction('activate')" class="bulk-btn activate-btn">
                <i class="fas fa-user-check"></i>
                <span>เปิดใช้งาน</span>
            </button>
            <button onclick="bulkAction('deactivate')" class="bulk-btn deactivate-btn">
                <i class="fas fa-user-slash"></i>
                <span>ปิดใช้งาน</span>
            </button>
            <button onclick="clearSelection()" class="bulk-btn cancel-btn">
                <i class="fas fa-times"></i>
                <span>ยกเลิก</span>
            </button>
        </div>
    </div>

    <!-- Users List -->
    <div class="users-container">
        <div class="container-header">
            <div class="container-title">
                <i class="fas fa-list"></i>
                <span>รายชื่อผู้ใช้งาน</span>
            </div>
            <div class="container-count">
                ทั้งหมด {{ ($users ?? collect())->total() ?? 0 }} รายการ
            </div>
        </div>
        
        <div class="users-content">
            <!-- Desktop Table -->
            <div class="desktop-table">
                <table class="users-table">
                    <thead>
                        <tr>
                            <th class="checkbox-col">
                                <input type="checkbox" id="selectAll" class="table-checkbox">
                            </th>
                            <th class="user-col">ผู้ใช้</th>
                            <th class="role-col">บทบาท</th>
                            <th class="warehouse-col">คลังสินค้า</th>
                            <th class="status-col">สถานะ</th>
                            <th class="date-col">สร้างเมื่อ</th>
                            <th class="actions-col">การดำเนินการ</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($users ?? [] as $user)
                        <tr class="user-row" data-user-id="{{ $user->id }}">
                            <td class="checkbox-cell">
                                <input type="checkbox" class="user-checkbox table-checkbox" value="{{ $user->id }}">
                            </td>
                            <td class="user-cell">
                                <div class="user-info">
                                    <div class="user-avatar">
                                        {{ strtoupper(substr($user->name ?? 'U', 0, 2)) }}
                                    </div>
                                    <div class="user-details">
                                        <div class="user-name">{{ $user->name ?? 'ไม่ระบุชื่อ' }}</div>
                                        <div class="user-email">{{ $user->email ?? 'ไม่ระบุอีเมล' }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="role-cell">
                                <div class="role-badge role-{{ $user->role ?? 'unknown' }}">
                                    @if(($user->role ?? '') === 'admin')
                                        <i class="fas fa-crown"></i>
                                        <span>ผู้ดูแลระบบ</span>
                                    @elseif(($user->role ?? '') === '2wheel')
                                        <i class="fas fa-motorcycle"></i>
                                        <span>รถ 2 ล้อ</span>
                                    @elseif(($user->role ?? '') === '4wheel')
                                        <i class="fas fa-truck"></i>
                                        <span>รถ 4 ล้อ</span>
                                    @else
                                        <i class="fas fa-question"></i>
                                        <span>{{ $user->role ?? 'ไม่ระบุ' }}</span>
                                    @endif
                                </div>
                            </td>
                            <td class="warehouse-cell">
                                @if($user->warehouse_code)
                                    <div class="warehouse-info">
                                        <div class="warehouse-code">{{ $user->warehouse_code }}</div>
                                        <div class="warehouse-name">{{ $user->warehouse->name ?? 'ไม่พบชื่อคลัง' }}</div>
                                    </div>
                                @else
                                    <span class="no-data">-</span>
                                @endif
                            </td>
                            <td class="status-cell">
                                <div class="status-badge status-{{ ($user->is_active ?? false) ? 'active' : 'inactive' }}">
                                    @if($user->is_active ?? false)
                                        <i class="fas fa-check-circle"></i>
                                        <span>ใช้งานอยู่</span>
                                    @else
                                        <i class="fas fa-times-circle"></i>
                                        <span>ปิดใช้งาน</span>
                                    @endif
                                </div>
                            </td>
                            <td class="date-cell">
                                @if($user->created_at)
                                    <div class="date-info">
                                        <div class="date-main">{{ $user->created_at->format('d/m/Y') }}</div>
                                        <div class="date-time">{{ $user->created_at->format('H:i') }}</div>
                                    </div>
                                @else
                                    <span class="no-data">-</span>
                                @endif
                            </td>
                            <td class="actions-cell">
                                <div class="action-buttons">
                                    <a href="{{ route('admin.users.edit', $user) }}" class="action-btn edit-btn" title="แก้ไข">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    @if($user->id !== auth()->id())
                                        <button onclick="toggleUserStatus({{ $user->id }})" 
                                                class="action-btn toggle-btn" 
                                                title="{{ ($user->is_active ?? false) ? 'ปิดใช้งาน' : 'เปิดใช้งาน' }}">
                                            <i class="fas fa-{{ ($user->is_active ?? false) ? 'user-slash' : 'user-check' }}"></i>
                                        </button>
                                        <button onclick="resetPassword({{ $user->id }})" 
                                                class="action-btn reset-btn" title="รีเซ็ตรหัสผ่าน">
                                            <i class="fas fa-key"></i>
                                        </button>
                                        <button onclick="deleteUser({{ $user->id }})" 
                                                class="action-btn delete-btn" title="ลบผู้ใช้">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    @else
                                        <span class="self-indicator">ตัวคุณเอง</span>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="empty-state">
                                <div class="empty-content">
                                    <div class="empty-icon">
                                        <i class="fas fa-users"></i>
                                    </div>
                                    <div class="empty-text">
                                        <h3>ไม่มีผู้ใช้งาน</h3>
                                        <p>ยังไม่มีผู้ใช้งานในระบบ หรือไม่พบผลการค้นหา</p>
                                    </div>
                                    <div class="empty-action">
                                        <a href="{{ route('admin.users.create') }}" class="empty-btn">
                                            <i class="fas fa-plus"></i>
                                            <span>เพิ่มผู้ใช้แรก</span>
                                        </a>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Mobile Cards -->
            <div class="mobile-cards">
                @forelse($users ?? [] as $user)
                <div class="user-card" data-user-id="{{ $user->id }}">
                    <div class="card-header">
                        <input type="checkbox" class="user-checkbox card-checkbox" value="{{ $user->id }}">
                        <div class="user-info">
                            <div class="user-avatar">
                                {{ strtoupper(substr($user->name ?? 'U', 0, 2)) }}
                            </div>
                            <div class="user-details">
                                <div class="user-name">{{ $user->name ?? 'ไม่ระบุชื่อ' }}</div>
                                <div class="user-email">{{ $user->email ?? 'ไม่ระบุอีเมล' }}</div>
                            </div>
                        </div>
                        @if($user->id !== auth()->id())
                        <button class="card-menu-btn" onclick="toggleCardMenu({{ $user->id }})">
                            <i class="fas fa-ellipsis-v"></i>
                        </button>
                        @endif
                    </div>
                    
                    <div class="card-body">
                        <div class="card-row">
                            <span class="row-label">บทบาท:</span>
                            <div class="role-badge role-{{ $user->role ?? 'unknown' }}">
                                @if(($user->role ?? '') === 'admin')
                                    <i class="fas fa-crown"></i> Admin
                                @elseif(($user->role ?? '') === '2wheel')
                                    <i class="fas fa-motorcycle"></i> 2 ล้อ
                                @elseif(($user->role ?? '') === '4wheel')
                                    <i class="fas fa-truck"></i> 4 ล้อ
                                @else
                                    {{ $user->role ?? 'ไม่ระบุ' }}
                                @endif
                            </div>
                        </div>
                        
                        <div class="card-row">
                            <span class="row-label">คลัง:</span>
                            <span class="row-value">
                                {{ $user->warehouse_code ?? '-' }}
                            </span>
                        </div>
                        
                        <div class="card-row">
                            <span class="row-label">สถานะ:</span>
                            <div class="status-badge status-{{ ($user->is_active ?? false) ? 'active' : 'inactive' }}">
                                @if($user->is_active ?? false)
                                    <i class="fas fa-check-circle"></i> ใช้งาน
                                @else
                                    <i class="fas fa-times-circle"></i> ปิดใช้งาน
                                @endif
                            </div>
                        </div>
                        
                        <div class="card-row">
                            <span class="row-label">สร้างเมื่อ:</span>
                            <span class="row-value">
                                {{ $user->created_at ? $user->created_at->format('d/m/Y H:i') : '-' }}
                            </span>
                        </div>
                    </div>
                    
                    @if($user->id !== auth()->id())
                    <div class="card-actions" id="card-actions-{{ $user->id }}" style="display: none;">
                        <a href="{{ route('admin.users.edit', $user) }}" class="card-action-btn edit">
                            <i class="fas fa-edit"></i> แก้ไข
                        </a>
                        <button onclick="toggleUserStatus({{ $user->id }})" class="card-action-btn toggle">
                            <i class="fas fa-{{ ($user->is_active ?? false) ? 'user-slash' : 'user-check' }}"></i>
                            {{ ($user->is_active ?? false) ? 'ปิดใช้งาน' : 'เปิดใช้งาน' }}
                        </button>
                        <button onclick="resetPassword({{ $user->id }})" class="card-action-btn reset">
                            <i class="fas fa-key"></i> รีเซ็ตรหัสผ่าน
                        </button>
                        <button onclick="deleteUser({{ $user->id }})" class="card-action-btn delete">
                            <i class="fas fa-trash"></i> ลบ
                        </button>
                    </div>
                    @endif
                </div>
                @empty
                <div class="empty-state-mobile">
                    <div class="empty-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="empty-text">
                        <h3>ไม่มีผู้ใช้งาน</h3>
                        <p>ยังไม่มีผู้ใช้งานในระบบ</p>
                    </div>
                    <div class="empty-action">
                        <a href="{{ route('admin.users.create') }}" class="empty-btn">
                            <i class="fas fa-plus"></i>
                            <span>เพิ่มผู้ใช้แรก</span>
                        </a>
                    </div>
                </div>
                @endforelse
            </div>
        </div>
        
        <!-- Pagination -->
        @if(isset($users) && $users->hasPages())
        <div class="pagination-section">
            <div class="pagination-info">
                แสดง {{ $users->firstItem() ?? 0 }} ถึง {{ $users->lastItem() ?? 0 }} 
                จาก {{ $users->total() ?? 0 }} รายการ
            </div>
            <div class="pagination-links">
                {{ $users->links() }}
            </div>
        </div>
        @endif
    </div>
</div>
@endsection