<x-guest-layout>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;500;600;700&display=swap');
        
        :root {
            --primary-orange: #FF6B35;
            --primary-dark: #E85D2F;
            --primary-light: #FF8C61;
            --primary-gradient: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
            --white: #FFFFFF;
            --off-white: #FEFEFE;
            --light-gray: #F8F9FA;
            --medium-gray: #E9ECEF;
            --gray: #6C757D;
            --dark-gray: #343A40;
            --success: #22C55E;
            --danger: #EF4444;
            --warning: #F59E0B;
            --info: #3B82F6;
            --shadow-sm: 0 1px 3px rgba(0, 0, 0, 0.1);
            --shadow-md: 0 4px 6px rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 10px 15px rgba(0, 0, 0, 0.1);
            --shadow-xl: 0 20px 25px rgba(0, 0, 0, 0.1);
            --transition-fast: all 0.15s ease-out;
            --transition-normal: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            --radius-sm: 6px;
            --radius-md: 12px;
            --radius-lg: 16px;
            --radius-xl: 24px;
        }
        
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            font-family: 'Kanit', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            font-weight: 300;
            line-height: 1.6;
        }
        
        .auth-container {
            min-height: 100vh;
            background: var(--primary-gradient);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
            position: relative;
            overflow: hidden;
        }
        
        .auth-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 80%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(255, 255, 255, 0.05) 0%, transparent 50%);
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-10px) rotate(1deg); }
        }
        
        .auth-card {
            background: var(--white);
            border-radius: var(--radius-xl);
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.15);
            padding: 3rem 2.5rem;
            width: 100%;
            max-width: 450px;
            position: relative;
            z-index: 1;
            border: 1px solid rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
            animation: slideUp 0.6s ease-out;
        }
        
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .auth-header {
            text-align: center;
            margin-bottom: 2.5rem;
        }
        
        .auth-logo {
            width: 70px;
            height: 70px;
            background: var(--primary-gradient);
            border-radius: var(--radius-lg);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem auto;
            box-shadow: var(--shadow-lg);
            position: relative;
            overflow: hidden;
        }
        
        .auth-logo::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            animation: shine 2s infinite;
        }
        
        @keyframes shine {
            0% { transform: translateX(-100%) translateY(-100%) rotate(45deg); }
            100% { transform: translateX(100%) translateY(100%) rotate(45deg); }
        }
        
        .auth-title {
            font-size: 1.875rem;
            font-weight: 600;
            color: var(--dark-gray);
            margin-bottom: 0.5rem;
        }
        
        .auth-subtitle {
            color: var(--gray);
            font-size: 1rem;
            font-weight: 400;
            line-height: 1.5;
        }
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-label {
            display: block;
            font-weight: 500;
            color: var(--dark-gray);
            margin-bottom: 0.5rem;
            font-size: 0.95rem;
        }
        
        .form-control {
            width: 100%;
            padding: 0.875rem 1rem;
            border: 2px solid var(--medium-gray);
            border-radius: var(--radius-md);
            font-family: inherit;
            font-size: 1rem;
            transition: var(--transition-normal);
            background: var(--white);
            color: var(--dark-gray);
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary-orange);
            box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
        }
        
        .form-control.error {
            border-color: var(--danger);
        }
        
        .alert {
            padding: 1rem 1.25rem;
            border-radius: var(--radius-md);
            margin-bottom: 1.5rem;
            font-size: 0.9rem;
            border: 1px solid;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            animation: slideIn 0.3s ease-out;
        }
        
        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .alert-success {
            background: rgba(34, 197, 94, 0.1);
            border-color: rgba(34, 197, 94, 0.3);
            color: #16a34a;
        }
        
        .auth-submit {
            width: 100%;
            background: var(--primary-gradient);
            color: var(--white);
            border: none;
            padding: 1rem 1.5rem;
            border-radius: var(--radius-md);
            font-family: inherit;
            font-weight: 500;
            font-size: 1rem;
            cursor: pointer;
            transition: var(--transition-normal);
            box-shadow: var(--shadow-md);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            position: relative;
            overflow: hidden;
        }
        
        .auth-submit::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }
        
        .auth-submit:hover::before {
            width: 300px;
            height: 300px;
        }
        
        .auth-submit:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
        }
        
        .auth-submit:active {
            transform: translateY(0);
        }
        
        .auth-submit:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .auth-submit:disabled:hover {
            transform: none;
            box-shadow: var(--shadow-md);
        }
        
        .loading-spinner {
            width: 20px;
            height: 20px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-top: 2px solid white;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .auth-footer {
            text-align: center;
            margin-top: 2rem;
            padding-top: 1.5rem;
            border-top: 1px solid var(--medium-gray);
        }
        
        .auth-links {
            display: flex;
            flex-direction: column;
            gap: 1rem;
            align-items: center;
        }
        
        .auth-link {
            color: var(--primary-orange);
            text-decoration: none;
            font-weight: 500;
            transition: var(--transition-fast);
            font-size: 0.9rem;
            position: relative;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .auth-link::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--primary-orange);
            transition: width 0.3s ease;
        }
        
        .auth-link:hover::after {
            width: 100%;
        }
        
        .auth-link:hover {
            color: var(--primary-dark);
        }
        
        .info-card {
            background: rgba(255, 107, 53, 0.05);
            border: 1px solid rgba(255, 107, 53, 0.15);
            border-radius: var(--radius-md);
            padding: 1.5rem;
            margin-top: 2rem;
            animation: fadeIn 0.5s ease-out 0.3s both;
        }
        
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .info-title {
            color: var(--primary-orange);
            font-weight: 600;
            margin-bottom: 0.75rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 0.95rem;
        }
        
        .info-content {
            color: var(--gray);
            font-size: 0.85rem;
            line-height: 1.6;
        }
        
        .info-list {
            margin: 0;
            padding-left: 1rem;
            line-height: 1.7;
        }
        
        .info-list li {
            margin-bottom: 0.5rem;
            position: relative;
        }
        
        .info-list li::marker {
            color: var(--primary-orange);
        }
        
        .error-message {
            color: var(--danger);
            font-size: 0.875rem;
            margin-top: 0.25rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .email-status {
            margin-top: 0.5rem;
            padding: 0.75rem;
            border-radius: var(--radius-sm);
            font-size: 0.85rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            opacity: 0;
            transform: translateY(-10px);
            transition: all 0.3s ease;
        }
        
        .email-status.show {
            opacity: 1;
            transform: translateY(0);
        }
        
        .email-status.valid {
            background: rgba(34, 197, 94, 0.1);
            color: var(--success);
            border: 1px solid rgba(34, 197, 94, 0.2);
        }
        
        .email-status.invalid {
            background: rgba(239, 68, 68, 0.1);
            color: var(--danger);
            border: 1px solid rgba(239, 68, 68, 0.2);
        }
        
        @media (max-width: 640px) {
            .auth-container {
                padding: 1rem;
            }
            
            .auth-card {
                padding: 2rem 1.5rem;
                margin: 0;
            }
            
            .auth-title {
                font-size: 1.5rem;
            }
            
            .info-card {
                padding: 1rem;
            }
        }
        
        @media (max-width: 480px) {
            .auth-card {
                padding: 1.5rem 1rem;
            }
            
            .auth-links {
                gap: 0.75rem;
            }
        }
    </style>

    <div class="auth-container">
        <div class="auth-card">
            <!-- Header -->
            <div class="auth-header">
                <div class="auth-logo">
                    <svg width="36" height="36" fill="white" viewBox="0 0 24 24">
                        <path fill-rule="evenodd" d="M18 8a6 6 0 01-7.743 5.743L10 14l-1 1-1 1H6v2H2v-4l4.257-4.257A6 6 0 1118 8zm-6-4a1 1 0 100 2 2 2 0 012 2 1 1 0 102 0 4 4 0 00-4-4z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <h1 class="auth-title">ลืมรหัสผ่าน?</h1>
                <p class="auth-subtitle">
                    ไม่ต้องกังวล เพียงแจ้งที่อยู่อีเมลของคุณ<br>
                    และเราจะส่งลิงก์รีเซ็ตรหัสผ่านให้คุณ
                </p>
            </div>

            <!-- Session Status -->
            @if (session('status'))
                <div class="alert alert-success">
                    <svg width="20" height="20" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                    </svg>
                    {{ session('status') }}
                </div>
            @endif

            <!-- Authentication Failed -->
            @if($errors->has('email') && ($errors->first('email') === 'auth.failed' || $errors->first('email') === 'passwords.user'))
                <div class="alert alert-error">
                    <svg width="20" height="20" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                    </svg>
                    ไม่พบอีเมลนี้ในระบบ กรุณาตรวจสอบอีเมลของคุณ
                </div>
            @endif

            <!-- Form -->
            <form method="POST" action="{{ route('password.email') }}" id="forgotForm">
                @csrf

                <!-- Email Address -->
                <div class="form-group">
                    <label for="email" class="form-label">
                        <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20" style="display: inline; margin-right: 0.5rem;">
                            <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"/>
                            <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"/>
                        </svg>
                        อีเมล
                    </label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           class="form-control @error('email') error @enderror"
                           value="{{ old('email') }}" 
                           required 
                           autofocus 
                           autocomplete="username"
                           placeholder="กรอกอีเมลของคุณ">
                    
                    <!-- Email Status Indicator -->
                    <div class="email-status" id="emailStatus"></div>
                    
                    @error('email')
                        @if($message !== 'auth.failed' && $message !== 'passwords.user')
                            <div class="error-message">
                                <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                </svg>
                                {{ $message }}
                            </div>
                        @endif
                    @enderror
                </div>

                <!-- Submit Button -->
                <button type="submit" class="auth-submit" id="submitBtn">
                    <span id="submitText">
                        <svg width="20" height="20" fill="currentColor" viewBox="0 0 20 20" style="margin-right: 0.5rem;">
                            <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"/>
                            <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"/>
                        </svg>
                        ส่งลิงก์รีเซ็ตรหัสผ่าน
                    </span>
                    <div id="loadingIcon" class="loading-spinner" style="display: none;"></div>
                </button>

                <!-- Footer Links -->
                <div class="auth-footer">
                    <div class="auth-links">
                        <a href="{{ route('login') }}" class="auth-link">
                            <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                            </svg>
                            กลับสู่หน้าเข้าสู่ระบบ
                        </a>
                        
                        <div style="color: var(--gray); font-size: 0.9rem;">
                            ยังไม่มีบัญชี? 
                            <a href="{{ route('register') }}" class="auth-link">
                                <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20" style="margin-right: 0.25rem;">
                                    <path d="M8 9a3 3 0 100-6 3 3 0 000 6zM8 11a6 6 0 016 6H2a6 6 0 016-6zM16 7a1 1 0 10-2 0v1h-1a1 1 0 100 2h1v1a1 1 0 102 0v-1h1a1 1 0 100-2h-1V7z"/>
                                </svg>
                                สมัครสมาชิก
                            </a>
                        </div>
                    </div>
                </div>
            </form>

            <!-- Information Card -->
            <div class="info-card">
                <div class="info-title">
                    <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                    </svg>
                    ข้อมูลการรีเซ็ตรหัสผ่าน
                </div>
                <div class="info-content">
                    <ul class="info-list">
                        <li>ลิงก์รีเซ็ตรหัสผ่านจะถูกส่งไปยังอีเมลที่คุณระบุ</li>
                        <li>ลิงก์จะมีอายุการใช้งาน 60 นาที</li>
                        <li>หากไม่พบอีเมลในกล่องจดหมาย ให้ตรวจสอบในโฟลเดอร์ Spam</li>
                        <li>หากยังไม่ได้รับอีเมล สามารถขอส่งใหม่ได้อีกครั้ง</li>
                        <li>ติดต่อผู้ดูแลระบบหากพบปัญหา</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Email validation
        function validateEmail(email) {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailRegex.test(email);
        }

        // Update email status
        function updateEmailStatus(email) {
            const statusDiv = document.getElementById('emailStatus');
            
            if (!email) {
                statusDiv.classList.remove('show');
                return;
            }
            
            if (validateEmail(email)) {
                statusDiv.className = 'email-status valid show';
                statusDiv.innerHTML = `
                    <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                    </svg>
                    รูปแบบอีเมลถูกต้อง
                `;
            } else {
                statusDiv.className = 'email-status invalid show';
                statusDiv.innerHTML = `
                    <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                    </svg>
                    รูปแบบอีเมลไม่ถูกต้อง
                `;
            }
        }

        // Form submission handling
        document.getElementById('forgotForm').addEventListener('submit', function(e) {
            const email = document.getElementById('email').value;
            
            if (!validateEmail(email)) {
                e.preventDefault();
                document.getElementById('email').focus();
                return;
            }
            
            const submitBtn = document.getElementById('submitBtn');
            const submitText = document.getElementById('submitText');
            const loadingIcon = document.getElementById('loadingIcon');
            
            submitBtn.disabled = true;
            submitText.style.display = 'none';
            loadingIcon.style.display = 'block';
            
            // Visual feedback
            submitBtn.style.background = 'linear-gradient(135deg, #E85D2F 0%, #FF6B35 100%)';
        });

        // Real-time email validation
        document.addEventListener('DOMContentLoaded', function() {
            const emailField = document.getElementById('email');
            
            emailField.addEventListener('input', function() {
                updateEmailStatus(this.value);
            });
            
            emailField.addEventListener('blur', function() {
                const email = this.value;
                if (email && !validateEmail(email)) {
                    this.classList.add('error');
                } else {
                    this.classList.remove('error');
                }
            });
            
            // Auto-focus email field
            setTimeout(() => {
                emailField.focus();
            }, 500);
            
            // Keyboard shortcuts
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    window.location.href = '{{ route("login") }}';
                }
            });
        });

        // Add loading screen effect
        window.addEventListener('load', function() {
            document.body.style.opacity = '0';
            document.body.style.transition = 'opacity 0.5s ease';
            
            setTimeout(() => {
                document.body.style.opacity = '1';
            }, 100);
        });

        // Show toast notification for auth errors
        document.addEventListener('DOMContentLoaded', function() {
            @if($errors->has('email') && ($errors->first('email') === 'auth.failed' || $errors->first('email') === 'passwords.user'))
                showToast('ไม่พบอีเมลนี้ในระบบ กรุณาตรวจสอบอีเมลของคุณ', 'error', 5000);
            @endif
        });

        // Toast notification function
        function showToast(message, type = 'info', duration = 3000) {
            const toast = document.createElement('div');
            toast.className = `toast-notification ${type}`;
            toast.style.cssText = `
                position: fixed;
                top: 20px;
                right: 20px;
                background: ${type === 'error' ? '#EF4444' : '#22C55E'};
                color: white;
                padding: 1rem 1.5rem;
                border-radius: 12px;
                box-shadow: 0 10px 25px rgba(0,0,0,0.15);
                z-index: 9999;
                font-family: 'Kanit', sans-serif;
                font-size: 0.9rem;
                max-width: 400px;
                animation: slideInRight 0.3s ease-out;
                display: flex;
                align-items: center;
                gap: 0.75rem;
            `;
            
            const icon = type === 'error' ? 
                '<svg width="20" height="20" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>' :
                '<svg width="20" height="20" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg>';
            
            toast.innerHTML = icon + '<span>' + message + '</span>';
            
            // Add CSS animation
            const style = document.createElement('style');
            style.textContent = `
                @keyframes slideInRight {
                    from { transform: translateX(100%); opacity: 0; }
                    to { transform: translateX(0); opacity: 1; }
                }
                @keyframes slideOutRight {
                    from { transform: translateX(0); opacity: 1; }
                    to { transform: translateX(100%); opacity: 0; }
                }
            `;
            document.head.appendChild(style);
            
            document.body.appendChild(toast);
            
            setTimeout(() => {
                toast.style.animation = 'slideOutRight 0.3s ease-in';
                setTimeout(() => {
                    if (toast.parentElement) {
                        toast.remove();
                    }
                    if (style.parentElement) {
                        style.remove();
                    }
                }, 300);
            }, duration);
        }
    </script>
</x-guest-layout>