<x-guest-layout>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;500;600;700&display=swap');
        
        :root {
            --primary-orange: #FF6B35;
            --primary-dark: #E85D2F;
            --primary-light: #FF8C61;
            --primary-gradient: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
            --white: #FFFFFF;
            --light-gray: #F8F9FA;
            --medium-gray: #E9ECEF;
            --gray: #6C757D;
            --dark-gray: #343A40;
            --success: #22C55E;
            --danger: #EF4444;
            --shadow-md: 0 4px 6px rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 10px 15px rgba(0, 0, 0, 0.1);
            --shadow-xl: 0 20px 25px rgba(0, 0, 0, 0.1);
            --transition-normal: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            --radius-md: 12px;
            --radius-lg: 16px;
            --radius-xl: 24px;
        }
        
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            font-family: 'Kanit', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            font-weight: 300;
            line-height: 1.6;
        }
        
        .auth-container {
            min-height: 100vh;
            background: var(--primary-gradient);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: clamp(1rem, 4vw, 2rem);
            position: relative;
            overflow: hidden;
        }
        
        .auth-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 80%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(255, 255, 255, 0.1) 0%, transparent 50%);
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-10px) rotate(1deg); }
        }
        
        .auth-card {
            background: var(--white);
            border-radius: var(--radius-xl);
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.15);
            padding: clamp(2rem, 5vw, 3rem) clamp(1.5rem, 4vw, 2.5rem);
            width: 100%;
            max-width: min(450px, 90vw);
            position: relative;
            z-index: 1;
            backdrop-filter: blur(10px);
            animation: slideUp 0.6s ease-out;
        }
        
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .auth-header {
            text-align: center;
            margin-bottom: clamp(1.5rem, 4vw, 2.5rem);
        }
        
        .auth-logo {
            width: clamp(60px, 12vw, 70px);
            height: clamp(60px, 12vw, 70px);
            background: var(--primary-gradient);
            border-radius: var(--radius-lg);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto clamp(1rem, 3vw, 1.5rem) auto;
            box-shadow: var(--shadow-lg);
            position: relative;
            overflow: hidden;
        }
        
        .auth-logo::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            animation: shine 2s infinite;
        }
        
        @keyframes shine {
            0% { transform: translateX(-100%) translateY(-100%) rotate(45deg); }
            100% { transform: translateX(100%) translateY(100%) rotate(45deg); }
        }
        
        .auth-title {
            font-size: clamp(1.25rem, 4vw, 1.875rem);
            font-weight: 600;
            color: var(--dark-gray);
            margin-bottom: 0.5rem;
        }
        
        .auth-subtitle {
            color: var(--gray);
            font-size: clamp(0.875rem, 2.5vw, 1rem);
            font-weight: 400;
            line-height: 1.5;
        }
        
        .form-group {
            margin-bottom: clamp(1rem, 3vw, 1.5rem);
        }
        
        .form-label {
            display: block;
            font-weight: 500;
            color: var(--dark-gray);
            margin-bottom: 0.5rem;
            font-size: clamp(0.875rem, 2.2vw, 0.95rem);
        }
        
        .form-control {
            width: 100%;
            padding: clamp(0.75rem, 2vw, 0.875rem) 1rem;
            border: 2px solid var(--medium-gray);
            border-radius: var(--radius-md);
            font-family: inherit;
            font-size: clamp(0.875rem, 2.2vw, 1rem);
            transition: var(--transition-normal);
            background: var(--white);
            color: var(--dark-gray);
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary-orange);
            box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
        }
        
        .form-control.error {
            border-color: var(--danger);
        }
        
        .password-wrapper {
            position: relative;
        }
        
        .password-toggle {
            position: absolute;
            right: 0.75rem;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--gray);
            cursor: pointer;
            padding: 0.5rem;
            border-radius: var(--radius-md);
            transition: var(--transition-normal);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .password-toggle:hover {
            color: var(--primary-orange);
            background: rgba(255, 107, 53, 0.05);
        }
        
        .strength-indicator {
            margin-top: 0.5rem;
        }
        
        .strength-bars {
            display: flex;
            gap: 0.25rem;
            margin-bottom: 0.5rem;
        }
        
        .strength-bar {
            height: 4px;
            flex: 1;
            background: var(--medium-gray);
            border-radius: 2px;
            transition: var(--transition-normal);
        }
        
        .strength-text {
            font-size: clamp(0.75rem, 2vw, 0.8rem);
            font-weight: 500;
        }
        
        .auth-submit {
            width: 100%;
            background: var(--primary-gradient);
            color: var(--white);
            border: none;
            padding: clamp(0.875rem, 2.5vw, 1rem) 1.5rem;
            border-radius: var(--radius-md);
            font-family: inherit;
            font-weight: 500;
            font-size: clamp(0.875rem, 2.2vw, 1rem);
            cursor: pointer;
            transition: var(--transition-normal);
            box-shadow: var(--shadow-md);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            position: relative;
            overflow: hidden;
        }
        
        .auth-submit::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }
        
        .auth-submit:hover::before {
            width: 300px;
            height: 300px;
        }
        
        .auth-submit:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
        }
        
        .auth-submit:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .loading-spinner {
            width: 20px;
            height: 20px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-top: 2px solid white;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .auth-footer {
            text-align: center;
            margin-top: clamp(1.5rem, 4vw, 2rem);
            padding-top: clamp(1rem, 3vw, 1.5rem);
            border-top: 1px solid var(--medium-gray);
        }
        
        .auth-link {
            color: var(--primary-orange);
            text-decoration: none;
            font-weight: 500;
            transition: var(--transition-normal);
            font-size: clamp(0.8rem, 2vw, 0.9rem);
            position: relative;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .auth-link::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--primary-orange);
            transition: width 0.3s ease;
        }
        
        .auth-link:hover::after {
            width: 100%;
        }
        
        .auth-link:hover {
            color: var(--primary-dark);
        }
        
        .error-message {
            color: var(--danger);
            font-size: clamp(0.75rem, 2vw, 0.875rem);
            margin-top: 0.25rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .success-message {
            color: var(--success);
            font-size: clamp(0.75rem, 2vw, 0.875rem);
            margin-top: 0.25rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        /* Responsive breakpoints */
        @media (max-width: 640px) {
            .auth-container {
                padding: 1rem 0.5rem;
            }
            
            .auth-card {
                margin: 0;
                border-radius: var(--radius-lg);
            }
            
            .password-toggle {
                padding: 0.375rem;
            }
        }
        
        @media (max-width: 480px) {
            .auth-card {
                padding: 1.5rem 1rem;
            }
            
            .form-control {
                padding: 0.75rem;
            }
        }
        
        @media (max-width: 360px) {
            .auth-container {
                padding: 0.5rem;
            }
            
            .auth-card {
                padding: 1.25rem 0.875rem;
            }
        }
        
        /* Landscape mobile */
        @media (max-height: 600px) and (orientation: landscape) {
            .auth-container {
                padding: 1rem;
            }
            
            .auth-card {
                max-height: 90vh;
                overflow-y: auto;
            }
            
            .auth-header {
                margin-bottom: 1rem;
            }
            
            .auth-logo {
                width: 50px;
                height: 50px;
                margin-bottom: 0.75rem;
            }
        }
        
        /* Tablet */
        @media (min-width: 641px) and (max-width: 1024px) {
            .auth-card {
                max-width: 500px;
            }
        }
        
        /* Desktop */
        @media (min-width: 1025px) {
            .auth-card {
                max-width: 450px;
            }
        }
        
        /* High DPI displays */
        @media (-webkit-min-device-pixel-ratio: 2), (min-resolution: 192dpi) {
            .auth-logo {
                box-shadow: 0 8px 32px rgba(255, 107, 53, 0.2);
            }
        }
        
        /* Reduced motion */
        @media (prefers-reduced-motion: reduce) {
            *,
            *::before,
            *::after {
                animation-duration: 0.01ms !important;
                animation-iteration-count: 1 !important;
                transition-duration: 0.01ms !important;
            }
        }
        
        /* Dark mode support */
        @media (prefers-color-scheme: dark) {
            .auth-card {
                background: rgba(255, 255, 255, 0.95);
            }
        }
    </style>

    <div class="auth-container">
        <div class="auth-card">
            <!-- Header -->
            <div class="auth-header">
                <div class="auth-logo">
                    <svg width="36" height="36" fill="white" viewBox="0 0 24 24">
                        <path fill-rule="evenodd" d="M12 1.586l-4 4v12.828l4-4 4 4V5.586l-4-4zM8 7.414V16.586L12 12.586 16 16.586V7.414L12 3.414 8 7.414z" clip-rule="evenodd"/>
                        <path d="M12 8a2 2 0 100 4 2 2 0 000-4z"/>
                    </svg>
                </div>
                <h1 class="auth-title">รีเซ็ตรหัสผ่าน</h1>
                <p class="auth-subtitle">กรอกรหัสผ่านใหม่เพื่อเข้าใช้งานระบบ</p>
            </div>

            <!-- Form -->
            <form method="POST" action="{{ route('password.store') }}" id="resetForm">
                @csrf
                <input type="hidden" name="token" value="{{ $request->route('token') }}">

                <!-- Email Address -->
                <div class="form-group">
                    <label for="email" class="form-label">
                        <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20" style="display: inline; margin-right: 0.5rem;">
                            <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"/>
                            <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"/>
                        </svg>
                        อีเมล
                    </label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           class="form-control @error('email') error @enderror"
                           value="{{ old('email', $request->email) }}" 
                           required 
                           autofocus 
                           autocomplete="username"
                           readonly
                           style="background: #f8f9fa;">
                    @error('email')
                        <div class="error-message">
                            <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                            </svg>
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <!-- Password -->
                <div class="form-group">
                    <label for="password" class="form-label">
                        <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20" style="display: inline; margin-right: 0.5rem;">
                            <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"/>
                        </svg>
                        รหัสผ่านใหม่
                    </label>
                    <div class="password-wrapper">
                        <input type="password" 
                               id="password" 
                               name="password" 
                               class="form-control @error('password') error @enderror"
                               required 
                               autocomplete="new-password"
                               placeholder="อย่างน้อย 8 ตัวอักษร"
                               style="padding-right: 3rem;">
                        <button type="button" class="password-toggle" onclick="togglePassword('password')">
                            <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24" id="password-eye">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                            </svg>
                        </button>
                    </div>
                    @error('password')
                        <div class="error-message">
                            <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                            </svg>
                            {{ $message }}
                        </div>
                    @enderror
                    
                    <!-- Password Strength Indicator -->
                    <div class="strength-indicator">
                        <div class="strength-bars">
                            <div class="strength-bar" id="strength-1"></div>
                            <div class="strength-bar" id="strength-2"></div>
                            <div class="strength-bar" id="strength-3"></div>
                            <div class="strength-bar" id="strength-4"></div>
                        </div>
                        <div class="strength-text" id="strength-text" style="color: var(--gray);">กรอกรหัสผ่าน</div>
                    </div>
                </div>

                <!-- Confirm Password -->
                <div class="form-group">
                    <label for="password_confirmation" class="form-label">
                        <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20" style="display: inline; margin-right: 0.5rem;">
                            <path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        ยืนยันรหัสผ่าน
                    </label>
                    <div class="password-wrapper">
                        <input type="password" 
                               id="password_confirmation" 
                               name="password_confirmation" 
                               class="form-control @error('password_confirmation') error @enderror"
                               required 
                               autocomplete="new-password"
                               placeholder="กรอกรหัสผ่านอีกครั้ง"
                               style="padding-right: 3rem;">
                        <button type="button" class="password-toggle" onclick="togglePassword('password_confirmation')">
                            <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24" id="password_confirmation-eye">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                            </svg>
                        </button>
                    </div>
                    @error('password_confirmation')
                        <div class="error-message">
                            <svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                            </svg>
                            {{ $message }}
                        </div>
                    @enderror
                    <div style="font-size: 0.8rem; margin-top: 0.25rem;" id="password-match"></div>
                </div>

                <!-- Submit Button -->
                <button type="submit" class="auth-submit" id="submitBtn">
                    <span id="submitText">
                        <svg width="20" height="20" fill="currentColor" viewBox="0 0 20 20" style="margin-right: 0.5rem;">
                            <path fill-rule="evenodd" d="M12 1.586l-4 4v12.828l4-4 4 4V5.586l-4-4z" clip-rule="evenodd"/>
                        </svg>
                        รีเซ็ตรหัสผ่าน
                    </span>
                    <div id="loadingIcon" class="loading-spinner" style="display: none;"></div>
                </button>

                <!-- Footer -->
                <div class="auth-footer">
                    <a href="{{ route('login') }}" class="auth-link">
                        <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                        </svg>
                        กลับสู่หน้าเข้าสู่ระบบ
                    </a>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Password visibility toggle
        function togglePassword(fieldId) {
            const field = document.getElementById(fieldId);
            const eye = document.getElementById(fieldId + '-eye');
            
            if (field.type === 'password') {
                field.type = 'text';
                eye.innerHTML = `
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L3 3m6.878 6.878L21 21" />
                `;
            } else {
                field.type = 'password';
                eye.innerHTML = `
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                `;
            }
        }

        // Password strength checker
        function checkPasswordStrength(password) {
            let strength = 0;
            if (password.length >= 8) strength++;
            if (/[a-z]/.test(password) && /[A-Z]/.test(password)) strength++;
            if (/\d/.test(password)) strength++;
            if (/[^A-Za-z0-9]/.test(password)) strength++;
            return strength;
        }

        // Form submission handling
        document.getElementById('resetForm').addEventListener('submit', function(e) {
            const submitBtn = document.getElementById('submitBtn');
            const submitText = document.getElementById('submitText');
            const loadingIcon = document.getElementById('loadingIcon');
            
            submitBtn.disabled = true;
            submitText.style.display = 'none';
            loadingIcon.style.display = 'block';
        });

        // Real-time validation
        document.addEventListener('DOMContentLoaded', function() {
            const passwordField = document.getElementById('password');
            const confirmField = document.getElementById('password_confirmation');
            
            // Password strength indicator
            passwordField.addEventListener('input', function() {
                const password = this.value;
                const strength = checkPasswordStrength(password);
                const colors = ['#EF4444', '#F59E0B', '#FFD93D', '#22C55E'];
                const labels = ['อ่อนแอ', 'พอใช้', 'ดี', 'แข็งแกร่ง'];
                
                // Reset all bars
                for (let i = 1; i <= 4; i++) {
                    document.getElementById(`strength-${i}`).style.background = '#E9ECEF';
                }

                // Update active bars
                for (let i = 1; i <= strength; i++) {
                    document.getElementById(`strength-${i}`).style.background = colors[strength - 1] || '#EF4444';
                }

                const strengthText = document.getElementById('strength-text');
                if (password.length === 0) {
                    strengthText.textContent = 'กรอกรหัสผ่าน';
                    strengthText.style.color = '#6C757D';
                } else {
                    strengthText.textContent = labels[strength - 1] || 'อ่อนแอ';
                    strengthText.style.color = colors[strength - 1] || '#EF4444';
                }
            });

            // Password confirmation checker
            confirmField.addEventListener('input', function() {
                const password = passwordField.value;
                const confirmation = this.value;
                const matchDiv = document.getElementById('password-match');

                if (confirmation.length === 0) {
                    matchDiv.textContent = '';
                } else if (password === confirmation) {
                    matchDiv.innerHTML = '<span class="success-message"><svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg>รหัสผ่านตรงกัน</span>';
                } else {
                    matchDiv.innerHTML = '<span class="error-message"><svg width="16" height="16" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>รหัสผ่านไม่ตรงกัน</span>';
                }
            });
        });

        // Add loading screen effect
        window.addEventListener('load', function() {
            document.body.style.opacity = '0';
            document.body.style.transition = 'opacity 0.5s ease';
            
            setTimeout(() => {
                document.body.style.opacity = '1';
            }, 100);
        });
    </script>
</x-guest-layout>