<style>
/* Modern Notification System */
:root {
    --notification-primary: #FF6B35;
    --notification-success: #10B981;
    --notification-warning: #F59E0B;
    --notification-error: #EF4444;
    --notification-info: #3B82F6;
    --notification-shadow: 0 20px 40px rgba(255, 107, 53, 0.15);
    --notification-radius: 16px;
}

/* Bell Animations */
@keyframes bellShake {
    0%, 100% { transform: rotate(0deg); }
    25% { transform: rotate(-15deg) scale(1.1); }
    75% { transform: rotate(15deg) scale(1.1); }
}

@keyframes bellGlow {
    0%, 100% { box-shadow: 0 0 0 0 rgba(255, 107, 53, 0.4); }
    50% { box-shadow: 0 0 0 8px rgba(255, 107, 53, 0); }
}

.notification-bell-active {
    animation: bellShake 0.6s ease-in-out, bellGlow 1.5s ease-in-out;
}

/* Toast Animations */
@keyframes toastSlideIn {
    from {
        transform: translateX(120%) scale(0.8);
        opacity: 0;
    }
    to {
        transform: translateX(0) scale(1);
        opacity: 1;
    }
}

@keyframes toastSlideOut {
    to {
        transform: translateX(120%) scale(0.8);
        opacity: 0;
    }
}

@keyframes toastBounce {
    0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
    40% { transform: translateY(-4px); }
    60% { transform: translateY(-2px); }
}

/* Toast Container */
.toast-container {
    position: fixed;
    top: calc(var(--header-height) + 20px);
    right: 20px;
    z-index: 9999;
    pointer-events: none;
}

/* Toast Notification */
.toast-notification {
    pointer-events: auto;
    margin-bottom: 12px;
    animation: toastSlideIn 0.4s cubic-bezier(0.68, -0.55, 0.265, 1.55);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    position: relative;
    overflow: hidden;
}

.toast-notification::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: linear-gradient(90deg, var(--notification-primary), var(--notification-primary-light));
}

.toast-notification.success::before { background: linear-gradient(90deg, var(--notification-success), #34D399); }
.toast-notification.warning::before { background: linear-gradient(90deg, var(--notification-warning), #FBBF24); }
.toast-notification.error::before { background: linear-gradient(90deg, var(--notification-error), #F87171); }
.toast-notification.info::before { background: linear-gradient(90deg, var(--notification-info), #60A5FA); }

.toast-notification:hover {
    transform: translateY(-2px) scale(1.02);
    box-shadow: var(--notification-shadow);
}

/* Toast Icon */
.toast-icon {
    width: 40px;
    height: 40px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    overflow: hidden;
}

.toast-icon::before {
    content: '';
    position: absolute;
    inset: 0;
    background: linear-gradient(135deg, rgba(255,255,255,0.3), rgba(255,255,255,0.1));
    border-radius: inherit;
}

.toast-icon.success { background: linear-gradient(135deg, var(--notification-success), #059669); }
.toast-icon.warning { background: linear-gradient(135deg, var(--notification-warning), #D97706); }
.toast-icon.error { background: linear-gradient(135deg, var(--notification-error), #DC2626); }
.toast-icon.info { background: linear-gradient(135deg, var(--notification-info), #2563EB); }

/* Notification Dropdown */
.notification-dropdown {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 107, 53, 0.1);
    box-shadow: 0 25px 50px rgba(255, 107, 53, 0.15);
    border-radius: var(--notification-radius);
}

.notification-header {
    background: linear-gradient(135deg, #FFE5DB 0%, #FFD4C4 100%);
    border-bottom: 1px solid rgba(255, 107, 53, 0.1);
    border-radius: var(--notification-radius) var(--notification-radius) 0 0;
    position: relative;
    overflow: hidden;
}

.notification-header::before {
    content: '';
    position: absolute;
    inset: 0;
    background: linear-gradient(135deg, rgba(255,255,255,0.2), transparent);
}

/* Notification Items */
.notification-item {
    position: relative;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    border-left: 4px solid transparent;
    background: rgba(255, 255, 255, 0.8);
}

.notification-item::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 0;
    background: linear-gradient(90deg, var(--notification-primary), transparent);
    transition: width 0.3s ease;
}

.notification-item:hover::before {
    width: 100%;
    opacity: 0.05;
}

.notification-item.unread {
    border-left-color: var(--notification-primary);
    background: linear-gradient(90deg, rgba(255, 107, 53, 0.08), rgba(255, 255, 255, 0.9));
}

.notification-item:hover {
    transform: translateX(4px);
    box-shadow: 0 8px 25px rgba(255, 107, 53, 0.1);
}

/* Notification Icon */
.notification-icon {
    width: 36px;
    height: 36px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.notification-icon::after {
    content: '';
    position: absolute;
    inset: 2px;
    border-radius: 8px;
    background: linear-gradient(135deg, rgba(255,255,255,0.3), rgba(255,255,255,0.1));
    pointer-events: none;
}

/* Badge Styles */
.notification-badge {
    background: linear-gradient(135deg, #EF4444, #DC2626);
    box-shadow: 0 4px 12px rgba(239, 68, 68, 0.4);
    animation: badgePulse 2s ease-in-out infinite;
}

@keyframes badgePulse {
    0%, 100% { transform: scale(1); box-shadow: 0 4px 12px rgba(239, 68, 68, 0.4); }
    50% { transform: scale(1.1); box-shadow: 0 6px 20px rgba(239, 68, 68, 0.6); }
}

.notification-type-badge {
    font-size: 10px;
    font-weight: 600;
    padding: 4px 8px;
    border-radius: 20px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

/* Scrollbar */
.notification-scroll::-webkit-scrollbar {
    width: 6px;
}

.notification-scroll::-webkit-scrollbar-track {
    background: rgba(255, 107, 53, 0.05);
    border-radius: 3px;
}

.notification-scroll::-webkit-scrollbar-thumb {
    background: linear-gradient(180deg, var(--notification-primary), var(--notification-primary-dark));
    border-radius: 3px;
    box-shadow: inset 0 0 2px rgba(255, 255, 255, 0.3);
}

/* Empty State */
.notification-empty {
    background: linear-gradient(135deg, #F8FAFC, #F1F5F9);
    border: 2px dashed rgba(255, 107, 53, 0.2);
    border-radius: 12px;
}

.notification-empty-icon {
    background: linear-gradient(135deg, #FFE5DB, #FFD4C4);
    box-shadow: 0 8px 25px rgba(255, 107, 53, 0.15);
}

/* Progress Bar */
.toast-progress {
    position: absolute;
    bottom: 0;
    left: 0;
    height: 3px;
    background: linear-gradient(90deg, var(--notification-primary), var(--notification-primary-light));
    border-radius: 0 0 12px 12px;
    animation: progressShrink 5s linear;
}

@keyframes progressShrink {
    from { width: 100%; }
    to { width: 0%; }
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .toast-container {
        right: 16px;
        left: 16px;
        top: calc(60px + 16px);
    }
    
    .toast-notification {
        max-width: none;
    }
    
    .notification-dropdown {
        width: calc(100vw - 32px);
        right: 16px;
    }
}

/* Glassmorphism Effect */
.glass-effect {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

/* Micro Interactions */
.notification-item:active {
    transform: translateX(2px) scale(0.98);
}

.toast-notification:active {
    transform: scale(0.95);
}

/* Loading Animation */
@keyframes shimmer {
    0% { background-position: -200px 0; }
    100% { background-position: calc(200px + 100%) 0; }
}

.notification-loading {
    background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
    background-size: 200px 100%;
    animation: shimmer 1.5s infinite;
}
</style>