@extends('layouts.app')

@section('title', 'รายงานการเงิน')
@section('page-title', 'รายงานการเงิน')
@section('mobile-title', 'รายงาน')

@section('content')
<div class="reports-container">
    <!-- Header Section -->
    <div class="reports-header">
        <div class="header-content">
            <div class="header-left">
                <div class="header-icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div class="header-text">
                    <h1 class="reports-title">รายงานการเงิน</h1>
                    <p class="reports-subtitle">วิเคราะห์และติดตามสถานะทางการเงินของคุณ</p>
                </div>
            </div>
            <div class="header-actions">
                <button class="action-btn secondary" onclick="refreshData()">
                    <i class="fas fa-sync-alt"></i>
                    <span>รีเฟรช</span>
                </button>
            </div>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="stats-section">
        <div class="stats-grid">
            <div class="stat-card period">
                <div class="stat-icon">
                    <i class="fas fa-calendar-check"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value">{{ now()->locale('th')->monthName }}</div>
                    <div class="stat-label">เดือนปัจจุบัน</div>
                </div>
            </div>

            <div class="stat-card income">
                <div class="stat-icon">
                    <i class="fas fa-arrow-up"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value">฿{{ number_format(\App\Models\FinanceRecord::forUser(auth()->id())->income()->forMonth(now()->format('Y-m'))->sum('amount'), 0) }}</div>
                    <div class="stat-label">รายรับเดือนนี้</div>
                </div>
            </div>

            <div class="stat-card expense">
                <div class="stat-icon">
                    <i class="fas fa-arrow-down"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value">฿{{ number_format(\App\Models\FinanceRecord::forUser(auth()->id())->expense()->forMonth(now()->format('Y-m'))->sum('amount'), 0) }}</div>
                    <div class="stat-label">รายจ่ายเดือนนี้</div>
                </div>
            </div>

            <div class="stat-card balance">
                @php
                    $monthlyIncome = \App\Models\FinanceRecord::forUser(auth()->id())->income()->forMonth(now()->format('Y-m'))->sum('amount');
                    $monthlyExpense = \App\Models\FinanceRecord::forUser(auth()->id())->expense()->forMonth(now()->format('Y-m'))->sum('amount');
                    $monthlyNet = $monthlyIncome - $monthlyExpense;
                @endphp
                <div class="stat-icon">
                    <i class="fas fa-wallet"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value {{ $monthlyNet >= 0 ? 'positive' : 'negative' }}">
                        {{ $monthlyNet >= 0 ? '+' : '-' }}฿{{ number_format(abs($monthlyNet), 0) }}
                    </div>
                    <div class="stat-label">คงเหลือเดือนนี้</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Report Types -->
    <div class="reports-section">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-chart-bar"></i>
                ประเภทรายงาน
            </h2>
            <p class="section-subtitle">เลือกประเภทรายงานที่ต้องการดู</p>
        </div>

        <div class="reports-grid">
            <!-- Monthly Report -->
            <div class="report-card monthly">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-calendar-alt"></i>
                    </div>
                    <div class="card-badge">รายเดือน</div>
                </div>
                <div class="card-content">
                    <h3 class="card-title">รายงานรายเดือน</h3>
                    <p class="card-desc">สรุปรายรับ-รายจ่ายประจำเดือน พร้อมกราฟแสดงแนวโน้ม</p>
                    
                    <form action="{{ route('finance.reports.monthly') }}" method="GET" class="report-form">
                        <div class="form-group">
                            <label>เลือกเดือน</label>
                            <div class="input-wrapper">
                                <i class="fas fa-calendar input-icon"></i>
                                <input type="month" name="month" class="form-control" value="{{ now()->format('Y-m') }}" required>
                            </div>
                        </div>
                        <button type="submit" class="report-btn monthly">
                            <i class="fas fa-chart-line"></i>
                            ดูรายงาน
                        </button>
                    </form>
                </div>
            </div>

            <!-- Yearly Report -->
            <div class="report-card yearly">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-chart-bar"></i>
                    </div>
                    <div class="card-badge">รายปี</div>
                </div>
                <div class="card-content">
                    <h3 class="card-title">รายงานรายปี</h3>
                    <p class="card-desc">ภาพรวมการเงินทั้งปี เปรียบเทียบแต่ละเดือน</p>
                    
                    <form action="{{ route('finance.reports.yearly') }}" method="GET" class="report-form">
                        <div class="form-group">
                            <label>เลือกปี</label>
                            <div class="input-wrapper">
                                <i class="fas fa-calendar-alt input-icon"></i>
                                <select name="year" class="form-control" required>
                                    @foreach($years ?? [now()->year-2, now()->year-1, now()->year, now()->year+1] as $year)
                                        <option value="{{ $year }}" {{ $year == now()->year ? 'selected' : '' }}>
                                            {{ $year + 543 }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <button type="submit" class="report-btn yearly">
                            <i class="fas fa-chart-bar"></i>
                            ดูรายงาน
                        </button>
                    </form>
                </div>
            </div>

            <!-- Category Report -->
            <div class="report-card category">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-chart-pie"></i>
                    </div>
                    <div class="card-badge">หมวดหมู่</div>
                </div>
                <div class="card-content">
                    <h3 class="card-title">รายงานตามหมวดหมู่</h3>
                    <p class="card-desc">วิเคราะห์การใช้จ่ายแยกตามหมวดหมู่</p>
                    
                    <form action="{{ route('finance.reports.category') }}" method="GET" class="report-form">
                        <div class="form-group">
                            <label>ช่วงเวลา</label>
                            <div class="input-wrapper">
                                <i class="fas fa-clock input-icon"></i>
                                <select name="period" class="form-control" id="categoryPeriod" required>
                                    <option value="month">รายเดือน</option>
                                    <option value="year">รายปี</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group" id="categoryMonthInput">
                            <label>เลือกเดือน</label>
                            <div class="input-wrapper">
                                <i class="fas fa-calendar input-icon"></i>
                                <input type="month" name="date" class="form-control" value="{{ now()->format('Y-m') }}">
                            </div>
                        </div>
                        <div class="form-group" id="categoryYearInput" style="display: none;">
                            <label>เลือกปี</label>
                            <div class="input-wrapper">
                                <i class="fas fa-calendar-alt input-icon"></i>
                                <select name="year" class="form-control">
                                    @foreach($years ?? [now()->year-2, now()->year-1, now()->year, now()->year+1] as $year)
                                        <option value="{{ $year }}">{{ $year + 543 }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <button type="submit" class="report-btn category">
                            <i class="fas fa-chart-pie"></i>
                            ดูรายงาน
                        </button>
                    </form>
                </div>
            </div>

            <!-- Export Report -->
            <div class="report-card export">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-download"></i>
                    </div>
                    <div class="card-badge">ส่งออก</div>
                </div>
                <div class="card-content">
                    <h3 class="card-title">ส่งออกข้อมูล</h3>
                    <p class="card-desc">ดาวน์โหลดรายงานในรูปแบบ PDF หรือ Excel</p>
                    
                    <form action="{{ route('finance.reports.export') }}" method="POST" class="report-form">
                        @csrf
                        <div class="form-group">
                            <label>ประเภทรายงาน</label>
                            <div class="input-wrapper">
                                <i class="fas fa-file-alt input-icon"></i>
                                <select name="type" class="form-control" required>
                                    <option value="monthly">รายเดือน</option>
                                    <option value="yearly">รายปี</option>
                                    <option value="category">ตามหมวดหมู่</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>ช่วงเวลา</label>
                            <div class="input-wrapper">
                                <i class="fas fa-calendar input-icon"></i>
                                <input type="month" name="period" class="form-control" value="{{ now()->format('Y-m') }}" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>รูปแบบไฟล์</label>
                            <div class="input-wrapper">
                                <i class="fas fa-file input-icon"></i>
                                <select name="format" class="form-control" required>
                                    <option value="csv">CSV (Excel)</option>
                                    <option value="pdf">PDF</option>
                                </select>
                            </div>
                        </div>
                        <button type="submit" class="report-btn export">
                            <i class="fas fa-download"></i>
                            ดาวน์โหลด
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="actions-section">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-bolt"></i>
                การดำเนินการด่วน
            </h2>
        </div>
        
        <div class="actions-grid">
            <a href="{{ route('finance.records.index') }}" class="action-card">
                <div class="action-icon records">
                    <i class="fas fa-list"></i>
                </div>
                <div class="action-content">
                    <h4>ดูรายการทั้งหมด</h4>
                    <p>รายรับ-รายจ่ายทั้งหมด</p>
                </div>
                <i class="fas fa-arrow-right action-arrow"></i>
            </a>

            <a href="{{ route('finance.budgets.index') }}" class="action-card">
                <div class="action-icon budgets">
                    <i class="fas fa-calculator"></i>
                </div>
                <div class="action-content">
                    <h4>จัดการงบประมาณ</h4>
                    <p>ตั้งและติดตามงบประมาณ</p>
                </div>
                <i class="fas fa-arrow-right action-arrow"></i>
            </a>

            <a href="{{ route('finance.goals.index') }}" class="action-card">
                <div class="action-icon goals">
                    <i class="fas fa-piggy-bank"></i>
                </div>
                <div class="action-content">
                    <h4>เป้าหมายการออม</h4>
                    <p>ติดตามเป้าหมายการออม</p>
                </div>
                <i class="fas fa-arrow-right action-arrow"></i>
            </a>

            <a href="{{ route('finance.dashboard') }}" class="action-card">
                <div class="action-icon dashboard">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div class="action-content">
                    <h4>ภาพรวมการเงิน</h4>
                    <p>สรุปสถานะการเงิน</p>
                </div>
                <i class="fas fa-arrow-right action-arrow"></i>
            </a>
        </div>
    </div>
</div>

@push('styles')
<style>
/* Container */
.reports-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
    min-height: calc(100vh - 140px);
}

/* Header */
.reports-header {
    background: var(--gradient);
    border-radius: 24px;
    padding: 32px;
    margin-bottom: 24px;
    color: white;
    box-shadow: 0 8px 32px rgba(255, 107, 53, 0.2);
    position: relative;
    overflow: hidden;
}

.reports-header::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -20%;
    width: 300px;
    height: 300px;
    background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
    border-radius: 50%;
}

.header-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 24px;
    position: relative;
    z-index: 2;
}

.header-left {
    display: flex;
    align-items: center;
    gap: 20px;
}

.header-icon {
    width: 64px;
    height: 64px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 28px;
    backdrop-filter: blur(10px);
}

.reports-title {
    font-size: 28px;
    font-weight: 700;
    margin-bottom: 4px;
}

.reports-subtitle {
    font-size: 16px;
    opacity: 0.9;
}

.action-btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    border: none;
    border-radius: 16px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
}

.action-btn.secondary {
    background: rgba(255, 255, 255, 0.15);
    color: white;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.action-btn.secondary:hover {
    background: rgba(255, 255, 255, 0.25);
    transform: translateY(-2px);
}

/* Stats Section */
.stats-section {
    margin-bottom: 32px;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
}

.stat-card {
    background: white;
    border-radius: 20px;
    padding: 24px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    display: flex;
    align-items: center;
    gap: 16px;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
}

.stat-card.period::before { background: #6366F1; }
.stat-card.income::before { background: #10B981; }
.stat-card.expense::before { background: #EF4444; }
.stat-card.balance::before { background: #F59E0B; }

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.12);
}

.stat-icon {
    width: 56px;
    height: 56px;
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    color: white;
}

.stat-card.period .stat-icon { background: linear-gradient(135deg, #6366F1, #4F46E5); }
.stat-card.income .stat-icon { background: linear-gradient(135deg, #10B981, #059669); }
.stat-card.expense .stat-icon { background: linear-gradient(135deg, #EF4444, #DC2626); }
.stat-card.balance .stat-icon { background: linear-gradient(135deg, #F59E0B, #D97706); }

.stat-value {
    font-size: 20px;
    font-weight: 700;
    color: var(--gray-900);
    margin-bottom: 4px;
}

.stat-value.positive { color: #10B981; }
.stat-value.negative { color: #EF4444; }

.stat-label {
    font-size: 14px;
    color: var(--gray-500);
    font-weight: 500;
}

/* Reports Section */
.reports-section {
    background: white;
    border-radius: 24px;
    padding: 32px;
    margin-bottom: 32px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
}

.section-header {
    margin-bottom: 32px;
}

.section-title {
    font-size: 24px;
    font-weight: 700;
    color: var(--gray-900);
    margin-bottom: 4px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.section-title i {
    color: var(--primary);
}

.section-subtitle {
    font-size: 14px;
    color: var(--gray-500);
}

.reports-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
    gap: 24px;
}

.report-card {
    background: white;
    border: 2px solid var(--gray-100);
    border-radius: 20px;
    padding: 24px;
    transition: all 0.3s ease;
    position: relative;
}

.report-card:hover {
    border-color: var(--primary);
    box-shadow: 0 8px 32px rgba(255, 107, 53, 0.1);
    transform: translateY(-2px);
}

.report-card.monthly:hover { border-color: #3B82F6; }
.report-card.yearly:hover { border-color: #10B981; }
.report-card.category:hover { border-color: #F59E0B; }
.report-card.export:hover { border-color: #8B5CF6; }

.card-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 16px;
}

.card-icon {
    width: 48px;
    height: 48px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    color: white;
}

.report-card.monthly .card-icon { background: linear-gradient(135deg, #3B82F6, #1D4ED8); }
.report-card.yearly .card-icon { background: linear-gradient(135deg, #10B981, #047857); }
.report-card.category .card-icon { background: linear-gradient(135deg, #F59E0B, #D97706); }
.report-card.export .card-icon { background: linear-gradient(135deg, #8B5CF6, #7C3AED); }

.card-badge {
    background: rgba(0, 0, 0, 0.05);
    color: var(--gray-600);
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.card-title {
    font-size: 18px;
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 8px;
}

.card-desc {
    font-size: 14px;
    color: var(--gray-500);
    margin-bottom: 20px;
    line-height: 1.5;
}

.report-form {
    display: flex;
    flex-direction: column;
    gap: 16px;
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.form-group label {
    font-size: 14px;
    font-weight: 500;
    color: var(--gray-700);
}

.input-wrapper {
    position: relative;
}

.input-icon {
    position: absolute;
    left: 12px;
    top: 50%;
    transform: translateY(-50%);
    color: var(--gray-400);
    z-index: 2;
}

.form-control {
    width: 100%;
    padding: 12px 16px 12px 40px;
    border: 2px solid var(--gray-200);
    border-radius: 12px;
    font-size: 14px;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: var(--primary);
}

select.form-control {
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%236b7280' d='M10.293 3.293L6 7.586 1.707 3.293A1 1 0 00.293 4.707l5 5a1 1 0 001.414 0l5-5a1 1 0 10-1.414-1.414z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 12px center;
    padding-right: 40px;
}

.report-btn {
    width: 100%;
    padding: 14px 20px;
    border: none;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    color: white;
}

.report-btn.monthly {
    background: linear-gradient(135deg, #3B82F6, #1D4ED8);
    box-shadow: 0 4px 15px rgba(59, 130, 246, 0.3);
}

.report-btn.yearly {
    background: linear-gradient(135deg, #10B981, #047857);
    box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);
}

.report-btn.category {
    background: linear-gradient(135deg, #F59E0B, #D97706);
    box-shadow: 0 4px 15px rgba(245, 158, 11, 0.3);
}

.report-btn.export {
    background: linear-gradient(135deg, #8B5CF6, #7C3AED);
    box-shadow: 0 4px 15px rgba(139, 92, 246, 0.3);
}

.report-btn:hover {
    transform: translateY(-2px);
}

.report-btn:active {
    transform: scale(0.98);
}

/* Actions Section */
.actions-section {
    background: var(--gray-50);
    border-radius: 24px;
    padding: 32px;
    margin-bottom: 32px;
}

.actions-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 20px;
}

.action-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    display: flex;
    align-items: center;
    gap: 16px;
    text-decoration: none;
    transition: all 0.3s ease;
    border: 1px solid var(--gray-200);
}

.action-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
    border-color: var(--primary);
}

.action-icon {
    width: 48px;
    height: 48px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    color: white;
}

.action-icon.records { background: linear-gradient(135deg, #3B82F6, #1D4ED8); }
.action-icon.budgets { background: linear-gradient(135deg, #F59E0B, #D97706); }
.action-icon.goals { background: linear-gradient(135deg, #10B981, #047857); }
.action-icon.dashboard { background: linear-gradient(135deg, #8B5CF6, #7C3AED); }

.action-content {
    flex: 1;
}

.action-content h4 {
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 4px;
}

.action-content p {
    font-size: 14px;
    color: var(--gray-500);
}

.action-arrow {
    color: var(--gray-400);
    font-size: 16px;
    transition: all 0.3s ease;
}

.action-card:hover .action-arrow {
    color: var(--primary);
    transform: translateX(4px);
}

/* Responsive */
@media (max-width: 768px) {
    .reports-container {
        padding: 16px;
    }

    .reports-header {
        padding: 24px;
    }

    .header-content {
        flex-direction: column;
        align-items: flex-start;
        gap: 20px;
    }

    .header-actions {
        width: 100%;
    }

    .action-btn {
        width: 100%;
        justify-content: center;
    }

    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 16px;
    }

    .reports-section {
        padding: 24px;
    }

    .reports-grid {
        grid-template-columns: 1fr;
        gap: 16px;
    }

    .actions-grid {
        grid-template-columns: 1fr;
        gap: 16px;
    }
}

@media (max-width: 480px) {
    .header-left {
        flex-direction: column;
        align-items: flex-start;
        gap: 12px;
    }

    .header-icon {
        width: 48px;
        height: 48px;
        font-size: 20px;
    }

    .reports-title {
        font-size: 24px;
    }

    .stats-grid {
        grid-template-columns: 1fr;
    }
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Toggle period inputs for category report
document.getElementById('categoryPeriod').addEventListener('change', function() {
    const monthInput = document.getElementById('categoryMonthInput');
    const yearInput = document.getElementById('categoryYearInput');
    
    if (this.value === 'month') {
        monthInput.style.display = 'block';
        yearInput.style.display = 'none';
        monthInput.querySelector('input').required = true;
        yearInput.querySelector('select').required = false;
    } else {
        monthInput.style.display = 'none';
        yearInput.style.display = 'block';
        monthInput.querySelector('input').required = false;
        yearInput.querySelector('select').required = true;
    }
});

// Refresh data function
function refreshData() {
    const btn = event.target.closest('.action-btn');
    const icon = btn.querySelector('i');
    
    // Add loading state
    icon.style.animation = 'spin 1s linear infinite';
    btn.disabled = true;
    
    // Simulate refresh (replace with actual API call)
    setTimeout(() => {
        icon.style.animation = '';
        btn.disabled = false;
        
        // Show success message
        Swal.fire({
            icon: 'success',
            title: 'รีเฟรชสำเร็จ!',
            text: 'ข้อมูลได้รับการอัปเดตแล้ว',
            confirmButtonColor: '#FF6B35',
            timer: 2000,
            timerProgressBar: true
        });
        
        // Reload page to show updated data
        setTimeout(() => {
            window.location.reload();
        }, 2000);
    }, 1500);
}

// Add CSS for spin animation
const style = document.createElement('style');
style.textContent = `
    @keyframes spin {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }
`;
document.head.appendChild(style);

// Form submission handling
document.querySelectorAll('.report-form').forEach(form => {
    form.addEventListener('submit', function(e) {
        const submitBtn = this.querySelector('.report-btn');
        const originalText = submitBtn.innerHTML;
        
        submitBtn.disabled = true;
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> กำลังสร้างรายงาน...';
        
        // Re-enable button after a delay (in case of errors)
        setTimeout(() => {
            submitBtn.disabled = false;
            submitBtn.innerHTML = originalText;
        }, 5000);
    });
});

// Session messages
@if (session('success'))
    Swal.fire({
        icon: 'success',
        title: 'สำเร็จ!',
        text: '{{ session('success') }}',
        confirmButtonColor: '#FF6B35'
    });
@endif

@if (session('error'))
    Swal.fire({
        icon: 'error',
        title: 'เกิดข้อผิดพลาด!',
        text: '{{ session('error') }}',
        confirmButtonColor: '#FF6B35'
    });
@endif

// Initialize page
document.addEventListener('DOMContentLoaded', function() {
    console.log('Reports page initialized');
});
</script>
@endpush
@endsection