@extends('layouts.app')

@section('content')
<div class="yearly-report-container">
    <!-- Header -->
    <div class="report-header">
        <div class="header-content">
            <h1 class="report-title">
                <i class="fas fa-chart-bar"></i>
                รายงานประจำปี
            </h1>
            <p class="report-subtitle">
                ปี {{ $year + 543 }}
            </p>
        </div>
        <div class="header-actions">
            <form method="GET" action="{{ route('finance.reports.yearly') }}" class="year-selector">
                <select name="year" class="form-control" onchange="this.form.submit()">
                    @foreach(range(date('Y'), date('Y') - 5) as $y)
                        <option value="{{ $y }}" {{ $year == $y ? 'selected' : '' }}>
                            {{ $y + 543 }}
                        </option>
                    @endforeach
                </select>
            </form>
            <div class="export-buttons">
                <form method="POST" action="{{ route('finance.reports.export') }}" class="d-inline">
                    @csrf
                    <input type="hidden" name="type" value="yearly">
                    <input type="hidden" name="period" value="{{ $year }}">
                    <input type="hidden" name="format" value="csv">
                    <button type="submit" class="btn btn-export">
                        <i class="fas fa-file-csv"></i> CSV
                    </button>
                </form>
                <form method="POST" action="{{ route('finance.reports.export') }}" class="d-inline">
                    @csrf
                    <input type="hidden" name="type" value="yearly">
                    <input type="hidden" name="period" value="{{ $year }}">
                    <input type="hidden" name="format" value="pdf">
                    <button type="submit" class="btn btn-export">
                        <i class="fas fa-file-pdf"></i> PDF
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Yearly Summary -->
    <div class="yearly-summary">
        <div class="summary-card total-income">
            <div class="card-icon">
                <i class="fas fa-coins"></i>
            </div>
            <div class="card-content">
                <h3>รายรับทั้งปี</h3>
                <p class="amount">฿{{ number_format($yearlyTotals['income'], 2) }}</p>
                <span class="average">เฉลี่ย ฿{{ number_format($yearlyTotals['avg_monthly_income'], 2) }}/เดือน</span>
            </div>
        </div>

        <div class="summary-card total-expense">
            <div class="card-icon">
                <i class="fas fa-shopping-cart"></i>
            </div>
            <div class="card-content">
                <h3>รายจ่ายทั้งปี</h3>
                <p class="amount">฿{{ number_format($yearlyTotals['expense'], 2) }}</p>
                <span class="average">เฉลี่ย ฿{{ number_format($yearlyTotals['avg_monthly_expense'], 2) }}/เดือน</span>
            </div>
        </div>

        <div class="summary-card {{ $yearlyTotals['net'] >= 0 ? 'total-positive' : 'total-negative' }}">
            <div class="card-icon">
                <i class="fas {{ $yearlyTotals['net'] >= 0 ? 'fa-piggy-bank' : 'fa-exclamation-triangle' }}"></i>
            </div>
            <div class="card-content">
                <h3>{{ $yearlyTotals['net'] >= 0 ? 'เงินเหลือ' : 'ขาดดุล' }}</h3>
                <p class="amount">฿{{ number_format(abs($yearlyTotals['net']), 2) }}</p>
                <span class="percentage">
                    @php
                        $savingRate = $yearlyTotals['income'] > 0 
                            ? round(($yearlyTotals['net'] / $yearlyTotals['income']) * 100, 1) 
                            : 0;
                    @endphp
                    อัตราการออม {{ $savingRate }}%
                </span>
            </div>
        </div>
    </div>

    <!-- Monthly Trend Chart -->
    <div class="trend-section">
        <h2 class="section-title">
            <i class="fas fa-chart-line"></i>
            แนวโน้มรายเดือน
        </h2>
        <div class="chart-container">
            <canvas id="monthlyTrendChart"></canvas>
        </div>
    </div>

    <!-- Monthly Comparison Table -->
    <div class="monthly-comparison">
        <h2 class="section-title">
            <i class="fas fa-table"></i>
            เปรียบเทียบรายเดือน
        </h2>
        <div class="comparison-table">
            <table>
                <thead>
                    <tr>
                        <th>เดือน</th>
                        <th>รายรับ</th>
                        <th>รายจ่าย</th>
                        <th>คงเหลือ</th>
                        <th>% ของรายรับ</th>
                        <th>แนวโน้ม</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($yearlyTrend as $index => $month)
                        <tr class="{{ $month['net'] >= 0 ? 'positive' : 'negative' }}">
                            <td>{{ $month['month_name'] }}</td>
                            <td class="income">฿{{ number_format($month['income'], 2) }}</td>
                            <td class="expense">฿{{ number_format($month['expense'], 2) }}</td>
                            <td class="{{ $month['net'] >= 0 ? 'positive' : 'negative' }}">
                                ฿{{ number_format($month['net'], 2) }}
                            </td>
                            <td>
                                @php
                                    $percentage = $month['income'] > 0 
                                        ? round(($month['expense'] / $month['income']) * 100, 1) 
                                        : 0;
                                @endphp
                                <div class="percentage-bar">
                                    <div class="percentage-fill" style="width: {{ min($percentage, 100) }}%"></div>
                                    <span class="percentage-text">{{ $percentage }}%</span>
                                </div>
                            </td>
                            <td>
                                @if($index > 0)
                                    @php
                                        $prevNet = $yearlyTrend[$index - 1]['net'];
                                        $change = $month['net'] - $prevNet;
                                    @endphp
                                    @if($change > 0)
                                        <span class="trend up"><i class="fas fa-arrow-up"></i></span>
                                    @elseif($change < 0)
                                        <span class="trend down"><i class="fas fa-arrow-down"></i></span>
                                    @else
                                        <span class="trend same"><i class="fas fa-equals"></i></span>
                                    @endif
                                @else
                                    -
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr class="total-row">
                        <th>รวมทั้งปี</th>
                        <th class="income">฿{{ number_format($yearlyTotals['income'], 2) }}</th>
                        <th class="expense">฿{{ number_format($yearlyTotals['expense'], 2) }}</th>
                        <th class="{{ $yearlyTotals['net'] >= 0 ? 'positive' : 'negative' }}">
                            ฿{{ number_format($yearlyTotals['net'], 2) }}
                        </th>
                        <th>
                            @php
                                $totalPercentage = $yearlyTotals['income'] > 0 
                                    ? round(($yearlyTotals['expense'] / $yearlyTotals['income']) * 100, 1) 
                                    : 0;
                            @endphp
                            {{ $totalPercentage }}%
                        </th>
                        <th>-</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <!-- Category Analysis -->
    <div class="category-analysis">
        <h2 class="section-title">
            <i class="fas fa-chart-pie"></i>
            วิเคราะห์ตามหมวดหมู่
        </h2>
        
        <div class="category-tabs">
            <button class="tab-btn active" data-type="income">รายรับ</button>
            <button class="tab-btn" data-type="expense">รายจ่าย</button>
        </div>

        <div class="category-content">
            <!-- Income Categories -->
            <div class="category-pane active" id="income-pane">
                @if(isset($categoryBreakdown['income']) && $categoryBreakdown['income']->count() > 0)
                    <div class="category-chart-grid">
                        <div class="pie-chart">
                            <canvas id="incomeCategoryChart"></canvas>
                        </div>
                        <div class="category-list">
                            @foreach($categoryBreakdown['income'] as $categorySlug => $data)
                                <div class="category-item">
                                    <div class="category-info">
                                        <i class="fas {{ $data['category_info']->icon ?? 'fa-circle' }}" 
                                           style="color: {{ $data['category_info']->color ?? '#6B7280' }}"></i>
                                        <span>{{ $data['category_info']->name ?? $categorySlug }}</span>
                                    </div>
                                    <div class="category-stats">
                                        <span class="amount">฿{{ number_format($data['amount'], 2) }}</span>
                                        <span class="count">{{ $data['count'] }} รายการ</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @else
                    <p class="no-data">ไม่มีข้อมูลรายรับ</p>
                @endif
            </div>

            <!-- Expense Categories -->
            <div class="category-pane" id="expense-pane">
                @if(isset($categoryBreakdown['expense']) && $categoryBreakdown['expense']->count() > 0)
                    <div class="category-chart-grid">
                        <div class="pie-chart">
                            <canvas id="expenseCategoryChart"></canvas>
                        </div>
                        <div class="category-list">
                            @foreach($categoryBreakdown['expense'] as $categorySlug => $data)
                                <div class="category-item">
                                    <div class="category-info">
                                        <i class="fas {{ $data['category_info']->icon ?? 'fa-circle' }}" 
                                           style="color: {{ $data['category_info']->color ?? '#6B7280' }}"></i>
                                        <span>{{ $data['category_info']->name ?? $categorySlug }}</span>
                                    </div>
                                    <div class="category-stats">
                                        <span class="amount">฿{{ number_format($data['amount'], 2) }}</span>
                                        <span class="count">{{ $data['count'] }} รายการ</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @else
                    <p class="no-data">ไม่มีข้อมูลรายจ่าย</p>
                @endif
            </div>
        </div>
    </div>

    <!-- Best & Worst Months -->
    <div class="highlights-section">
        <h2 class="section-title">
            <i class="fas fa-trophy"></i>
            จุดเด่นประจำปี
        </h2>
        <div class="highlights-grid">
            @php
                $bestMonth = collect($yearlyTrend)->sortByDesc('net')->first();
                $worstMonth = collect($yearlyTrend)->sortBy('net')->first();
                $highestIncome = collect($yearlyTrend)->sortByDesc('income')->first();
                $highestExpense = collect($yearlyTrend)->sortByDesc('expense')->first();
            @endphp

            <div class="highlight-card best">
                <i class="fas fa-medal"></i>
                <h3>เดือนที่ดีที่สุด</h3>
                <p class="month">{{ $bestMonth['month_name'] }}</p>
                <p class="value">เหลือ ฿{{ number_format($bestMonth['net'], 2) }}</p>
            </div>

            <div class="highlight-card worst">
                <i class="fas fa-exclamation-triangle"></i>
                <h3>เดือนที่ควรระวัง</h3>
                <p class="month">{{ $worstMonth['month_name'] }}</p>
                <p class="value">{{ $worstMonth['net'] >= 0 ? 'เหลือ' : 'ขาด' }} ฿{{ number_format(abs($worstMonth['net']), 2) }}</p>
            </div>

            <div class="highlight-card income">
                <i class="fas fa-chart-line"></i>
                <h3>รายรับสูงสุด</h3>
                <p class="month">{{ $highestIncome['month_name'] }}</p>
                <p class="value">฿{{ number_format($highestIncome['income'], 2) }}</p>
            </div>

            <div class="highlight-card expense">
                <i class="fas fa-shopping-bag"></i>
                <h3>ใช้จ่ายมากสุด</h3>
                <p class="month">{{ $highestExpense['month_name'] }}</p>
                <p class="value">฿{{ number_format($highestExpense['expense'], 2) }}</p>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.yearly-report-container {
    max-width: 1200px;
    margin: 2rem auto;
    padding: 0 1rem;
}

/* Header */
.report-header {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    border-radius: 20px;
    padding: 2rem;
    color: white;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(16, 185, 129, 0.3);
}

.header-content {
    margin-bottom: 1.5rem;
}

.report-title {
    font-size: 1.8rem;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin-bottom: 0.5rem;
}

.report-subtitle {
    font-size: 1.2rem;
    opacity: 0.9;
}

.header-actions {
    display: flex;
    gap: 1rem;
    align-items: center;
}

.year-selector .form-control {
    background: rgba(255, 255, 255, 0.2);
    border: 1px solid rgba(255, 255, 255, 0.3);
    color: white;
    padding: 0.5rem 1rem;
    border-radius: 10px;
}

.year-selector .form-control option {
    background: #10b981;
    color: white;
}

.export-buttons {
    display: flex;
    gap: 0.5rem;
}

.btn-export {
    background: rgba(255, 255, 255, 0.2);
    border: 1px solid rgba(255, 255, 255, 0.3);
    color: white;
    padding: 0.5rem 1rem;
    border-radius: 8px;
    font-size: 0.9rem;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-export:hover {
    background: rgba(255, 255, 255, 0.3);
}

/* Yearly Summary */
.yearly-summary {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.summary-card {
    background: white;
    border-radius: 16px;
    padding: 1.5rem;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    display: flex;
    gap: 1.5rem;
    align-items: center;
}

.summary-card .card-icon {
    width: 70px;
    height: 70px;
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
}

.summary-card.total-income .card-icon {
    background: linear-gradient(135deg, #d1fae5 0%, #10b981 100%);
    color: white;
}

.summary-card.total-expense .card-icon {
    background: linear-gradient(135deg, #fee2e2 0%, #ef4444 100%);
    color: white;
}

.summary-card.total-positive .card-icon {
    background: linear-gradient(135deg, #dbeafe 0%, #3b82f6 100%);
    color: white;
}

.summary-card.total-negative .card-icon {
    background: linear-gradient(135deg, #fef3c7 0%, #f59e0b 100%);
    color: white;
}

.card-content h3 {
    font-size: 0.9rem;
    color: #6b7280;
    margin-bottom: 0.5rem;
}

.card-content .amount {
    font-size: 2rem;
    font-weight: 700;
    color: #1f2937;
    margin: 0.5rem 0;
}

.card-content .average,
.card-content .percentage {
    font-size: 0.9rem;
    color: #6b7280;
}

/* Sections */
.trend-section,
.monthly-comparison,
.category-analysis,
.highlights-section {
    background: white;
    border-radius: 16px;
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
}

.section-title {
    font-size: 1.2rem;
    font-weight: 600;
    color: #1f2937;
    margin-bottom: 1.5rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.chart-container {
    height: 350px;
    position: relative;
}

/* Comparison Table */
.comparison-table {
    overflow-x: auto;
}

.comparison-table table {
    width: 100%;
    border-collapse: collapse;
}

.comparison-table th,
.comparison-table td {
    padding: 0.75rem;
    text-align: left;
    border-bottom: 1px solid #f3f4f6;
}

.comparison-table th {
    background: #f9fafb;
    font-weight: 600;
    color: #374151;
}

.comparison-table td.income {
    color: #10b981;
}

.comparison-table td.expense {
    color: #ef4444;
}

.comparison-table td.positive {
    color: #10b981;
    font-weight: 600;
}

.comparison-table td.negative {
    color: #ef4444;
    font-weight: 600;
}

.percentage-bar {
    position: relative;
    width: 100px;
    height: 20px;
    background: #f3f4f6;
    border-radius: 10px;
    overflow: hidden;
}

.percentage-fill {
    position: absolute;
    left: 0;
    top: 0;
    height: 100%;
    background: linear-gradient(90deg, #ef4444 0%, #f87171 100%);
    transition: width 0.3s;
}

.percentage-text {
    position: absolute;
    right: 5px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 0.75rem;
    font-weight: 600;
    color: #374151;
    z-index: 1;
}

.trend {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 30px;
    height: 30px;
    border-radius: 50%;
}

.trend.up {
    background: #d1fae5;
    color: #10b981;
}

.trend.down {
    background: #fee2e2;
    color: #ef4444;
}

.trend.same {
    background: #f3f4f6;
    color: #6b7280;
}

.total-row {
    background: #f9fafb;
    font-weight: 600;
}

/* Category Analysis */
.category-tabs {
    display: flex;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.tab-btn {
    padding: 0.5rem 1.5rem;
    border: 2px solid #e5e7eb;
    background: white;
    border-radius: 8px;
    font-weight: 600;
    color: #6b7280;
    cursor: pointer;
    transition: all 0.3s;
}

.tab-btn.active {
    background: #3b82f6;
    color: white;
    border-color: #3b82f6;
}

.category-pane {
    display: none;
}

.category-pane.active {
    display: block;
}

.category-chart-grid {
    display: grid;
    grid-template-columns: 300px 1fr;
    gap: 2rem;
    align-items: flex-start;
}

.pie-chart {
    height: 300px;
    position: relative;
}

.category-list {
    max-height: 300px;
    overflow-y: auto;
}

.category-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem;
    border-bottom: 1px solid #f3f4f6;
    transition: background 0.2s;
}

.category-item:hover {
    background: #f9fafb;
}

.category-item:last-child {
    border-bottom: none;
}

.category-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.category-info i {
    font-size: 1.2rem;
}

.category-info span {
    font-weight: 500;
    color: #374151;
}

.category-stats {
    display: flex;
    flex-direction: column;
    align-items: flex-end;
    gap: 0.25rem;
}

.category-stats .amount {
    font-weight: 600;
    color: #1f2937;
}

.category-stats .count {
    font-size: 0.875rem;
    color: #6b7280;
}

.no-data {
    text-align: center;
    padding: 2rem;
    color: #6b7280;
}

/* Highlights */
.highlights-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
}

.highlight-card {
    background: white;
    border: 2px solid #e5e7eb;
    border-radius: 16px;
    padding: 2rem;
    text-align: center;
    transition: all 0.3s;
}

.highlight-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
}

.highlight-card i {
    font-size: 3rem;
    margin-bottom: 1rem;
}

.highlight-card.best {
    border-color: #10b981;
    background: #f0fdf4;
}

.highlight-card.best i {
    color: #10b981;
}

.highlight-card.worst {
    border-color: #ef4444;
    background: #fef2f2;
}

.highlight-card.worst i {
    color: #ef4444;
}

.highlight-card.income {
    border-color: #3b82f6;
    background: #eff6ff;
}

.highlight-card.income i {
    color: #3b82f6;
}

.highlight-card.expense {
    border-color: #f59e0b;
    background: #fffbeb;
}

.highlight-card.expense i {
    color: #f59e0b;
}

.highlight-card h3 {
    font-size: 1rem;
    color: #6b7280;
    margin-bottom: 0.5rem;
}

.highlight-card .month {
    font-size: 1.2rem;
    font-weight: 600;
    color: #1f2937;
    margin-bottom: 0.5rem;
}

.highlight-card .value {
    font-size: 1.5rem;
    font-weight: 700;
    color: #1f2937;
}

/* Responsive */
@media (max-width: 1024px) {
    .category-chart-grid {
        grid-template-columns: 1fr;
    }
    
    .pie-chart {
        margin-bottom: 2rem;
    }
}

@media (max-width: 768px) {
    .yearly-summary {
        grid-template-columns: 1fr;
    }
    
    .highlights-grid {
        grid-template-columns: 1fr;
    }
    
    .header-actions {
        flex-direction: column;
        align-items: stretch;
    }
    
    .year-selector {
        width: 100%;
    }
    
    .comparison-table {
        font-size: 0.875rem;
    }
    
    .comparison-table th,
    .comparison-table td {
        padding: 0.5rem;
    }
}

/* Scrollbar */
.category-list::-webkit-scrollbar {
    width: 6px;
}

.category-list::-webkit-scrollbar-track {
    background: #f3f4f6;
    border-radius: 3px;
}

.category-list::-webkit-scrollbar-thumb {
    background: #d1d5db;
    border-radius: 3px;
}

.category-list::-webkit-scrollbar-thumb:hover {
    background: #9ca3af;
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Monthly Trend Chart
const trendCtx = document.getElementById('monthlyTrendChart').getContext('2d');
const yearlyData = @json($yearlyTrend);

new Chart(trendCtx, {
    type: 'line',
    data: {
        labels: yearlyData.map(d => d.month_name),
        datasets: [{
            label: 'รายรับ',
            data: yearlyData.map(d => d.income),
            borderColor: '#10b981',
            backgroundColor: '#10b98120',
            tension: 0.4,
            fill: true
        }, {
            label: 'รายจ่าย',
            data: yearlyData.map(d => d.expense),
            borderColor: '#ef4444',
            backgroundColor: '#ef444420',
            tension: 0.4,
            fill: true
        }, {
            label: 'คงเหลือ',
            data: yearlyData.map(d => d.net),
            borderColor: '#3b82f6',
            backgroundColor: '#3b82f620',
            tension: 0.4,
            fill: true
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom'
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        let label = context.dataset.label || '';
                        if (label) {
                            label += ': ';
                        }
                        label += '฿' + context.parsed.y.toLocaleString();
                        return label;
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return '฿' + value.toLocaleString();
                    }
                }
            }
        }
    }
});

// Category Charts
@if(isset($categoryBreakdown['income']) && $categoryBreakdown['income']->count() > 0)
const incomeCtx = document.getElementById('incomeCategoryChart').getContext('2d');
const incomeData = @json($categoryBreakdown['income']);

new Chart(incomeCtx, {
    type: 'doughnut',
    data: {
        labels: Object.values(incomeData).map(d => d.category_info ? d.category_info.name : 'อื่นๆ'),
        datasets: [{
            data: Object.values(incomeData).map(d => d.amount),
            backgroundColor: Object.values(incomeData).map(d => d.category_info ? d.category_info.color : '#6B7280')
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom',
                labels: {
                    padding: 15,
                    font: {
                        size: 12
                    }
                }
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        let label = context.label || '';
                        if (label) {
                            label += ': ';
                        }
                        label += '฿' + context.parsed.toLocaleString();
                        return label;
                    }
                }
            }
        }
    }
});
@endif

@if(isset($categoryBreakdown['expense']) && $categoryBreakdown['expense']->count() > 0)
const expenseCtx = document.getElementById('expenseCategoryChart').getContext('2d');
const expenseData = @json($categoryBreakdown['expense']);

new Chart(expenseCtx, {
    type: 'doughnut',
    data: {
        labels: Object.values(expenseData).map(d => d.category_info ? d.category_info.name : 'อื่นๆ'),
        datasets: [{
            data: Object.values(expenseData).map(d => d.amount),
            backgroundColor: Object.values(expenseData).map(d => d.category_info ? d.category_info.color : '#6B7280')
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom',
                labels: {
                    padding: 15,
                    font: {
                        size: 12
                    }
                }
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        let label = context.label || '';
                        if (label) {
                            label += ': ';
                        }
                        label += '฿' + context.parsed.toLocaleString();
                        return label;
                    }
                }
            }
        }
    }
});
@endif

// Category Tabs
const tabBtns = document.querySelectorAll('.tab-btn');
const categoryPanes = document.querySelectorAll('.category-pane');

tabBtns.forEach(btn => {
    btn.addEventListener('click', function() {
        // Remove active from all
        tabBtns.forEach(b => b.classList.remove('active'));
        categoryPanes.forEach(p => p.classList.remove('active'));
        
        // Add active to clicked
        this.classList.add('active');
        const type = this.dataset.type;
        document.getElementById(type + '-pane').classList.add('active');
    });
});

// Animate numbers on load
document.addEventListener('DOMContentLoaded', function() {
    const animateValue = (elem, start, end, duration) => {
        const range = end - start;
        const increment = range / (duration / 16);
        let current = start;
        
        const timer = setInterval(() => {
            current += increment;
            if ((increment > 0 && current >= end) || (increment < 0 && current <= end)) {
                current = end;
                clearInterval(timer);
            }
            elem.textContent = '฿' + current.toLocaleString('th-TH', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            });
        }, 16);
    };
    
    // Animate summary cards
    document.querySelectorAll('.summary-card .amount').forEach(elem => {
        const text = elem.textContent;
        const value = parseFloat(text.replace(/[^\d.-]/g, ''));
        elem.textContent = '฿0.00';
        setTimeout(() => {
            animateValue(elem, 0, value, 1000);
        }, 200);
    });
});

// Print functionality
function printReport() {
    window.print();
}

// Export functionality enhancement
document.querySelectorAll('.btn-export').forEach(btn => {
    btn.addEventListener('click', function(e) {
        // Add loading state
        const originalText = this.innerHTML;
        this.innerHTML = '<i class="fas fa-spinner fa-spin"></i> กำลังดาวน์โหลด...';
        this.disabled = true;
        
        // Reset after form submission
        setTimeout(() => {
            this.innerHTML = originalText;
            this.disabled = false;
        }, 2000);
    });
});
</script>

<!-- Print Styles -->
<style media="print">
    .header-actions,
    .btn-export,
    .tab-btn {
        display: none !important;
    }
    
    .yearly-report-container {
        max-width: 100%;
        margin: 0;
        padding: 0;
    }
    
    .report-header {
        background: none !important;
        color: #000 !important;
        border: 1px solid #ddd;
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }
    
    .summary-card,
    .trend-section,
    .monthly-comparison,
    .category-analysis,
    .highlights-section {
        break-inside: avoid;
        page-break-inside: avoid;
    }
    
    .chart-container {
        height: 250px !important;
    }
    
    .category-pane {
        display: block !important;
        page-break-before: always;
    }
    
    .category-chart-grid {
        grid-template-columns: 1fr !important;
    }
    
    @page {
        margin: 1cm;
        size: A4 portrait;
    }
}
</style>
@endpush
@endsection