@extends('layouts.app')

@section('page-title', 'ระบบแจ้งเตือน')
@section('mobile-title', 'แจ้งเตือน')

@section('content')
<div class="container mx-auto px-4 py-6">
    <!-- Header Card -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6" style="background: linear-gradient(135deg, #FFE5DB 0%, #FFD4C4 100%); border: 1px solid rgba(255, 107, 53, 0.1);">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-2xl font-bold mb-2" style="color: var(--primary);">
                    <i class="fas fa-bell mr-3"></i>ระบบแจ้งเตือนหน้าเว็บ
                </h2>
                <p class="text-gray-600">ทดสอบและจัดการการแจ้งเตือนแบบเรียลไทม์</p>
            </div>
            <div class="text-right">
                <div class="w-16 h-16 rounded-full flex items-center justify-center" style="background: var(--gradient);">
                    <i class="fas fa-volume-up text-2xl text-white"></i>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex items-center mb-6">
            <div class="w-8 h-8 rounded-lg flex items-center justify-center mr-3" style="background: var(--gradient);">
                <i class="fas fa-cog text-white"></i>
            </div>
            <h3 class="text-lg font-semibold text-gray-900">การทดสอบ</h3>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- ทดสอบ Toast Notifications -->
            <div class="bg-gradient-to-br from-blue-50 to-blue-100 p-6 rounded-lg border border-blue-200">
                <div class="flex items-center mb-4">
                    <div class="w-8 h-8 rounded-lg bg-blue-500 flex items-center justify-center mr-3">
                        <i class="fas fa-toast text-white text-sm"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-blue-800">ทดสอบ Toast Notifications</h3>
                </div>
                
                <div class="space-y-3">
                    <button onclick="showToast('เข้าสู่ระบบสำเร็จ', 'เข้าสู่ระบบด้วยรถ กข 1234 เรียบร้อย', 'success')" 
                            class="w-full bg-green-500 text-white px-4 py-2 rounded hover:bg-green-600">
                        🔊 Toast สำเร็จ
                    </button>
                    
                    <button onclick="showToast('เปลี่ยนรหัสผ่านแล้ว', 'เปลี่ยนรหัสผ่านสำหรับรถ กข 1234 เรียบร้อย', 'warning')" 
                            class="w-full bg-yellow-500 text-white px-4 py-2 rounded hover:bg-yellow-600">
                        🔊 Toast เตือน
                    </button>
                    
                    <button onclick="showToast('เกิดข้อผิดพลาด', 'ไม่สามารถบันทึกข้อมูลได้', 'error')" 
                            class="w-full bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
                        🔊 Toast ข้อผิดพลาด
                    </button>
                    
                    <button onclick="showToast('ข้อมูลทั่วไป', 'มีการอัปเดตระบบใหม่', 'info')" 
                            class="w-full bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
                        🔊 Toast ข้อมูล
                    </button>
                </div>
            </div>
            
            <!-- ทดสอบ Web Notifications -->
            <div class="bg-gradient-to-br from-green-50 to-green-100 p-6 rounded-lg border border-green-200">
                <div class="flex items-center mb-4">
                    <div class="w-8 h-8 rounded-lg bg-green-500 flex items-center justify-center mr-3">
                        <i class="fas fa-bell text-white text-sm"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-green-800">ทดสอบ Web Notifications</h3>
                </div>
                
                <div class="space-y-3">
                    <button onclick="createWebNotification('login')" 
                            class="w-full bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
                        สร้างการแจ้งเตือนเข้าสู่ระบบ
                    </button>
                    
                    <button onclick="createWebNotification('delivery')" 
                            class="w-full bg-green-500 text-white px-4 py-2 rounded hover:bg-green-600">
                        สร้างการแจ้งเตือนเพิ่มรายการส่ง
                    </button>
                    
                    <button onclick="createWebNotification('password')" 
                            class="w-full bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
                        สร้างการแจ้งเตือนเปลี่ยนรหัสผ่าน
                    </button>
                    
                    <button onclick="createWebNotification('profile')" 
                            class="w-full bg-purple-500 text-white px-4 py-2 rounded hover:bg-purple-600">
                        สร้างการแจ้งเตือนอัปเดตข้อมูล
                    </button>
                </div>
            </div>
        </div>
        
        <!-- สถิติการแจ้งเตือน -->
        <div class="mt-6 bg-gradient-to-br from-gray-50 to-gray-100 p-6 rounded-lg border border-gray-200">
            <div class="flex items-center mb-4">
                <div class="w-8 h-8 rounded-lg flex items-center justify-center mr-3" style="background: var(--gradient);">
                    <i class="fas fa-chart-bar text-white text-sm"></i>
                </div>
                <h3 class="text-lg font-semibold text-gray-800">สถิติการแจ้งเตือน</h3>
            </div>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-center">
                <div class="bg-white p-4 rounded-lg shadow-sm border border-blue-100">
                    <div class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-list text-blue-600"></i>
                    </div>
                    <div class="text-2xl font-bold text-blue-600" id="totalNotifications">0</div>
                    <div class="text-sm text-gray-600">ทั้งหมด</div>
                </div>
                <div class="bg-white p-4 rounded-lg shadow-sm border border-green-100">
                    <div class="w-10 h-10 rounded-full bg-green-100 flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-envelope text-green-600"></i>
                    </div>
                    <div class="text-2xl font-bold text-green-600" id="unreadNotifications">0</div>
                    <div class="text-sm text-gray-600">ยังไม่อ่าน</div>
                </div>
                <div class="bg-white p-4 rounded-lg shadow-sm border border-yellow-100">
                    <div class="w-10 h-10 rounded-full bg-yellow-100 flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-calendar-day text-yellow-600"></i>
                    </div>
                    <div class="text-2xl font-bold text-yellow-600" id="todayNotifications">0</div>
                    <div class="text-sm text-gray-600">วันนี้</div>
                </div>
                <div class="bg-white p-4 rounded-lg shadow-sm border border-purple-100">
                    <div class="w-10 h-10 rounded-full bg-purple-100 flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-calendar-week text-purple-600"></i>
                    </div>
                    <div class="text-2xl font-bold text-purple-600" id="weekNotifications">0</div>
                    <div class="text-sm text-gray-600">สัปดาห์นี้</div>
                </div>
            </div>
        </div>
        
        <!-- คำอธิบาย -->
        <div class="mt-6 bg-gradient-to-br from-yellow-50 to-orange-50 p-6 rounded-lg border border-yellow-200">
            <div class="flex items-center mb-4">
                <div class="w-8 h-8 rounded-lg bg-yellow-500 flex items-center justify-center mr-3">
                    <i class="fas fa-info-circle text-white text-sm"></i>
                </div>
                <h3 class="text-lg font-semibold text-yellow-800">คำอธิบายระบบแจ้งเตือน</h3>
            </div>
            <ul class="space-y-2 text-sm">
                <li>🔔 <strong>Notification Bell:</strong> แสดงจำนวนการแจ้งเตือนที่ยังไม่อ่าน และรายการการแจ้งเตือนล่าสุด</li>
                <li>🍞 <strong>Toast Notifications:</strong> แสดงการแจ้งเตือนแบบป๊อปอัพชั่วคราว มุมขวาบน</li>
                <li>🔊 <strong>Sound Notifications:</strong> เล่นเสียงแจ้งเตือนตามประเภท (สำเร็จ/เตือน/ข้อผิดพลาด)</li>
                <li>📱 <strong>Real-time Updates:</strong> ระบบจะตรวจสอบการแจ้งเตือนใหม่ทุก 30 วินาที</li>
                <li>💾 <strong>Persistent Storage:</strong> การแจ้งเตือนจะถูกเก็บในฐานข้อมูลและสามารถดูย้อนหลังได้</li>
                <li>🎯 <strong>Auto Triggers:</strong> ระบบจะส่งการแจ้งเตือนอัตโนมัติเมื่อมีเหตุการณ์สำคัญ</li>
            </ul>
        </div>
    </div>
</div>

<script>
// ฟังก์ชันสำหรับสร้าง Web Notification
async function createWebNotification(type) {
    const notifications = {
        login: {
            title: 'เข้าสู่ระบบสำเร็จ',
            message: 'เข้าสู่ระบบด้วยรถ กข 1234 เมื่อ ' + new Date().toLocaleTimeString('th-TH'),
            type: 'success'
        },
        delivery: {
            title: 'เพิ่มรายการส่งแล้ว',
            message: 'เพิ่มรายการส่งใหม่ 150 ชิ้น ค่าคอมมิชชั่น 1,250 บาท',
            type: 'success'
        },
        password: {
            title: 'เปลี่ยนรหัสผ่านแล้ว',
            message: 'เปลี่ยนรหัสผ่านสำหรับรถ กข 1234 เรียบร้อย',
            type: 'warning'
        },
        profile: {
            title: 'อัปเดตข้อมูลแล้ว',
            message: 'อัปเดตข้อมูลรถ กข 1234: ชื่อ, อีเมล',
            type: 'info'
        }
    };
    
    const notification = notifications[type];
    
    try {
        const response = await fetch('/api/notifications/create-demo', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(notification)
        });
        
        if (response.ok) {
            showToast('สร้างการแจ้งเตือนสำเร็จ', 'ตรวจสอบที่กระดิ่งการแจ้งเตือน', 'success');
            updateStats();
        } else {
            showToast('เกิดข้อผิดพลาด', 'ไม่สามารถสร้างการแจ้งเตือนได้', 'error');
        }
    } catch (error) {
        console.error('Error:', error);
        showToast('เกิดข้อผิดพลาด', 'ไม่สามารถเชื่อมต่อเซิร์ฟเวอร์ได้', 'error');
    }
}

// อัปเดตสถิติ
async function updateStats() {
    try {
        const response = await fetch('/api/notifications/stats');
        const stats = await response.json();
        
        document.getElementById('totalNotifications').textContent = stats.total || 0;
        document.getElementById('unreadNotifications').textContent = stats.unread || 0;
        document.getElementById('todayNotifications').textContent = stats.today || 0;
        document.getElementById('weekNotifications').textContent = stats.week || 0;
    } catch (error) {
        console.error('Error updating stats:', error);
    }
}

// โหลดสถิติเมื่อเริ่มต้น
document.addEventListener('DOMContentLoaded', function() {
    updateStats();
    
    // อัปเดตสถิติทุก 30 วินาที
    setInterval(updateStats, 30000);
});
</script>
@endsection