
<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['tiers' => [], 'commission' => 0, 'packageCount' => 0]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['tiers' => [], 'commission' => 0, 'packageCount' => 0]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<div class="commission-tier-box">
    <div class="commission-title">
        <i class="fas fa-calculator"></i>
        ตัวอย่างการคำนวณค่าคอมมิชชั่น
    </div>
    
    <?php if(!empty($tiers)): ?>
        <ul class="commission-tier-list">
            <?php $__currentLoopData = $tiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="commission-tier-item">
                    <span class="tier-count"><?php echo e($tier['range'] ?? 'ไม่ระบุ'); ?></span>
                    <span class="tier-label">:</span>
                    <span class="tier-count"><?php echo e(number_format($tier['count'] ?? 0)); ?></span>
                    <span class="tier-label">ชิ้น ×</span>
                    <span class="tier-rate"><?php echo e(number_format($tier['rate'] ?? 0, 2)); ?></span>
                    <span class="tier-currency">บาท =</span>
                    <span class="tier-sum"><?php echo e(number_format($tier['sum'] ?? 0, 2)); ?></span>
                    <span class="tier-currency">บาท</span>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        
        <div class="commission-total">
            <i class="fas fa-coins"></i>
            <span class="label">ค่าคอมมิชชั่นรวม:</span>
            <span class="amount"><?php echo e(number_format($commission, 2)); ?></span>
            <span class="label">บาท</span>
        </div>
    <?php else: ?>
        <div class="text-center py-8 text-gray-500">
            <i class="fas fa-info-circle text-4xl mb-4"></i>
            <p class="text-lg">กรอกจำนวนพัสดุเพื่อดูการคำนวณ</p>
            <p class="text-sm">ระบบจะคำนวณค่าคอมมิชชั่นตามอัตราที่กำหนด</p>
        </div>
    <?php endif; ?>
</div>

<style>
/* Commission Preview Styles */
.commission-tier-box {
    background: linear-gradient(135deg, #f6fbff 65%, #ffefea 100%);
    border: 1.5px solid #C2E4F5;
    border-radius: 18px;
    padding: 1.25rem;
    margin: 0.5rem 0 0.8rem 0;
    box-shadow: 0 2px 12px 0 rgba(255, 107, 53, 0.1);
}

.commission-title {
    font-size: 1.1rem;
    color: #1887c7;
    font-weight: 600;
    margin-bottom: 0.8rem;
    display: flex;
    align-items: center;
    gap: 0.4em;
}

.commission-tier-list {
    margin: 0 0 1rem 0.4em;
    padding: 0;
    list-style: none;
}

.commission-tier-item {
    background: #fff;
    border-radius: 9px;
    margin-bottom: 0.4em;
    padding: 0.55em 1em 0.55em 0.7em;
    font-size: 1.01em;
    color: #343a40;
    display: flex;
    flex-wrap: wrap;
    align-items: baseline;
    box-shadow: 0 1px 4px 0 rgba(24, 135, 199, 0.1);
    border-left: 4px solid #FF6B35;
    gap: 0.45em;
}

.commission-tier-item:last-child {
    margin-bottom: 0;
}

.tier-count {
    font-weight: 500;
    color: #ff6b35;
}

.tier-label {
    color: #aaa;
    font-size: 0.92em;
}

.tier-range {
    color: #888;
    font-size: 0.93em;
}

.tier-mult, .tier-eq {
    color: #ccc;
    font-size: 1em;
}

.tier-rate {
    font-weight: 500;
    color: #1887c7;
}

.tier-sum {
    font-weight: 600;
    color: #1887c7;
    font-size: 1.08em;
}

.tier-currency {
    color: #aaa;
    font-size: 0.94em;
}

.commission-total {
    margin-top: 0.5em;
    font-weight: 700;
    font-size: 1.18em;
    color: #FF6B35;
    display: flex;
    align-items: center;
    gap: 0.5em;
    padding: 0.75rem;
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 2px 8px 0 rgba(255, 107, 53, 0.15);
}

.commission-total .amount {
    font-size: 1.25em;
    color: #FF6B35;
}

.commission-total .label {
    font-weight: 600;
    color: #FF6B35;
}

@media (max-width: 700px) {
    .commission-tier-box {
        padding: 1em 0.8em;
    }
    
    .commission-tier-list {
        margin: 0 0 0.7em 0;
    }
    
    .commission-tier-item {
        font-size: 0.98em;
        padding: 0.4em 0.8em 0.4em 0.7em;
    }
    
    .commission-title {
        font-size: 1em;
    }
    
    .commission-total {
        font-size: 1em;
    }
}
</style><?php /**PATH C:\xampp\htdocs\crs\resources\views/components/commission_preview.blade.php ENDPATH**/ ?>