<?php $__env->startSection('title', 'คำนวณคอมมิชชั่น'); ?>
<?php $__env->startSection('page-title', 'คำนวณคอมมิชชั่น'); ?>
<?php $__env->startSection('mobile-title', 'คำนวณ'); ?>

<?php $__env->startSection('content'); ?>
<!-- Welcome Card (Mobile Only) -->
<div class="welcome-card">
    <div class="welcome-content">
        <div class="welcome-text">
            <div class="welcome-greeting">คำนวณคอมมิชชั่น</div>
            <div class="welcome-name"><?php echo e(Auth::user()->name); ?></div>
            <div class="welcome-subtitle">คำนวณค่าคอมมิชชั่นจากจำนวนชิ้น</div>
        </div>
        <div class="welcome-icon">
            <i class="fas fa-calculator"></i>
        </div>
    </div>
</div>

<div class="calculator-container">
    <!-- Calculator Form -->
    <div class="calculator-section">
        <div class="calculator-card">
            <div class="card-header">
                <div class="header-title">
                    <i class="fas fa-edit"></i>
                    กรอกจำนวนชิ้น
                </div>
            </div>
            
            <!-- User Info -->
            <div class="user-info">
                <div class="info-item">
                    <i class="fas fa-warehouse"></i>
                    <span><?php echo e(auth()->user()->warehouse->name ?? auth()->user()->warehouse_code ?? 'N/A'); ?></span>
                </div>
                <div class="info-item">
                    <i class="fas fa-<?php echo e(auth()->user()->role == '2wheel' ? 'motorcycle' : 'truck'); ?>"></i>
                    <span><?php echo e(auth()->user()->role == '2wheel' ? 'รถมอเตอร์ไซค์' : 'รถสี่ล้อ'); ?></span>
                </div>
            </div>

            <form id="calculatorForm" method="POST" action="<?php echo e(route('vehicle.calculator')); ?>">
                <?php echo csrf_field(); ?>
                
                <div class="card-body">
                    <!-- Input Section -->
                    <div class="input-section">
                        <label class="input-label">จำนวนชิ้นที่จัดส่ง</label>
                        <div class="input-wrapper">
                            <input type="number" 
                                   id="parcel_count" 
                                   name="parcel_count" 
                                   class="parcel-input" 
                                   min="1" 
                                   max="9999"
                                   value="<?php echo e(old('parcel_count', request('parcel_count', ''))); ?>"
                                   placeholder="0"
                                   autocomplete="off">
                            <span class="input-unit">ชิ้น</span>
                        </div>
                    </div>

                    <!-- Quick Select -->
                    <div class="quick-section">
                        <div class="quick-header">
                            <span class="quick-label">เลือกด่วน</span>
                            <button type="button" class="clear-btn" onclick="clearInput()">
                                <i class="fas fa-times"></i>
                                ล้าง
                            </button>
                        </div>
                        <div class="quick-grid">
                            <button type="button" class="quick-btn" data-value="50">50</button>
                            <button type="button" class="quick-btn" data-value="100">100</button>
                            <button type="button" class="quick-btn" data-value="150">150</button>
                            <button type="button" class="quick-btn" data-value="200">200</button>
                            <button type="button" class="quick-btn" data-value="300">300</button>
                            <button type="button" class="quick-btn" data-value="500">500</button>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <button type="submit" class="calculate-btn">
                        <i class="fas fa-calculator"></i>
                        <span>คำนวณคอมมิชชั่น</span>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Commission Rates -->
    <?php if(isset($commissionRates) && $commissionRates->count() > 0): ?>
        <div class="rates-section">
            <div class="rates-card">
                <div class="card-header">
                    <h2 class="card-title">
                        <i class="fas fa-info-circle"></i>
                        อัตราคอมมิชชั่น
                    </h2>
                </div>
                <div class="card-body">
                    <div class="rates-grid">
                        <?php $__currentLoopData = $commissionRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="rate-item" data-min="<?php echo e($rate->min_packages); ?>" data-max="<?php echo e($rate->max_packages ?? 999999); ?>">
                                <div class="rate-tier">ขั้น <?php echo e($rate->tier); ?></div>
                                <div class="rate-range"><?php echo e($rate->range_display); ?></div>
                                <div class="rate-price">฿<?php echo e(number_format($rate->rate_per_package, 2)); ?>/ชิ้น</div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Result Display -->
    <?php if(isset($result)): ?>
        <div class="result-section" id="resultSection">
            <div class="result-card">
                <div class="card-header success">
                    <div class="header-left">
                        <div class="success-icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        <div class="header-text">
                            <h2 class="card-title">ผลการคำนวณ</h2>
                            <p class="result-count"><?php echo e(number_format($result['package_count'])); ?> ชิ้น</p>
                        </div>
                    </div>
                </div>
                
                <div class="card-body">
                    <!-- Total Commission -->
                    <div class="total-section">
                        <div class="total-label">คอมมิชชั่นทั้งหมด</div>
                        <div class="total-amount">
                            <span class="currency">฿</span>
                            <span class="amount"><?php echo e(number_format($result['total_commission'], 0)); ?></span>
                        </div>
                        <div class="average-info">
                            <div class="average-item">
                                <span class="label">เฉลี่ยต่อชิ้น</span>
                                <span class="value">฿<?php echo e(number_format($result['average_per_package'], 2)); ?></span>
                            </div>
                        </div>
                    </div>

                    <!-- Breakdown -->
                    <?php if(count($result['breakdown']) > 0): ?>
                        <div class="breakdown-section">
                            <h3 class="breakdown-title">
                                <i class="fas fa-list-ul"></i>
                                รายละเอียดการคำนวณ
                            </h3>
                            <div class="breakdown-list">
                                <?php $__currentLoopData = $result['breakdown']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="breakdown-item">
                                        <div class="breakdown-header">
                                            <div class="tier-info">
                                                <span class="tier-label">ขั้น <?php echo e($tier['tier']); ?></span>
                                                <span class="tier-range"><?php echo e($tier['range']); ?></span>
                                            </div>
                                            <div class="tier-amount">฿<?php echo e(number_format($tier['tier_commission'], 0)); ?></div>
                                        </div>
                                        <div class="breakdown-calc">
                                            <?php echo e(number_format($tier['packages_in_tier'])); ?> ชิ้น × ฿<?php echo e(number_format($tier['rate_per_package'], 2)); ?>

                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="card-footer">
                    <button type="button" class="action-btn secondary" onclick="clearResult()">
                        <i class="fas fa-redo"></i>
                        <span>คำนวณใหม่</span>
                    </button>
                    <button type="button" class="action-btn primary" onclick="saveAsDelivery()">
                        <i class="fas fa-save"></i>
                        <span>บันทึกเป็นการจัดส่ง</span>
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php $__env->startPush('styles'); ?>
<style>
/* Welcome Card */
.welcome-card {
    background: var(--gradient);
    border-radius: 20px;
    padding: 20px;
    margin-bottom: 20px;
    color: white;
}

.welcome-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.welcome-greeting {
    font-size: 14px;
    opacity: 0.9;
    margin-bottom: 4px;
}

.welcome-name {
    font-size: 20px;
    font-weight: 600;
    margin-bottom: 4px;
}

.welcome-subtitle {
    font-size: 14px;
    opacity: 0.9;
}

.welcome-icon {
    width: 60px;
    height: 60px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
}

/* Container */
.calculator-container {
    padding: 0;
}

/* Calculator Card */
.calculator-card, .rates-card, .result-card {
    background: white;
    border-radius: 16px;
    margin-bottom: 20px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
    overflow: hidden;
}

.card-header {
    background: var(--gradient-soft);
    padding: 16px 20px;
    border-bottom: 1px solid rgba(255,107,53,0.1);
}

.header-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--primary);
    display: flex;
    align-items: center;
    gap: 8px;
}

.card-header.success {
    background: var(--gradient);
    color: white;
    border-bottom: none;
    padding: 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.card-header.success .header-title {
    color: white;
    font-size: 18px;
}

.success-icon {
    width: 48px;
    height: 48px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
}

.result-count {
    font-size: 14px;
    opacity: 0.9;
    margin: 0;
}

/* User Info */
.user-info {
    background: var(--gray-50);
    border-radius: 12px;
    padding: 16px;
    margin: 16px 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.info-item {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    color: var(--gray-700);
    font-weight: 500;
}

.info-item i {
    color: var(--primary);
    width: 16px;
}

.card-body {
    padding: 20px;
}

/* Input Section */
.input-section {
    margin-bottom: 20px;
}

.input-label {
    display: block;
    font-size: 14px;
    font-weight: 500;
    color: var(--gray-900);
    margin-bottom: 8px;
    text-align: center;
}

.input-wrapper {
    position: relative;
    display: flex;
    align-items: center;
}

.parcel-input {
    width: 100%;
    padding: 20px 60px 20px 20px;
    border: 2px solid var(--gray-200);
    border-radius: 12px;
    font-size: 32px;
    font-weight: 700;
    text-align: center;
    font-family: inherit;
    transition: all 0.3s;
    background: white;
    color: var(--primary);
}

.parcel-input:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(255,107,53,0.1);
}

.input-unit {
    position: absolute;
    right: 20px;
    font-size: 16px;
    color: var(--gray-500);
    font-weight: 500;
}

/* Quick Section */
.quick-section {
    margin-bottom: 20px;
}

.quick-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 12px;
}

.quick-label {
    font-size: 14px;
    color: var(--gray-500);
    margin-bottom: 12px;
    text-align: center;
}

.clear-btn {
    display: flex;
    align-items: center;
    gap: 6px;
    padding: 8px 12px;
    background: var(--gray-100);
    border: none;
    border-radius: 10px;
    font-size: 14px;
    color: var(--gray-600);
    cursor: pointer;
    transition: all 0.3s ease;
}

.clear-btn:hover {
    background: var(--gray-200);
}

.quick-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 8px;
}

.quick-btn {
    padding: 12px;
    border: 2px solid var(--gray-200);
    background: white;
    border-radius: 8px;
    font-weight: 600;
    color: var(--gray-700);
    cursor: pointer;
    transition: all 0.3s;
    font-size: 14px;
}

.quick-btn:hover {
    border-color: var(--primary);
    color: var(--primary);
    transform: translateY(-1px);
}

.quick-btn.active {
    background: var(--primary);
    border-color: var(--primary);
    color: white;
}

.card-footer {
    padding: 20px;
    background: var(--gray-50);
    border-top: 1px solid var(--gray-200);
}

.calculate-btn {
    width: 100%;
    padding: 16px 20px;
    background: var(--gradient);
    color: white;
    border: none;
    border-radius: 12px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    box-shadow: 0 4px 12px rgba(255,107,53,0.3);
}

.calculate-btn:active {
    transform: scale(0.98);
}

/* Rates Section */
.rates-card .card-body {
    padding: 16px 20px;
}

.rates-grid {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.rate-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 0;
    border-bottom: 1px solid var(--gray-100);
    transition: all 0.3s;
}

.rate-item:last-child {
    border-bottom: none;
}

.rate-item.highlight {
    background: rgba(255,107,53,0.1);
    border-radius: 8px;
    padding: 12px;
    margin: 0 -12px;
    border-bottom: 1px solid transparent;
}

.rate-tier {
    font-size: 12px;
    color: var(--primary);
    font-weight: 600;
}

.rate-range {
    font-size: 14px;
    color: var(--gray-700);
    font-weight: 500;
}

.rate-price {
    font-size: 14px;
    font-weight: 600;
    color: var(--primary);
}

/* Result Section */
.result-section {
    margin-bottom: 120px;
    animation: slideUp 0.3s ease-out;
}

@keyframes slideUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.total-section {
    text-align: center;
    margin-bottom: 20px;
    padding: 20px;
    background: var(--gradient-soft);
    border-radius: 12px;
}

.total-label {
    font-size: 14px;
    color: var(--gray-600);
    margin-bottom: 8px;
}

.total-amount {
    display: flex;
    align-items: baseline;
    justify-content: center;
    gap: 4px;
    margin-bottom: 8px;
}

.currency {
    font-size: 24px;
    color: var(--primary);
    font-weight: 600;
}

.amount {
    font-size: 36px;
    font-weight: 700;
    color: var(--primary);
}

.average-info {
    display: flex;
    justify-content: center;
    gap: 16px;
}

.average-item {
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.average-item .label {
    font-size: 12px;
    color: var(--gray-500);
}

.average-item .value {
    font-size: 14px;
    font-weight: 600;
    color: var(--gray-900);
}

/* Breakdown Section */
.breakdown-section {
    border-top: 1px solid var(--gray-200);
    padding-top: 20px;
}

.breakdown-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 16px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.breakdown-title i {
    color: var(--primary);
}

.breakdown-list {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.breakdown-item {
    background: var(--gray-50);
    border-radius: 8px;
    padding: 12px;
}

.breakdown-header {
    display: flex;
    justify-content: space-between;
    margin-bottom: 4px;
}

.tier-info {
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.tier-label {
    font-size: 12px;
    font-weight: 600;
    color: var(--primary);
}

.tier-range {
    font-size: 12px;
    color: var(--gray-500);
}

.tier-amount {
    font-size: 14px;
    font-weight: 600;
    color: var(--primary);
}

.breakdown-calc {
    font-size: 14px;
    color: var(--gray-700);
    font-weight: 500;
}

/* Action Buttons */
.card-footer {
    display: flex;
    gap: 12px;
}

.action-btn {
    flex: 1;
    padding: 12px 16px;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 600;
    border: none;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 6px;
}

.action-btn.primary {
    background: var(--gradient);
    color: white;
}

.action-btn.primary:active {
    transform: scale(0.98);
}

.action-btn.secondary {
    background: var(--gray-100);
    color: var(--gray-700);
    border: 2px solid var(--gray-200);
}

.action-btn.secondary:active {
    transform: scale(0.98);
    background: var(--gray-200);
}

/* Desktop Styles */
@media (min-width: 769px) {
    .welcome-card {
        display: none;
    }
    
    .user-info {
        flex-direction: column;
        align-items: flex-start;
        gap: 8px;
    }
    
    .quick-grid {
        grid-template-columns: repeat(6, 1fr);
    }
}

@media (max-width: 768px) {
    .result-section {
        margin-bottom: 150px;
    }
}

@media (max-width: 380px) {
    .parcel-input {
        font-size: 24px;
        padding: 16px 50px 16px 16px;
    }
    
    .quick-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .card-footer {
        flex-direction: column;
    }
    
    .result-section {
        margin-bottom: 200px;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const parcelInput = document.getElementById('parcel_count');
    const form = document.getElementById('calculatorForm');
    
    // Quick select buttons
    document.querySelectorAll('.quick-btn').forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            const value = this.getAttribute('data-value');
            parcelInput.value = value;
            
            // Update active state
            document.querySelectorAll('.quick-btn').forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            
            // Highlight matching rate items
            highlightRateItems(parseInt(value));
            
            // Trigger input event
            parcelInput.dispatchEvent(new Event('input'));
        });
    });
    
    // Highlight rate items based on parcel count
    function highlightRateItems(count) {
        document.querySelectorAll('.rate-item').forEach(item => {
            const min = parseInt(item.getAttribute('data-min'));
            const max = parseInt(item.getAttribute('data-max')) || 999999;
            
            if (count >= min && count <= max) {
                item.classList.add('highlight');
            } else {
                item.classList.remove('highlight');
            }
        });
    }
    
    // Input change event
    parcelInput.addEventListener('input', function() {
        const value = parseInt(this.value) || 0;
        highlightRateItems(value);
        
        // Update quick button active state
        document.querySelectorAll('.quick-btn').forEach(btn => {
            if (parseInt(btn.getAttribute('data-value')) === value) {
                btn.classList.add('active');
            } else {
                btn.classList.remove('active');
            }
        });
    });
    
    // Form submit
    form.addEventListener('submit', function(e) {
        const parcelCount = parcelInput.value;
        
        if (!parcelCount || parcelCount < 1) {
            e.preventDefault();
            Swal.fire({
                icon: 'warning',
                title: 'กรุณากรอกจำนวนชิ้น',
                text: 'จำนวนชิ้นต้องมากกว่า 0',
                confirmButtonColor: '#FF6B35',
                confirmButtonText: 'ตกลง'
            });
            return;
        }
        
        // Show loading
        const submitBtn = this.querySelector('.calculate-btn');
        const originalText = submitBtn.innerHTML;
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i><span>กำลังคำนวณ...</span>';
        submitBtn.disabled = true;
        
        // Re-enable after delay (in case of errors)
        setTimeout(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        }, 5000);
    });
    
    // Initialize highlights
    const currentValue = parcelInput.value;
    if (currentValue) {
        highlightRateItems(parseInt(currentValue));
        
        // Set active quick button
        document.querySelectorAll('.quick-btn').forEach(btn => {
            if (parseInt(btn.getAttribute('data-value')) === parseInt(currentValue)) {
                btn.classList.add('active');
            }
        });
    }
    
    // Scroll to result if exists
    <?php if(isset($result)): ?>
    setTimeout(() => {
        const resultSection = document.getElementById('resultSection');
        if (resultSection) {
            resultSection.scrollIntoView({ 
                behavior: 'smooth', 
                block: 'start' 
            });
        }
    }, 300);
    <?php endif; ?>
});

// Clear input function
function clearInput() {
    document.getElementById('parcel_count').value = '';
    document.querySelectorAll('.quick-btn').forEach(btn => btn.classList.remove('active'));
    document.querySelectorAll('.rate-item').forEach(item => item.classList.remove('highlight'));
}

// Clear result function
function clearResult() {
    clearInput();
    
    const resultSection = document.getElementById('resultSection');
    if (resultSection) {
        resultSection.style.display = 'none';
    }
    
    // Scroll to top
    window.scrollTo({ top: 0, behavior: 'smooth' });
}

// Save as delivery function
function saveAsDelivery() {
    const parcelCount = <?php echo e(isset($result) ? $result['package_count'] : 0); ?>;
    const commission = <?php echo e(isset($result) ? $result['total_commission'] : 0); ?>;
    
    Swal.fire({
        title: 'บันทึกเป็นการจัดส่ง?',
        html: `<div style="text-align: left; padding: 16px;">
            <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                <strong>จำนวนชิ้น:</strong> 
                <span>${parcelCount.toLocaleString()} ชิ้น</span>
            </div>
            <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                <strong>คอมมิชชั่น:</strong> 
                <span style="color: #FF6B35; font-weight: 600;">฿${commission.toLocaleString()}</span>
            </div>
            <div style="display: flex; justify-content: space-between;">
                <strong>วันที่:</strong> 
                <span>${new Date().toLocaleDateString('th-TH')}</span>
            </div>
        </div>`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6B7280',
        confirmButtonText: '<i class="fas fa-save"></i> บันทึก',
        cancelButtonText: '<i class="fas fa-times"></i> ยกเลิก',
        customClass: {
            confirmButton: 'swal-btn-confirm',
            cancelButton: 'swal-btn-cancel'
        }
    }).then((result) => {
        if (result.isConfirmed) {
            // Show loading
            Swal.fire({
                title: 'กำลังบันทึก...',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            
            // Redirect to delivery creation
            setTimeout(() => {
                window.location.href = `<?php echo e(route('vehicle.deliveries.create')); ?>?parcel_count=${parcelCount}`;
            }, 1000);
        }
    });
}

// Session messages
<?php if(session('success')): ?>
    Swal.fire({
        icon: 'success',
        title: 'สำเร็จ!',
        text: '<?php echo e(session('success')); ?>',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>

<?php if(session('error')): ?>
    Swal.fire({
        icon: 'error',
        title: 'เกิดข้อผิดพลาด!',
        text: '<?php echo e(session('error')); ?>',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>
</script>

<style>
.swal-btn-confirm, .swal-btn-cancel {
    display: inline-flex !important;
    align-items: center !important;
    gap: 8px !important;
    padding: 12px 20px !important;
    font-weight: 600 !important;
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/vehicle/calculator.blade.php ENDPATH**/ ?>