

<?php $__env->startSection('page-title', __('deliveries.page_title')); ?>

<?php $__env->startSection('content'); ?>
<div class="deliveries-container">
    <!-- Welcome Card (Mobile Only) -->
    <div class="welcome-card">
        <div class="welcome-content">
            <div class="welcome-text">
                <div class="welcome-greeting"><?php echo e(__('deliveries.greeting')); ?></div>
                <div class="welcome-name"><?php echo e(Auth::user()->name); ?></div>
                <div class="welcome-subtitle"><?php echo e(__('deliveries.view_history')); ?></div>
            </div>
            <div class="welcome-actions">
                <div class="welcome-icon">
                    <i class="fas fa-history"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Grid -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon blue">
                <i class="fas fa-calendar-check"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?php echo e($summary['total_days']); ?></div>
                <div class="stat-label"><?php echo e(__('deliveries.working_days')); ?></div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon purple">
                <i class="fas fa-box"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?php echo e(number_format($summary['total_parcels'])); ?></div>
                <div class="stat-label"><?php echo e(__('deliveries.total_parcels')); ?></div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon green">
                <i class="fas fa-coins"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?php echo e(number_format($summary['total_commission'], 2)); ?></div>
                <div class="stat-label"><?php echo e(__('deliveries.total_commission')); ?></div>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon orange">
                <i class="fas fa-chart-line"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?php echo e($summary['total_parcels'] > 0 ? number_format($summary['total_parcels'] / max($summary['total_days'], 1), 1) : 0); ?></div>
                <div class="stat-label"><?php echo e(__('deliveries.avg_per_day')); ?></div>
            </div>
        </div>
    </div>

    <!-- Filter Card -->
    <div class="filter-card">
        <div class="filter-header">
            <div class="filter-title">
                <i class="fas fa-filter"></i>
                กรองและค้นหา
            </div>
            <div class="filter-status"><?php echo e($records->total()); ?> รายการที่พบ</div>
        </div>
        
        <form method="GET" action="<?php echo e(route('vehicle.deliveries.index')); ?>" class="filter-form" id="filter-form">
            <div class="filter-group">
                <label>
                    <i class="fas fa-calendar-alt"></i>
                    เลือกเดือน
                </label>
                <input type="month" name="month" value="<?php echo e($selectedMonth); ?>" class="form-control" max="<?php echo e(date('Y-m')); ?>">
            </div>
            
            <div class="filter-group">
                <label>
                    <i class="fas fa-search"></i>
                    ค้นหาข้อมูล
                </label>
                <input type="text" name="search" value="<?php echo e(request('search')); ?>" class="form-control" placeholder="ค้นหาตามวันที่, จำนวนพัสดุ หรือค่าคอมมิชชั่น...">
            </div>
            
            <div class="filter-group">
                <label>
                    <i class="fas fa-sort"></i>
                    เรียงตาม
                </label>
                <select name="sort" class="form-control">
                    <option value="date_desc" <?php echo e(request('sort') === 'date_desc' ? 'selected' : ''); ?>>วันที่ (ล่าสุดก่อน)</option>
                    <option value="date_asc" <?php echo e(request('sort') === 'date_asc' ? 'selected' : ''); ?>>วันที่ (เก่าสุดก่อน)</option>
                    <option value="parcels_desc" <?php echo e(request('sort') === 'parcels_desc' ? 'selected' : ''); ?>>พัสดุ (มากไปน้อย)</option>
                    <option value="parcels_asc" <?php echo e(request('sort') === 'parcels_asc' ? 'selected' : ''); ?>>พัสดุ (น้อยไปมาก)</option>
                    <option value="commission_desc" <?php echo e(request('sort') === 'commission_desc' ? 'selected' : ''); ?>>คอมมิชชั่น (มากไปน้อย)</option>
                    <option value="commission_asc" <?php echo e(request('sort') === 'commission_asc' ? 'selected' : ''); ?>>คอมมิชชั่น (น้อยไปมาก)</option>
                </select>
            </div>
        </form>
    </div>

    <!-- Action Buttons -->
    <div class="action-buttons-section">
        <button type="submit" form="filter-form" class="btn btn-primary">
            <i class="fas fa-search"></i>
            ใช้ตัวกรอง
        </button>
        
        <?php if(request('search') || request('month') !== date('Y-m') || request('sort')): ?>
        <a href="<?php echo e(route('vehicle.deliveries.index')); ?>" class="btn btn-reset">
            <i class="fas fa-times"></i>
            ล้างตัวกรอง
        </a>
        <?php endif; ?>
        
        <button type="button" onclick="exportData()" class="btn btn-secondary">
            <i class="fas fa-download"></i>
            ส่งออก Excel
        </button>
        
        <button type="button" onclick="printReport()" class="btn btn-outline">
            <i class="fas fa-print"></i>
            พิมพ์
        </button>
    </div>

    <!-- Weekly Summary -->
    <?php if(count($weeklyData) > 0): ?>
    <div class="weekly-card">
        <div class="weekly-header">
            <div class="weekly-title">
                <i class="fas fa-calendar-week"></i>
                สรุปรายสัปดาห์
            </div>
        </div>
        
        <div class="weekly-grid">
            <?php $__currentLoopData = $weeklyData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $week => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="week-item">
                <div class="week-header">สัปดาห์ <?php echo e($week); ?></div>
                <div class="week-stats">
                    <div class="week-stat">
                        <div class="week-value"><?php echo e($data['days']); ?></div>
                        <div class="week-label">วัน</div>
                    </div>
                    <div class="week-stat">
                        <div class="week-value"><?php echo e(number_format($data['parcels'])); ?></div>
                        <div class="week-label">พัสดุ</div>
                    </div>
                    <div class="week-stat">
                        <div class="week-value"><?php echo e(number_format($data['commission'], 0)); ?></div>
                        <div class="week-label">บาท</div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Table Card -->
    <div class="table-card">
        <div class="table-header">
            <div class="table-title">
                <i class="fas fa-table"></i>
                รายการทั้งหมด
            </div>
            <div class="record-count"><?php echo e($records->total()); ?> รายการ</div>
        </div>
        
        <?php if($records->count() > 0): ?>
        <div style="overflow-x: auto;">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>วันที่</th>
                        <th>วัน</th>
                        <th style="text-align: center;">จำนวนพัสดุ</th>
                        <th style="text-align: right;">ค่าคอมมิชชั่น</th>
                        <th style="text-align: center;">อัตราต่อชิ้น</th>
                        <th style="text-align: center;">จัดการ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(\Carbon\Carbon::parse($record->delivery_date)->format('d/m/Y')); ?></td>
                        <td><?php echo e(\Carbon\Carbon::parse($record->delivery_date)->locale('th')->translatedFormat('l')); ?></td>
                        <td style="text-align: center;">
                            <span class="parcel-badge"><?php echo e(number_format($record->parcel_count)); ?> ชิ้น</span>
                        </td>
                        <td style="text-align: right;">
                            <span class="commission-amount"><?php echo e(number_format($record->commission_amount, 2)); ?> บาท</span>
                        </td>
                        <td style="text-align: center;"><?php echo e(number_format($record->commission_amount / $record->parcel_count, 2)); ?></td>
                        <td>
                            <div class="action-buttons">
                                <a href="<?php echo e(route('vehicle.deliveries.show', $record)); ?>" class="action-btn view" title="ดูรายละเอียด">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('vehicle.deliveries.edit', $record)); ?>" class="action-btn edit" title="แก้ไข">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="<?php echo e(route('vehicle.deliveries.destroy', $record)); ?>" method="POST" class="delete-form">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="action-btn delete" title="ลบ">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <div class="pagination-wrapper">
            <?php echo e($records->withQueryString()->links()); ?>

        </div>
        <?php else: ?>
        <div class="empty-state">
            <div class="empty-icon">
                <i class="fas fa-inbox"></i>
            </div>
            <h3>ไม่มีข้อมูลการจัดส่ง</h3>
            <p>ไม่มีบันทึกการจัดส่งในเดือนนี้</p>
            <a href="<?php echo e(route('vehicle.deliveries.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i>
                บันทึกการจัดส่งแรก
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>



<?php $__env->startPush('styles'); ?>
<style>
:root {
    --primary: #FF6B35;
    --gradient: linear-gradient(135deg, #FF6B35 0%, #FF8C61 50%, #FFAB91 100%);
    --gradient-soft: linear-gradient(135deg, rgba(255,107,53,0.1) 0%, rgba(255,140,97,0.05) 100%);
    --gray-50: #F9FAFB;
    --gray-100: #F3F4F6;
    --gray-200: #E5E7EB;
    --gray-300: #D1D5DB;
    --gray-400: #9CA3AF;
    --gray-500: #6B7280;
    --gray-600: #4B5563;
    --gray-700: #374151;
    --gray-800: #1F2937;
    --gray-900: #111827;
}

.deliveries-container {
    padding: 20px;
    margin-bottom: 100px;
}

/* Welcome Card - Mobile Only */
.welcome-card {
    background: var(--gradient);
    border-radius: 20px;
    padding: 20px;
    margin-bottom: 20px;
    color: white;
    display: none;
}

.welcome-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.welcome-greeting {
    font-size: 14px;
    opacity: 0.9;
    margin-bottom: 4px;
}

.welcome-name {
    font-size: 20px;
    font-weight: 600;
    margin-bottom: 4px;
}

.welcome-subtitle {
    font-size: 14px;
    opacity: 0.9;
}

.welcome-icon {
    width: 60px;
    height: 60px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
}

/* Stats Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
    margin-bottom: 20px;
}

.stat-card {
    background: white;
    border-radius: 16px;
    padding: 1.25rem;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
    display: flex;
    align-items: center;
    gap: 1rem;
    transition: all 0.3s ease;
}

.stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255,107,53,0.12);
}

.stat-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.25rem;
    flex-shrink: 0;
}

.stat-icon.blue {
    background: rgba(59,130,246,0.1);
    color: #3B82F6;
}

.stat-icon.purple {
    background: rgba(139,92,246,0.1);
    color: #8B5CF6;
}

.stat-icon.green {
    background: rgba(16,185,129,0.1);
    color: #10B981;
}

.stat-icon.orange {
    background: rgba(245,158,11,0.1);
    color: #F59E0B;
}

.stat-content {
    flex: 1;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--gray-900);
    margin-bottom: 0.25rem;
}

.stat-label {
    font-size: 0.875rem;
    color: var(--gray-500);
}

/* Filter Card */
.filter-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
}

.filter-header {
    background: var(--gradient-soft);
    margin: -20px -20px 16px -20px;
    padding: 16px 20px;
    border-radius: 16px 16px 0 0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.filter-title {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
}

.filter-title i {
    color: var(--primary);
}

.filter-status {
    font-size: 14px;
    color: var(--gray-600);
    font-weight: 500;
}

.filter-form {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
}

.filter-group label {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 14px;
    font-weight: 500;
    color: var(--gray-700);
    margin-bottom: 6px;
}

.filter-group i {
    color: var(--primary);
}

.form-control {
    width: 100%;
    padding: 0.75rem 1rem;
    border: 2px solid var(--gray-200);
    border-radius: 12px;
    font-family: inherit;
    font-size: 0.95rem;
    transition: all 0.3s;
    background: white;
}

.form-control:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
}

/* Action Buttons */
.action-buttons-section {
    display: flex;
    gap: 0.75rem;
    flex-wrap: wrap;
    justify-content: center;
    margin-bottom: 20px;
    padding: 20px;
    background: white;
    border-radius: 16px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
}

.btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.25rem;
    border: none;
    border-radius: 12px;
    font-weight: 500;
    font-size: 0.9rem;
    cursor: pointer;
    transition: all 0.3s;
    text-decoration: none;
}

.btn-primary {
    background: linear-gradient(135deg, #3B82F6 0%, #2563EB 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}

.btn-secondary {
    background: linear-gradient(135deg, #10B981 0%, #059669 100%);
    color: white;
}

.btn-secondary:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);
}

.btn-outline {
    background: white;
    border: 2px solid var(--gray-300);
    color: var(--gray-700);
}

.btn-outline:hover {
    border-color: var(--primary);
    color: var(--primary);
}

.btn-reset {
    background: var(--gray-100);
    color: var(--gray-700);
}

.btn-reset:hover {
    background: var(--gray-200);
}

/* Weekly Summary */
.weekly-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
}

.weekly-header {
    background: var(--gradient-soft);
    margin: -20px -20px 16px -20px;
    padding: 16px 20px;
    border-radius: 16px 16px 0 0;
    display: flex;
    align-items: center;
    gap: 8px;
}

.weekly-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
    display: flex;
    align-items: center;
    gap: 8px;
}

.weekly-title i {
    color: var(--primary);
}

.weekly-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 1rem;
}

.week-item {
    background: var(--gray-50);
    border-radius: 12px;
    padding: 1rem;
    text-align: center;
    border: 1px solid var(--gray-200);
    transition: all 0.3s ease;
}

.week-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.week-header {
    font-size: 14px;
    font-weight: 600;
    color: var(--primary);
    margin-bottom: 8px;
}

.week-stats {
    display: flex;
    justify-content: space-around;
    gap: 0.5rem;
}

.week-stat {
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.week-value {
    font-size: 16px;
    font-weight: 700;
    color: var(--gray-900);
}

.week-label {
    font-size: 11px;
    color: var(--gray-500);
}

/* Table Card */
.table-card {
    background: white;
    border-radius: 16px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
    overflow: hidden;
}

.table-header {
    background: var(--gradient-soft);
    padding: 20px;
    border-bottom: 1px solid var(--gray-200);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.table-title {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
}

.table-title i {
    color: var(--primary);
}

.record-count {
    font-size: 14px;
    color: var(--gray-600);
    font-weight: 500;
}

.data-table {
    width: 100%;
    border-collapse: collapse;
}

.data-table th {
    background: var(--gray-50);
    padding: 12px 16px;
    text-align: left;
    font-weight: 600;
    font-size: 14px;
    color: var(--gray-900);
    border-bottom: 1px solid var(--gray-200);
}

.data-table td {
    padding: 12px 16px;
    border-bottom: 1px solid var(--gray-100);
    font-size: 14px;
}

.data-table tbody tr:hover {
    background: var(--gray-50);
}

.parcel-badge {
    background: rgba(139,92,246,0.1);
    color: #8B5CF6;
    padding: 4px 8px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
}

.commission-amount {
    font-weight: 600;
    color: #10B981;
}

.action-buttons {
    display: flex;
    gap: 4px;
    justify-content: center;
}

.action-btn {
    width: 32px;
    height: 32px;
    border-radius: 8px;
    border: none;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s;
    text-decoration: none;
    font-size: 14px;
}

.action-btn.view {
    background: rgba(59,130,246,0.1);
    color: #3B82F6;
}

.action-btn.view:hover {
    background: #3B82F6;
    color: white;
}

.action-btn.edit {
    background: rgba(245,158,11,0.1);
    color: #F59E0B;
}

.action-btn.edit:hover {
    background: #F59E0B;
    color: white;
}

.action-btn.delete {
    background: rgba(239,68,68,0.1);
    color: #EF4444;
}

.action-btn.delete:hover {
    background: #EF4444;
    color: white;
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 60px 20px;
}

.empty-icon {
    width: 80px;
    height: 80px;
    background: var(--gray-100);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 16px;
    font-size: 32px;
    color: var(--gray-400);
}

.empty-state h3 {
    font-size: 18px;
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 8px;
}

.empty-state p {
    color: var(--gray-600);
    margin-bottom: 20px;
}

/* Pagination */
.pagination-wrapper {
    padding: 20px;
    display: flex;
    justify-content: center;
    border-top: 1px solid var(--gray-200);
}

/* Responsive */
@media (max-width: 768px) {
    .welcome-card {
        display: block;
    }
    
    .deliveries-container {
        padding: 16px;
    }
    
    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 12px;
    }
    
    .stat-card {
        flex-direction: column;
        text-align: center;
        padding: 1rem;
    }
    
    .filter-form {
        grid-template-columns: 1fr;
    }
    
    .btn {
        width: 100%;
        justify-content: center;
    }
    
    .weekly-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .data-table {
        font-size: 12px;
    }
    
    .data-table th,
    .data-table td {
        padding: 8px;
    }
    
    .data-table th:nth-child(2),
    .data-table td:nth-child(2),
    .data-table th:nth-child(5),
    .data-table td:nth-child(5) {
        display: none;
    }
}

@media (max-width: 480px) {
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .weekly-grid {
        grid-template-columns: 1fr;
    }
}

.delete-form {
    display: inline;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Delete confirmation
document.querySelectorAll('.delete-form').forEach(form => {
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        if (confirm('ยืนยันการลบรายการนี้?')) {
            this.submit();
        }
    });
});

// Auto-submit form on filter changes
document.addEventListener('DOMContentLoaded', function() {
    const monthFilter = document.querySelector('input[name="month"]');
    const sortFilter = document.querySelector('select[name="sort"]');
    const form = document.querySelector('.filter-form form');
    
    if (monthFilter) {
        monthFilter.addEventListener('change', function() {
            form.submit();
        });
    }
    
    if (sortFilter) {
        sortFilter.addEventListener('change', function() {
            form.submit();
        });
    }
});

// Enhanced Export functionality
function exportData() {
    showToast('กำลังสร้างไฟล์ Excel...', 'info');
    
    const currentUrl = new URL(window.location.href);
    currentUrl.searchParams.set('export', 'excel');
    
    const link = document.createElement('a');
    link.href = currentUrl.toString();
    link.download = `delivery-records-${new Date().toISOString().split('T')[0]}.xlsx`;
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    
    setTimeout(() => {
        showToast('ดาวน์โหลดไฟล์สำเร็จ!', 'success');
    }, 2000);
}

// Print Report functionality
function printReport() {
    showToast('กำลังเตรียมรายงานสำหรับพิมพ์...', 'info');
    
    const printWindow = window.open('', '_blank');
    const currentDate = new Date().toLocaleDateString('th-TH');
    const currentTime = new Date().toLocaleTimeString('th-TH');
    
    const table = document.querySelector('.data-table');
    const tableHTML = table ? table.outerHTML : '<p>ไม่มีข้อมูลสำหรับพิมพ์</p>';
    
    const printContent = `
        <!DOCTYPE html>
        <html>
        <head>
            <title>รายงานประวัติการส่งมอบ</title>
            <meta charset="utf-8">
            <style>
                @import url('https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;500;600;700&display=swap');
                * { margin: 0; padding: 0; box-sizing: border-box; }
                body { font-family: 'Kanit', sans-serif; font-size: 12px; line-height: 1.4; color: #333; }
                .header { text-align: center; margin-bottom: 20px; padding: 20px; border-bottom: 2px solid #FF6B35; }
                .header h1 { color: #FF6B35; font-size: 24px; margin-bottom: 10px; }
                table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
                th, td { padding: 8px; text-align: left; border: 1px solid #ddd; }
                th { background: #FF6B35; color: white; font-weight: 600; }
                tr:nth-child(even) { background: #f8f9fa; }
                .footer { text-align: center; margin-top: 30px; padding-top: 20px; border-top: 1px solid #ddd; color: #666; font-size: 11px; }
            </style>
        </head>
        <body>
            <div class="header">
                <h1>รายงานประวัติการส่งมอบ</h1>
                <p>ระบบจัดการข้อมูลและการส่งมอบพัสดุ</p>
            </div>
            ${tableHTML.replace(/class="[^"]*"/g, '').replace(/<i[^>]*>[^<]*<\/i>/g, '')}
            <div class="footer">
                <p>ออกโดยระบบจัดการข้อมูลการส่งมอบ (CRS) | ออกเมื่อ: ${currentDate}</p>
            </div>
        </body>
        </html>
    `;
    
    printWindow.document.write(printContent);
    printWindow.document.close();
    
    setTimeout(() => {
        printWindow.focus();
        printWindow.print();
        showToast('เตรียมรายงานสำหรับพิมพ์เรียบร้อย!', 'success');
    }, 1000);
}

// Toast notification function
function showToast(message, type = 'info', duration = 3000) {
    const toast = document.createElement('div');
    toast.className = `toast-notification ${type}`;
    toast.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        background: ${type === 'error' ? '#EF4444' : type === 'success' ? '#22C55E' : '#3B82F6'};
        color: white;
        padding: 1rem 1.5rem;
        border-radius: 12px;
        box-shadow: 0 10px 25px rgba(0,0,0,0.15);
        z-index: 9999;
        font-family: 'Kanit', sans-serif;
        font-size: 0.9rem;
        max-width: 400px;
        animation: slideInRight 0.3s ease-out;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    `;
    
    const iconMap = {
        success: '<svg width="20" height="20" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg>',
        error: '<svg width="20" height="20" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>',
        info: '<svg width="20" height="20" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/></svg>'
    };
    
    toast.innerHTML = iconMap[type] + '<span>' + message + '</span>';
    
    const style = document.createElement('style');
    style.textContent = `
        @keyframes slideInRight {
            from { transform: translateX(100%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }
        @keyframes slideOutRight {
            from { transform: translateX(0); opacity: 1; }
            to { transform: translateX(100%); opacity: 0; }
        }
    `;
    document.head.appendChild(style);
    
    document.body.appendChild(toast);
    
    setTimeout(() => {
        toast.style.animation = 'slideOutRight 0.3s ease-in';
        setTimeout(() => {
            if (toast.parentElement) {
                toast.remove();
            }
            if (style.parentElement) {
                style.remove();
            }
        }, 300);
    }, duration);
}

</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\crs\resources\views/vehicle/deliveries/index.blade.php ENDPATH**/ ?>