<?php $__env->startSection('title', 'ภาพรวมการเงิน'); ?>
<?php $__env->startSection('page-title', 'ภาพรวมการเงิน'); ?>
<?php $__env->startSection('mobile-title', 'การเงิน'); ?>

<?php $__env->startSection('content'); ?>
<!-- Welcome Card (Mobile Only) -->
<div class="welcome-card">
    <div class="welcome-content">
        <div class="welcome-text">
            <div class="welcome-greeting">สวัสดี!</div>
            <div class="welcome-name"><?php echo e(Auth::user()->name); ?></div>
            <div class="welcome-subtitle">ภาพรวมการเงินของคุณ</div>
        </div>
        <div class="welcome-icon">
            <i class="fas fa-wallet"></i>
        </div>
    </div>
</div>

<!-- Month Selector -->
<div class="month-selector-card">
    <div class="selector-content">
        <div class="selector-label">
            <i class="fas fa-calendar-alt"></i>
            <span>เลือกเดือน</span>
        </div>
        <form method="GET" action="<?php echo e(route('finance.dashboard')); ?>" class="selector-form">
            <select name="month" class="month-select" onchange="this.form.submit()">
                <?php $__currentLoopData = $availableMonths; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($month['value']); ?>" <?php echo e($selectedMonth == $month['value'] ? 'selected' : ''); ?>>
                        <?php echo e($month['label']); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </form>
    </div>
    <button class="sync-btn" onclick="syncDeliveryData()" title="ซิงค์ข้อมูล">
        <i class="fas fa-sync-alt"></i>
    </button>
</div>

<!-- Summary Stats -->
<div class="stats-grid">
    <div class="stat-card income">
        <div class="stat-icon">
            <i class="fas fa-arrow-up"></i>
        </div>
        <div class="stat-content">
            <div class="stat-value">฿<?php echo e(number_format($monthlyStats['total_income'] ?? 0, 0)); ?></div>
            <div class="stat-label">รายรับ</div>
            <div class="stat-detail">
                <span class="detail-badge income">
                    <i class="fas fa-truck"></i>
                    ฿<?php echo e(number_format($monthlyStats['income_sources']['delivery'] ?? 0, 0)); ?>

                </span>
            </div>
        </div>
    </div>

    <div class="stat-card expense">
        <div class="stat-icon">
            <i class="fas fa-arrow-down"></i>
        </div>
        <div class="stat-content">
            <div class="stat-value">฿<?php echo e(number_format($monthlyStats['total_expense'] ?? 0, 0)); ?></div>
            <div class="stat-label">รายจ่าย</div>
            <div class="stat-detail">
                <span class="detail-badge expense">
                    <i class="fas fa-list"></i>
                    <?php echo e(count($monthlyStats['expense_by_category'] ?? [])); ?> หมวด
                </span>
            </div>
        </div>
    </div>

    <div class="stat-card balance <?php echo e(($monthlyStats['is_positive'] ?? true) ? 'positive' : 'negative'); ?>">
        <div class="stat-icon">
            <i class="fas <?php echo e(($monthlyStats['is_positive'] ?? true) ? 'fa-piggy-bank' : 'fa-exclamation-triangle'); ?>"></i>
        </div>
        <div class="stat-content">
            <div class="stat-value">฿<?php echo e(number_format($monthlyStats['net_amount'] ?? 0, 0)); ?></div>
            <div class="stat-label">คงเหลือ</div>
            <div class="stat-badge <?php echo e(($monthlyStats['is_positive'] ?? true) ? 'success' : 'danger'); ?>">
                <?php echo e(($monthlyStats['is_positive'] ?? true) ? 'เงินเหลือ' : 'ติดลบ'); ?>

            </div>
        </div>
    </div>

    <div class="stat-card savings">
        <div class="stat-icon">
            <i class="fas fa-chart-line"></i>
        </div>
        <div class="stat-content">
            <div class="stat-value"><?php echo e(number_format(($monthlyStats['savings_rate'] ?? 0), 1)); ?>%</div>
            <div class="stat-label">อัตราออม</div>
            <div class="stat-detail">
                <span class="detail-badge neutral">
                    <i class="fas fa-target"></i>
                    เป้า 20%
                </span>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="quick-actions-card">
    <div class="actions-header">
        <div class="actions-title">การดำเนินการด่วน</div>
    </div>
    <div class="actions-grid">
        <a href="<?php echo e(route('finance.records.create')); ?>?type=income" class="action-item income">
            <div class="action-icon">
                <i class="fas fa-plus"></i>
            </div>
            <span class="action-label">เพิ่มรายรับ</span>
        </a>
        <a href="<?php echo e(route('finance.records.create')); ?>?type=expense" class="action-item expense">
            <div class="action-icon">
                <i class="fas fa-minus"></i>
            </div>
            <span class="action-label">เพิ่มรายจ่าย</span>
        </a>
        <a href="<?php echo e(route('finance.reports.index')); ?>" class="action-item report">
            <div class="action-icon">
                <i class="fas fa-chart-bar"></i>
            </div>
            <span class="action-label">รายงาน</span>
        </a>
        <a href="<?php echo e(route('finance.goals.index')); ?>" class="action-item goal">
            <div class="action-icon">
                <i class="fas fa-bullseye"></i>
            </div>
            <span class="action-label">เป้าหมาย</span>
        </a>
    </div>
</div>

<!-- Charts -->
<div class="charts-container">
    <!-- Trend Chart -->
    <div class="chart-card">
        <div class="chart-header">
            <div class="chart-title">
                <i class="fas fa-chart-line"></i>
                แนวโน้มรายรับ-รายจ่าย
            </div>
        </div>
        <div class="chart-body">
            <canvas id="trendChart"></canvas>
        </div>
    </div>

    <!-- Expense Breakdown -->
    <div class="chart-card">
        <div class="chart-header">
            <div class="chart-title">
                <i class="fas fa-chart-pie"></i>
                สัดส่วนค่าใช้จ่าย
            </div>
        </div>
        <div class="chart-body">
            <?php if(count($monthlyStats['expense_by_category'] ?? []) > 0): ?>
                <canvas id="expenseChart"></canvas>
                <div class="expense-list">
                    <?php $__currentLoopData = $monthlyStats['expense_by_category']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $category = \App\Models\FinanceCategory::where('slug', $expense['category'])->first();
                        ?>
                        <div class="expense-item">
                            <div class="expense-info">
                                <div class="expense-color" style="background: <?php echo e($category->color ?? '#FF6B35'); ?>"></div>
                                <span class="expense-name"><?php echo e($category->name ?? $expense['category']); ?></span>
                            </div>
                            <div class="expense-amount">
                                <span class="amount">฿<?php echo e(number_format($expense['amount'], 0)); ?></span>
                                <span class="percentage"><?php echo e($expense['percentage']); ?>%</span>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="empty-chart">
                    <i class="fas fa-chart-pie"></i>
                    <p>ยังไม่มีข้อมูลค่าใช้จ่าย</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Recent Transactions -->
<div class="transactions-card">
    <div class="transactions-header">
        <div class="transactions-title">
            <i class="fas fa-history"></i>
            รายการล่าสุด
        </div>
        <a href="<?php echo e(route('finance.records.index')); ?>" class="view-all-btn">
            ดูทั้งหมด
            <i class="fas fa-arrow-right"></i>
        </a>
    </div>
    <div class="transactions-list">
        <?php $__empty_1 = true; $__currentLoopData = $recentTransactions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="transaction-item <?php echo e($transaction->type); ?>">
                <div class="transaction-icon">
                    <i class="fas <?php echo e($transaction->categoryInfo->icon ?? 'fa-circle'); ?>"></i>
                </div>
                <div class="transaction-content">
                    <div class="transaction-title"><?php echo e($transaction->description); ?></div>
                    <div class="transaction-meta">
                        <span class="transaction-category"><?php echo e($transaction->categoryInfo->name ?? 'ไม่ระบุหมวดหมู่'); ?></span>
                        <span class="transaction-date"><?php echo e($transaction->transaction_date ? $transaction->transaction_date->format('d/m/Y') : 'N/A'); ?></span>
                    </div>
                </div>
                <div class="transaction-amount <?php echo e($transaction->type); ?>">
                    <?php echo e($transaction->type === 'income' ? '+' : '-'); ?>฿<?php echo e(number_format($transaction->amount, 0)); ?>

                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="empty-transactions">
                <i class="fas fa-receipt"></i>
                <p>ยังไม่มีรายการล่าสุด</p>
                <a href="<?php echo e(route('finance.records.create')); ?>" class="add-transaction-btn">
                    <i class="fas fa-plus"></i>
                    เพิ่มรายการแรก
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
/* Welcome Card */
.welcome-card {
    background: var(--gradient);
    border-radius: 20px;
    padding: 20px;
    margin-bottom: 20px;
    color: white;
}

.welcome-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.welcome-greeting {
    font-size: 14px;
    opacity: 0.9;
    margin-bottom: 4px;
}

.welcome-name {
    font-size: 20px;
    font-weight: 600;
    margin-bottom: 4px;
}

.welcome-subtitle {
    font-size: 14px;
    opacity: 0.9;
}

.welcome-icon {
    width: 60px;
    height: 60px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
}

/* Month Selector */
.month-selector-card {
    background: white;
    border-radius: 16px;
    padding: 16px 20px;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
}

.selector-content {
    display: flex;
    align-items: center;
    gap: 12px;
    flex: 1;
}

.selector-label {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    font-weight: 500;
    color: var(--gray-700);
}

.selector-label i {
    color: var(--primary);
}

.month-select {
    background: var(--gradient-soft);
    border: 1px solid rgba(255,107,53,0.1);
    border-radius: 12px;
    padding: 8px 12px;
    font-size: 14px;
    font-weight: 500;
    color: var(--primary);
    outline: none;
    cursor: pointer;
}

.sync-btn {
    width: 40px;
    height: 40px;
    border-radius: 12px;
    background: var(--gradient-soft);
    border: none;
    color: var(--primary);
    cursor: pointer;
    transition: all 0.3s;
}

.sync-btn:active {
    transform: scale(0.95);
}

/* Stats Grid */
.stats-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 12px;
    margin-bottom: 20px;
}

.stat-card {
    background: white;
    border-radius: 16px;
    padding: 16px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 3px;
}

.stat-card.income::before { background: #22C55E; }
.stat-card.expense::before { background: #EF4444; }
.stat-card.balance.positive::before { background: var(--primary); }
.stat-card.balance.negative::before { background: #F59E0B; }
.stat-card.savings::before { background: #8B5CF6; }

.stat-icon {
    width: 44px;
    height: 44px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 12px;
    font-size: 20px;
}

.stat-card.income .stat-icon {
    background: rgba(34,197,94,0.1);
    color: #22C55E;
}

.stat-card.expense .stat-icon {
    background: rgba(239,68,68,0.1);
    color: #EF4444;
}

.stat-card.balance .stat-icon {
    background: var(--gradient-soft);
    color: var(--primary);
}

.stat-card.savings .stat-icon {
    background: rgba(139,92,246,0.1);
    color: #8B5CF6;
}

.stat-value {
    font-size: 20px;
    font-weight: 700;
    color: var(--gray-900);
    margin-bottom: 4px;
}

.stat-label {
    font-size: 12px;
    color: var(--gray-500);
    font-weight: 500;
    margin-bottom: 8px;
}

.stat-detail {
    display: flex;
    align-items: center;
}

.detail-badge {
    background: var(--gray-100);
    color: var(--gray-600);
    padding: 2px 6px;
    border-radius: 6px;
    font-size: 10px;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 4px;
}

.detail-badge.income {
    background: rgba(34,197,94,0.1);
    color: #22C55E;
}

.detail-badge.expense {
    background: rgba(239,68,68,0.1);
    color: #EF4444;
}

.stat-badge {
    background: var(--gray-100);
    color: var(--gray-600);
    padding: 4px 8px;
    border-radius: 8px;
    font-size: 10px;
    font-weight: 600;
}

.stat-badge.success {
    background: rgba(34,197,94,0.1);
    color: #22C55E;
}

.stat-badge.danger {
    background: rgba(239,68,68,0.1);
    color: #EF4444;
}

/* Quick Actions */
.quick-actions-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
}

.actions-header {
    margin-bottom: 16px;
}

.actions-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
}

.actions-grid {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 12px;
}

.action-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 16px 8px;
    border-radius: 12px;
    text-decoration: none;
    transition: all 0.3s;
    background: var(--gray-50);
}

.action-item:active {
    transform: scale(0.95);
}

.action-icon {
    width: 44px;
    height: 44px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 8px;
    font-size: 18px;
}

.action-item.income .action-icon {
    background: rgba(34,197,94,0.1);
    color: #22C55E;
}

.action-item.expense .action-icon {
    background: rgba(239,68,68,0.1);
    color: #EF4444;
}

.action-item.report .action-icon {
    background: var(--gradient-soft);
    color: var(--primary);
}

.action-item.goal .action-icon {
    background: rgba(139,92,246,0.1);
    color: #8B5CF6;
}

.action-label {
    font-size: 11px;
    font-weight: 500;
    color: var(--gray-700);
    text-align: center;
}

/* Charts */
.charts-container {
    display: flex;
    flex-direction: column;
    gap: 16px;
    margin-bottom: 20px;
}

.chart-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
}

.chart-header {
    margin-bottom: 16px;
}

.chart-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
    display: flex;
    align-items: center;
    gap: 8px;
}

.chart-title i {
    color: var(--primary);
}

.chart-body {
    position: relative;
    height: 200px;
}

.chart-card:first-child .chart-body {
    height: 250px;
}

.chart-card:first-child .chart-body canvas {
    max-height: 250px !important;
    width: 100% !important;
}

.chart-card:last-child .chart-body {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 20px;
    padding: 10px;
}

.chart-body canvas {
    max-height: 180px !important;
    width: 180px !important;
    flex-shrink: 0;
}

.empty-chart {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    height: 200px;
    color: var(--gray-400);
}

.empty-chart i {
    font-size: 48px;
    margin-bottom: 12px;
}

.expense-list {
    flex: 1;
    margin-top: 0;
    max-height: 180px;
    overflow-y: auto;
    padding: 0 8px;
}

.expense-item {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 8px 0;
    border-bottom: 1px solid var(--gray-100);
}

.expense-item:last-child {
    border-bottom: none;
}

.expense-info {
    display: flex;
    align-items: center;
    gap: 12px;
}

.expense-color {
    width: 12px;
    height: 12px;
    border-radius: 50%;
}

.expense-name {
    font-size: 14px;
    color: var(--gray-700);
    font-weight: 500;
}

.expense-amount {
    display: flex;
    flex-direction: column;
    align-items: flex-end;
    gap: 2px;
}

.amount {
    font-size: 14px;
    font-weight: 600;
    color: var(--gray-900);
}

.percentage {
    font-size: 12px;
    color: var(--gray-500);
}

/* Transactions */
.transactions-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    margin-bottom: 120px;
    box-shadow: 0 2px 12px rgba(255,107,53,0.06);
    border: 1px solid rgba(255,107,53,0.05);
}

.transactions-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 16px;
}

.transactions-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
    display: flex;
    align-items: center;
    gap: 8px;
}

.transactions-title i {
    color: var(--primary);
}

.view-all-btn {
    color: var(--primary);
    font-size: 14px;
    font-weight: 500;
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 4px;
}

.transaction-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px 0;
    border-bottom: 1px solid var(--gray-100);
}

.transaction-item:last-child {
    border-bottom: none;
}

.transaction-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
    flex-shrink: 0;
}

.transaction-item.income .transaction-icon {
    background: rgba(34,197,94,0.1);
    color: #22C55E;
}

.transaction-item.expense .transaction-icon {
    background: rgba(239,68,68,0.1);
    color: #EF4444;
}

.transaction-content {
    flex: 1;
}

.transaction-title {
    font-size: 14px;
    font-weight: 500;
    color: var(--gray-900);
    margin-bottom: 4px;
}

.transaction-meta {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 12px;
    color: var(--gray-500);
}

.transaction-category {
    background: var(--gray-100);
    padding: 2px 6px;
    border-radius: 4px;
}

.transaction-amount {
    font-size: 14px;
    font-weight: 600;
}

.transaction-amount.income {
    color: #22C55E;
}

.transaction-amount.expense {
    color: #EF4444;
}

.empty-transactions {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    padding: 40px 20px;
    text-align: center;
    color: var(--gray-400);
}

.empty-transactions i {
    font-size: 48px;
    margin-bottom: 12px;
}

.empty-transactions p {
    margin-bottom: 16px;
    color: var(--gray-500);
}

.add-transaction-btn {
    background: var(--gradient);
    color: white;
    padding: 8px 16px;
    border-radius: 12px;
    text-decoration: none;
    font-size: 14px;
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: 6px;
}

/* Desktop Styles */
@media (min-width: 769px) {
    .welcome-card {
        display: none;
    }
    
    .stats-grid {
        grid-template-columns: repeat(4, 1fr);
        gap: 20px;
    }
    
    .charts-container {
        display: grid;
        grid-template-columns: 2fr 1fr;
        gap: 20px;
    }
    
    .actions-grid {
        grid-template-columns: repeat(6, 1fr);
    }
}

@media (max-width: 380px) {
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .actions-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<script>
  const originalWarn = console.warn;
  console.warn = function(...args) {
    if (args[0] && args[0].includes('cdn.tailwindcss.com should not be used in production')) {
      return;
    }
    originalWarn.apply(console, args);
  };
</script>
<script src="https://cdn.tailwindcss.com"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Trend Chart
    const trendCtx = document.getElementById('trendChart');
    if (trendCtx) {
        const trendData = <?php echo json_encode($trendData ?? ['labels' => [], 'income' => [], 'expense' => []]) ?>;
        
        // Use real data or fallback
        const labels = trendData.labels && trendData.labels.length > 0 ? trendData.labels : ['ม.ค.', 'ก.พ.', 'มี.ค.', 'เม.ย.', 'พ.ค.', 'มิ.ย.'];
        const incomeData = trendData.income && trendData.income.length > 0 ? trendData.income : [15000, 18000, 22000, 19000, 25000, 28000];
        const expenseData = trendData.expense && trendData.expense.length > 0 ? trendData.expense : [12000, 14000, 16000, 15000, 18000, 20000];
        
        new Chart(trendCtx, {
            type: 'line',
            data: {
                labels: labels,
                datasets: [{
                    label: 'รายรับ',
                    data: incomeData,
                    borderColor: '#22C55E',
                    backgroundColor: 'rgba(34, 197, 94, 0.1)',
                    tension: 0.4,
                    fill: true
                }, {
                    label: 'รายจ่าย',
                    data: expenseData,
                    borderColor: '#EF4444',
                    backgroundColor: 'rgba(239, 68, 68, 0.1)',
                    tension: 0.4,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                        labels: {
                            usePointStyle: true,
                            padding: 20,
                            font: {
                                size: 12,
                                family: 'Kanit'
                            }
                        }
                    }
                },
                scales: {
                    x: {
                        grid: {
                            display: false
                        },
                        ticks: {
                            font: {
                                size: 11,
                                family: 'Kanit'
                            }
                        }
                    },
                    y: {
                        beginAtZero: true,
                        grid: {
                            color: 'rgba(0,0,0,0.05)'
                        },
                        ticks: {
                            callback: function(value) {
                                return '฿' + (value / 1000).toFixed(0) + 'K';
                            },
                            font: {
                                size: 11,
                                family: 'Kanit'
                            }
                        }
                    }
                },
                interaction: {
                    intersect: false,
                    mode: 'index'
                }
            }
        });
    }

    // Expense Chart
    const expenseCtx = document.getElementById('expenseChart');
    if (expenseCtx) {
        const expenseChartData = <?php echo json_encode($expenseChartData ?? ['labels' => [], 'data' => [], 'colors' => []]) ?>;
        
        // Use real data or fallback
        const expenseLabels = expenseChartData.labels && expenseChartData.labels.length > 0 ? expenseChartData.labels : ['อาหาร', 'เดินทาง', 'น้ำมัน'];
        const expenseData = expenseChartData.data && expenseChartData.data.length > 0 ? expenseChartData.data : [1500, 800, 2000];
        const expenseColors = expenseChartData.colors && expenseChartData.colors.length > 0 ? expenseChartData.colors : ['#FF6B35', '#FFA94D', '#FFD93D'];
        
        if (expenseData && expenseData.length > 0) {
            new Chart(expenseCtx, {
                type: 'doughnut',
                data: {
                    labels: expenseLabels,
                    datasets: [{
                        data: expenseData,
                        backgroundColor: expenseColors,
                        borderWidth: 3,
                        borderColor: '#fff',
                        hoverBorderWidth: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true,
                    aspectRatio: 1,
                    cutout: '60%',
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    return context.label + ': ฿' + context.parsed.toLocaleString();
                                }
                            },
                            titleFont: {
                                family: 'Kanit'
                            },
                            bodyFont: {
                                family: 'Kanit'
                            }
                        }
                    },
                    layout: {
                        padding: 10
                    }
                }
            });
        }
    }
});

// Sync delivery data function
function syncDeliveryData() {
    const btn = document.querySelector('.sync-btn');
    const icon = btn.querySelector('i');
    
    // Add loading state
    icon.style.animation = 'spin 1s linear infinite';
    btn.disabled = true;
    
    // Simulate sync (replace with actual API call)
    setTimeout(() => {
        icon.style.animation = '';
        btn.disabled = false;
        
        // Show success message
        if (window.showToast) {
            showToast('ซิงค์ข้อมูลสำเร็จ!', 'success');
        }
        
        // Reload page to show updated data
        window.location.reload();
    }, 2000);
}

// Add CSS for spin animation
const style = document.createElement('style');
style.textContent = `
    @keyframes spin {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }
`;
document.head.appendChild(style);
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\crs\resources\views/finance/dashboard.blade.php ENDPATH**/ ?>