<?php $__env->startSection('title', 'รายงาน - ระบบจัดการค่าคอมมิชชั่น'); ?>

<?php $__env->startSection('content'); ?>
<div class="reports-container">
    <!-- Header Card -->
    <div class="header-card">
        <div class="header-content">
            <div class="header-info">
                <div class="header-icon">
                    <i class="fas fa-chart-bar"></i>
                </div>
                <div class="header-text">
                    <h1 class="header-title">ศูนย์รายงาน</h1>
                    <p class="header-subtitle">ภาพรวมและการวิเคราะห์ข้อมูลทั้งหมดในระบบ</p>
                </div>
            </div>
            <div class="header-actions">
                <button onclick="generateReport()" class="btn btn-primary">
                    <i class="fas fa-file-pdf"></i>
                    <span>สร้างรายงาน</span>
                </button>
                <button onclick="scheduleReport()" class="btn btn-secondary">
                    <i class="fas fa-clock"></i>
                    <span>ตั้งเวลา</span>
                </button>
            </div>
        </div>
    </div>

    <!-- Stats Grid -->
    <div class="stats-grid">
        <div class="stat-card orange">
            <div class="stat-icon">
                <i class="fas fa-truck"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?php echo e(number_format($stats['total_deliveries'])); ?></div>
                <div class="stat-label">การจัดส่งทั้งหมด</div>
            </div>
            <div class="stat-bg"></div>
        </div>

        <div class="stat-card green">
            <div class="stat-icon">
                <i class="fas fa-coins"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value">฿<?php echo e(number_format($stats['total_commission'], 2)); ?></div>
                <div class="stat-label">ค่าคอมมิชชั่นรวม</div>
            </div>
            <div class="stat-bg"></div>
        </div>

        <div class="stat-card blue">
            <div class="stat-icon">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?php echo e(number_format($stats['active_users'])); ?></div>
                <div class="stat-label">พนักงานที่ใช้งาน</div>
            </div>
            <div class="stat-bg"></div>
        </div>

        <div class="stat-card purple">
            <div class="stat-icon">
                <i class="fas fa-warehouse"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?php echo e(number_format($stats['active_warehouses'])); ?></div>
                <div class="stat-label">คลังที่ใช้งาน</div>
            </div>
            <div class="stat-bg"></div>
        </div>
    </div>

    <!-- Performance Section -->
    <div class="section-card">
        <div class="section-header">
            <div class="section-icon blue">
                <i class="fas fa-chart-line"></i>
            </div>
            <div class="section-info">
                <h2 class="section-title">เปรียบเทียบประสิทธิภาพ</h2>
                <p class="section-subtitle">เดือนนี้ vs เดือนที่แล้ว</p>
            </div>
        </div>

        <div class="comparison-grid">
            <div class="comparison-card">
                <div class="comparison-header">
                    <h3>การจัดส่ง</h3>
                    <?php
                        $deliveryChange = 0;
                        if ($lastMonthStats->total_deliveries > 0) {
                            $deliveryChange = (($thisMonthStats->total_deliveries - $lastMonthStats->total_deliveries) / $lastMonthStats->total_deliveries) * 100;
                        }
                    ?>
                    <span class="change-badge <?php echo e($deliveryChange >= 0 ? 'positive' : 'negative'); ?>">
                        <i class="fas fa-<?php echo e($deliveryChange >= 0 ? 'arrow-up' : 'arrow-down'); ?>"></i>
                        <?php echo e(abs(round($deliveryChange, 1))); ?>%
                    </span>
                </div>
                <div class="comparison-data">
                    <div class="data-row">
                        <span class="data-label">เดือนนี้</span>
                        <span class="data-value"><?php echo e(number_format($thisMonthStats->total_deliveries)); ?></span>
                    </div>
                    <div class="data-row">
                        <span class="data-label">เดือนที่แล้ว</span>
                        <span class="data-value"><?php echo e(number_format($lastMonthStats->total_deliveries)); ?></span>
                    </div>
                </div>
            </div>

            <div class="comparison-card">
                <div class="comparison-header">
                    <h3>จำนวนพัสดุ</h3>
                    <?php
                        $parcelChange = 0;
                        if ($lastMonthStats->total_parcels > 0) {
                            $parcelChange = (($thisMonthStats->total_parcels - $lastMonthStats->total_parcels) / $lastMonthStats->total_parcels) * 100;
                        }
                    ?>
                    <span class="change-badge <?php echo e($parcelChange >= 0 ? 'positive' : 'negative'); ?>">
                        <i class="fas fa-<?php echo e($parcelChange >= 0 ? 'arrow-up' : 'arrow-down'); ?>"></i>
                        <?php echo e(abs(round($parcelChange, 1))); ?>%
                    </span>
                </div>
                <div class="comparison-data">
                    <div class="data-row">
                        <span class="data-label">เดือนนี้</span>
                        <span class="data-value"><?php echo e(number_format($thisMonthStats->total_parcels)); ?></span>
                    </div>
                    <div class="data-row">
                        <span class="data-label">เดือนที่แล้ว</span>
                        <span class="data-value"><?php echo e(number_format($lastMonthStats->total_parcels)); ?></span>
                    </div>
                </div>
            </div>

            <div class="comparison-card">
                <div class="comparison-header">
                    <h3>ค่าคอมมิชชั่น</h3>
                    <?php
                        $commissionChange = 0;
                        if ($lastMonthStats->total_commission > 0) {
                            $commissionChange = (($thisMonthStats->total_commission - $lastMonthStats->total_commission) / $lastMonthStats->total_commission) * 100;
                        }
                    ?>
                    <span class="change-badge <?php echo e($commissionChange >= 0 ? 'positive' : 'negative'); ?>">
                        <i class="fas fa-<?php echo e($commissionChange >= 0 ? 'arrow-up' : 'arrow-down'); ?>"></i>
                        <?php echo e(abs(round($commissionChange, 1))); ?>%
                    </span>
                </div>
                <div class="comparison-data">
                    <div class="data-row">
                        <span class="data-label">เดือนนี้</span>
                        <span class="data-value">฿<?php echo e(number_format($thisMonthStats->total_commission, 2)); ?></span>
                    </div>
                    <div class="data-row">
                        <span class="data-label">เดือนที่แล้ว</span>
                        <span class="data-value">฿<?php echo e(number_format($lastMonthStats->total_commission, 2)); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Report Types Section -->
    <div class="section-card">
        <div class="section-header">
            <div class="section-icon orange">
                <i class="fas fa-file-chart-line"></i>
            </div>
            <div class="section-info">
                <h2 class="section-title">ประเภทรายงาน</h2>
                <p class="section-subtitle">เลือกรายงานที่ต้องการดู</p>
            </div>
        </div>

        <div class="report-grid">
            <a href="<?php echo e(route('admin.reports.delivery')); ?>" class="report-card">
                <div class="report-icon delivery">
                    <i class="fas fa-truck"></i>
                </div>
                <div class="report-content">
                    <h3 class="report-title">รายงานการจัดส่ง</h3>
                    <p class="report-description">ข้อมูลการจัดส่งพัสดุ แนวโน้ม และประสิทธิภาพการทำงาน</p>
                    <div class="report-link">
                        <span>ดูรายงาน</span>
                        <i class="fas fa-arrow-right"></i>
                    </div>
                </div>
            </a>

            <a href="<?php echo e(route('admin.reports.commission')); ?>" class="report-card">
                <div class="report-icon commission">
                    <i class="fas fa-coins"></i>
                </div>
                <div class="report-content">
                    <h3 class="report-title">รายงานค่าคอมมิชชั่น</h3>
                    <p class="report-description">การวิเคราะห์ค่าคอมมิชชั่น รายได้ และการกระจายตามระดับ</p>
                    <div class="report-link">
                        <span>ดูรายงาน</span>
                        <i class="fas fa-arrow-right"></i>
                    </div>
                </div>
            </a>

            <a href="<?php echo e(route('admin.reports.warehouse')); ?>" class="report-card">
                <div class="report-icon warehouse">
                    <i class="fas fa-warehouse"></i>
                </div>
                <div class="report-content">
                    <h3 class="report-title">รายงานคลังสินค้า</h3>
                    <p class="report-description">ประสิทธิภาพคลังสินค้า การเปรียบเทียบ และการจัดอันดับ</p>
                    <div class="report-link">
                        <span>ดูรายงาน</span>
                        <i class="fas fa-arrow-right"></i>
                    </div>
                </div>
            </a>
        </div>
    </div>

    <!-- Quick Actions Section -->
    <div class="section-card">
        <div class="section-header">
            <div class="section-icon yellow">
                <i class="fas fa-bolt"></i>
            </div>
            <div class="section-info">
                <h2 class="section-title">การดำเนินการด่วน</h2>
            </div>
        </div>

        <div class="actions-grid">
            <button onclick="generateReport()" class="action-btn primary">
                <i class="fas fa-file-pdf"></i>
                <span>สร้างรายงานประจำเดือน</span>
            </button>
            <button onclick="scheduleReport()" class="action-btn secondary">
                <i class="fas fa-clock"></i>
                <span>ตั้งเวลาส่งรายงาน</span>
            </button>
            <button onclick="customReport()" class="action-btn tertiary">
                <i class="fas fa-cog"></i>
                <span>รายงานแบบกำหนดเอง</span>
            </button>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Container */
.reports-container {
    min-height: 100vh;
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 50%, #cbd5e1 100%);
    padding: 2rem;
}

/* Header Card */
.header-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 24px;
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    padding: 2rem;
    margin-bottom: 2rem;
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1.5rem;
}

.header-info {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.header-icon {
    width: 64px;
    height: 64px;
    background: linear-gradient(135deg, #FF6B35 0%, #DC2626 100%);
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: white;
    box-shadow: 0 10px 25px rgba(255, 107, 53, 0.3);
}

.header-title {
    font-size: 2rem;
    font-weight: 700;
    background: linear-gradient(135deg, #1f2937 0%, #6b7280 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    margin: 0 0 0.5rem 0;
}

.header-subtitle {
    color: #6b7280;
    margin: 0;
    font-size: 1rem;
}

.header-actions {
    display: flex;
    gap: 0.75rem;
}

/* Buttons */
.btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    font-weight: 500;
    border: none;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
}

.btn-primary {
    background: linear-gradient(135deg, #FF6B35 0%, #DC2626 100%);
    color: white;
    box-shadow: 0 10px 25px rgba(255, 107, 53, 0.3);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 15px 35px rgba(255, 107, 53, 0.4);
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.9);
    color: #374151;
    border: 1px solid #e5e7eb;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
}

.btn-secondary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
}

/* Stats Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    position: relative;
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 2rem;
    overflow: hidden;
    transition: all 0.3s ease;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.stat-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
}

.stat-card.orange {
    background: linear-gradient(135deg, #FF6B35 0%, #DC2626 100%);
    color: white;
}

.stat-card.green {
    background: linear-gradient(135deg, #10B981 0%, #059669 100%);
    color: white;
}

.stat-card.blue {
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
    color: white;
}

.stat-card.purple {
    background: linear-gradient(135deg, #8B5CF6 0%, #7C3AED 100%);
    color: white;
}

.stat-icon {
    width: 60px;
    height: 60px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.75rem;
    margin-bottom: 1.5rem;
}

.stat-value {
    font-size: 2.25rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.stat-label {
    font-size: 0.9rem;
    opacity: 0.9;
}

.stat-bg {
    position: absolute;
    top: -50%;
    right: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
    pointer-events: none;
}

/* Section Cards */
.section-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 24px;
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    padding: 2rem;
    margin-bottom: 2rem;
}

.section-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 2rem;
}

.section-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.25rem;
    color: white;
}

.section-icon.blue {
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
}

.section-icon.orange {
    background: linear-gradient(135deg, #FF6B35 0%, #DC2626 100%);
}

.section-icon.yellow {
    background: linear-gradient(135deg, #F59E0B 0%, #D97706 100%);
}

.section-title {
    font-size: 1.5rem;
    font-weight: 600;
    color: #1f2937;
    margin: 0;
}

.section-subtitle {
    color: #6b7280;
    font-size: 0.9rem;
    margin: 0.25rem 0 0 0;
}

/* Comparison Grid */
.comparison-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1.5rem;
}

.comparison-card {
    background: rgba(249, 250, 251, 0.8);
    border-radius: 16px;
    padding: 1.5rem;
    border: 1px solid rgba(229, 231, 235, 0.5);
}

.comparison-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
}

.comparison-header h3 {
    font-size: 1.1rem;
    font-weight: 600;
    color: #1f2937;
    margin: 0;
}

.change-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.25rem;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.875rem;
    font-weight: 600;
}

.change-badge.positive {
    background: #D1FAE5;
    color: #047857;
}

.change-badge.negative {
    background: #FEE2E2;
    color: #DC2626;
}

.comparison-data {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.data-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.data-label {
    color: #6b7280;
    font-size: 0.9rem;
}

.data-value {
    font-weight: 600;
    color: #1f2937;
}

/* Report Grid */
.report-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
    gap: 1.5rem;
}

.report-card {
    display: block;
    background: rgba(249, 250, 251, 0.8);
    border-radius: 16px;
    padding: 2rem;
    border: 1px solid rgba(229, 231, 235, 0.5);
    transition: all 0.3s ease;
    text-decoration: none;
    color: inherit;
}

.report-card:hover {
    background: white;
    transform: translateY(-4px);
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
    text-decoration: none;
    color: inherit;
}

.report-icon {
    width: 64px;
    height: 64px;
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.75rem;
    margin-bottom: 1.5rem;
}

.report-icon.delivery {
    background: linear-gradient(135deg, #FEF3C7 0%, #FDE68A 100%);
    color: #D97706;
}

.report-icon.commission {
    background: linear-gradient(135deg, #D1FAE5 0%, #A7F3D0 100%);
    color: #047857;
}

.report-icon.warehouse {
    background: linear-gradient(135deg, #DBEAFE 0%, #BFDBFE 100%);
    color: #2563EB;
}

.report-title {
    font-size: 1.25rem;
    font-weight: 600;
    color: #1f2937;
    margin: 0 0 0.75rem 0;
}

.report-description {
    color: #6b7280;
    font-size: 0.9rem;
    margin: 0 0 1.5rem 0;
    line-height: 1.5;
}

.report-link {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: #FF6B35;
    font-weight: 500;
    font-size: 0.95rem;
}

.report-card:hover .report-link i {
    transform: translateX(4px);
}

.report-link i {
    transition: transform 0.3s ease;
}

/* Actions Grid */
.actions-grid {
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
}

.action-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.875rem 1.75rem;
    border-radius: 12px;
    font-weight: 500;
    border: none;
    cursor: pointer;
    transition: all 0.3s ease;
}

.action-btn:hover {
    transform: translateY(-2px);
}

.action-btn.primary {
    background: linear-gradient(135deg, #FF6B35 0%, #DC2626 100%);
    color: white;
    box-shadow: 0 10px 25px rgba(255, 107, 53, 0.3);
}

.action-btn.primary:hover {
    box-shadow: 0 15px 35px rgba(255, 107, 53, 0.4);
}

.action-btn.secondary {
    background: #F3F4F6;
    color: #374151;
}

.action-btn.secondary:hover {
    background: #E5E7EB;
}

.action-btn.tertiary {
    background: transparent;
    color: #FF6B35;
    border: 2px solid #FF6B35;
}

.action-btn.tertiary:hover {
    background: #FF6B35;
    color: white;
}

/* Responsive */
@media (max-width: 768px) {
    .reports-container {
        padding: 1rem;
    }
    
    .header-content {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .header-actions {
        width: 100%;
        justify-content: stretch;
    }
    
    .btn {
        flex: 1;
        justify-content: center;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .comparison-grid {
        grid-template-columns: 1fr;
    }
    
    .report-grid {
        grid-template-columns: 1fr;
    }
    
    .actions-grid {
        flex-direction: column;
    }
    
    .action-btn {
        width: 100%;
        justify-content: center;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function generateReport() {
    Swal.fire({
        title: 'สร้างและส่งรายงานประจำเดือน',
        html: `
            <div class="text-left space-y-4">
                <div>
                    <label class="block text-sm font-medium mb-2">ส่งไปยังอีเมล</label>
                    <input type="email" id="report-email" class="w-full p-3 border rounded-lg" placeholder="กรอกอีเมลผู้รับ" value="<?php echo e(auth()->user()->email ?? ''); ?>">
                </div>
                <div>
                    <label class="block text-sm font-medium mb-2">ประเภทรายงาน</label>
                    <select id="report-type" class="w-full p-3 border rounded-lg">
                        <option value="monthly">รายงานประจำเดือน</option>
                        <option value="weekly">รายงานประจำสัปดาห์</option>
                        <option value="daily">รายงานประจำวัน</option>
                    </select>
                </div>
            </div>
        `,
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'สร้างและส่งรายงาน',
        cancelButtonText: 'ยกเลิก',
        customClass: {
            popup: 'swal-popup'
        },
        preConfirm: () => {
            const email = document.getElementById('report-email').value;
            const reportType = document.getElementById('report-type').value;
            
            if (!email) {
                Swal.showValidationMessage('กรุณากรอกอีเมลผู้รับ');
                return false;
            }
            
            return { email, reportType };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const { email, reportType } = result.value;
            
            Swal.fire({
                title: 'กำลังสร้างและส่งรายงาน...',
                html: '<div class="loading-spinner"></div>',
                allowOutsideClick: false,
                showConfirmButton: false,
                customClass: {
                    popup: 'swal-popup'
                }
            });
            
            fetch('<?php echo e(route("admin.reports.generate-monthly")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    email: email,
                    report_type: reportType
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'ส่งรายงานสำเร็จ!',
                        text: data.message,
                        confirmButtonColor: '#FF6B35',
                        customClass: {
                            popup: 'swal-popup'
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'เกิดข้อผิดพลาด!',
                        text: data.message,
                        confirmButtonColor: '#FF6B35',
                        customClass: {
                            popup: 'swal-popup'
                        }
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'เกิดข้อผิดพลาด!',
                    text: 'ไม่สามารถส่งรายงานได้ กรุณาลองใหม่อีกครั้ง',
                    confirmButtonColor: '#FF6B35',
                    customClass: {
                        popup: 'swal-popup'
                    }
                });
            });
        }
    });
}

function scheduleReport() {
    Swal.fire({
        title: 'ตั้งเวลาส่งรายงาน',
        html: `
            <div class="schedule-form">
                <div class="form-group">
                    <label>ประเภทรายงาน</label>
                    <select id="schedule-report-type" class="form-control">
                        <option value="daily">รายงานประจำวัน</option>
                        <option value="weekly">รายงานประจำสัปดาห์</option>
                        <option value="monthly">รายงานประจำเดือน</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>เวลาส่ง</label>
                    <input type="time" id="schedule-time" class="form-control" value="08:00">
                </div>
                <div class="form-group">
                    <label>อีเมลผู้รับ</label>
                    <input type="email" id="schedule-email" class="form-control" placeholder="email@example.com" value="<?php echo e(auth()->user()->email ?? ''); ?>">
                </div>
            </div>
        `,
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'บันทึก',
        cancelButtonText: 'ยกเลิก',
        customClass: {
            popup: 'swal-popup schedule-modal'
        },
        preConfirm: () => {
            const reportType = document.getElementById('schedule-report-type').value;
            const sendTime = document.getElementById('schedule-time').value;
            const email = document.getElementById('schedule-email').value;
            
            if (!email) {
                Swal.showValidationMessage('กรุณากรอกอีเมลผู้รับ');
                return false;
            }
            
            if (!sendTime) {
                Swal.showValidationMessage('กรุณาเลือกเวลาส่ง');
                return false;
            }
            
            return { reportType, sendTime, email };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const { reportType, sendTime, email } = result.value;
            
            fetch('<?php echo e(route("admin.reports.schedule")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    report_type: reportType,
                    send_time: sendTime,
                    email: email
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'ตั้งเวลาสำเร็จ!',
                        text: data.message,
                        confirmButtonColor: '#FF6B35',
                        customClass: {
                            popup: 'swal-popup'
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'เกิดข้อผิดพลาด!',
                        text: data.message,
                        confirmButtonColor: '#FF6B35',
                        customClass: {
                            popup: 'swal-popup'
                        }
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'เกิดข้อผิดพลาด!',
                    text: 'ไม่สามารถตั้งเวลาได้ กรุณาลองใหม่อีกครั้ง',
                    confirmButtonColor: '#FF6B35',
                    customClass: {
                        popup: 'swal-popup'
                    }
                });
            });
        }
    });
}

function customReport() {
    Swal.fire({
        title: 'รายงานแบบกำหนดเอง',
        text: 'ฟีเจอร์นี้จะเปิดให้ใช้งานเร็วๆ นี้',
        icon: 'info',
        confirmButtonColor: '#FF6B35',
        customClass: {
            popup: 'swal-popup'
        }
    });
}
</script>

<style>
/* SweetAlert2 Custom Styles */
.swal-popup {
    border-radius: 16px !important;
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25) !important;
}

.swal-title {
    font-weight: 600 !important;
    color: #1f2937 !important;
}

.swal-content {
    color: #6b7280 !important;
}

.loading-spinner {
    width: 40px;
    height: 40px;
    border: 4px solid #f3f4f6;
    border-top: 4px solid #FF6B35;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin: 20px auto;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.schedule-form {
    text-align: left;
    padding: 1rem 0;
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-group label {
    display: block;
    font-weight: 500;
    color: #374151;
    margin-bottom: 0.5rem;
    font-size: 0.9rem;
}

.form-control {
    width: 100%;
    padding: 0.75rem;
    border: 2px solid #e5e7eb;
    border-radius: 8px;
    font-size: 0.9rem;
    transition: border-color 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #FF6B35;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\crs\resources\views/admin/reports/index.blade.php ENDPATH**/ ?>