<?php $__env->startSection('title', 'สร้างเป้าหมายการออม - ระบบจัดการค่าคอมมิชชั่น'); ?>

<?php $__env->startSection('content'); ?>
<div class="create-container">
    <!-- Header Card -->
    <div class="header-card">
        <div class="header-content">
            <div class="header-info">
                <div class="header-icon">
                    <i class="fas fa-piggy-bank"></i>
                </div>
                <div class="header-text">
                    <h1 class="header-title">สร้างเป้าหมายการออม</h1>
                    <p class="header-subtitle">วางแผนและติดตามเป้าหมายการออมเงินของคุณ</p>
                </div>
            </div>
            <div class="header-actions">
                <a href="<?php echo e(route('finance.goals.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i>
                    <span>กลับ</span>
                </a>
            </div>
        </div>
    </div>

    <form method="POST" action="<?php echo e(route('finance.goals.store')); ?>" class="create-form">
        <?php echo csrf_field(); ?>
        
        <!-- Basic Information Card -->
        <div class="form-card">
            <div class="card-header">
                <div class="card-icon primary">
                    <i class="fas fa-bullseye"></i>
                </div>
                <div class="card-title">ข้อมูลเป้าหมาย</div>
            </div>
            <div class="card-content">
                <div class="form-group">
                    <label class="form-label">ชื่อเป้าหมาย <span class="required">*</span></label>
                    <input type="text" 
                           name="goal_name" 
                           class="form-control <?php $__errorArgs = ['goal_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                           placeholder="เช่น ซื้อรถใหม่, เที่ยวญี่ปุ่น, เงินฉุกเฉิน"
                           value="<?php echo e(old('goal_name')); ?>"
                           required>
                    <?php $__errorArgs = ['goal_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label class="form-label">จำนวนเงินเป้าหมาย <span class="required">*</span></label>
                        <div class="input-wrapper">
                            <span class="input-prefix">฿</span>
                            <input type="number" 
                                   name="target_amount" 
                                   class="form-control amount-input <?php $__errorArgs = ['target_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   placeholder="0"
                                   value="<?php echo e(old('target_amount')); ?>"
                                   step="100"
                                   min="1"
                                   required>
                        </div>
                        <?php $__errorArgs = ['target_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="error-message"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group">
                        <label class="form-label">วันที่เป้าหมาย</label>
                        <input type="date" 
                               name="target_date" 
                               class="form-control <?php $__errorArgs = ['target_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               value="<?php echo e(old('target_date')); ?>"
                               min="<?php echo e(date('Y-m-d', strtotime('+1 day'))); ?>">
                        <?php $__errorArgs = ['target_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="error-message"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">จำนวนเงินเริ่มต้น</label>
                    <div class="input-wrapper">
                        <span class="input-prefix">฿</span>
                        <input type="number" 
                               name="initial_amount" 
                               class="form-control amount-input <?php $__errorArgs = ['initial_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               placeholder="0"
                               value="<?php echo e(old('initial_amount', 0)); ?>"
                               step="100"
                               min="0">
                    </div>
                    <?php $__errorArgs = ['initial_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
        </div>

        <!-- Calculator Card -->
        <div class="form-card calculator-card">
            <div class="card-header">
                <div class="card-icon calculator">
                    <i class="fas fa-calculator"></i>
                </div>
                <div class="card-title">คำนวณแผนการออม</div>
            </div>
            <div class="card-content">
                <div class="calculator-result" id="calculatorResult" style="display: none;">
                    <div class="result-grid">
                        <div class="result-item">
                            <div class="result-icon">
                                <i class="fas fa-coins"></i>
                            </div>
                            <div class="result-content">
                                <div class="result-label">ต้องออมทั้งหมด</div>
                                <div class="result-value" id="totalToSave">฿0</div>
                            </div>
                        </div>

                        <div class="result-item">
                            <div class="result-icon">
                                <i class="fas fa-calendar"></i>
                            </div>
                            <div class="result-content">
                                <div class="result-label">ระยะเวลา</div>
                                <div class="result-value" id="duration">- วัน</div>
                            </div>
                        </div>

                        <div class="result-item highlight">
                            <div class="result-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="result-content">
                                <div class="result-label">ควรออมต่อเดือน</div>
                                <div class="result-value" id="monthlySaving">฿0</div>
                            </div>
                        </div>

                        <div class="result-item">
                            <div class="result-icon">
                                <i class="fas fa-calendar-day"></i>
                            </div>
                            <div class="result-content">
                                <div class="result-label">ควรออมต่อวัน</div>
                                <div class="result-value" id="dailySaving">฿0</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="calculator-hint" id="calculatorHint">
                    <i class="fas fa-info-circle"></i>
                    <span>กรอกจำนวนเงินเป้าหมายและวันที่เพื่อคำนวณแผนการออม</span>
                </div>
            </div>
        </div>

        <!-- Goal Ideas Card -->
        <div class="form-card ideas-card">
            <div class="card-header">
                <div class="card-icon ideas">
                    <i class="fas fa-lightbulb"></i>
                </div>
                <div class="card-title">ไอเดียเป้าหมายการออม</div>
            </div>
            <div class="card-content">
                <div class="ideas-grid">
                    <button type="button" class="idea-item" onclick="setGoalIdea('เงินฉุกเฉิน 6 เดือน', 180000)">
                        <div class="idea-icon">🏥</div>
                        <div class="idea-text">
                            <div class="idea-name">เงินฉุกเฉิน 6 เดือน</div>
                            <div class="idea-amount">฿180,000</div>
                        </div>
                    </button>

                    <button type="button" class="idea-item" onclick="setGoalIdea('ดาวน์บ้าน', 300000)">
                        <div class="idea-icon">🏠</div>
                        <div class="idea-text">
                            <div class="idea-name">ดาวน์บ้าน</div>
                            <div class="idea-amount">฿300,000</div>
                        </div>
                    </button>

                    <button type="button" class="idea-item" onclick="setGoalIdea('ซื้อรถใหม่', 200000)">
                        <div class="idea-icon">🚗</div>
                        <div class="idea-text">
                            <div class="idea-name">ซื้อรถใหม่</div>
                            <div class="idea-amount">฿200,000</div>
                        </div>
                    </button>

                    <button type="button" class="idea-item" onclick="setGoalIdea('เที่ยวต่างประเทศ', 50000)">
                        <div class="idea-icon">✈️</div>
                        <div class="idea-text">
                            <div class="idea-name">เที่ยวต่างประเทศ</div>
                            <div class="idea-amount">฿50,000</div>
                        </div>
                    </button>

                    <button type="button" class="idea-item" onclick="setGoalIdea('แต่งงาน', 500000)">
                        <div class="idea-icon">💒</div>
                        <div class="idea-text">
                            <div class="idea-name">แต่งงาน</div>
                            <div class="idea-amount">฿500,000</div>
                        </div>
                    </button>

                    <button type="button" class="idea-item" onclick="setGoalIdea('เรียนต่อ', 100000)">
                        <div class="idea-icon">🎓</div>
                        <div class="idea-text">
                            <div class="idea-name">เรียนต่อ</div>
                            <div class="idea-amount">฿100,000</div>
                        </div>
                    </button>
                </div>
            </div>
        </div>

        <!-- Form Actions -->
        <div class="form-actions">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i>
                <span>สร้างเป้าหมาย</span>
            </button>
            <a href="<?php echo e(route('finance.goals.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-times"></i>
                <span>ยกเลิก</span>
            </a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Container */
.create-container {
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 50%, #cbd5e1 100%);
    padding: 2rem;
    padding-bottom: 4rem;
}

/* Header Card */
.header-card {
    background: linear-gradient(135deg, #FF6B35 0%, #DC2626 100%);
    border-radius: 24px;
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: 0 25px 50px -12px rgba(255, 107, 53, 0.3);
    position: relative;
    overflow: hidden;
}

.header-card::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -20%;
    width: 300px;
    height: 300px;
    background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
    border-radius: 50%;
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    position: relative;
    z-index: 2;
}

.header-info {
    display: flex;
    align-items: center;
    gap: 1.5rem;
}

.header-icon {
    width: 80px;
    height: 80px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
    color: white;
    backdrop-filter: blur(10px);
    border: 2px solid rgba(255, 255, 255, 0.3);
}

.header-title {
    font-size: 1.75rem;
    font-weight: 700;
    color: white;
    margin: 0 0 0.5rem 0;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.header-subtitle {
    color: rgba(255, 255, 255, 0.9);
    font-size: 1rem;
    margin: 0;
}

/* Form */
.create-form {
    max-width: 800px;
    margin: 0 auto;
    display: flex;
    flex-direction: column;
    gap: 2rem;
}

/* Form Cards */
.form-card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    box-shadow: 0 20px 40px -12px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    overflow: hidden;
    transition: all 0.3s ease;
}

.form-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.15);
}

.calculator-card {
    border: 2px solid rgba(16, 185, 129, 0.2);
}

.ideas-card {
    border: 2px solid rgba(245, 158, 11, 0.2);
}

.card-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1.5rem 2rem;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-bottom: 1px solid #e5e7eb;
}

.card-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.1rem;
}

.card-icon.primary {
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
}

.card-icon.calculator {
    background: linear-gradient(135deg, #10B981 0%, #059669 100%);
}

.card-icon.ideas {
    background: linear-gradient(135deg, #F59E0B 0%, #D97706 100%);
}

.card-title {
    font-size: 1.1rem;
    font-weight: 600;
    color: #1f2937;
}

.card-content {
    padding: 2rem;
}

/* Form Elements */
.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1.5rem;
    margin-bottom: 1.5rem;
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
    margin-bottom: 1.5rem;
}

.form-label {
    font-weight: 500;
    color: #374151;
    font-size: 0.875rem;
}

.required {
    color: #EF4444;
}

.input-wrapper {
    position: relative;
}

.input-prefix {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #6B7280;
    font-weight: 600;
    z-index: 1;
}

.form-control {
    padding: 0.75rem 1rem;
    border: 2px solid #e5e7eb;
    border-radius: 8px;
    font-size: 0.875rem;
    transition: all 0.3s ease;
    background: white;
    width: 100%;
}

.input-wrapper .form-control {
    padding-left: 2.5rem;
}

.amount-input {
    text-align: right;
    font-weight: 600;
}

.form-control:focus {
    outline: none;
    border-color: #FF6B35;
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
}

.form-control.error {
    border-color: #EF4444;
}

.error-message {
    color: #EF4444;
    font-size: 0.75rem;
    margin-top: 0.25rem;
}

/* Calculator Results */
.calculator-result {
    margin-bottom: 1rem;
}

.result-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1rem;
}

.result-item {
    background: white;
    border-radius: 12px;
    padding: 1rem;
    border: 1px solid #e5e7eb;
    display: flex;
    align-items: center;
    gap: 0.75rem;
    transition: all 0.3s ease;
}

.result-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.result-item.highlight {
    grid-column: 1 / -1;
    background: linear-gradient(135deg, #EFF6FF 0%, #DBEAFE 100%);
    border-color: #3B82F6;
}

.result-icon {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #10B981 0%, #059669 100%);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1rem;
}

.result-item.highlight .result-icon {
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
}

.result-label {
    font-size: 0.75rem;
    color: #6B7280;
    font-weight: 500;
    margin-bottom: 0.25rem;
}

.result-value {
    font-size: 1rem;
    font-weight: 700;
    color: #1F2937;
}

.result-item.highlight .result-value {
    color: #3B82F6;
    font-size: 1.25rem;
}

.calculator-hint {
    text-align: center;
    color: #6B7280;
    font-size: 0.875rem;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    padding: 1rem;
    background: #F8FAFC;
    border-radius: 8px;
}

/* Ideas Grid */
.ideas-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
}

.idea-item {
    background: white;
    border: 2px solid #FEF3C7;
    border-radius: 12px;
    padding: 1rem;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.idea-item:hover {
    background: #FEF3C7;
    border-color: #F59E0B;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(245, 158, 11, 0.2);
}

.idea-icon {
    font-size: 1.5rem;
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #FEF3C7;
    border-radius: 10px;
}

.idea-name {
    font-size: 0.875rem;
    font-weight: 600;
    color: #1F2937;
    margin-bottom: 0.25rem;
}

.idea-amount {
    font-size: 0.75rem;
    color: #F59E0B;
    font-weight: 600;
}

/* Form Actions */
.form-actions {
    display: flex;
    gap: 1rem;
    justify-content: center;
    padding: 2rem;
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    box-shadow: 0 20px 40px -12px rgba(0, 0, 0, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

/* Buttons */
.btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    font-weight: 500;
    border: none;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
    font-size: 0.875rem;
}

.btn-primary {
    background: linear-gradient(135deg, #FF6B35 0%, #DC2626 100%);
    color: white;
    box-shadow: 0 10px 25px rgba(255, 107, 53, 0.3);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 15px 35px rgba(255, 107, 53, 0.4);
}

.btn-secondary {
    background: #F3F4F6;
    color: #6B7280;
}

.btn-secondary:hover {
    background: #E5E7EB;
    color: #374151;
}

/* Responsive */
@media (max-width: 768px) {
    .create-container {
        padding: 1rem;
        padding-bottom: 4rem;
    }
    
    .header-content {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
    }
    
    .card-content {
        padding: 1.5rem;
    }
    
    .form-row {
        grid-template-columns: 1fr;
    }
    
    .result-grid {
        grid-template-columns: 1fr;
    }
    
    .ideas-grid {
        grid-template-columns: 1fr;
    }
    
    .form-actions {
        flex-direction: column;
    }
    
    .header-icon {
        width: 60px;
        height: 60px;
        font-size: 1.5rem;
    }
    
    .header-title {
        font-size: 1.5rem;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Calculate savings plan
function calculateSavings() {
    const targetAmount = parseFloat(document.querySelector('[name="target_amount"]').value) || 0;
    const initialAmount = parseFloat(document.querySelector('[name="initial_amount"]').value) || 0;
    const targetDate = document.querySelector('[name="target_date"]').value;
    
    if (targetAmount > 0 && targetDate) {
        const totalToSave = targetAmount - initialAmount;
        const today = new Date();
        const target = new Date(targetDate);
        const days = Math.ceil((target - today) / (1000 * 60 * 60 * 24));
        const months = Math.ceil(days / 30);
        
        if (days > 0 && totalToSave > 0) {
            const monthlySaving = totalToSave / months;
            const dailySaving = totalToSave / days;
            
            document.getElementById('totalToSave').textContent = '฿' + totalToSave.toLocaleString('th-TH', {minimumFractionDigits: 0});
            document.getElementById('duration').textContent = days + ' วัน (' + months + ' เดือน)';
            document.getElementById('monthlySaving').textContent = '฿' + monthlySaving.toLocaleString('th-TH', {minimumFractionDigits: 0});
            document.getElementById('dailySaving').textContent = '฿' + dailySaving.toLocaleString('th-TH', {minimumFractionDigits: 0});
            
            document.getElementById('calculatorResult').style.display = 'block';
            document.getElementById('calculatorHint').style.display = 'none';
        } else {
            document.getElementById('calculatorResult').style.display = 'none';
            document.getElementById('calculatorHint').style.display = 'flex';
        }
    } else {
        document.getElementById('calculatorResult').style.display = 'none';
        document.getElementById('calculatorHint').style.display = 'flex';
    }
}

// Set goal idea
function setGoalIdea(name, amount) {
    document.querySelector('[name="goal_name"]').value = name;
    document.querySelector('[name="target_amount"]').value = amount;
    
    // Add visual feedback
    Swal.fire({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 2000,
        timerProgressBar: true,
        icon: 'success',
        title: `ตั้งเป้าหมาย: ${name}`
    });
    
    calculateSavings();
}

// Event listeners
document.querySelector('[name="target_amount"]').addEventListener('input', calculateSavings);
document.querySelector('[name="initial_amount"]').addEventListener('input', calculateSavings);
document.querySelector('[name="target_date"]').addEventListener('change', calculateSavings);

// Form submission
document.querySelector('.create-form').addEventListener('submit', function(e) {
    e.preventDefault();
    
    Swal.fire({
        title: 'ยืนยันการสร้างเป้าหมาย',
        text: 'คุณต้องการสร้างเป้าหมายการออมนี้ใช่หรือไม่?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'สร้างเป้าหมาย',
        cancelButtonText: 'ยกเลิก'
    }).then((result) => {
        if (result.isConfirmed) {
            this.submit();
        }
    });
});

// Initial calculation
calculateSavings();

// Show success/error messages
<?php if(session('success')): ?>
    Swal.fire({
        icon: 'success',
        title: 'สำเร็จ!',
        text: '<?php echo e(session('success')); ?>',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>

<?php if(session('error')): ?>
    Swal.fire({
        icon: 'error',
        title: 'เกิดข้อผิดพลาด!',
        text: '<?php echo e(session('error')); ?>',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/finance/goals/create.blade.php ENDPATH**/ ?>