<?php $__env->startSection('title', 'แก้ไขผู้ใช้งาน - EazyCom Plus'); ?>
<?php $__env->startSection('page-title', 'แก้ไขผู้ใช้งาน'); ?>
<?php $__env->startSection('mobile-title', 'แก้ไขผู้ใช้'); ?>

<?php $__env->startSection('content'); ?>
<div class="edit-user-page">
    <!-- Header Section -->
    <div class="page-header">
        <div class="header-content">
            <div class="header-info">
                <div class="header-title">
                    <div class="title-icon">
                        <i class="fas fa-user-edit"></i>
                    </div>
                    <div class="title-text">
                        <h1>แก้ไขผู้ใช้งาน</h1>
                        <p>แก้ไขข้อมูล: <?php echo e($user->name ?? 'ไม่ระบุชื่อ'); ?></p>
                    </div>
                </div>
                <div class="header-actions">
                    <a href="<?php echo e(route('admin.users.index')); ?>" class="action-btn secondary-btn">
                        <i class="fas fa-arrow-left"></i>
                        <span>กลับ</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- User Info Summary -->
    <div class="user-summary">
        <div class="summary-content">
            <div class="user-avatar-large">
                <?php echo e(strtoupper(substr($user->name ?? 'U', 0, 2))); ?>

            </div>
            <div class="user-details">
                <div class="user-name"><?php echo e($user->name ?? 'ไม่ระบุชื่อ'); ?></div>
                <div class="user-email"><?php echo e($user->email ?? 'ไม่ระบุอีเมล'); ?></div>
                <div class="user-meta">
                    <div class="meta-item">
                        <i class="fas fa-calendar-alt"></i>
                        <span>สร้างเมื่อ: <?php echo e($user->created_at ? $user->created_at->format('d/m/Y') : '-'); ?></span>
                    </div>
                    <div class="meta-item">
                        <i class="fas fa-clock"></i>
                        <span>อัปเดต: <?php echo e($user->updated_at ? $user->updated_at->diffForHumans() : '-'); ?></span>
                    </div>
                </div>
            </div>
            <div class="user-status">
                <div class="status-badge status-<?php echo e(($user->is_active ?? false) ? 'active' : 'inactive'); ?>">
                    <?php if($user->is_active ?? false): ?>
                        <i class="fas fa-check-circle"></i>
                        <span>ใช้งานอยู่</span>
                    <?php else: ?>
                        <i class="fas fa-times-circle"></i>
                        <span>ปิดใช้งาน</span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Form Container -->
    <div class="form-container">
        <form method="POST" action="<?php echo e(route('admin.users.update', $user)); ?>" id="editUserForm" class="user-form">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            
            <!-- Personal Information Card -->
            <div class="form-card">
                <div class="card-header">
                    <div class="card-title">
                        <i class="fas fa-user"></i>
                        <span>ข้อมูลส่วนตัว</span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="form-grid">
                        <div class="form-group">
                            <label for="first_name" class="form-label required">ชื่อ</label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="fas fa-user"></i>
                                </div>
                                <input type="text" id="first_name" name="first_name" 
                                       value="<?php echo e(old('first_name', $user->first_name ?? '')); ?>" 
                                       class="form-input <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       placeholder="กรอกชื่อ" required>
                            </div>
                            <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="error-message"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group">
                            <label for="last_name" class="form-label required">นามสกุล</label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="fas fa-user"></i>
                                </div>
                                <input type="text" id="last_name" name="last_name" 
                                       value="<?php echo e(old('last_name', $user->last_name ?? '')); ?>" 
                                       class="form-input <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       placeholder="กรอกนามสกุล" required>
                            </div>
                            <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="error-message"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group full-width">
                            <label for="email" class="form-label required">อีเมล</label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <input type="email" id="email" name="email" 
                                       value="<?php echo e(old('email', $user->email ?? '')); ?>" 
                                       class="form-input <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       placeholder="example@email.com" required>
                            </div>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="error-message"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Security Information Card -->
            <div class="form-card">
                <div class="card-header">
                    <div class="card-title">
                        <i class="fas fa-shield-alt"></i>
                        <span>เปลี่ยนรหัสผ่าน</span>
                    </div>
                    <div class="card-subtitle">เว้นว่างไว้หากไม่ต้องการเปลี่ยนรหัสผ่าน</div>
                </div>
                <div class="card-body">
                    <div class="form-grid">
                        <div class="form-group">
                            <label for="password" class="form-label">รหัสผ่านใหม่</label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="fas fa-lock"></i>
                                </div>
                                <input type="password" id="password" name="password" 
                                       class="form-input <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       placeholder="อย่างน้อย 8 ตัวอักษร">
                                <button type="button" class="password-toggle" onclick="togglePassword('password')">
                                    <i class="fas fa-eye" id="password-icon"></i>
                                </button>
                            </div>
                            <div class="password-strength" id="password-strength"></div>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="error-message"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="form-hint">เว้นว่างไว้หากไม่ต้องการเปลี่ยน</div>
                        </div>

                        <div class="form-group">
                            <label for="password_confirmation" class="form-label">ยืนยันรหัสผ่านใหม่</label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="fas fa-lock"></i>
                                </div>
                                <input type="password" id="password_confirmation" name="password_confirmation" 
                                       class="form-input" 
                                       placeholder="ยืนยันรหัสผ่าน">
                                <button type="button" class="password-toggle" onclick="togglePassword('password_confirmation')">
                                    <i class="fas fa-eye" id="password_confirmation-icon"></i>
                                </button>
                            </div>
                            <div class="password-match" id="password-match"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Role & Warehouse Card -->
            <div class="form-card">
                <div class="card-header">
                    <div class="card-title">
                        <i class="fas fa-user-tag"></i>
                        <span>บทบาทและคลังสินค้า</span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="form-grid">
                        <div class="form-group">
                            <label for="role" class="form-label required">บทบาท</label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="fas fa-user-tag"></i>
                                </div>
                                <select id="role" name="role" class="form-select <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        required <?php echo e($user->id === auth()->id() ? 'disabled' : ''); ?>>
                                    <option value="">เลือกบทบาท</option>
                                    <option value="admin" <?php echo e(old('role', $user->role ?? '') === 'admin' ? 'selected' : ''); ?>>
                                        👑 ผู้ดูแลระบบ
                                    </option>
                                    <option value="2wheel" <?php echo e(old('role', $user->role ?? '') === '2wheel' ? 'selected' : ''); ?>>
                                        🏍️ รถ 2 ล้อ
                                    </option>
                                    <option value="4wheel" <?php echo e(old('role', $user->role ?? '') === '4wheel' ? 'selected' : ''); ?>>
                                        🚚 รถ 4 ล้อ
                                    </option>
                                </select>
                            </div>
                            <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="error-message"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <?php if($user->id === auth()->id()): ?>
                                <div class="form-warning">
                                    <i class="fas fa-exclamation-triangle"></i>
                                    คุณไม่สามารถเปลี่ยนบทบาทของตัวเองได้
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="form-group" id="warehouse-group" style="display: none;">
                            <label for="warehouse_code" class="form-label required">คลังสินค้า</label>
                            <div class="input-wrapper">
                                <div class="input-icon">
                                    <i class="fas fa-warehouse"></i>
                                </div>
                                <select id="warehouse_code" name="warehouse_code" class="form-select <?php $__errorArgs = ['warehouse_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value="">เลือกคลังสินค้า</option>
                                    <?php $__currentLoopData = $warehouses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($warehouse->code); ?>" 
                                                <?php echo e(old('warehouse_code', $user->warehouse_code ?? '') === $warehouse->code ? 'selected' : ''); ?>>
                                            <?php echo e($warehouse->code); ?> - <?php echo e($warehouse->name); ?>

                                            <?php if($warehouse->location): ?>
                                                (<?php echo e($warehouse->location); ?>)
                                            <?php endif; ?>
                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <?php $__errorArgs = ['warehouse_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="error-message"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="form-hint">จำเป็นสำหรับผู้ใช้ประเภทรถ</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Status Card -->
            <div class="form-card">
                <div class="card-header">
                    <div class="card-title">
                        <i class="fas fa-toggle-on"></i>
                        <span>สถานะการใช้งาน</span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="status-options">
                        <label class="status-option <?php echo e(($user->is_active ?? true) ? 'active' : ''); ?>">
                            <input type="radio" name="is_active" value="1" 
                                   <?php echo e(old('is_active', $user->is_active ?? true) ? 'checked' : ''); ?>

                                   <?php echo e($user->id === auth()->id() ? 'disabled' : ''); ?>>
                            <div class="option-content">
                                <div class="option-icon active">
                                    <i class="fas fa-user-check"></i>
                                </div>
                                <div class="option-text">
                                    <div class="option-title">ใช้งานอยู่</div>
                                    <div class="option-desc">ผู้ใช้สามารถเข้าสู่ระบบได้</div>
                                </div>
                            </div>
                        </label>
                        
                        <label class="status-option <?php echo e(!($user->is_active ?? true) ? 'active' : ''); ?>">
                            <input type="radio" name="is_active" value="0" 
                                   <?php echo e(!old('is_active', $user->is_active ?? true) ? 'checked' : ''); ?>

                                   <?php echo e($user->id === auth()->id() ? 'disabled' : ''); ?>>
                            <div class="option-content">
                                <div class="option-icon inactive">
                                    <i class="fas fa-user-slash"></i>
                                </div>
                                <div class="option-text">
                                    <div class="option-title">ปิดใช้งาน</div>
                                    <div class="option-desc">ผู้ใช้ไม่สามารถเข้าสู่ระบบได้</div>
                                </div>
                            </div>
                        </label>
                    </div>
                    <?php if($user->id === auth()->id()): ?>
                        <div class="form-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            คุณไม่สามารถปิดการใช้งานตัวเองได้
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="form-actions">
                <div class="action-group left">
                    <?php if($user->id !== auth()->id()): ?>
                        <button type="button" onclick="resetPassword()" class="btn btn-warning">
                            <i class="fas fa-key"></i>
                            <span>รีเซ็ตรหัสผ่าน</span>
                        </button>
                        <button type="button" onclick="deleteUser()" class="btn btn-danger">
                            <i class="fas fa-trash"></i>
                            <span>ลบผู้ใช้</span>
                        </button>
                    <?php endif; ?>
                </div>
                <div class="action-group right">
                    <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-times"></i>
                        <span>ยกเลิก</span>
                    </a>
                    <button type="submit" class="btn btn-primary" id="submit-btn">
                        <i class="fas fa-save"></i>
                        <span>บันทึกการเปลี่ยนแปลง</span>
                        <div class="btn-loader" style="display: none;">
                            <i class="fas fa-spinner fa-spin"></i>
                        </div>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<style>
/* Edit User Page Styles */
.edit-user-page {
    min-height: 100vh;
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
}

/* Page Header */
.page-header {
    background: white;
    border-bottom: 1px solid #e2e8f0;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    margin-bottom: 2rem;
}

.header-content {
    max-width: 1200px;
    margin: 0 auto;
    padding: 2rem;
}

.header-info {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 2rem;
}

.header-title {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.title-icon {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 24px;
    box-shadow: 0 4px 12px rgba(255, 107, 53, 0.3);
}

.title-text h1 {
    font-size: 2rem;
    font-weight: 600;
    color: #1e293b;
    margin: 0;
}

.title-text p {
    color: #64748b;
    margin: 0.5rem 0 0;
    font-size: 1rem;
}

.header-actions {
    display: flex;
    gap: 1rem;
}

.action-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    text-decoration: none;
    font-weight: 500;
    transition: all 0.3s ease;
    border: none;
    cursor: pointer;
}

.secondary-btn {
    background: #f1f5f9;
    color: #475569;
    border: 1px solid #e2e8f0;
}

.secondary-btn:hover {
    background: #e2e8f0;
    transform: translateY(-1px);
}

/* User Summary */
.user-summary {
    max-width: 1200px;
    margin: 0 auto 2rem;
    padding: 0 2rem;
}

.summary-content {
    background: white;
    border-radius: 16px;
    padding: 2rem;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
    border: 1px solid #e2e8f0;
    display: flex;
    align-items: center;
    gap: 2rem;
}

.user-avatar-large {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 2rem;
    font-weight: 600;
    box-shadow: 0 8px 25px rgba(255, 107, 53, 0.3);
    flex-shrink: 0;
}

.user-details {
    flex: 1;
}

.user-name {
    font-size: 1.5rem;
    font-weight: 600;
    color: #1e293b;
    margin-bottom: 0.25rem;
}

.user-email {
    color: #64748b;
    font-size: 1rem;
    margin-bottom: 1rem;
}

.user-meta {
    display: flex;
    gap: 2rem;
}

.meta-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: #64748b;
    font-size: 0.9rem;
}

.meta-item i {
    color: #FF6B35;
}

.user-status {
    flex-shrink: 0;
}

.status-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1rem;
    border-radius: 12px;
    font-weight: 500;
    font-size: 0.9rem;
}

.status-badge.status-active {
    background: linear-gradient(135deg, rgba(34, 197, 94, 0.1) 0%, rgba(22, 163, 74, 0.1) 100%);
    color: #16a34a;
    border: 1px solid rgba(34, 197, 94, 0.2);
}

.status-badge.status-inactive {
    background: linear-gradient(135deg, rgba(239, 68, 68, 0.1) 0%, rgba(220, 38, 38, 0.1) 100%);
    color: #dc2626;
    border: 1px solid rgba(239, 68, 68, 0.2);
}

/* Form Container */
.form-container {
    max-width: 800px;
    margin: 0 auto;
    padding: 0 2rem 2rem;
}

.user-form {
    display: flex;
    flex-direction: column;
    gap: 2rem;
}

/* Form Cards */
.form-card {
    background: white;
    border-radius: 16px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
    border: 1px solid #e2e8f0;
    overflow: hidden;
    transition: all 0.3s ease;
}

.form-card:hover {
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.card-header {
    background: linear-gradient(135deg, rgba(255, 107, 53, 0.05) 0%, rgba(255, 140, 97, 0.05) 100%);
    padding: 1.5rem 2rem;
    border-bottom: 1px solid #e2e8f0;
}

.card-title {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    font-size: 1.125rem;
    font-weight: 600;
    color: #1e293b;
}

.card-title i {
    color: #FF6B35;
    font-size: 1.25rem;
}

.card-subtitle {
    color: #64748b;
    font-size: 0.9rem;
    margin-top: 0.5rem;
}

.card-body {
    padding: 2rem;
}

/* Form Grid */
.form-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1.5rem;
}

.form-group.full-width {
    grid-column: 1 / -1;
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.form-label {
    font-weight: 500;
    color: #374151;
    font-size: 0.95rem;
}

.form-label.required::after {
    content: '*';
    color: #ef4444;
    margin-left: 0.25rem;
}

/* Input Wrapper */
.input-wrapper {
    position: relative;
    display: flex;
    align-items: center;
}

.input-icon {
    position: absolute;
    left: 1rem;
    color: #9ca3af;
    font-size: 0.9rem;
    z-index: 10;
}

.form-input,
.form-select {
    width: 100%;
    padding: 0.875rem 1rem 0.875rem 2.75rem;
    border: 2px solid #e5e7eb;
    border-radius: 12px;
    font-size: 0.95rem;
    transition: all 0.3s ease;
    background: white;
    font-family: inherit;
}

.form-input:focus,
.form-select:focus {
    outline: none;
    border-color: #FF6B35;
    box-shadow: 0 0 0 3px rgba(255, 107, 53, 0.1);
}

.form-input.error,
.form-select.error {
    border-color: #ef4444;
    box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.1);
}

.form-input:disabled,
.form-select:disabled {
    background: #f9fafb;
    color: #9ca3af;
    cursor: not-allowed;
}

/* Password Toggle */
.password-toggle {
    position: absolute;
    right: 1rem;
    background: none;
    border: none;
    color: #9ca3af;
    cursor: pointer;
    font-size: 0.9rem;
    z-index: 10;
    transition: color 0.3s ease;
}

.password-toggle:hover {
    color: #FF6B35;
}

/* Password Strength */
.password-strength {
    height: 4px;
    border-radius: 2px;
    margin-top: 0.5rem;
    transition: all 0.3s ease;
}

.password-strength.weak {
    background: #ef4444;
    width: 33%;
}

.password-strength.medium {
    background: #f59e0b;
    width: 66%;
}

.password-strength.strong {
    background: #22c55e;
    width: 100%;
}

/* Password Match */
.password-match {
    margin-top: 0.5rem;
    font-size: 0.85rem;
    font-weight: 500;
}

.password-match.match {
    color: #22c55e;
}

.password-match.no-match {
    color: #ef4444;
}

/* Status Options */
.status-options {
    display: flex;
    gap: 1rem;
}

.status-option {
    flex: 1;
    cursor: pointer;
    border: 2px solid #e5e7eb;
    border-radius: 12px;
    padding: 1.5rem;
    transition: all 0.3s ease;
    background: white;
}

.status-option:hover {
    border-color: #FF6B35;
    background: rgba(255, 107, 53, 0.02);
}

.status-option input[type="radio"] {
    display: none;
}

.status-option input[type="radio"]:checked + .option-content {
    color: #FF6B35;
}

.status-option.active {
    border-color: #FF6B35;
    background: rgba(255, 107, 53, 0.05);
}

.option-content {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.option-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.25rem;
    color: white;
}

.option-icon.active {
    background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%);
}

.option-icon.inactive {
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
}

.option-text {
    flex: 1;
}

.option-title {
    font-weight: 600;
    color: #1e293b;
    margin-bottom: 0.25rem;
}

.option-desc {
    font-size: 0.85rem;
    color: #64748b;
}

/* Error Messages */
.error-message {
    color: #ef4444;
    font-size: 0.85rem;
    margin-top: 0.25rem;
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.error-message::before {
    content: '⚠️';
    font-size: 0.8rem;
}

/* Form Hints */
.form-hint {
    color: #64748b;
    font-size: 0.85rem;
    margin-top: 0.25rem;
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.form-hint::before {
    content: 'ℹ️';
    font-size: 0.8rem;
}

/* Form Warning */
.form-warning {
    color: #f59e0b;
    font-size: 0.85rem;
    margin-top: 0.25rem;
    display: flex;
    align-items: center;
    gap: 0.25rem;
    background: rgba(245, 158, 11, 0.1);
    padding: 0.5rem;
    border-radius: 8px;
    border: 1px solid rgba(245, 158, 11, 0.2);
}

/* Form Actions */
.form-actions {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 2rem;
    background: white;
    border-radius: 16px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
    border: 1px solid #e2e8f0;
}

.action-group {
    display: flex;
    gap: 1rem;
}

.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    padding: 0.875rem 1.5rem;
    border: none;
    border-radius: 12px;
    font-family: inherit;
    font-weight: 500;
    font-size: 0.95rem;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
    position: relative;
    overflow: hidden;
}

.btn-primary {
    background: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
    color: white;
    box-shadow: 0 4px 12px rgba(255, 107, 53, 0.3);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255, 107, 53, 0.4);
}

.btn-primary:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
}

.btn-secondary {
    background: #f1f5f9;
    color: #475569;
    border: 1px solid #e2e8f0;
}

.btn-secondary:hover {
    background: #e2e8f0;
    transform: translateY(-1px);
}

.btn-warning {
    background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
    color: white;
    box-shadow: 0 4px 12px rgba(245, 158, 11, 0.3);
}

.btn-warning:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(245, 158, 11, 0.4);
}

.btn-danger {
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    color: white;
    box-shadow: 0 4px 12px rgba(239, 68, 68, 0.3);
}

.btn-danger:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(239, 68, 68, 0.4);
}

.btn-loader {
    position: absolute;
    inset: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    background: inherit;
}

/* Responsive Design */
@media (max-width: 768px) {
    .header-content {
        padding: 1.5rem 1rem;
    }
    
    .header-info {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }
    
    .summary-content {
        flex-direction: column;
        text-align: center;
        gap: 1rem;
    }
    
    .user-meta {
        justify-content: center;
        flex-wrap: wrap;
        gap: 1rem;
    }
    
    .form-container {
        padding: 0 1rem 2rem;
    }
    
    .form-grid {
        grid-template-columns: 1fr;
    }
    
    .card-body {
        padding: 1.5rem;
    }
    
    .status-options {
        flex-direction: column;
    }
    
    .form-actions {
        flex-direction: column;
        gap: 1rem;
        padding: 1.5rem;
    }
    
    .action-group {
        width: 100%;
        justify-content: center;
    }
    
    .action-group.left {
        order: 2;
    }
    
    .action-group.right {
        order: 1;
    }
    
    .btn {
        flex: 1;
        justify-content: center;
    }
    
    .title-text h1 {
        font-size: 1.5rem;
    }
}

/* Animation */
@keyframes fadeIn {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.user-summary,
.form-card {
    animation: fadeIn 0.5s ease-out;
}

.user-summary { animation-delay: 0.1s; }
.form-card:nth-child(1) { animation-delay: 0.2s; }
.form-card:nth-child(2) { animation-delay: 0.3s; }
.form-card:nth-child(3) { animation-delay: 0.4s; }
.form-card:nth-child(4) { animation-delay: 0.5s; }
</style>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('editUserForm');
    const roleSelect = document.getElementById('role');
    const warehouseGroup = document.getElementById('warehouse-group');
    const warehouseSelect = document.getElementById('warehouse_code');
    const passwordField = document.getElementById('password');
    const confirmPasswordField = document.getElementById('password_confirmation');
    const submitBtn = document.getElementById('submit-btn');

    // Role-based warehouse visibility
    function toggleWarehouseVisibility() {
        const role = roleSelect.value;
        
        if (role === '2wheel' || role === '4wheel') {
            warehouseGroup.style.display = 'block';
            warehouseSelect.required = true;
            
            // Add animation
            warehouseGroup.style.opacity = '0';
            warehouseGroup.style.transform = 'translateY(-10px)';
            
            setTimeout(() => {
                warehouseGroup.style.transition = 'all 0.3s ease';
                warehouseGroup.style.opacity = '1';
                warehouseGroup.style.transform = 'translateY(0)';
            }, 50);
        } else {
            warehouseGroup.style.display = 'none';
            warehouseSelect.required = false;
            warehouseSelect.value = '';
        }
    }

    roleSelect.addEventListener('change', toggleWarehouseVisibility);
    
    // Initialize on page load
    if (roleSelect.value) {
        toggleWarehouseVisibility();
    }

    // Password strength indicator
    function checkPasswordStrength(password) {
        const strengthIndicator = document.getElementById('password-strength');
        if (!password) {
            strengthIndicator.className = 'password-strength';
            return;
        }
        
        let strength = 0;
        
        if (password.length >= 8) strength++;
        if (/[a-z]/.test(password)) strength++;
        if (/[A-Z]/.test(password)) strength++;
        if (/[0-9]/.test(password)) strength++;
        if (/[^A-Za-z0-9]/.test(password)) strength++;
        
        strengthIndicator.className = 'password-strength';
        
        if (strength < 2) {
            strengthIndicator.classList.add('weak');
        } else if (strength < 4) {
            strengthIndicator.classList.add('medium');
        } else {
            strengthIndicator.classList.add('strong');
        }
    }

    passwordField.addEventListener('input', function() {
        checkPasswordStrength(this.value);
        checkPasswordMatch();
    });

    // Password match indicator
    function checkPasswordMatch() {
        const matchIndicator = document.getElementById('password-match');
        const password = passwordField.value;
        const confirmPassword = confirmPasswordField.value;
        
        if (!password || confirmPassword === '') {
            matchIndicator.textContent = '';
            matchIndicator.className = 'password-match';
            return;
        }
        
        if (password === confirmPassword) {
            matchIndicator.textContent = '✓ รหัสผ่านตรงกัน';
            matchIndicator.className = 'password-match match';
            confirmPasswordField.classList.remove('error');
        } else {
            matchIndicator.textContent = '✗ รหัสผ่านไม่ตรงกัน';
            matchIndicator.className = 'password-match no-match';
            confirmPasswordField.classList.add('error');
        }
    }

    confirmPasswordField.addEventListener('input', checkPasswordMatch);

    // Form submission with loading state
    form.addEventListener('submit', function(e) {
        const password = passwordField.value;
        const confirmPassword = confirmPasswordField.value;
        
        // Validation only if password is provided
        if (password) {
            if (password !== confirmPassword) {
                e.preventDefault();
                Swal.fire({
                    icon: 'error',
                    title: 'ข้อผิดพลาด',
                    text: 'รหัสผ่านและการยืนยันรหัสผ่านไม่ตรงกัน',
                    confirmButtonColor: '#FF6B35'
                });
                return false;
            }
            
            if (password.length < 8) {
                e.preventDefault();
                Swal.fire({
                    icon: 'error',
                    title: 'ข้อผิดพลาด',
                    text: 'รหัสผ่านต้องมีอย่างน้อย 8 ตัวอักษร',
                    confirmButtonColor: '#FF6B35'
                });
                return false;
            }
        }

        // Show loading state
        submitBtn.disabled = true;
        submitBtn.querySelector('span').style.display = 'none';
        submitBtn.querySelector('.btn-loader').style.display = 'flex';
        
        // Re-enable after 10 seconds as fallback
        setTimeout(() => {
            submitBtn.disabled = false;
            submitBtn.querySelector('span').style.display = 'inline';
            submitBtn.querySelector('.btn-loader').style.display = 'none';
        }, 10000);
    });

    // Status option styling
    document.querySelectorAll('.status-option input[type="radio"]').forEach(radio => {
        radio.addEventListener('change', function() {
            document.querySelectorAll('.status-option').forEach(option => {
                option.classList.remove('active');
            });
            
            if (this.checked) {
                this.closest('.status-option').classList.add('active');
            }
        });
    });

    // Initialize active status option
    const checkedRadio = document.querySelector('.status-option input[type="radio"]:checked');
    if (checkedRadio) {
        checkedRadio.closest('.status-option').classList.add('active');
    }
});

// Toggle password visibility
function togglePassword(fieldId) {
    const field = document.getElementById(fieldId);
    const icon = document.getElementById(fieldId + '-icon');
    
    if (field.type === 'password') {
        field.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        field.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}

// Reset password function
function resetPassword() {
    Swal.fire({
        title: 'ยืนยันการรีเซ็ตรหัสผ่าน',
        text: 'คุณต้องการรีเซ็ตรหัสผ่านของผู้ใช้นี้หรือไม่?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'ยืนยัน',
        cancelButtonText: 'ยกเลิก'
    }).then((result) => {
        if (result.isConfirmed) {
            // Show loading
            Swal.fire({
                title: 'กำลังรีเซ็ตรหัสผ่าน...',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            fetch(`<?php echo e(route('admin.users.reset-password', $user)); ?>`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'สำเร็จ!',
                        html: `รหัสผ่านใหม่: <strong>${data.new_password}</strong><br><small>กรุณาแจ้งให้ผู้ใช้ทราบ</small>`,
                        confirmButtonColor: '#FF6B35'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'เกิดข้อผิดพลาด!',
                        text: data.message,
                        confirmButtonColor: '#FF6B35'
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'เกิดข้อผิดพลาด!',
                    text: 'ไม่สามารถรีเซ็ตรหัสผ่านได้',
                    confirmButtonColor: '#FF6B35'
                });
            });
        }
    });
}

// Delete user function
function deleteUser() {
    Swal.fire({
        title: 'ยืนยันการลบ',
        text: 'คุณต้องการลบผู้ใช้นี้หรือไม่? การดำเนินการนี้ไม่สามารถยกเลิกได้',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#EF4444',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'ลบ',
        cancelButtonText: 'ยกเลิก'
    }).then((result) => {
        if (result.isConfirmed) {
            // Show loading
            Swal.fire({
                title: 'กำลังลบผู้ใช้...',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            fetch(`<?php echo e(route('admin.users.destroy', $user)); ?>`, {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'สำเร็จ!',
                        text: data.message,
                        confirmButtonColor: '#FF6B35'
                    }).then(() => {
                        window.location.href = '<?php echo e(route('admin.users.index')); ?>';
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'เกิดข้อผิดพลาด!',
                        text: data.message,
                        confirmButtonColor: '#FF6B35'
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'เกิดข้อผิดพลาด!',
                    text: 'ไม่สามารถลบผู้ใช้ได้',
                    confirmButtonColor: '#FF6B35'
                });
            });
        }
    });
}

// Show success message if redirected back with success
<?php if(session('success')): ?>
    Swal.fire({
        icon: 'success',
        title: 'สำเร็จ!',
        text: '<?php echo e(session('success')); ?>',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>

// Show error messages
<?php if($errors->any()): ?>
    Swal.fire({
        icon: 'error',
        title: 'มีข้อผิดพลาด',
        html: '<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($error); ?><br><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>',
        confirmButtonColor: '#FF6B35'
    });
<?php endif; ?>
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zlerpszw/public_html/www.crs.niendsitekungz.com/resources/views/admin/users/edit.blade.php ENDPATH**/ ?>