

<?php $__env->startSection('title', 'แดชบอร์ดผู้ดูแลระบบ'); ?>
<?php $__env->startSection('page-title', 'แดชบอร์ดผู้ดูแลระบบ'); ?>
<?php $__env->startSection('mobile-title', 'แดชบอร์ด'); ?>

<?php $__env->startSection('content'); ?>
<!-- Header Card -->
<div class="header-card">
    <div class="header-content">
        <div class="header-text">
            <div class="header-title">
                <i class="fas fa-crown"></i>
                สวัสดี, <?php echo e(auth()->user()->name); ?>

            </div>
            <div class="header-subtitle">จัดการระบบและติดตามสถานะการทำงาน</div>
        </div>
        <div class="header-actions">
            <div class="time-display">
                <div class="time-label">เวลาปัจจุบัน</div>
                <div class="time-value" id="currentTime"><?php echo e(now()->format('H:i:s')); ?></div>
            </div>
            <div class="header-icon">
                <i class="fas fa-chart-line"></i>
            </div>
        </div>
    </div>
</div>

<!-- Stats Grid -->
<div class="stats-grid">
    <div class="stat-card users">
        <div class="stat-header">
            <div class="stat-icon">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-trend up">
                <i class="fas fa-arrow-up"></i>
                <span>+<?php echo e($stats['new_users_this_month'] ?? 0); ?></span>
            </div>
        </div>
        <div class="stat-body">
            <div class="stat-number"><?php echo e(number_format($stats['total'] ?? 0)); ?></div>
            <div class="stat-label">ผู้ใช้ทั้งหมด</div>
        </div>
        <div class="stat-footer">
            <a href="<?php echo e(route('admin.users.index')); ?>" class="stat-link">
                ดูทั้งหมด <i class="fas fa-chevron-right"></i>
            </a>
        </div>
    </div>
    
    <div class="stat-card active">
        <div class="stat-header">
            <div class="stat-icon">
                <i class="fas fa-user-check"></i>
            </div>
            <div class="stat-badge">
                <?php echo e(number_format((($stats['active'] ?? 0) / max($stats['total'] ?? 1, 1)) * 100, 1)); ?>%
            </div>
        </div>
        <div class="stat-body">
            <div class="stat-number"><?php echo e(number_format($stats['active'] ?? 0)); ?></div>
            <div class="stat-label">ใช้งานอยู่</div>
        </div>
        <div class="stat-footer">
            <span class="stat-info"><?php echo e($stats['online_users'] ?? 0); ?> ออนไลน์</span>
        </div>
    </div>
    
    <div class="stat-card warehouses">
        <div class="stat-header">
            <div class="stat-icon">
                <i class="fas fa-warehouse"></i>
            </div>
            <div class="stat-status active">
                <?php echo e(number_format($stats['active_warehouses'] ?? 0)); ?>/<?php echo e(number_format($stats['total_warehouses'] ?? 0)); ?>

            </div>
        </div>
        <div class="stat-body">
            <div class="stat-number"><?php echo e(number_format($stats['total_warehouses'] ?? 0)); ?></div>
            <div class="stat-label">คลังสินค้า</div>
        </div>
        <div class="stat-footer">
            <a href="<?php echo e(route('admin.warehouses.index')); ?>" class="stat-link">
                จัดการ <i class="fas fa-chevron-right"></i>
            </a>
        </div>
    </div>
    
    <div class="stat-card commission">
        <div class="stat-header">
            <div class="stat-icon">
                <i class="fas fa-percentage"></i>
            </div>
            <div class="stat-status">
                <?php echo e(number_format($stats['active_commission_rates'] ?? 0)); ?> ใช้งาน
            </div>
        </div>
        <div class="stat-body">
            <div class="stat-number"><?php echo e(number_format($stats['total_commission_rates'] ?? 0)); ?></div>
            <div class="stat-label">อัตราคอมมิชชั่น</div>
        </div>
        <div class="stat-footer">
            <a href="<?php echo e(route('admin.commission-rates.index')); ?>" class="stat-link">
                ตั้งค่า <i class="fas fa-chevron-right"></i>
            </a>
        </div>
    </div>
</div>

<!-- Main Content Grid -->
<div class="content-grid">
    <!-- Quick Actions -->
    <div class="actions-card">
        <div class="actions-header">
            <div class="actions-title">
                <i class="fas fa-bolt"></i>
                การดำเนินการด่วน
            </div>
        </div>
        <div class="actions-body">
            <a href="<?php echo e(route('admin.users.create')); ?>" class="action-item users">
                <div class="action-icon">
                    <i class="fas fa-user-plus"></i>
                </div>
                <div class="action-content">
                    <div class="action-title">เพิ่มผู้ใช้</div>
                    <div class="action-desc">สร้างบัญชีใหม่</div>
                </div>
                <div class="action-arrow">
                    <i class="fas fa-chevron-right"></i>
                </div>
            </a>
            <a href="<?php echo e(route('admin.warehouses.create')); ?>" class="action-item warehouses">
                <div class="action-icon">
                    <i class="fas fa-warehouse"></i>
                </div>
                <div class="action-content">
                    <div class="action-title">เพิ่มคลัง</div>
                    <div class="action-desc">จัดการคลังสินค้า</div>
                </div>
                <div class="action-arrow">
                    <i class="fas fa-chevron-right"></i>
                </div>
            </a>
            <a href="<?php echo e(route('admin.commission-rates.create')); ?>" class="action-item commission">
                <div class="action-icon">
                    <i class="fas fa-percentage"></i>
                </div>
                <div class="action-content">
                    <div class="action-title">ตั้งอัตรา</div>
                    <div class="action-desc">ค่าคอมมิชชั่น</div>
                </div>
                <div class="action-arrow">
                    <i class="fas fa-chevron-right"></i>
                </div>
            </a>
        </div>
    </div>
    
    <!-- Chart Card -->
    <div class="chart-card">
        <div class="chart-header">
            <div class="chart-title">
                <i class="fas fa-chart-pie"></i>
                การกระจายผู้ใช้งาน
            </div>
        </div>
        <div class="chart-body">
            <div class="chart-container">
                <canvas id="userChart"></canvas>
            </div>
            <div class="chart-legend">
                <div class="legend-item">
                    <span class="legend-dot admin"></span>
                    <span>ผู้ดูแล (<?php echo e($stats['admin'] ?? 0); ?>)</span>
                </div>
                <div class="legend-item">
                    <span class="legend-dot wheel2"></span>
                    <span>รถ 2 ล้อ (<?php echo e($stats['2wheel'] ?? 0); ?>)</span>
                </div>
                <div class="legend-item">
                    <span class="legend-dot wheel4"></span>
                    <span>รถ 4 ล้อ (<?php echo e($stats['4wheel'] ?? 0); ?>)</span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bottom Grid -->
<div class="bottom-grid">
    <!-- Recent Users -->
    <div class="users-card">
        <div class="users-header">
            <div class="users-title">
                <i class="fas fa-user-clock"></i>
                ผู้ใช้ล่าสุด
            </div>
        </div>
        <div class="users-body">
            <?php $__empty_1 = true; $__currentLoopData = $recent_users ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="user-item">
                <div class="user-avatar">
                    <?php echo e(strtoupper(mb_substr($user->name,0,2))); ?>

                </div>
                <div class="user-info">
                    <div class="user-name"><?php echo e($user->name); ?></div>
                    <div class="user-email"><?php echo e($user->email); ?></div>
                    <div class="user-date"><?php echo e($user->created_at? $user->created_at->diffForHumans() : ''); ?></div>
                </div>
                <div class="user-badge <?php echo e($user->role=='admin'?'admin':($user->role=='2wheel'?'wheel2':'wheel4')); ?>">
                    <?php echo e($user->role_display_name ?? $user->role); ?>

                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="users-empty">
                <i class="fas fa-users"></i>
                <span>ยังไม่มีผู้ใช้ใหม่</span>
            </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- System Status -->
    <div class="status-card">
        <div class="status-header">
            <div class="status-title">
                <i class="fas fa-server"></i>
                สถานะระบบ
            </div>
        </div>
        <div class="status-body">
            <div class="status-item">
                <div class="status-dot online"></div>
                <div class="status-info">
                    <div class="status-name">ฐานข้อมูล</div>
                    <div class="status-value">ปกติ</div>
                </div>
            </div>
            <div class="status-item">
                <div class="status-dot warning"></div>
                <div class="status-info">
                    <div class="status-name">พื้นที่จัดเก็บ</div>
                    <div class="status-value"><?php echo e($system_status['storage_usage'] ?? '75%'); ?></div>
                </div>
            </div>
            <div class="status-item">
                <div class="status-dot online"></div>
                <div class="status-info">
                    <div class="status-name">แคชระบบ</div>
                    <div class="status-value">ปกติ</div>
                </div>
            </div>
            <div class="performance-item">
                <div class="performance-label">ประสิทธิภาพระบบ</div>
                <div class="performance-bar">
                    <div class="performance-fill" style="width:<?php echo e($system_status['performance'] ?? 92); ?>%"></div>
                </div>
                <div class="performance-value"><?php echo e($system_status['performance'] ?? 92); ?>%</div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Fix scrolling and mobile issues */
body {
    padding-bottom: 150px !important;
}

.main-content {
    padding-bottom: 120px !important;
}

/* Header Card */
.header-card {
    background: var(--gradient);
    border-radius: 20px;
    padding: 20px;
    margin-bottom: 20px;
    color: white;
}

.header-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.header-title {
    font-size: 20px;
    font-weight: 600;
    margin-bottom: 4px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.header-subtitle {
    font-size: 14px;
    opacity: 0.9;
}

.header-actions {
    display: flex;
    align-items: center;
    gap: 16px;
}

.time-display {
    text-align: right;
}

.time-label {
    font-size: 12px;
    opacity: 0.8;
    margin-bottom: 4px;
}

.time-value {
    font-size: 18px;
    font-weight: 600;
    font-family: monospace;
}

.header-icon {
    width: 60px;
    height: 60px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
}

/* Stats Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 20px;
}

.stat-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    box-shadow: 0 2px 12px rgba(0,0,0,0.06);
    border: 1px solid rgba(0,0,0,0.05);
    transition: all 0.3s;
}

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.12);
}

.stat-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 16px;
}

.stat-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    color: white;
}

.stat-card.users .stat-icon {
    background: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
}

.stat-card.active .stat-icon {
    background: linear-gradient(135deg, #10B981 0%, #047857 100%);
}

.stat-card.warehouses .stat-icon {
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
}

.stat-card.commission .stat-icon {
    background: linear-gradient(135deg, #8B5CF6 0%, #7C3AED 100%);
}

.stat-trend {
    display: flex;
    align-items: center;
    gap: 4px;
    font-size: 12px;
    font-weight: 600;
    color: #10B981;
    background: rgba(16,185,129,0.1);
    padding: 4px 8px;
    border-radius: 12px;
}

.stat-badge {
    font-size: 12px;
    font-weight: 600;
    color: #10B981;
    background: rgba(16,185,129,0.1);
    padding: 4px 8px;
    border-radius: 12px;
}

.stat-status {
    font-size: 12px;
    font-weight: 500;
    color: var(--gray-600);
}

.stat-body {
    margin-bottom: 16px;
}

.stat-number {
    font-size: 32px;
    font-weight: 700;
    color: var(--gray-900);
    margin-bottom: 4px;
}

.stat-label {
    font-size: 14px;
    color: var(--gray-600);
    font-weight: 500;
}

.stat-footer {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.stat-link {
    color: var(--primary);
    text-decoration: none;
    font-size: 14px;
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: 4px;
    transition: all 0.3s;
}

.stat-link:hover {
    gap: 8px;
}

.stat-info {
    font-size: 12px;
    color: var(--gray-500);
}

/* Content Grid */
.content-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
    margin-bottom: 20px;
}

/* Actions Card */
.actions-card {
    background: white;
    border-radius: 16px;
    box-shadow: 0 2px 12px rgba(0,0,0,0.06);
    border: 1px solid rgba(0,0,0,0.05);
    overflow: hidden;
}

.actions-header {
    background: var(--gradient-soft);
    padding: 16px 20px;
    border-bottom: 1px solid rgba(255,107,53,0.1);
}

.actions-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--primary);
    display: flex;
    align-items: center;
    gap: 8px;
}

.actions-body {
    padding: 20px;
}

.action-item {
    display: flex;
    align-items: center;
    gap: 16px;
    padding: 16px;
    background: var(--gray-50);
    border-radius: 12px;
    text-decoration: none;
    color: var(--gray-900);
    margin-bottom: 12px;
    border: 1px solid var(--gray-200);
    transition: all 0.3s;
}

.action-item:hover {
    background: white;
    border-color: var(--primary);
    transform: translateX(4px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.action-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
    color: white;
}

.action-item.users .action-icon {
    background: linear-gradient(135deg, #FF6B35 0%, #FF8C61 100%);
}

.action-item.warehouses .action-icon {
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
}

.action-item.commission .action-icon {
    background: linear-gradient(135deg, #8B5CF6 0%, #7C3AED 100%);
}

.action-content {
    flex: 1;
}

.action-title {
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 2px;
}

.action-desc {
    font-size: 12px;
    color: var(--gray-500);
}

.action-arrow {
    color: var(--gray-400);
    transition: all 0.3s;
}

.action-item:hover .action-arrow {
    color: var(--primary);
    transform: translateX(2px);
}

/* Chart Card */
.chart-card {
    background: white;
    border-radius: 16px;
    box-shadow: 0 2px 12px rgba(0,0,0,0.06);
    border: 1px solid rgba(0,0,0,0.05);
    overflow: hidden;
}

.chart-header {
    background: var(--gradient-soft);
    padding: 16px 20px;
    border-bottom: 1px solid rgba(255,107,53,0.1);
}

.chart-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--primary);
    display: flex;
    align-items: center;
    gap: 8px;
}

.chart-body {
    padding: 20px;
}

.chart-container {
    height: 200px;
    margin-bottom: 20px;
    position: relative;
    width: 100%;
}

.chart-container canvas {
    max-width: 100% !important;
    height: auto !important;
}

.chart-legend {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.legend-item {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    color: var(--gray-700);
}

.legend-dot {
    width: 12px;
    height: 12px;
    border-radius: 50%;
}

.legend-dot.admin {
    background: #8B5CF6;
}

.legend-dot.wheel2 {
    background: #3B82F6;
}

.legend-dot.wheel4 {
    background: #10B981;
}

/* Bottom Grid */
.bottom-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
}

/* Users Card */
.users-card {
    background: white;
    border-radius: 16px;
    box-shadow: 0 2px 12px rgba(0,0,0,0.06);
    border: 1px solid rgba(0,0,0,0.05);
    overflow: hidden;
}

.users-header {
    background: var(--gradient-soft);
    padding: 16px 20px;
    border-bottom: 1px solid rgba(255,107,53,0.1);
}

.users-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--primary);
    display: flex;
    align-items: center;
    gap: 8px;
}

.users-body {
    padding: 20px;
    max-height: 300px;
    overflow-y: auto;
}

.user-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px 0;
    border-bottom: 1px solid var(--gray-100);
}

.user-item:last-child {
    border-bottom: none;
}

.user-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: var(--gradient);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 14px;
}

.user-info {
    flex: 1;
}

.user-name {
    font-size: 14px;
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 2px;
}

.user-email {
    font-size: 12px;
    color: var(--gray-500);
    margin-bottom: 2px;
}

.user-date {
    font-size: 11px;
    color: var(--gray-400);
}

.user-badge {
    font-size: 11px;
    font-weight: 500;
    padding: 4px 8px;
    border-radius: 12px;
    color: white;
}

.user-badge.admin {
    background: #8B5CF6;
}

.user-badge.wheel2 {
    background: #3B82F6;
}

.user-badge.wheel4 {
    background: #10B981;
}

.users-empty {
    text-align: center;
    padding: 40px 20px;
    color: var(--gray-500);
}

.users-empty i {
    font-size: 32px;
    margin-bottom: 8px;
    display: block;
}

/* Status Card */
.status-card {
    background: white;
    border-radius: 16px;
    box-shadow: 0 2px 12px rgba(0,0,0,0.06);
    border: 1px solid rgba(0,0,0,0.05);
    overflow: hidden;
}

.status-header {
    background: var(--gradient-soft);
    padding: 16px 20px;
    border-bottom: 1px solid rgba(255,107,53,0.1);
}

.status-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--primary);
    display: flex;
    align-items: center;
    gap: 8px;
}

.status-body {
    padding: 20px;
}

.status-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px 0;
    border-bottom: 1px solid var(--gray-100);
}

.status-item:last-child {
    border-bottom: none;
}

.status-dot {
    width: 12px;
    height: 12px;
    border-radius: 50%;
}

.status-dot.online {
    background: #10B981;
}

.status-dot.warning {
    background: #F59E0B;
}

.status-info {
    flex: 1;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.status-name {
    font-size: 14px;
    color: var(--gray-700);
}

.status-value {
    font-size: 14px;
    font-weight: 600;
    color: var(--gray-900);
}

.performance-item {
    margin-top: 16px;
    padding-top: 16px;
    border-top: 1px solid var(--gray-100);
}

.performance-label {
    font-size: 14px;
    color: var(--gray-700);
    margin-bottom: 8px;
}

.performance-bar {
    height: 8px;
    background: var(--gray-200);
    border-radius: 4px;
    overflow: hidden;
    margin-bottom: 8px;
}

.performance-fill {
    height: 100%;
    background: var(--gradient);
    border-radius: 4px;
    transition: width 0.3s;
}

.performance-value {
    font-size: 14px;
    font-weight: 600;
    color: var(--primary);
    text-align: right;
}

/* Desktop Styles */
@media (min-width: 769px) {
    .header-card {
        display: none;
    }
}

/* Mobile Styles */
@media (max-width: 768px) {
    body {
        padding-bottom: 180px !important;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
        gap: 16px;
    }
    
    .content-grid,
    .bottom-grid {
        grid-template-columns: 1fr;
        gap: 16px;
    }
    
    .chart-container {
        height: 180px;
        min-height: 180px;
    }
    
    .chart-card {
        margin-bottom: 20px;
    }
    
    .users-body {
        max-height: 250px;
    }
    
    .header-actions {
        flex-direction: column;
        gap: 8px;
        align-items: flex-end;
    }
    
    .time-display {
        order: 2;
    }
    
    .header-icon {
        order: 1;
        width: 50px;
        height: 50px;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Update time
function updateTime() {
    const now = new Date();
    const timeString = now.toLocaleTimeString('th-TH');
    const timeElement = document.getElementById('currentTime');
    if (timeElement && timeElement.textContent !== timeString) {
        timeElement.style.opacity = '0.7';
        setTimeout(() => {
            timeElement.textContent = timeString;
            timeElement.style.opacity = '1';
        }, 100);
    }
}
setInterval(updateTime, 1000);

// Fix mobile scrolling
document.addEventListener('DOMContentLoaded', function() {
    // Ensure proper viewport height
    function setViewportHeight() {
        const vh = window.innerHeight * 0.01;
        document.documentElement.style.setProperty('--vh', `${vh}px`);
    }
    
    setViewportHeight();
    window.addEventListener('resize', setViewportHeight);
    window.addEventListener('orientationchange', setViewportHeight);
});

// Chart with mobile fixes
const ctx = document.getElementById('userChart');
if (ctx) {
    // Wait for DOM to be ready
    setTimeout(() => {
        try {
            new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: ['ผู้ดูแล', 'รถ 2 ล้อ', 'รถ 4 ล้อ'],
                    datasets: [{
                        data: [<?php echo e($stats['admin'] ?? 0); ?>, <?php echo e($stats['2wheel'] ?? 0); ?>, <?php echo e($stats['4wheel'] ?? 0); ?>],
                        backgroundColor: ['#8B5CF6', '#3B82F6', '#10B981'],
                        borderWidth: 0,
                        hoverBorderWidth: 2,
                        hoverBorderColor: '#fff'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '65%',
                    devicePixelRatio: window.devicePixelRatio || 1,
                    plugins: { 
                        legend: { display: false },
                        tooltip: {
                            enabled: true,
                            backgroundColor: 'rgba(0,0,0,0.8)',
                            titleColor: '#fff',
                            bodyColor: '#fff'
                        }
                    },
                    interaction: {
                        intersect: false,
                        mode: 'index'
                    }
                }
            });
        } catch (error) {
            console.log('Chart initialization error:', error);
            // Fallback for mobile
            ctx.style.display = 'none';
            const fallback = document.createElement('div');
            fallback.innerHTML = '<div style="text-align:center;padding:40px;color:#666;"><i class="fas fa-chart-pie" style="font-size:48px;margin-bottom:16px;display:block;"></i>กราฟไม่สามารถแสดงได้</div>';
            ctx.parentNode.appendChild(fallback);
        }
    }, 100);
}
</script>

<style>
/* Additional mobile fixes */
@media (max-width: 768px) {
    .chart-container {
        overflow: hidden;
    }
    
    canvas {
        touch-action: manipulation;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\crs\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>