<?php $__env->startSection('title', 'งบประมาณรายเดือน'); ?>
<?php $__env->startSection('page-title', 'งบประมาณรายเดือน'); ?>
<?php $__env->startSection('mobile-title', 'งบประมาณ'); ?>

<?php $__env->startSection('content'); ?>
<div class="budget-container">
    <!-- Header Section -->
    <div class="budget-header">
        <div class="header-content">
            <div class="header-left">
                <div class="header-icon">
                    <i class="fas fa-calculator"></i>
                </div>
                <div class="header-text">
                    <h1 class="budget-title">งบประมาณรายเดือน</h1>
                    <p class="budget-subtitle">
                        <?php echo e(Carbon\Carbon::parse($selectedMonth)->locale('th')->monthName); ?> 
                        <?php echo e(Carbon\Carbon::parse($selectedMonth)->year + 543); ?>

                    </p>
                </div>
            </div>
            <div class="header-actions">
                <form method="GET" action="<?php echo e(route('finance.budgets.index')); ?>" class="month-selector">
                    <div class="select-wrapper">
                        <select name="month" class="month-select" onchange="this.form.submit()">
                            <?php $__currentLoopData = $availableMonths; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($month['value']); ?>" <?php echo e($selectedMonth == $month['value'] ? 'selected' : ''); ?>>
                                    <?php echo e($month['label']); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <i class="fas fa-chevron-down select-icon"></i>
                    </div>
                </form>
                <button class="action-btn copy-btn" onclick="copyFromPreviousMonth()">
                    <i class="fas fa-copy"></i>
                    <span>คัดลอกจากเดือนก่อน</span>
                </button>
            </div>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="summary-section">
        <div class="summary-grid">
            <div class="summary-card total">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-wallet"></i>
                    </div>
                    <div class="card-badge">งบรวม</div>
                </div>
                <div class="card-content">
                    <div class="amount">฿<?php echo e(number_format($totalBudget, 0)); ?></div>
                    <div class="label">งบประมาณทั้งหมด</div>
                </div>
            </div>

            <div class="summary-card spent">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-shopping-cart"></i>
                    </div>
                    <div class="card-badge">ใช้แล้ว</div>
                </div>
                <div class="card-content">
                    <div class="amount">฿<?php echo e(number_format($totalSpent, 0)); ?></div>
                    <div class="label"><?php echo e($totalBudget > 0 ? number_format(($totalSpent / $totalBudget) * 100, 1) : 0); ?>% ของงบรวม</div>
                </div>
            </div>

            <div class="summary-card <?php echo e($totalRemaining >= 0 ? 'remaining' : 'over'); ?>">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas <?php echo e($totalRemaining >= 0 ? 'fa-piggy-bank' : 'fa-exclamation-triangle'); ?>"></i>
                    </div>
                    <div class="card-badge"><?php echo e($totalRemaining >= 0 ? 'คงเหลือ' : 'เกินงบ'); ?></div>
                </div>
                <div class="card-content">
                    <div class="amount">฿<?php echo e(number_format(abs($totalRemaining), 0)); ?></div>
                    <div class="label"><?php echo e($totalRemaining >= 0 ? 'เงินคงเหลือ' : 'ใช้เกินงบประมาณ'); ?></div>
                </div>
            </div>

            <div class="summary-card progress">
                <div class="card-header">
                    <div class="card-icon">
                        <i class="fas fa-chart-pie"></i>
                    </div>
                    <div class="card-badge">ความคืบหน้า</div>
                </div>
                <div class="card-content">
                    <div class="progress-circle">
                        <svg class="progress-ring" width="60" height="60">
                            <circle class="progress-ring-circle" stroke="#e5e7eb" stroke-width="4" fill="transparent" r="26" cx="30" cy="30"/>
                            <circle class="progress-ring-fill" stroke="var(--primary)" stroke-width="4" fill="transparent" r="26" cx="30" cy="30" 
                                    style="stroke-dasharray: <?php echo e(2 * pi() * 26); ?>; stroke-dashoffset: <?php echo e(2 * pi() * 26 * (1 - min(($totalBudget > 0 ? $totalSpent / $totalBudget : 0), 1))); ?>;"/>
                        </svg>
                        <div class="progress-text"><?php echo e($totalBudget > 0 ? number_format(($totalSpent / $totalBudget) * 100, 0) : 0); ?>%</div>
                    </div>
                    <div class="label">การใช้งบประมาณ</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Budget Management -->
    <div class="budget-management">
        <div class="management-header">
            <div class="header-left">
                <h2 class="section-title">
                    <i class="fas fa-list-ul"></i>
                    งบประมาณตามหมวดหมู่
                </h2>
                <p class="section-subtitle">จัดการงบประมาณในแต่ละหมวดหมู่</p>
            </div>
            <div class="header-actions">
                <button class="action-btn edit-btn" onclick="toggleEditMode()" id="editModeBtn">
                    <i class="fas fa-edit"></i>
                    <span>แก้ไข</span>
                </button>
                <button class="action-btn add-btn" onclick="showAddBudgetModal()">
                    <i class="fas fa-plus"></i>
                    <span>เพิ่มหมวดหมู่</span>
                </button>
            </div>
        </div>

        <form id="budgetForm" method="POST" action="<?php echo e(route('finance.budgets.bulk-update')); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="month" value="<?php echo e($selectedMonth); ?>">
            
            <div class="budget-grid">
                <?php $__empty_1 = true; $__currentLoopData = $budgets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $budget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="budget-card <?php echo e($budget->status); ?>" data-category="<?php echo e($budget->category); ?>">
                        <div class="card-header">
                            <div class="category-info">
                                <div class="category-icon" style="background: <?php echo e($budget->categoryInfo->color ?? '#6B7280'); ?>20; color: <?php echo e($budget->categoryInfo->color ?? '#6B7280'); ?>">
                                    <i class="fas <?php echo e($budget->categoryInfo->icon ?? 'fa-circle'); ?>"></i>
                                </div>
                                <div class="category-details">
                                    <h3 class="category-name"><?php echo e($budget->categoryInfo->name ?? $budget->category); ?></h3>
                                    <p class="category-desc"><?php echo e($budget->categoryInfo->description ?? 'หมวดหมู่ค่าใช้จ่าย'); ?></p>
                                </div>
                            </div>
                            <div class="card-actions">
                                <div class="status-indicator <?php echo e($budget->status); ?>">
                                    <?php if($budget->status === 'over'): ?>
                                        <i class="fas fa-exclamation-triangle"></i>
                                    <?php elseif($budget->status === 'warning'): ?>
                                        <i class="fas fa-exclamation-circle"></i>
                                    <?php else: ?>
                                        <i class="fas fa-check-circle"></i>
                                    <?php endif; ?>
                                </div>
                                <button type="button" class="card-menu-btn" onclick="toggleCardMenu(this)">
                                    <i class="fas fa-ellipsis-v"></i>
                                </button>
                                <div class="card-menu">
                                    <button type="button" onclick="viewBudgetDetails('<?php echo e($budget->category); ?>')">
                                        <i class="fas fa-eye"></i> ดูรายละเอียด
                                    </button>
                                    <button type="button" onclick="editBudgetAmount('<?php echo e($budget->category); ?>')">
                                        <i class="fas fa-edit"></i> แก้ไขงบประมาณ
                                    </button>
                                    <button type="button" onclick="deleteBudget('<?php echo e($budget->category); ?>')">
                                        <i class="fas fa-trash"></i> ลบหมวดหมู่
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">
                            <div class="budget-amounts">
                                <div class="amount-item">
                                    <span class="amount-label">งบประมาณ</span>
                                    <div class="amount-value">
                                        <span class="view-mode">฿<?php echo e(number_format($budget->budget_amount, 0)); ?></span>
                                        <div class="edit-mode" style="display: none;">
                                            <input type="hidden" name="budgets[<?php echo e($loop->index); ?>][id]" value="<?php echo e($budget->id); ?>">
                                            <input type="number" 
                                                   name="budgets[<?php echo e($loop->index); ?>][amount]" 
                                                   class="budget-input"
                                                   value="<?php echo e($budget->budget_amount); ?>"
                                                   min="0"
                                                   step="100"
                                                   placeholder="0">
                                        </div>
                                    </div>
                                </div>
                                <div class="amount-item">
                                    <span class="amount-label">ใช้ไปแล้ว</span>
                                    <span class="amount-value spent">฿<?php echo e(number_format($budget->spent_amount, 0)); ?></span>
                                </div>
                                <div class="amount-item">
                                    <span class="amount-label">คงเหลือ</span>
                                    <span class="amount-value <?php echo e($budget->remaining_amount >= 0 ? 'remaining' : 'over'); ?>">
                                        <?php echo e($budget->remaining_amount >= 0 ? '+' : '-'); ?>฿<?php echo e(number_format(abs($budget->remaining_amount), 0)); ?>

                                    </span>
                                </div>
                            </div>

                            <div class="progress-section">
                                <div class="progress-header">
                                    <span class="progress-label">การใช้งบประมาณ</span>
                                    <span class="progress-percentage"><?php echo e(number_format($budget->usage_percentage, 1)); ?>%</span>
                                </div>
                                <div class="progress-bar">
                                    <div class="progress-fill <?php echo e($budget->status); ?>" 
                                         style="width: <?php echo e(min($budget->usage_percentage, 100)); ?>%">
                                    </div>
                                </div>
                                <div class="progress-labels">
                                    <span class="progress-start">0%</span>
                                    <span class="progress-end">100%</span>
                                </div>
                            </div>

                            <?php if($budget->status === 'over'): ?>
                                <div class="alert alert-danger">
                                    <i class="fas fa-exclamation-triangle"></i>
                                    <span>เกินงบประมาณ <?php echo e(number_format($budget->usage_percentage - 100, 1)); ?>%</span>
                                </div>
                            <?php elseif($budget->status === 'warning'): ?>
                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-circle"></i>
                                    <span>ใกล้หมดงบประมาณแล้ว</span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="empty-state">
                        <div class="empty-icon">
                            <i class="fas fa-calculator"></i>
                        </div>
                        <h3>ยังไม่มีงบประมาณ</h3>
                        <p>เริ่มต้นสร้างงบประมาณสำหรับเดือนนี้</p>
                        <button class="action-btn primary" onclick="showAddBudgetModal()">
                            <i class="fas fa-plus"></i>
                            เพิ่มงบประมาณแรก
                        </button>
                    </div>
                <?php endif; ?>
            </div>

            <div class="form-actions edit-mode" style="display: none;">
                <button type="submit" class="action-btn primary save-btn">
                    <i class="fas fa-save"></i>
                    <span>บันทึกการแก้ไข</span>
                </button>
                <button type="button" class="action-btn secondary" onclick="cancelEdit()">
                    <i class="fas fa-times"></i>
                    <span>ยกเลิก</span>
                </button>
            </div>
        </form>
    </div>

    <!-- Budget Tips -->
    <div class="tips-section">
        <div class="tips-header">
            <h3 class="tips-title">
                <i class="fas fa-lightbulb"></i>
                เคล็ดลับการจัดการงบประมาณ
            </h3>
        </div>
        <div class="tips-grid">
            <div class="tip-card">
                <div class="tip-icon">
                    <i class="fas fa-percentage"></i>
                </div>
                <h4>กฎ 50/30/20</h4>
                <p>แบ่งรายได้เป็น 50% ค่าใช้จ่ายจำเป็น, 30% ความต้องการส่วนตัว, และ 20% การออมและลงทุน</p>
            </div>
            <div class="tip-card">
                <div class="tip-icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <h4>ติดตามสม่ำเสมอ</h4>
                <p>ตรวจสอบการใช้จ่ายทุกสัปดาห์เพื่อให้แน่ใจว่าอยู่ในแผนงบประมาณที่วางไว้</p>
            </div>
            <div class="tip-card">
                <div class="tip-icon">
                    <i class="fas fa-piggy-bank"></i>
                </div>
                <h4>เงินสำรองฉุกเฉิน</h4>
                <p>ควรมีเงินสำรองอย่างน้อย 10% ของรายได้เพื่อรับมือกับเหตุการณ์ไม่คาดคิด</p>
            </div>
            <div class="tip-card">
                <div class="tip-icon">
                    <i class="fas fa-target"></i>
                </div>
                <h4>ตั้งเป้าหมายชัดเจน</h4>
                <p>กำหนดเป้าหมายการออมและการใช้จ่ายที่ชัดเจนและสามารถวัดผลได้</p>
            </div>
        </div>
    </div>
</div>

<!-- Add Budget Modal -->
<div class="modal" id="addBudgetModal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>เพิ่มหมวดหมู่งบประมาณ</h3>
            <button class="modal-close" onclick="closeAddBudgetModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body">
            <form id="addBudgetForm">
                <div class="form-group">
                    <label>หมวดหมู่</label>
                    <select name="category" class="form-control" required>
                        <option value="">เลือกหมวดหมู่</option>
                        <!-- Categories will be loaded via JavaScript -->
                    </select>
                </div>
                <div class="form-group">
                    <label>งบประมาณ (บาท)</label>
                    <input type="number" name="amount" class="form-control" min="0" step="100" required>
                </div>
            </form>
        </div>
        <div class="modal-footer">
            <button class="action-btn secondary" onclick="closeAddBudgetModal()">ยกเลิก</button>
            <button class="action-btn primary" onclick="addBudget()">เพิ่มงบประมาณ</button>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
/* Budget Container */
.budget-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
    min-height: calc(100vh - 140px);
}

/* Header Section */
.budget-header {
    background: var(--gradient);
    border-radius: 24px;
    padding: 32px;
    margin-bottom: 24px;
    color: white;
    box-shadow: 0 8px 32px rgba(255, 107, 53, 0.2);
}

.header-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 24px;
}

.header-left {
    display: flex;
    align-items: center;
    gap: 20px;
}

.header-icon {
    width: 64px;
    height: 64px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 28px;
    backdrop-filter: blur(10px);
}

.budget-title {
    font-size: 28px;
    font-weight: 700;
    margin-bottom: 4px;
}

.budget-subtitle {
    font-size: 16px;
    opacity: 0.9;
}

.header-actions {
    display: flex;
    align-items: center;
    gap: 16px;
}

.month-selector {
    position: relative;
}

.select-wrapper {
    position: relative;
}

.month-select {
    background: rgba(255, 255, 255, 0.15);
    border: 1px solid rgba(255, 255, 255, 0.2);
    color: white;
    padding: 12px 40px 12px 16px;
    border-radius: 16px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    appearance: none;
    min-width: 180px;
}

.month-select option {
    background: var(--primary);
    color: white;
}

.select-icon {
    position: absolute;
    right: 12px;
    top: 50%;
    transform: translateY(-50%);
    pointer-events: none;
    font-size: 12px;
}

.action-btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    border: none;
    border-radius: 16px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
}

.copy-btn {
    background: rgba(255, 255, 255, 0.15);
    color: white;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.copy-btn:hover {
    background: rgba(255, 255, 255, 0.25);
    transform: translateY(-2px);
}

/* Summary Section */
.summary-section {
    margin-bottom: 32px;
}

.summary-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 20px;
}

.summary-card {
    background: white;
    border-radius: 20px;
    padding: 24px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    border: 1px solid rgba(0, 0, 0, 0.05);
    position: relative;
    overflow: hidden;
}

.summary-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
}

.summary-card.total::before { background: #3B82F6; }
.summary-card.spent::before { background: #F59E0B; }
.summary-card.remaining::before { background: #10B981; }
.summary-card.over::before { background: #EF4444; }
.summary-card.progress::before { background: var(--primary); }

.card-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 16px;
}

.card-icon {
    width: 48px;
    height: 48px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
}

.summary-card.total .card-icon {
    background: rgba(59, 130, 246, 0.1);
    color: #3B82F6;
}

.summary-card.spent .card-icon {
    background: rgba(245, 158, 11, 0.1);
    color: #F59E0B;
}

.summary-card.remaining .card-icon {
    background: rgba(16, 185, 129, 0.1);
    color: #10B981;
}

.summary-card.over .card-icon {
    background: rgba(239, 68, 68, 0.1);
    color: #EF4444;
}

.summary-card.progress .card-icon {
    background: var(--gradient-soft);
    color: var(--primary);
}

.card-badge {
    background: rgba(0, 0, 0, 0.05);
    color: var(--gray-600);
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.card-content .amount {
    font-size: 24px;
    font-weight: 700;
    color: var(--gray-900);
    margin-bottom: 4px;
}

.card-content .label {
    font-size: 14px;
    color: var(--gray-500);
}

.progress-circle {
    position: relative;
    display: inline-block;
}

.progress-ring {
    transform: rotate(-90deg);
}

.progress-ring-circle {
    transition: stroke-dashoffset 0.5s ease;
}

.progress-text {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    font-size: 14px;
    font-weight: 700;
    color: var(--primary);
}

/* Budget Management */
.budget-management {
    background: white;
    border-radius: 24px;
    padding: 32px;
    margin-bottom: 32px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
}

.management-header {
    display: flex;
    align-items: flex-start;
    justify-content: space-between;
    margin-bottom: 32px;
    gap: 24px;
}

.section-title {
    font-size: 24px;
    font-weight: 700;
    color: var(--gray-900);
    margin-bottom: 4px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.section-title i {
    color: var(--primary);
}

.section-subtitle {
    font-size: 14px;
    color: var(--gray-500);
}

.edit-btn {
    background: var(--gray-100);
    color: var(--gray-700);
}

.edit-btn:hover {
    background: var(--gray-200);
}

.add-btn {
    background: var(--gradient);
    color: white;
}

.add-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255, 107, 53, 0.3);
}

/* Budget Grid */
.budget-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
    gap: 24px;
}

.budget-card {
    background: white;
    border: 2px solid var(--gray-100);
    border-radius: 20px;
    padding: 24px;
    transition: all 0.3s ease;
    position: relative;
}

.budget-card:hover {
    border-color: var(--primary);
    box-shadow: 0 8px 32px rgba(255, 107, 53, 0.1);
    transform: translateY(-2px);
}

.budget-card.over {
    border-color: #FCA5A5;
    background: linear-gradient(135deg, #FEF2F2 0%, #FFFFFF 100%);
}

.budget-card.warning {
    border-color: #FCD34D;
    background: linear-gradient(135deg, #FFFBEB 0%, #FFFFFF 100%);
}

.budget-card .card-header {
    margin-bottom: 20px;
}

.category-info {
    display: flex;
    align-items: center;
    gap: 16px;
    flex: 1;
}

.category-icon {
    width: 48px;
    height: 48px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
}

.category-name {
    font-size: 18px;
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 2px;
}

.category-desc {
    font-size: 12px;
    color: var(--gray-500);
}

.card-actions {
    display: flex;
    align-items: center;
    gap: 8px;
    position: relative;
}

.status-indicator {
    width: 32px;
    height: 32px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
}

.status-indicator.good {
    background: rgba(16, 185, 129, 0.1);
    color: #10B981;
}

.status-indicator.warning {
    background: rgba(245, 158, 11, 0.1);
    color: #F59E0B;
}

.status-indicator.over {
    background: rgba(239, 68, 68, 0.1);
    color: #EF4444;
}

.card-menu-btn {
    width: 32px;
    height: 32px;
    border: none;
    background: var(--gray-100);
    border-radius: 10px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--gray-500);
}

.card-menu {
    position: absolute;
    top: 100%;
    right: 0;
    background: white;
    border: 1px solid var(--gray-200);
    border-radius: 12px;
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
    padding: 8px;
    min-width: 180px;
    z-index: 10;
    display: none;
}

.card-menu button {
    width: 100%;
    padding: 8px 12px;
    border: none;
    background: none;
    text-align: left;
    border-radius: 8px;
    cursor: pointer;
    font-size: 14px;
    color: var(--gray-700);
    display: flex;
    align-items: center;
    gap: 8px;
}

.card-menu button:hover {
    background: var(--gray-50);
}

/* Budget Amounts */
.budget-amounts {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 16px;
    margin-bottom: 20px;
}

.amount-item {
    text-align: center;
}

.amount-label {
    display: block;
    font-size: 12px;
    color: var(--gray-500);
    margin-bottom: 4px;
    font-weight: 500;
}

.amount-value {
    font-size: 16px;
    font-weight: 700;
    color: var(--gray-900);
}

.amount-value.spent {
    color: #F59E0B;
}

.amount-value.remaining {
    color: #10B981;
}

.amount-value.over {
    color: #EF4444;
}

.budget-input {
    width: 100%;
    padding: 8px 12px;
    border: 2px solid var(--gray-200);
    border-radius: 10px;
    font-size: 14px;
    font-weight: 600;
    text-align: center;
}

.budget-input:focus {
    outline: none;
    border-color: var(--primary);
}

/* Progress Section */
.progress-section {
    margin-top: 20px;
}

.progress-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 8px;
}

.progress-label {
    font-size: 14px;
    color: var(--gray-600);
    font-weight: 500;
}

.progress-percentage {
    font-size: 14px;
    font-weight: 700;
    color: var(--gray-900);
}

.progress-bar {
    height: 8px;
    background: var(--gray-100);
    border-radius: 4px;
    overflow: hidden;
    margin-bottom: 8px;
}

.progress-fill {
    height: 100%;
    border-radius: 4px;
    transition: width 0.5s ease;
}

.progress-fill.good {
    background: linear-gradient(90deg, #10B981, #34D399);
}

.progress-fill.warning {
    background: linear-gradient(90deg, #F59E0B, #FBBF24);
}

.progress-fill.over {
    background: linear-gradient(90deg, #EF4444, #F87171);
}

.progress-labels {
    display: flex;
    justify-content: space-between;
    font-size: 11px;
    color: var(--gray-400);
}

/* Alerts */
.alert {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 12px 16px;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 500;
    margin-top: 16px;
}

.alert-danger {
    background: rgba(239, 68, 68, 0.1);
    color: #DC2626;
    border: 1px solid rgba(239, 68, 68, 0.2);
}

.alert-warning {
    background: rgba(245, 158, 11, 0.1);
    color: #D97706;
    border: 1px solid rgba(245, 158, 11, 0.2);
}

/* Form Actions */
.form-actions {
    display: flex;
    gap: 16px;
    margin-top: 32px;
    padding-top: 24px;
    border-top: 1px solid var(--gray-200);
}

.save-btn {
    background: var(--gradient);
    color: white;
}

.save-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255, 107, 53, 0.3);
}

.action-btn.secondary {
    background: var(--gray-100);
    color: var(--gray-700);
}

.action-btn.secondary:hover {
    background: var(--gray-200);
}

/* Empty State */
.empty-state {
    grid-column: 1 / -1;
    text-align: center;
    padding: 60px 20px;
    color: var(--gray-500);
}

.empty-icon {
    width: 80px;
    height: 80px;
    background: var(--gradient-soft);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 32px;
    color: var(--primary);
    margin: 0 auto 20px;
}

.empty-state h3 {
    font-size: 20px;
    font-weight: 600;
    color: var(--gray-700);
    margin-bottom: 8px;
}

.empty-state p {
    font-size: 14px;
    margin-bottom: 24px;
}

.action-btn.primary {
    background: var(--gradient);
    color: white;
}

/* Tips Section */
.tips-section {
    background: var(--gray-50);
    border-radius: 24px;
    padding: 32px;
    margin-bottom: 32px;
}

.tips-title {
    font-size: 20px;
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 24px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.tips-title i {
    color: #F59E0B;
}

.tips-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 20px;
}

.tip-card {
    background: white;
    border-radius: 16px;
    padding: 24px;
    text-align: center;
    border: 1px solid var(--gray-200);
    transition: all 0.3s ease;
}

.tip-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
}

.tip-icon {
    width: 56px;
    height: 56px;
    background: var(--gradient-soft);
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    color: var(--primary);
    margin: 0 auto 16px;
}

.tip-card h4 {
    font-size: 16px;
    font-weight: 600;
    color: var(--gray-900);
    margin-bottom: 8px;
}

.tip-card p {
    font-size: 14px;
    color: var(--gray-600);
    line-height: 1.5;
}

/* Modal */
.modal {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.5);
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 1000;
    padding: 20px;
}

.modal.active {
    display: flex;
}

.modal-content {
    background: white;
    border-radius: 20px;
    width: 100%;
    max-width: 500px;
    max-height: 90vh;
    overflow-y: auto;
}

.modal-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 24px 24px 0;
    margin-bottom: 24px;
}

.modal-header h3 {
    font-size: 20px;
    font-weight: 600;
    color: var(--gray-900);
}

.modal-close {
    width: 32px;
    height: 32px;
    border: none;
    background: var(--gray-100);
    border-radius: 10px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--gray-500);
}

.modal-body {
    padding: 0 24px;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    font-size: 14px;
    font-weight: 500;
    color: var(--gray-700);
    margin-bottom: 8px;
}

.form-control {
    width: 100%;
    padding: 12px 16px;
    border: 2px solid var(--gray-200);
    border-radius: 12px;
    font-size: 14px;
}

.form-control:focus {
    outline: none;
    border-color: var(--primary);
}

.modal-footer {
    display: flex;
    gap: 12px;
    padding: 24px;
    border-top: 1px solid var(--gray-200);
}

.modal-footer .action-btn {
    flex: 1;
    justify-content: center;
}

/* Responsive Design */
@media (max-width: 768px) {
    .budget-container {
        padding: 16px;
    }

    .budget-header {
        padding: 24px;
    }

    .header-content {
        flex-direction: column;
        align-items: flex-start;
        gap: 20px;
    }

    .header-actions {
        width: 100%;
        flex-direction: column;
        gap: 12px;
    }

    .month-select {
        width: 100%;
    }

    .copy-btn {
        width: 100%;
        justify-content: center;
    }

    .summary-grid {
        grid-template-columns: 1fr;
        gap: 16px;
    }

    .budget-management {
        padding: 24px;
    }

    .management-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
    }

    .header-actions {
        flex-direction: row;
        width: auto;
    }

    .budget-grid {
        grid-template-columns: 1fr;
        gap: 16px;
    }

    .budget-amounts {
        grid-template-columns: 1fr;
        gap: 12px;
    }

    .tips-grid {
        grid-template-columns: 1fr;
        gap: 16px;
    }

    .form-actions {
        flex-direction: column;
    }

    .modal-footer {
        flex-direction: column;
    }
}

@media (max-width: 480px) {
    .header-left {
        flex-direction: column;
        align-items: flex-start;
        gap: 12px;
    }

    .header-icon {
        width: 48px;
        height: 48px;
        font-size: 20px;
    }

    .budget-title {
        font-size: 24px;
    }

    .section-title {
        font-size: 20px;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
let editMode = false;

// Toggle Edit Mode
function toggleEditMode() {
    editMode = !editMode;
    
    document.querySelectorAll('.view-mode').forEach(el => {
        el.style.display = editMode ? 'none' : 'block';
    });
    
    document.querySelectorAll('.edit-mode').forEach(el => {
        el.style.display = editMode ? 'block' : 'none';
    });
    
    const editBtn = document.getElementById('editModeBtn');
    if (editMode) {
        editBtn.innerHTML = '<i class="fas fa-times"></i><span>ยกเลิก</span>';
        editBtn.classList.add('active');
    } else {
        editBtn.innerHTML = '<i class="fas fa-edit"></i><span>แก้ไข</span>';
        editBtn.classList.remove('active');
    }
}

function cancelEdit() {
    location.reload();
}

// Copy from Previous Month
function copyFromPreviousMonth() {
    Swal.fire({
        title: 'คัดลอกงบประมาณ',
        text: 'คุณต้องการคัดลอกงบประมาณจากเดือนที่แล้วใช่หรือไม่?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#FF6B35',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'คัดลอก',
        cancelButtonText: 'ยกเลิก'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '<?php echo e(route('finance.budgets.copy')); ?>';
            
            const csrfInput = document.createElement('input');
            csrfInput.type = 'hidden';
            csrfInput.name = '_token';
            csrfInput.value = '<?php echo e(csrf_token()); ?>';
            
            const monthInput = document.createElement('input');
            monthInput.type = 'hidden';
            monthInput.name = 'month';
            monthInput.value = '<?php echo e($selectedMonth); ?>';
            
            form.appendChild(csrfInput);
            form.appendChild(monthInput);
            document.body.appendChild(form);
            form.submit();
        }
    });
}

// Card Menu Toggle
function toggleCardMenu(button) {
    const menu = button.nextElementSibling;
    const isVisible = menu.style.display === 'block';
    
    // Hide all other menus
    document.querySelectorAll('.card-menu').forEach(m => m.style.display = 'none');
    
    // Toggle current menu
    menu.style.display = isVisible ? 'none' : 'block';
}

// Close menus when clicking outside
document.addEventListener('click', function(e) {
    if (!e.target.closest('.card-actions')) {
        document.querySelectorAll('.card-menu').forEach(m => m.style.display = 'none');
    }
});

// Budget Actions
function viewBudgetDetails(category) {
    // Implementation for viewing budget details
    console.log('View details for:', category);
}

function editBudgetAmount(category) {
    // Implementation for editing budget amount
    console.log('Edit amount for:', category);
}

function deleteBudget(category) {
    Swal.fire({
        title: 'ลบงบประมาณ',
        text: 'คุณต้องการลบงบประมาณหมวดหมู่นี้ใช่หรือไม่?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#EF4444',
        cancelButtonColor: '#6B7280',
        confirmButtonText: 'ลบ',
        cancelButtonText: 'ยกเลิก'
    }).then((result) => {
        if (result.isConfirmed) {
            // Implementation for deleting budget
            console.log('Delete budget for:', category);
        }
    });
}

// Add Budget Modal
function showAddBudgetModal() {
    document.getElementById('addBudgetModal').classList.add('active');
    loadCategories();
}

function closeAddBudgetModal() {
    document.getElementById('addBudgetModal').classList.remove('active');
    document.getElementById('addBudgetForm').reset();
}

function loadCategories() {
    // Load available categories via AJAX
    fetch('<?php echo e(route('finance.records.categories')); ?>')
        .then(response => response.json())
        .then(data => {
            const select = document.querySelector('#addBudgetForm select[name="category"]');
            select.innerHTML = '<option value="">เลือกหมวดหมู่</option>';
            
            data.expense.forEach(category => {
                const option = document.createElement('option');
                option.value = category.slug;
                option.textContent = category.name;
                select.appendChild(option);
            });
        })
        .catch(error => {
            console.error('Error loading categories:', error);
        });
}

function addBudget() {
    const form = document.getElementById('addBudgetForm');
    const formData = new FormData(form);
    
    // Add month and CSRF token
    formData.append('month', '<?php echo e($selectedMonth); ?>');
    formData.append('_token', '<?php echo e(csrf_token()); ?>');
    
    fetch('<?php echo e(route('finance.budgets.store')); ?>', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'สำเร็จ',
                text: 'เพิ่มงบประมาณเรียบร้อยแล้ว',
                confirmButtonColor: '#FF6B35'
            }).then(() => {
                location.reload();
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'เกิดข้อผิดพลาด',
                text: data.message || 'ไม่สามารถเพิ่มงบประมาณได้',
                confirmButtonColor: '#FF6B35'
            });
        }
    })
    .catch(error => {
        console.error('Error:', error);
        Swal.fire({
            icon: 'error',
            title: 'เกิดข้อผิดพลาด',
            text: 'เกิดข้อผิดพลาดในการเชื่อมต่อเซิร์ฟเวอร์',
            confirmButtonColor: '#FF6B35'
        });
    });
}

// Form Submission
document.getElementById('budgetForm').addEventListener('submit', function(e) {
    e.preventDefault();

    const form = e.target;
    const formData = new FormData(form);

    fetch(form.action, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'สำเร็จ',
                text: data.message || 'บันทึกงบประมาณเรียบร้อยแล้ว',
                confirmButtonText: 'ตกลง',
                confirmButtonColor: '#FF6B35'
            }).then(() => {
                location.reload();
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'เกิดข้อผิดพลาด',
                text: data.message || 'ไม่สามารถบันทึกงบประมาณได้',
                confirmButtonColor: '#FF6B35'
            });
        }
    })
    .catch(error => {
        console.error(error);
        Swal.fire({
            icon: 'error',
            title: 'ข้อผิดพลาด',
            text: 'เกิดข้อผิดพลาดในการเชื่อมต่อเซิร์ฟเวอร์',
            confirmButtonColor: '#FF6B35'
        });
    });
});

// Auto-save functionality
document.querySelectorAll('.budget-input').forEach(input => {
    let timeout;
    input.addEventListener('input', function() {
        clearTimeout(timeout);
        timeout = setTimeout(() => {
            // Show saving indicator
            const card = this.closest('.budget-card');
            const indicator = card.querySelector('.status-indicator');
            const originalContent = indicator.innerHTML;
            
            indicator.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
            indicator.className = 'status-indicator saving';
            
            // Restore after delay (in real implementation, this would be after AJAX success)
            setTimeout(() => {
                indicator.innerHTML = originalContent;
                indicator.className = indicator.className.replace('saving', 'good');
            }, 1000);
        }, 500);
    });
});

// Initialize tooltips and other interactive elements
document.addEventListener('DOMContentLoaded', function() {
    // Add any initialization code here
    console.log('Budget page initialized');
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\crs\resources\views/finance/budgets/index.blade.php ENDPATH**/ ?>